/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.testgen.pathanalysis;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.testgen.TestGenStatistics;
import org.sosy_lab.cpachecker.core.algorithm.testgen.iteration.PredicatePathAnalysisResult;
import org.sosy_lab.cpachecker.core.algorithm.testgen.pathanalysis.PathSelector;
import org.sosy_lab.cpachecker.core.algorithm.testgen.util.CFAUtils2;
import org.sosy_lab.cpachecker.core.algorithm.testgen.util.StartupConfig;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.MutableARGPath;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.predicates.PathChecker;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;

@Deprecated
public class CUTEBasicPathSelector
implements PathSelector {
    private TestGenStatistics stats;
    private LogManager logger;
    private BranchingHistory branchingHistory;
    private PathChecker pathChecker;

    public CUTEBasicPathSelector(PathChecker pPathChecker, StartupConfig config, TestGenStatistics pStats) {
        this.pathChecker = pPathChecker;
        this.logger = config.getLog();
        this.stats = pStats;
        this.branchingHistory = new BranchingHistory();
    }

    @Override
    public PredicatePathAnalysisResult findNewFeasiblePathUsingPredicates(ARGPath pExecutedPath, ReachedSet reachedStates) throws CPAException, InterruptedException {
        MutableARGPath newARGPath = pExecutedPath.mutableCopy();
        PathInfo pathInfo = new PathInfo(newARGPath.size());
        ArrayList newPath = Lists.newArrayList(newARGPath.asEdgesList());
        Pair lastElement = null;
        Iterator descendingPathElements = Iterators.consumingIterator(newARGPath.descendingIterator());
        while (descendingPathElements.hasNext()) {
            pathInfo.increaseNodeCount();
            Pair currentElement = (Pair)descendingPathElements.next();
            CFAEdge edge = (CFAEdge)currentElement.getSecond();
            Pair<CFAEdge, Boolean> oldElement = null;
            if (edge == null) {
                lastElement = currentElement;
                continue;
            }
            oldElement = this.handleNextNode(pathInfo.getCurrentPathSize(), edge, oldElement);
            CFANode node = edge.getPredecessor();
            if (node.getNumLeavingEdges() != 2) {
                lastElement = currentElement;
                continue;
            }
            pathInfo.increaseBranchCount();
            CFANode decidingNode = node;
            CFAEdge wrongEdge = edge;
            Optional<CFAEdge> otherEdge = CFAUtils2.getAlternativeLeavingEdge(decidingNode, wrongEdge);
            assert (otherEdge.isPresent());
            this.logger.logf(Level.FINEST, "StackState: %d %d (%d)", new Object[]{pathInfo.getCurrentPathSize(), this.branchingHistory.getCurrentDepths(), this.branchingHistory.getPathDepths()});
            if (this.isVisited((Pair<ARGState, CFAEdge>)currentElement, oldElement, (CFAEdge)otherEdge.get())) {
                this.logger.log(Level.FINER, new Object[]{"Branch on path was handled in an earlier iteration -> skipping branching."});
                lastElement = currentElement;
                continue;
            }
            if (lastElement == null) {
                this.logger.log(Level.FINER, new Object[]{"encountered an executed path that continues into an already reached region. -> Skipping"});
                lastElement = currentElement;
                continue;
            }
            this.logger.logf(Level.FINER, "identified new path candidate (visited branchings: %d, nodes: %d)", new Object[]{pathInfo.getBranchCount(), pathInfo.getNodeCount()});
            newPath = Lists.newArrayList(newARGPath.asEdgesList());
            newPath.add(otherEdge.get());
            this.stats.beforePathCheck();
            CounterexampleTraceInfo traceInfo = this.pathChecker.checkPath(newPath);
            this.stats.afterPathCheck();
            if (!traceInfo.isSpurious()) {
                newARGPath.add(Pair.of((Object)currentElement.getFirst(), (Object)otherEdge.get()));
                this.logger.logf(Level.FINEST, "selected new path %s", new Object[]{((Object)newPath).toString()});
                this.branchingHistory.resetTo(newARGPath);
                return new PredicatePathAnalysisResult(traceInfo, (ARGState)currentElement.getFirst(), (ARGState)lastElement.getFirst(), newARGPath.immutableCopy());
            }
            lastElement = currentElement;
            this.logger.logf(Level.FINER, "path candidate is infeasible", new Object[0]);
        }
        this.logger.logf(Level.FINER, "No possible path left to explore", new Object[0]);
        return PredicatePathAnalysisResult.INVALID;
    }

    private boolean isVisited(Pair<ARGState, CFAEdge> currentElement, Pair<CFAEdge, Boolean> oldElement, CFAEdge otherEdge) {
        if (oldElement != null) {
            this.logger.log(Level.FINER, new Object[]{"Matching path length. Possibly handled this branch earlier"});
            if (this.branchingHistory.isVisited(otherEdge, oldElement)) {
                return true;
            }
            this.logger.log(Level.FINER, new Object[]{"Same path length but not in predicted section."});
            return false;
        }
        return false;
    }

    private Pair<CFAEdge, Boolean> handleNextNode(long currentPathSize, CFAEdge edge, Pair<CFAEdge, Boolean> oldElement) {
        if (this.branchingHistory.getCurrentDepths() > currentPathSize + 1L) {
            this.branchingHistory.consumeUntilSameSize(currentPathSize);
            this.logger.logf(Level.FINER, "comsumed until %d %d (%d)", new Object[]{currentPathSize, this.branchingHistory.getCurrentDepths(), this.branchingHistory.getPathDepths()});
        }
        if (this.branchingHistory.isPathCandidateForPredictedSection(edge, currentPathSize)) {
            this.branchingHistory.hasNext();
            oldElement = this.branchingHistory.next();
            this.logger.logf(Level.FINER, "Is path candidate for predicted section", new Object[0]);
        }
        return oldElement;
    }

    @Override
    public CounterexampleTraceInfo computePredicateCheck(ARGPath pExecutedPath) throws CPAException, InterruptedException {
        return this.pathChecker.checkPath(pExecutedPath.getInnerEdges());
    }

    class BranchingHistory {
        Iterator<CFAEdge> descendingEdgePath = Collections.emptyIterator();
        Map<CFAEdge, Boolean> visitedEdges = Maps.newHashMap();
        Iterator<Pair<CFAEdge, Boolean>> edgeHistory;
        long pathDepths = 0L;
        long currentDepths = 0L;

        public BranchingHistory() {
            this.edgeHistory = Iterators.transform(this.descendingEdgePath, (Function)new Function<CFAEdge, Pair<CFAEdge, Boolean>>(){

                public Pair<CFAEdge, Boolean> apply(CFAEdge pInput) {
                    return Pair.of((Object)pInput, (Object)BranchingHistory.this.visitedEdges.get(pInput));
                }
            });
        }

        public void consumeUntilSameSize(long pCurrentSizeOfPath) {
            while (this.edgeHistory.hasNext() && pCurrentSizeOfPath + 1L < this.currentDepths) {
                this.next();
            }
        }

        public boolean isPathCandidateForPredictedSection(CFAEdge pEdge, long pCurrentPathLength) {
            return pCurrentPathLength < this.currentDepths;
        }

        public void resetTo(MutableARGPath argPath) {
            this.descendingEdgePath = Iterators.transform(argPath.descendingIterator(), (Function)Pair.getProjectionToSecond());
            this.edgeHistory = Iterators.transform(this.descendingEdgePath, (Function)new Function<CFAEdge, Pair<CFAEdge, Boolean>>(){

                public Pair<CFAEdge, Boolean> apply(CFAEdge pInput) {
                    return Pair.of((Object)pInput, (Object)BranchingHistory.this.visitedEdges.get(pInput));
                }
            });
            this.currentDepths = this.pathDepths = (long)argPath.size();
            this.visitedEdges.put((CFAEdge)((Pair)argPath.getLast()).getSecond(), true);
        }

        public boolean isVisited(CFAEdge edgeToCheck, Pair<CFAEdge, Boolean> oldEdge) {
            assert (((CFAEdge)oldEdge.getFirst()).getPredecessor().equals(edgeToCheck.getPredecessor())) : "Illegal State of history. Wrong edge executed.";
            if (oldEdge.getSecond() == null) {
                CUTEBasicPathSelector.this.logger.log(Level.FINER, new Object[]{"Didn't find a 'visited' match. Not a branching edge or a skipped edge."});
                return false;
            }
            return (Boolean)oldEdge.getSecond();
        }

        public boolean hasNext() {
            return this.edgeHistory.hasNext();
        }

        public Pair<CFAEdge, Boolean> next() {
            assert (this.edgeHistory.hasNext()) : "Illegal State of history. Check if this method was called to often.";
            --this.currentDepths;
            return this.edgeHistory.next();
        }

        public long getPathDepths() {
            return this.pathDepths;
        }

        public long getCurrentDepths() {
            return this.currentDepths;
        }
    }

    public class PathInfo {
        private final long pathSize;
        private long currentPathSize;
        private long branchCount = 0L;
        private long nodeCount = 0L;

        public PathInfo(long pPathSize) {
            this.currentPathSize = this.pathSize = pPathSize;
            this.branchCount = 0L;
            this.nodeCount = 0L;
        }

        public long getPathSize() {
            return this.pathSize;
        }

        public long getCurrentPathSize() {
            return this.currentPathSize;
        }

        public long getBranchCount() {
            return this.branchCount;
        }

        public long getNodeCount() {
            return this.nodeCount;
        }

        protected long increaseNodeCount() {
            ++this.nodeCount;
            this.currentPathSize = this.pathSize - this.nodeCount;
            return this.nodeCount;
        }

        protected long increaseBranchCount() {
            return ++this.branchCount;
        }
    }
}

