/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.testgen.pathanalysis;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.testgen.iteration.PredicatePathAnalysisResult;
import org.sosy_lab.cpachecker.core.algorithm.testgen.pathanalysis.AbstractPathValidator;
import org.sosy_lab.cpachecker.core.algorithm.testgen.pathanalysis.BasicPathSelector;
import org.sosy_lab.cpachecker.core.algorithm.testgen.util.StartupConfig;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.MutableARGPath;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.predicates.PathChecker;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;

public class CUTEPathValidator
extends AbstractPathValidator {
    private final PathChecker patchChecher;
    private final BranchingHistory branchingHistory;
    protected Pair<CFAEdge, Boolean> oldElement;

    public CUTEPathValidator(PathChecker pPatchChecher, StartupConfig pConfig) {
        super(pConfig);
        this.patchChecher = pPatchChecher;
        this.branchingHistory = new BranchingHistory();
        this.oldElement = null;
    }

    @Override
    public void handleNewCheck(ARGPath pExecutedPath) {
        this.oldElement = null;
    }

    @Override
    public CounterexampleTraceInfo validatePath(List<CFAEdge> pPath) throws CPAException, InterruptedException {
        return this.patchChecher.checkPath(pPath);
    }

    @Override
    public boolean isVisitedBranching(MutableARGPath pNewARGPath, Pair<ARGState, CFAEdge> pCurrentElement, CFANode pNode, CFAEdge pOtherEdge) {
        return this.isVisited(pCurrentElement, pOtherEdge);
    }

    @Override
    public void handleVisitedBranching(MutableARGPath pNewARGPath, Pair<ARGState, CFAEdge> pCurrentElement) {
    }

    @Override
    public void handleNext(BasicPathSelector.PathInfo pathInfo, CFAEdge edge) {
        this.handleNextNode(pathInfo.getCurrentPathSize(), edge);
        this.logger.logf(Level.FINEST, "StackState: %d %d (%d)", new Object[]{pathInfo.getCurrentPathSize(), this.branchingHistory.getCurrentDepths(), this.branchingHistory.getPathDepths()});
    }

    @Override
    public void handleValidPath(PredicatePathAnalysisResult result) {
        this.branchingHistory.resetTo(result.getPath());
    }

    private boolean isVisited(Pair<ARGState, CFAEdge> currentElement, CFAEdge otherEdge) {
        if (this.oldElement != null) {
            this.logger.log(Level.FINER, new Object[]{"Matching path length. Possibly handled this branch earlier"});
            if (this.branchingHistory.isVisited(otherEdge, this.oldElement)) {
                return true;
            }
            this.logger.log(Level.FINER, new Object[]{"Same path length but not in predicted section."});
            return false;
        }
        return false;
    }

    private Pair<CFAEdge, Boolean> handleNextNode(long currentPathSize, CFAEdge edge) {
        if (this.branchingHistory.getCurrentDepths() > currentPathSize + 1L) {
            this.branchingHistory.consumeUntilSameSize(currentPathSize);
            this.logger.logf(Level.FINER, "comsumed until %d %d (%d)", new Object[]{currentPathSize, this.branchingHistory.getCurrentDepths(), this.branchingHistory.getPathDepths()});
        }
        if (this.branchingHistory.isPathCandidateForPredictedSection(edge, currentPathSize)) {
            this.branchingHistory.hasNext();
            this.oldElement = this.branchingHistory.next();
            this.logger.logf(Level.FINER, "Is path candidate for predicted section", new Object[0]);
        }
        return this.oldElement;
    }

    class BranchingHistory {
        Map<CFAEdge, Boolean> visitedEdges = Maps.newHashMap();
        Iterator<Pair<CFAEdge, Boolean>> edgeHistory = Collections.emptyIterator();
        long pathDepths = 0L;
        long currentDepths = 0L;

        public void consumeUntilSameSize(long pCurrentSizeOfPath) {
            while (this.edgeHistory.hasNext() && pCurrentSizeOfPath + 1L < this.currentDepths) {
                this.next();
            }
        }

        public boolean isPathCandidateForPredictedSection(CFAEdge pEdge, long pCurrentPathLength) {
            return pCurrentPathLength < this.currentDepths;
        }

        public void resetTo(ARGPath argPath) {
            Iterator descendingEdgePath = Lists.reverse(argPath.asEdgesList()).iterator();
            this.edgeHistory = Iterators.transform(descendingEdgePath, (Function)new Function<CFAEdge, Pair<CFAEdge, Boolean>>(){

                public Pair<CFAEdge, Boolean> apply(CFAEdge pInput) {
                    return Pair.of((Object)pInput, (Object)BranchingHistory.this.visitedEdges.get(pInput));
                }
            });
            this.currentDepths = this.pathDepths = (long)argPath.size();
            this.visitedEdges.put((CFAEdge)Iterables.getLast(argPath.asEdgesList()), true);
        }

        public boolean isVisited(CFAEdge edgeToCheck, Pair<CFAEdge, Boolean> oldEdge) {
            assert (((CFAEdge)oldEdge.getFirst()).getPredecessor().equals(edgeToCheck.getPredecessor())) : "Illegal State of history. Wrong edge executed.";
            if (oldEdge.getSecond() == null) {
                CUTEPathValidator.this.logger.log(Level.FINER, new Object[]{"Didn't find a 'visited' match. Not a branching edge or a skipped edge."});
                return false;
            }
            return (Boolean)oldEdge.getSecond();
        }

        public boolean hasNext() {
            return this.edgeHistory.hasNext();
        }

        public Pair<CFAEdge, Boolean> next() {
            assert (this.edgeHistory.hasNext()) : "Illegal State of history. Check if this method was called to often.";
            --this.currentDepths;
            return this.edgeHistory.next();
        }

        public long getPathDepths() {
            return this.pathDepths;
        }

        public long getCurrentDepths() {
            return this.currentDepths;
        }
    }
}

