/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.testgen.pathanalysis;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.testgen.TestGenStatistics;
import org.sosy_lab.cpachecker.core.algorithm.testgen.iteration.PredicatePathAnalysisResult;
import org.sosy_lab.cpachecker.core.algorithm.testgen.pathanalysis.PathSelector;
import org.sosy_lab.cpachecker.core.algorithm.testgen.util.StartupConfig;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.MutableARGPath;
import org.sosy_lab.cpachecker.cpa.location.LocationState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.predicates.PathChecker;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;

public class LocationAndValueStateTrackingPathAnalysisStrategy
implements PathSelector {
    private PathChecker pathChecker;
    private List<AbstractState> handledDecisions;
    private TestGenStatistics stats;
    private LogManager logger;

    public LocationAndValueStateTrackingPathAnalysisStrategy(PathChecker pPathChecker, StartupConfig config, TestGenStatistics pStats) {
        this.pathChecker = pPathChecker;
        this.logger = config.getLog();
        this.stats = pStats;
        this.handledDecisions = Lists.newLinkedList();
    }

    @Override
    public PredicatePathAnalysisResult findNewFeasiblePathUsingPredicates(ARGPath pExecutedPath, ReachedSet reached) throws CPAException, InterruptedException {
        MutableARGPath newARGPath = pExecutedPath.mutableCopy();
        ArrayList newPath = Lists.newArrayList(newARGPath.asEdgesList());
        Pair lastElement = null;
        long branchCounter = 0L;
        long nodeCounter = 0L;
        Iterator branchingEdges = Iterators.consumingIterator(newARGPath.descendingIterator());
        while (branchingEdges.hasNext()) {
            ++nodeCounter;
            Pair currentElement = (Pair)branchingEdges.next();
            CFAEdge edge = (CFAEdge)currentElement.getSecond();
            if (edge == null) {
                lastElement = currentElement;
                continue;
            }
            CFANode node = edge.getPredecessor();
            if (node.getNumLeavingEdges() != 2) {
                lastElement = currentElement;
                continue;
            }
            CFANode decidingNode = node;
            final AbstractState currentElementTmp = (AbstractState)currentElement.getFirst();
            if (FluentIterable.from(this.handledDecisions).anyMatch((Predicate)new Predicate<AbstractState>(){

                public boolean apply(AbstractState pInput) {
                    return AbstractStates.extractStateByType(currentElementTmp, ValueAnalysisState.class).equals(AbstractStates.extractStateByType(pInput, ValueAnalysisState.class)) && AbstractStates.extractStateByType(currentElementTmp, LocationState.class).getLocationNode().getNodeNumber() == AbstractStates.extractStateByType(pInput, LocationState.class).getLocationNode().getNodeNumber();
                }
            })) {
                this.logger.log(Level.FINER, new Object[]{"Branch on path was handled in an earlier iteration -> skipping branching."});
                lastElement = currentElement;
                continue;
            }
            if (lastElement == null) {
                this.logger.log(Level.FINER, new Object[]{"encountered an executed path that might be spurious."});
                lastElement = currentElement;
                continue;
            }
            CFAEdge wrongEdge = edge;
            CFAEdge otherEdge = null;
            for (CFAEdge cfaEdge : CFAUtils.leavingEdges(decidingNode)) {
                if (cfaEdge.equals(wrongEdge)) continue;
                otherEdge = cfaEdge;
                break;
            }
            this.logger.logf(Level.FINER, "identified valid branching (skipped branching count: %d, nodes: %d)", new Object[]{branchCounter++, nodeCounter});
            assert (otherEdge != null);
            newPath = Lists.newArrayList(newARGPath.asEdgesList());
            newPath.add(otherEdge);
            this.stats.beforePathCheck();
            CounterexampleTraceInfo traceInfo = this.pathChecker.checkPath(newPath);
            this.stats.afterPathCheck();
            if (!traceInfo.isSpurious()) {
                newARGPath.add(Pair.of((Object)currentElement.getFirst(), (Object)otherEdge));
                this.logger.logf(Level.FINEST, "selected new path %s", new Object[]{((Object)newPath).toString()});
                this.handledDecisions.add((AbstractState)currentElement.getFirst());
                return new PredicatePathAnalysisResult(traceInfo, (ARGState)currentElement.getFirst(), (ARGState)lastElement.getFirst(), newARGPath.immutableCopy());
            }
            lastElement = currentElement;
        }
        return PredicatePathAnalysisResult.INVALID;
    }

    @Override
    public CounterexampleTraceInfo computePredicateCheck(ARGPath pExecutedPath) throws CPAException, InterruptedException {
        return this.pathChecker.checkPath(pExecutedPath.getInnerEdges());
    }
}

