/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.testgen.pathanalysis;

import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.algorithm.testgen.TestGenAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.testgen.TestGenStatistics;
import org.sosy_lab.cpachecker.core.algorithm.testgen.pathanalysis.AbstractPathValidator;
import org.sosy_lab.cpachecker.core.algorithm.testgen.pathanalysis.BasicPathSelector;
import org.sosy_lab.cpachecker.core.algorithm.testgen.pathanalysis.CFATrackingPathValidator;
import org.sosy_lab.cpachecker.core.algorithm.testgen.pathanalysis.CUTEBasicPathSelector;
import org.sosy_lab.cpachecker.core.algorithm.testgen.pathanalysis.CUTEPathValidator;
import org.sosy_lab.cpachecker.core.algorithm.testgen.pathanalysis.LocationAndValueStateTrackingPathAnalysisStrategy;
import org.sosy_lab.cpachecker.core.algorithm.testgen.pathanalysis.PathSelector;
import org.sosy_lab.cpachecker.core.algorithm.testgen.pathanalysis.PathValidator;
import org.sosy_lab.cpachecker.core.algorithm.testgen.util.StartupConfig;
import org.sosy_lab.cpachecker.util.predicates.PathChecker;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManagerImpl;

public class PathSelectorFactory {
    private StartupConfig startupConfig;

    public PathSelectorFactory(StartupConfig pStartupConfig) {
        this.startupConfig = pStartupConfig;
    }

    public PathValidator createValidator(TestGenAlgorithm.AnalysisStrategySelector selector, CFA pCfa) throws InvalidConfigurationException {
        AbstractPathValidator validator;
        PathChecker pathChecker = this.createPathChecker(pCfa);
        switch (selector) {
            case CUTE_PATH_SELECTOR: {
                validator = new CUTEPathValidator(pathChecker, this.startupConfig);
                break;
            }
            case CFA_TRACKING: {
                validator = new CFATrackingPathValidator(pathChecker, this.startupConfig);
                break;
            }
            case CUTE_LIKE: 
            case LOCATION_AND_VALUE_STATE_TRACKING: {
                throw new IllegalArgumentException("Currently not supported strategy with a validator");
            }
            default: {
                throw new IllegalStateException("Not all analysisStrategySelector cases matched");
            }
        }
        return validator;
    }

    public PathSelector createPathSelector(PathValidator pPathValidator, TestGenStatistics stats) {
        return new BasicPathSelector(pPathValidator, this.startupConfig, stats);
    }

    public PathSelector createPathSelector(TestGenAlgorithm.AnalysisStrategySelector selector, CFA pCfa, TestGenStatistics stats) throws InvalidConfigurationException {
        PathSelector analysisStrategy;
        switch (selector) {
            case LOCATION_AND_VALUE_STATE_TRACKING: {
                analysisStrategy = new LocationAndValueStateTrackingPathAnalysisStrategy(this.createPathChecker(pCfa), this.startupConfig, stats);
                break;
            }
            case CUTE_LIKE: {
                analysisStrategy = new CUTEBasicPathSelector(this.createPathChecker(pCfa), this.startupConfig, stats);
                break;
            }
            case CUTE_PATH_SELECTOR: 
            case CFA_TRACKING: {
                analysisStrategy = this.createPathSelector(this.createValidator(selector, pCfa), stats);
                break;
            }
            default: {
                throw new IllegalStateException("Not all analysisStrategySelector cases matched");
            }
        }
        return analysisStrategy;
    }

    private PathChecker createPathChecker(CFA pCfa) throws InvalidConfigurationException {
        Solver solver = Solver.create(this.startupConfig.getConfig(), this.startupConfig.getLog(), this.startupConfig.getShutdownNotifier());
        PathFormulaManagerImpl pfMgr = new PathFormulaManagerImpl(solver.getFormulaManager(), this.startupConfig.getConfig(), this.startupConfig.getLog(), this.startupConfig.getShutdownNotifier(), pCfa, AnalysisDirection.FORWARD);
        PathChecker pathChecker = new PathChecker(this.startupConfig.getLog(), this.startupConfig.getShutdownNotifier(), pfMgr, solver, pCfa.getMachineModel());
        return pathChecker;
    }
}

