/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.counterexample;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JIdExpression;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.cfa.types.c.DefaultCTypeVisitor;
import org.sosy_lab.cpachecker.core.counterexample.Address;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteState;
import org.sosy_lab.cpachecker.core.counterexample.FieldReference;
import org.sosy_lab.cpachecker.core.counterexample.IDExpression;
import org.sosy_lab.cpachecker.core.defaults.ForwardingTransferRelation;
import org.sosy_lab.cpachecker.cpa.value.AbstractExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.util.rationals.Rational;

public class AssumptionToEdgeAllocator {
    private final LogManager logger;
    private final MachineModel machineModel;
    private final CFAEdge cfaEdge;
    private final ConcreteState modelAtEdge;
    private static final int FIRST = 0;

    public AssumptionToEdgeAllocator(LogManager pLogger, CFAEdge pCfaEdge, ConcreteState pModelAtEdge, MachineModel pMachineModel) {
        this.logger = pLogger;
        this.machineModel = pMachineModel;
        this.cfaEdge = pCfaEdge;
        this.modelAtEdge = pModelAtEdge;
    }

    public CFAEdgeWithAssumptions allocateAssumptionsToEdge() {
        List<AExpressionStatement> assignmentsAtEdge = this.createAssignmentsAtEdge(this.cfaEdge);
        String comment = this.createComment(this.cfaEdge);
        return new CFAEdgeWithAssumptions(this.cfaEdge, assignmentsAtEdge, comment);
    }

    private String createComment(CFAEdge pCfaEdge) {
        if (this.cfaEdge.getEdgeType() == CFAEdgeType.AssumeEdge) {
            return this.handleAssume((AssumeEdge)this.cfaEdge);
        }
        if (this.cfaEdge.getEdgeType() == CFAEdgeType.DeclarationEdge) {
            return this.handleDclComment((ADeclarationEdge)this.cfaEdge);
        }
        if (this.cfaEdge.getEdgeType() == CFAEdgeType.ReturnStatementEdge) {
            return this.handleReturnStatementComment((AReturnStatementEdge)this.cfaEdge);
        }
        return "";
    }

    private String handleReturnStatementComment(AReturnStatementEdge pCfaEdge) {
        if (pCfaEdge.getExpression() instanceof CExpression) {
            CExpression returnExp = (CExpression)pCfaEdge.getExpression();
            if (returnExp instanceof CLiteralExpression) {
                return "";
            }
            String functionname = pCfaEdge.getPredecessor().getFunctionName();
            LModelValueVisitor v = new LModelValueVisitor(functionname);
            Number value = v.evaluateNumericalValue(returnExp);
            if (value == null) {
                return "";
            }
            return returnExp.toASTString() + " = " + value.toString();
        }
        return "";
    }

    private String handleDclComment(ADeclarationEdge pCfaEdge) {
        if (pCfaEdge instanceof CDeclarationEdge) {
            return this.getCommentOfDclAddress((CSimpleDeclaration)((Object)pCfaEdge.getDeclaration()), pCfaEdge);
        }
        return "";
    }

    private String getCommentOfDclAddress(CSimpleDeclaration dcl, CFAEdge edge) {
        String functionName = this.cfaEdge.getPredecessor().getFunctionName();
        LModelValueVisitor v = new LModelValueVisitor(functionName);
        Address address = v.getAddress(dcl);
        if (address.isUnknown()) {
            return "";
        }
        return "&" + dcl.getName() + " = " + address.getCommentRepresentation();
    }

    @Nullable
    private List<AExpressionStatement> createAssignmentsAtEdge(CFAEdge pCFAEdge) {
        if (this.cfaEdge.getEdgeType() == CFAEdgeType.DeclarationEdge) {
            return this.handleDeclaration(((ADeclarationEdge)pCFAEdge).getDeclaration(), this.cfaEdge.getPredecessor().getFunctionName());
        }
        if (this.cfaEdge.getEdgeType() == CFAEdgeType.StatementEdge) {
            return this.handleStatement(((AStatementEdge)pCFAEdge).getStatement());
        }
        if (this.cfaEdge.getEdgeType() == CFAEdgeType.FunctionCallEdge) {
            return this.handleFunctionCall((FunctionCallEdge)pCFAEdge);
        }
        if (this.cfaEdge.getEdgeType() == CFAEdgeType.MultiEdge) {
            throw new AssertionError((Object)"Multi-edges should be resolved by this point.");
        }
        return Collections.emptyList();
    }

    private String handleAssume(AssumeEdge pCfaEdge) {
        if (pCfaEdge instanceof CAssumeEdge) {
            return this.handleAssume((CAssumeEdge)pCfaEdge);
        }
        return "";
    }

    private String handleAssume(CAssumeEdge pCfaEdge) {
        CExpression pCExpression = pCfaEdge.getExpression();
        String functionName = this.cfaEdge.getPredecessor().getFunctionName();
        if (pCExpression instanceof CBinaryExpression) {
            CBinaryExpression binExp = (CBinaryExpression)pCExpression;
            CExpression op1 = binExp.getOperand1();
            CExpression op2 = binExp.getOperand2();
            String result1 = this.handleAssumeOp(op1, functionName);
            String result2 = this.handleAssumeOp(op2, functionName);
            if (!result1.isEmpty() && !result2.isEmpty()) {
                return result1 + System.lineSeparator() + result2;
            }
            if (!result1.isEmpty()) {
                return result1;
            }
            if (!result2.isEmpty()) {
                return result2;
            }
            return "";
        }
        return "";
    }

    private String handleAssumeOp(CExpression op, String functionName) {
        if (op instanceof CLiteralExpression) {
            return "";
        }
        if (op instanceof CLeftHandSide) {
            List<AExpressionStatement> assignments = this.handleAssignment((CLeftHandSide)op);
            if (assignments.size() == 0) {
                return "";
            }
            ArrayList<String> result = new ArrayList<String>(assignments.size());
            for (AExpressionStatement assignment : assignments) {
                result.add(assignment.toASTString());
            }
            return Joiner.on((String)System.lineSeparator()).join(result);
        }
        Object value = this.getValueObject(op, functionName);
        if (value != null) {
            return op.toASTString() + " == " + value.toString();
        }
        return "";
    }

    private Object getValueObject(CExpression pOp1, String pFunctionName) {
        LModelValueVisitor v = new LModelValueVisitor(pFunctionName);
        return v.evaluateNumericalValue(pOp1);
    }

    private List<AExpressionStatement> handleFunctionCall(FunctionCallEdge pFunctionCallEdge) {
        if (!(pFunctionCallEdge instanceof CFunctionCallEdge)) {
            return Collections.emptyList();
        }
        CFunctionCallEdge functionCallEdge = (CFunctionCallEdge)pFunctionCallEdge;
        CFunctionEntryNode functionEntryNode = functionCallEdge.getSuccessor();
        List<CParameterDeclaration> dcls = functionEntryNode.getFunctionParameters();
        ArrayList<AExpressionStatement> assignments = new ArrayList<AExpressionStatement>();
        for (CParameterDeclaration dcl : dcls) {
            assignments.addAll(this.handleDeclaration(dcl, pFunctionCallEdge.getSuccessor().getFunctionName()));
        }
        return assignments;
    }

    @Nullable
    private List<AExpressionStatement> handleAssignment(CLeftHandSide leftHandSide) {
        String functionName = this.cfaEdge.getPredecessor().getFunctionName();
        Object value = this.getValueObject(leftHandSide, functionName);
        if (value == null) {
            return Collections.emptyList();
        }
        CType expectedType = leftHandSide.getExpressionType();
        ValueLiterals valueAsCode = this.getValueAsCode(value, expectedType, leftHandSide, functionName);
        return this.handleSimpleValueLiteralsAssumptions(valueAsCode, leftHandSide);
    }

    private List<AExpressionStatement> handleAssignment(CAssignment assignment) {
        CLeftHandSide leftHandSide = assignment.getLeftHandSide();
        return this.handleAssignment(leftHandSide);
    }

    private Object getValueObject(CLeftHandSide pLeftHandSide, String pFunctionName) {
        LModelValueVisitor v = new LModelValueVisitor(pFunctionName);
        return pLeftHandSide.accept(v);
    }

    private ValueLiterals getValueAsCode(Object pValue, Type pExpectedType, CLeftHandSide leftHandSide, String functionName) {
        if (pExpectedType instanceof CType) {
            CType cType = ((CType)pExpectedType).getCanonicalType();
            ValueLiteralsVisitor v = new ValueLiteralsVisitor(pValue, leftHandSide);
            ValueLiterals valueLiterals = cType.accept(v);
            if (this.isStructOrUnionType(cType) && leftHandSide instanceof CIdExpression) {
                v.resolveStruct(cType, valueLiterals, (CIdExpression)leftHandSide, functionName);
            }
            return valueLiterals;
        }
        return new ValueLiterals();
    }

    private List<AExpressionStatement> handleStatement(AStatement pStatement) {
        if (pStatement instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement assignmentStatement = (CFunctionCallAssignmentStatement)pStatement;
            return this.handleAssignment(assignmentStatement);
        }
        if (pStatement instanceof CExpressionAssignmentStatement) {
            CExpressionAssignmentStatement assignmentStatement = (CExpressionAssignmentStatement)pStatement;
            return this.handleAssignment(assignmentStatement);
        }
        return Collections.emptyList();
    }

    private List<AExpressionStatement> handleDeclaration(ASimpleDeclaration dcl, String pFunctionName) {
        if (dcl instanceof CSimpleDeclaration) {
            CSimpleDeclaration cDcl = (CSimpleDeclaration)dcl;
            CType dclType = cDcl.getType();
            Object value = this.getValueObject(cDcl, pFunctionName);
            if (value == null) {
                return Collections.emptyList();
            }
            CIdExpression idExpression = new CIdExpression(dcl.getFileLocation(), cDcl);
            ValueLiterals valueAsCode = this.getValueAsCode(value, dclType, idExpression, pFunctionName);
            CIdExpression leftHandSide = new CIdExpression(FileLocation.DUMMY, cDcl);
            return this.handleSimpleValueLiteralsAssumptions(valueAsCode, leftHandSide);
        }
        return Collections.emptyList();
    }

    private List<AExpressionStatement> handleSimpleValueLiteralsAssumptions(ValueLiterals pValueLiterals, CLeftHandSide pLValue) {
        Set<SubExpressionValueLiteral> subValues = pValueLiterals.getSubExpressionValueLiteral();
        ArrayList<AExpressionStatement> statements = new ArrayList<AExpressionStatement>(subValues.size() + 1);
        if (!pValueLiterals.hasUnknownValueLiteral()) {
            CExpression leftAssumption = this.getLeftAssumptionFromLhs(pLValue);
            CBinaryExpression assumption = new CBinaryExpression(leftAssumption.getFileLocation(), CNumericTypes.BOOL, leftAssumption.getExpressionType(), leftAssumption, pValueLiterals.getExpressionValueLiteralAsCExpression(), CBinaryExpression.BinaryOperator.EQUALS);
            CExpressionStatement statement = new CExpressionStatement(leftAssumption.getFileLocation(), assumption);
            statements.add(statement);
        }
        for (SubExpressionValueLiteral subValueLiteral : subValues) {
            CExpression leftAssumption = this.getLeftAssumptionFromLhs(subValueLiteral.getSubExpression());
            CBinaryExpression assumption = new CBinaryExpression(pLValue.getFileLocation(), CNumericTypes.BOOL, pLValue.getExpressionType(), leftAssumption, subValueLiteral.getValueLiteralAsCExpression(), CBinaryExpression.BinaryOperator.EQUALS);
            CExpressionStatement statement = new CExpressionStatement(pLValue.getFileLocation(), assumption);
            statements.add(statement);
        }
        return statements;
    }

    private CExpression getLeftAssumptionFromLhs(CLeftHandSide pLValue) {
        CType type = pLValue.getExpressionType().getCanonicalType();
        if (this.isStructOrUnionType(type) || type instanceof CArrayType) {
            CUnaryExpression unaryExpression = new CUnaryExpression(pLValue.getFileLocation(), type, pLValue, CUnaryExpression.UnaryOperator.AMPER);
            return unaryExpression;
        }
        return pLValue;
    }

    private Object getValueObject(CSimpleDeclaration pDcl, String pFunctionName) {
        return new LModelValueVisitor(pFunctionName).handleVariableDeclaration(pDcl);
    }

    private boolean isStructOrUnionType(CType rValueType) {
        if ((rValueType = rValueType.getCanonicalType()) instanceof CElaboratedType) {
            CElaboratedType type = (CElaboratedType)rValueType;
            return type.getKind() != CComplexType.ComplexTypeKind.ENUM;
        }
        if (rValueType instanceof CCompositeType) {
            CCompositeType type = (CCompositeType)rValueType;
            return type.getKind() != CComplexType.ComplexTypeKind.ENUM;
        }
        return false;
    }

    private FieldReference getFieldReference(CFieldReference pIastFieldReference, String pFunctionName) {
        ArrayList<String> fieldNameList = new ArrayList<String>();
        CFieldReference reference = pIastFieldReference;
        fieldNameList.add(0, reference.getFieldName());
        while (reference.getFieldOwner() instanceof CFieldReference && !reference.isPointerDereference()) {
            reference = (CFieldReference)reference.getFieldOwner();
            fieldNameList.add(0, reference.getFieldName());
        }
        if (reference.getFieldOwner() instanceof CIdExpression) {
            CIdExpression idExpression = (CIdExpression)reference.getFieldOwner();
            if (ForwardingTransferRelation.isGlobal((AExpression)idExpression)) {
                return new FieldReference(idExpression.getName(), fieldNameList);
            }
            return new FieldReference(idExpression.getName(), pFunctionName, fieldNameList);
        }
        return null;
    }

    public static final class SubExpressionValueLiteral {
        private final ValueLiteral valueLiteral;
        private final CLeftHandSide subExpression;

        private SubExpressionValueLiteral(ValueLiteral pValueLiteral, CLeftHandSide pSubExpression) {
            this.valueLiteral = pValueLiteral;
            this.subExpression = pSubExpression;
        }

        public CExpression getValueLiteralAsCExpression() {
            return this.valueLiteral.getValueLiteral();
        }

        public ValueLiteral getValueLiteral() {
            return this.valueLiteral;
        }

        public CLeftHandSide getSubExpression() {
            return this.subExpression;
        }
    }

    public static final class CastedExplicitValueLiteral
    extends ExplicitValueLiteral {
        private final CCastExpression castExpression;

        protected CastedExplicitValueLiteral(CLiteralExpression pValueLiteral, CCastExpression exp) {
            super(pValueLiteral);
            this.castExpression = exp;
        }

        @Override
        public CExpression getValueLiteral() {
            return this.castExpression;
        }
    }

    public static class ExplicitValueLiteral
    implements ValueLiteral {
        private final CLiteralExpression explicitValueLiteral;

        protected ExplicitValueLiteral(CLiteralExpression pValueLiteral) {
            this.explicitValueLiteral = pValueLiteral;
        }

        public static ValueLiteral valueOf(Address address) {
            if (address.isUnknown() || address.isSymbolic()) {
                return UnknownValueLiteral.getInstance();
            }
            BigInteger value = address.getAddressValue();
            CIntegerLiteralExpression lit = new CIntegerLiteralExpression(FileLocation.DUMMY, CNumericTypes.LONG_LONG_INT, value);
            return new ExplicitValueLiteral(lit);
        }

        protected ExplicitValueLiteral(CLiteralExpression pValueLiteral, CCastExpression pCastedValue) {
            this.explicitValueLiteral = pValueLiteral;
        }

        @Override
        public ValueLiteral addCast(CSimpleType pType) {
            CExpression castedValue = this.getValueLiteral();
            CCastExpression castExpression = new CCastExpression(castedValue.getFileLocation(), pType, castedValue);
            return new CastedExplicitValueLiteral(this.explicitValueLiteral, castExpression);
        }

        public static ValueLiteral valueOf(BigInteger value, CSimpleType pType) {
            CIntegerLiteralExpression literal = new CIntegerLiteralExpression(FileLocation.DUMMY, pType, value);
            return new ExplicitValueLiteral(literal);
        }

        public static ValueLiteral valueOf(BigDecimal value, CSimpleType pType) {
            CFloatLiteralExpression literal = new CFloatLiteralExpression(FileLocation.DUMMY, pType, value);
            return new ExplicitValueLiteral(literal);
        }

        @Override
        public CExpression getValueLiteral() {
            return this.explicitValueLiteral;
        }

        public CLiteralExpression getExplicitValueLiteral() {
            return this.explicitValueLiteral;
        }

        @Override
        public boolean isUnknown() {
            return false;
        }

        public String toString() {
            return this.explicitValueLiteral.toASTString();
        }
    }

    public static class UnknownValueLiteral
    implements ValueLiteral {
        private static final UnknownValueLiteral instance = new UnknownValueLiteral();

        private UnknownValueLiteral() {
        }

        public static UnknownValueLiteral getInstance() {
            return instance;
        }

        @Override
        public CLiteralExpression getValueLiteral() {
            throw new UnsupportedOperationException("Can't get the value code of an unknown value");
        }

        @Override
        public boolean isUnknown() {
            return true;
        }

        @Override
        public ValueLiteral addCast(CSimpleType pType) {
            throw new UnsupportedOperationException("Can't get the value code of an unknown value");
        }

        public String toString() {
            return "UNKNOWN";
        }
    }

    public static interface ValueLiteral {
        public CExpression getValueLiteral();

        public boolean isUnknown();

        public ValueLiteral addCast(CSimpleType var1);
    }

    public static final class ValueLiterals {
        private final List<SubExpressionValueLiteral> subExpressionValueLiterals = new ArrayList<SubExpressionValueLiteral>();
        private final ValueLiteral expressionValueLiteral;

        public ValueLiterals() {
            this.expressionValueLiteral = UnknownValueLiteral.getInstance();
        }

        public ValueLiterals(ValueLiteral valueLiteral) {
            this.expressionValueLiteral = valueLiteral;
        }

        public ValueLiteral getExpressionValueLiteral() {
            return this.expressionValueLiteral;
        }

        public CExpression getExpressionValueLiteralAsCExpression() {
            return this.expressionValueLiteral.getValueLiteral();
        }

        public void addSubExpressionValueLiteral(SubExpressionValueLiteral code) {
            this.subExpressionValueLiterals.add(code);
        }

        public boolean hasUnknownValueLiteral() {
            return this.expressionValueLiteral.isUnknown();
        }

        public Set<SubExpressionValueLiteral> getSubExpressionValueLiteral() {
            return ImmutableSet.copyOf(this.subExpressionValueLiterals);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("ValueLiteral : ");
            result.append(this.expressionValueLiteral.toString());
            result.append(", SubValueLiterals : ");
            Joiner joiner = Joiner.on((String)", ");
            result.append(joiner.join(this.subExpressionValueLiterals));
            return result.toString();
        }
    }

    private class ValueLiteralsVisitor
    extends DefaultCTypeVisitor<ValueLiterals, RuntimeException> {
        private final Object value;
        private final CExpression exp;

        public ValueLiteralsVisitor(Object pValue, CExpression pExp) {
            this.value = pValue;
            this.exp = pExp;
        }

        @Override
        public ValueLiterals visitDefault(CType pT) {
            return this.createUnknownValueLiterals();
        }

        @Override
        public ValueLiterals visit(CPointerType pointerType) {
            Address address = Address.valueOf(this.value);
            if (address.isUnknown()) {
                return this.createUnknownValueLiterals();
            }
            ValueLiteral valueLiteral = ExplicitValueLiteral.valueOf(address);
            ValueLiterals valueLiterals = new ValueLiterals(valueLiteral);
            ValueLiteralVisitor v = new ValueLiteralVisitor(address, valueLiterals, this.exp);
            pointerType.accept(v);
            return valueLiterals;
        }

        @Override
        public ValueLiterals visit(CArrayType arrayType) {
            Address address = Address.valueOf(this.value);
            if (address.isUnknown()) {
                return this.createUnknownValueLiterals();
            }
            ValueLiteral valueLiteral = ExplicitValueLiteral.valueOf(address);
            ValueLiterals valueLiterals = new ValueLiterals(valueLiteral);
            ValueLiteralVisitor v = new ValueLiteralVisitor(address, valueLiterals, this.exp);
            arrayType.accept(v);
            return valueLiterals;
        }

        @Override
        public ValueLiterals visit(CElaboratedType pT) {
            CComplexType realType = pT.getRealType();
            if (realType != null) {
                return realType.accept(this);
            }
            return this.createUnknownValueLiterals();
        }

        @Override
        public ValueLiterals visit(CEnumType pT) {
            return this.createUnknownValueLiterals();
        }

        @Override
        public ValueLiterals visit(CFunctionType pT) {
            return this.createUnknownValueLiterals();
        }

        @Override
        public ValueLiterals visit(CSimpleType simpleType) {
            return new ValueLiterals(this.getValueLiteral(simpleType, this.value));
        }

        @Override
        public ValueLiterals visit(CProblemType pT) {
            return this.createUnknownValueLiterals();
        }

        @Override
        public ValueLiterals visit(CTypedefType pT) {
            return pT.getRealType().accept(this);
        }

        @Override
        public ValueLiterals visit(CCompositeType compType) {
            if (compType.getKind() == CComplexType.ComplexTypeKind.ENUM) {
                return this.createUnknownValueLiterals();
            }
            Address address = Address.valueOf(this.value);
            if (address.isUnknown()) {
                return this.createUnknownValueLiterals();
            }
            ValueLiteral valueLiteral = ExplicitValueLiteral.valueOf(address);
            ValueLiterals valueLiterals = new ValueLiterals(valueLiteral);
            ValueLiteralVisitor v = new ValueLiteralVisitor(address, valueLiterals, this.exp);
            compType.accept(v);
            return valueLiterals;
        }

        protected ValueLiteral getValueLiteral(CSimpleType pSimpleType, Object pValue) {
            CSimpleType simpleType = pSimpleType.getCanonicalType();
            CBasicType basicType = simpleType.getType();
            switch (basicType) {
                case BOOL: 
                case CHAR: 
                case INT: {
                    return this.handleIntegerNumbers(pValue, simpleType);
                }
                case FLOAT: 
                case DOUBLE: {
                    return this.handleFloatingPointNumbers(pValue, simpleType);
                }
            }
            return UnknownValueLiteral.getInstance();
        }

        private ValueLiterals createUnknownValueLiterals() {
            return new ValueLiterals();
        }

        private ValueLiteral handleFloatingPointNumbers(Object pValue, CSimpleType pType) {
            BigDecimal val;
            if (pValue instanceof Rational) {
                double val2 = ((Rational)pValue).toDouble();
                return ExplicitValueLiteral.valueOf(new BigDecimal(val2), pType);
            }
            if (pValue instanceof Double) {
                double doubleValue = (Double)pValue;
                if (Double.isInfinite(doubleValue) || Double.isNaN(doubleValue)) {
                    return UnknownValueLiteral.getInstance();
                }
                return ExplicitValueLiteral.valueOf(new BigDecimal(doubleValue), pType);
            }
            if (pValue instanceof Float) {
                float floatValue = ((Float)pValue).floatValue();
                if (Float.isInfinite(floatValue) || Double.isNaN(floatValue)) {
                    return UnknownValueLiteral.getInstance();
                }
                return ExplicitValueLiteral.valueOf(new BigDecimal(floatValue), pType);
            }
            String value = pValue.toString();
            try {
                val = new BigDecimal(value);
            }
            catch (NumberFormatException e) {
                AssumptionToEdgeAllocator.this.logger.log(Level.INFO, new Object[]{"Can't parse " + value + " as value for the counter-example path."});
                return UnknownValueLiteral.getInstance();
            }
            return ExplicitValueLiteral.valueOf(val, pType);
        }

        public void resolveStruct(CType type, ValueLiterals pValueLiterals, CIdExpression pOwner, String pFunctionName) {
            ValueLiteralStructResolver v = new ValueLiteralStructResolver(pValueLiterals, pFunctionName, pOwner);
            type.accept(v);
        }

        private ValueLiteral handleIntegerNumbers(Object pValue, CSimpleType pType) {
            String value = pValue.toString();
            if (value.matches("((-)?)\\d*")) {
                BigInteger integerValue = new BigInteger(value);
                return this.handlePotentialIntegerOverflow(integerValue, pType);
            }
            String[] numberParts = value.split("\\.");
            if (numberParts.length == 2 && numberParts[1].matches("0*") && numberParts[0].matches("((-)?)\\d*")) {
                BigInteger integerValue = new BigInteger(numberParts[0]);
                return this.handlePotentialIntegerOverflow(integerValue, pType);
            }
            ValueLiteral valueLiteral = this.handleFloatingPointNumbers(pValue, pType);
            if (valueLiteral.isUnknown()) {
                return valueLiteral;
            }
            return valueLiteral.addCast(pType);
        }

        private ValueLiteral handlePotentialIntegerOverflow(BigInteger pIntegerValue, CSimpleType pType) {
            ValueLiteral result = ExplicitValueLiteral.valueOf(pIntegerValue, pType);
            BigInteger lowerInclusiveBound = AssumptionToEdgeAllocator.this.machineModel.getMinimalIntegerValue(pType);
            BigInteger upperInclusiveBound = AssumptionToEdgeAllocator.this.machineModel.getMaximalIntegerValue(pType);
            assert (lowerInclusiveBound.compareTo(upperInclusiveBound) < 0);
            if (pIntegerValue.compareTo(lowerInclusiveBound) < 0 || pIntegerValue.compareTo(upperInclusiveBound) > 0) {
                result = result.addCast(pType);
            }
            return result;
        }

        private class ValueLiteralStructResolver
        extends DefaultCTypeVisitor<Void, RuntimeException> {
            private final ValueLiterals valueLiterals;
            private final String functionName;
            private final CExpression prevSub;

            public ValueLiteralStructResolver(ValueLiterals pValueLiterals, String pFunctionName, CFieldReference pPrevSub) {
                this.valueLiterals = pValueLiterals;
                this.functionName = pFunctionName;
                this.prevSub = pPrevSub;
            }

            public ValueLiteralStructResolver(ValueLiterals pValueLiterals, String pFunctionName, CIdExpression pOwner) {
                this.valueLiterals = pValueLiterals;
                this.functionName = pFunctionName;
                this.prevSub = pOwner;
            }

            @Override
            public Void visitDefault(CType pT) {
                return null;
            }

            @Override
            public Void visit(CElaboratedType type) {
                CComplexType realType = type.getRealType();
                if (realType == null) {
                    return null;
                }
                return realType.getCanonicalType().accept(this);
            }

            @Override
            public Void visit(CTypedefType pType) {
                return pType.getRealType().accept(this);
            }

            @Override
            public Void visit(CCompositeType compType) {
                if (compType.getKind() == CComplexType.ComplexTypeKind.ENUM) {
                    return null;
                }
                for (CCompositeType.CCompositeTypeMemberDeclaration memberType : compType.getMembers()) {
                    this.handleField(memberType.getName(), memberType.getType());
                }
                return null;
            }

            private void handleField(String pFieldName, CType pMemberType) {
                CFieldReference reference = new CFieldReference(this.prevSub.getFileLocation(), pMemberType, pFieldName, this.prevSub, false);
                FieldReference fieldReferenceName = AssumptionToEdgeAllocator.this.getFieldReference(reference, this.functionName);
                if (AssumptionToEdgeAllocator.this.modelAtEdge.hasValueForLeftHandSide(fieldReferenceName)) {
                    Object referenceValue = AssumptionToEdgeAllocator.this.modelAtEdge.getVariableValue(fieldReferenceName);
                    this.addStructSubexpression(referenceValue, reference);
                }
                ValueLiteralStructResolver resolver = new ValueLiteralStructResolver(this.valueLiterals, this.functionName, reference);
                pMemberType.accept(resolver);
            }

            private void addStructSubexpression(Object pFieldValue, CFieldReference reference) {
                ValueLiteral valueLiteral;
                CType realType = reference.getExpressionType();
                Address valueAddress = Address.getUnknownAddress();
                if (realType instanceof CSimpleType) {
                    valueLiteral = ValueLiteralsVisitor.this.getValueLiteral((CSimpleType)realType, pFieldValue);
                } else {
                    valueAddress = Address.valueOf(pFieldValue);
                    if (valueAddress.isUnknown()) {
                        return;
                    }
                    valueLiteral = ExplicitValueLiteral.valueOf(valueAddress);
                }
                if (valueLiteral.isUnknown()) {
                    return;
                }
                SubExpressionValueLiteral subExpression = new SubExpressionValueLiteral(valueLiteral, reference);
                this.valueLiterals.addSubExpressionValueLiteral(subExpression);
            }
        }

        private class ValueLiteralVisitor
        extends DefaultCTypeVisitor<Void, RuntimeException> {
            private final Set<Pair<CType, Address>> visited;
            private final Address address;
            private final ValueLiterals valueLiterals;
            private final CExpression subExpression;

            public ValueLiteralVisitor(Address pAddress, ValueLiterals pValueLiterals, CExpression pSubExp) {
                this.address = pAddress;
                this.valueLiterals = pValueLiterals;
                this.visited = new HashSet<Pair<CType, Address>>();
                this.subExpression = pSubExp;
            }

            private ValueLiteralVisitor(Address pAddress, ValueLiterals pValueLiterals, CExpression pSubExp, Set<Pair<CType, Address>> pVisited) {
                this.address = pAddress;
                this.valueLiterals = pValueLiterals;
                this.visited = pVisited;
                this.subExpression = pSubExp;
            }

            @Override
            public Void visitDefault(CType pT) {
                return null;
            }

            @Override
            public Void visit(CTypedefType pT) {
                return pT.getRealType().accept(this);
            }

            @Override
            public Void visit(CElaboratedType pT) {
                CComplexType realType = pT.getRealType();
                if (realType == null) {
                    return null;
                }
                return realType.getCanonicalType().accept(this);
            }

            @Override
            public Void visit(CEnumType pT) {
                return null;
            }

            @Override
            public Void visit(CCompositeType compType) {
                if (compType.getKind() == CComplexType.ComplexTypeKind.ENUM) {
                    // empty if block
                }
                if (compType.getKind() == CComplexType.ComplexTypeKind.UNION) {
                    // empty if block
                }
                if (compType.getKind() == CComplexType.ComplexTypeKind.STRUCT) {
                    this.handleStruct(compType);
                }
                return null;
            }

            private void handleStruct(CCompositeType pCompType) {
                Address fieldAddress = this.address;
                for (CCompositeType.CCompositeTypeMemberDeclaration memberType : pCompType.getMembers()) {
                    this.handleMemberField(memberType, fieldAddress, pCompType);
                    int offsetToNextField = AssumptionToEdgeAllocator.this.machineModel.getSizeof(memberType.getType());
                    if (fieldAddress.isConcrete()) {
                        fieldAddress = fieldAddress.addOffset(BigInteger.valueOf(offsetToNextField));
                        continue;
                    }
                    return;
                }
            }

            private void handleMemberField(CCompositeType.CCompositeTypeMemberDeclaration pType, Address fieldAddress, CCompositeType structType) {
                ValueLiteral valueLiteral;
                boolean isPointerDeref;
                CExpression subExp;
                CType expectedType = pType.getType().getCanonicalType();
                assert (AssumptionToEdgeAllocator.this.isStructOrUnionType(this.subExpression.getExpressionType().getCanonicalType()));
                if (this.subExpression instanceof CPointerExpression) {
                    subExp = ((CPointerExpression)this.subExpression).getOperand();
                    isPointerDeref = true;
                } else {
                    subExp = this.subExpression;
                    isPointerDeref = false;
                }
                CFieldReference fieldReference = new CFieldReference(subExp.getFileLocation(), expectedType, pType.getName(), subExp, isPointerDeref);
                Object fieldValue = expectedType instanceof CArrayType || AssumptionToEdgeAllocator.this.isStructOrUnionType(expectedType) ? fieldAddress : AssumptionToEdgeAllocator.this.modelAtEdge.getValueFromMemory(fieldReference, fieldAddress);
                if (fieldValue == null) {
                    return;
                }
                Address valueAddress = Address.getUnknownAddress();
                if (expectedType instanceof CSimpleType) {
                    valueLiteral = ValueLiteralsVisitor.this.getValueLiteral((CSimpleType)expectedType, fieldValue);
                } else {
                    valueAddress = Address.valueOf(fieldValue);
                    if (valueAddress.isUnknown()) {
                        return;
                    }
                    valueLiteral = ExplicitValueLiteral.valueOf(valueAddress);
                }
                Pair visits = Pair.of((Object)expectedType, (Object)fieldAddress);
                if (this.visited.contains(visits)) {
                    return;
                }
                if (!valueLiteral.isUnknown()) {
                    this.visited.add((Pair<CType, Address>)visits);
                    SubExpressionValueLiteral subExpression = new SubExpressionValueLiteral(valueLiteral, fieldReference);
                    this.valueLiterals.addSubExpressionValueLiteral(subExpression);
                }
                if (valueAddress != null) {
                    ValueLiteralVisitor v = new ValueLiteralVisitor(valueAddress, this.valueLiterals, fieldReference, this.visited);
                    expectedType.accept(v);
                }
            }

            @Override
            public Void visit(CArrayType arrayType) {
                CType expectedType = arrayType.getType().getCanonicalType();
                int subscript = 0;
                boolean memoryHasValue = true;
                while (memoryHasValue) {
                    memoryHasValue = this.handleArraySubscript(this.address, subscript, expectedType, arrayType);
                    ++subscript;
                }
                return null;
            }

            private boolean handleArraySubscript(Address pArrayAddress, int pSubscript, CType pExpectedType, CArrayType pArrayType) {
                ValueLiteral valueLiteral;
                int typeSize = AssumptionToEdgeAllocator.this.machineModel.getSizeof(pExpectedType);
                int subscriptOffset = pSubscript * typeSize;
                int arraySize = AssumptionToEdgeAllocator.this.machineModel.getSizeof(pArrayType);
                if (!pArrayAddress.isConcrete() || arraySize <= subscriptOffset) {
                    return false;
                }
                Address address = pArrayAddress.addOffset(BigInteger.valueOf(subscriptOffset));
                BigInteger subscript = BigInteger.valueOf(pSubscript);
                CIntegerLiteralExpression litExp = new CIntegerLiteralExpression(FileLocation.DUMMY, CNumericTypes.INT, subscript);
                CArraySubscriptExpression arraySubscript = new CArraySubscriptExpression(this.subExpression.getFileLocation(), pExpectedType, this.subExpression, litExp);
                Object value = AssumptionToEdgeAllocator.this.isStructOrUnionType(pExpectedType) || pExpectedType instanceof CArrayType ? address : AssumptionToEdgeAllocator.this.modelAtEdge.getValueFromMemory(arraySubscript, address);
                if (value == null) {
                    return false;
                }
                Address valueAddress = Address.getUnknownAddress();
                if (pExpectedType instanceof CSimpleType) {
                    valueLiteral = ValueLiteralsVisitor.this.getValueLiteral((CSimpleType)pExpectedType, value);
                } else {
                    valueAddress = Address.valueOf(value);
                    if (valueAddress.isUnknown()) {
                        return false;
                    }
                    valueLiteral = ExplicitValueLiteral.valueOf(valueAddress);
                }
                if (!valueLiteral.isUnknown()) {
                    SubExpressionValueLiteral subExpressionValueLiteral = new SubExpressionValueLiteral(valueLiteral, arraySubscript);
                    this.valueLiterals.addSubExpressionValueLiteral(subExpressionValueLiteral);
                }
                if (!valueAddress.isUnknown()) {
                    Pair visits = Pair.of((Object)pExpectedType, (Object)valueAddress);
                    if (this.visited.contains(visits)) {
                        return false;
                    }
                    this.visited.add((Pair<CType, Address>)visits);
                    ValueLiteralVisitor v = new ValueLiteralVisitor(valueAddress, this.valueLiterals, arraySubscript, this.visited);
                    pExpectedType.accept(v);
                }
                return true;
            }

            @Override
            public Void visit(CPointerType pointerType) {
                ValueLiteral valueLiteral;
                CType expectedType = pointerType.getType().getCanonicalType();
                CPointerExpression pointerExp = new CPointerExpression(this.subExpression.getFileLocation(), expectedType, this.subExpression);
                Object value = AssumptionToEdgeAllocator.this.isStructOrUnionType(expectedType) || expectedType instanceof CArrayType ? this.address : AssumptionToEdgeAllocator.this.modelAtEdge.getValueFromMemory(pointerExp, this.address);
                if (value == null) {
                    return null;
                }
                Address valueAddress = Address.getUnknownAddress();
                if (expectedType instanceof CSimpleType) {
                    valueLiteral = ValueLiteralsVisitor.this.getValueLiteral((CSimpleType)expectedType, value);
                } else {
                    valueAddress = Address.valueOf(value);
                    if (valueAddress.isUnknown()) {
                        return null;
                    }
                    valueLiteral = ExplicitValueLiteral.valueOf(valueAddress);
                }
                if (!valueLiteral.isUnknown()) {
                    SubExpressionValueLiteral subExpressionValueLiteral = new SubExpressionValueLiteral(valueLiteral, pointerExp);
                    this.valueLiterals.addSubExpressionValueLiteral(subExpressionValueLiteral);
                }
                if (!valueAddress.isUnknown()) {
                    Pair visits = Pair.of((Object)expectedType, (Object)valueAddress);
                    if (this.visited.contains(visits)) {
                        return null;
                    }
                    this.visited.add((Pair<CType, Address>)visits);
                    ValueLiteralVisitor v = new ValueLiteralVisitor(valueAddress, this.valueLiterals, pointerExp, this.visited);
                    expectedType.accept(v);
                }
                return null;
            }
        }
    }

    private class LModelValueVisitor
    implements CLeftHandSideVisitor<Object, RuntimeException> {
        private final String functionName;
        private final AddressValueVisitor addressVisitor;

        public LModelValueVisitor(String pFunctionName) {
            this.functionName = pFunctionName;
            this.addressVisitor = new AddressValueVisitor(this);
        }

        private Address getAddress(CSimpleDeclaration dcl) {
            return this.addressVisitor.getAddress(dcl);
        }

        private final Number evaluateNumericalValue(CExpression exp) {
            Value addressV;
            try {
                ModelExpressionValueVisitor v = new ModelExpressionValueVisitor(this.functionName, AssumptionToEdgeAllocator.this.machineModel, new LogManagerWithoutDuplicates(AssumptionToEdgeAllocator.this.logger));
                addressV = exp.accept(v);
            }
            catch (ArithmeticException e) {
                AssumptionToEdgeAllocator.this.logger.logDebugException((Throwable)e);
                AssumptionToEdgeAllocator.this.logger.log(Level.WARNING, new Object[]{"The expression " + exp.toASTString() + "could not be correctly evaluated while calculating the concrete values " + "in the counterexample path."});
                return null;
            }
            catch (UnrecognizedCCodeException e1) {
                throw new IllegalArgumentException(e1);
            }
            if (addressV.isUnknown() && !addressV.isNumericValue()) {
                return null;
            }
            return addressV.asNumericValue().getNumber();
        }

        private final Address evaluateNumericalValueAsAddress(CExpression exp) {
            Number result = this.evaluateNumericalValue(exp);
            if (result == null) {
                return Address.getUnknownAddress();
            }
            return Address.valueOf(result);
        }

        private Address evaluateAddress(CLeftHandSide pExp) {
            return pExp.accept(this.addressVisitor);
        }

        @Override
        public Object visit(CArraySubscriptExpression pIastArraySubscriptExpression) {
            Address valueAddress = this.evaluateAddress(pIastArraySubscriptExpression);
            if (valueAddress.isUnknown()) {
                return null;
            }
            CType type = pIastArraySubscriptExpression.getExpressionType().getCanonicalType();
            if (type instanceof CArrayType || this.isStructOrUnionType(type)) {
                if (valueAddress.isSymbolic()) {
                    return null;
                }
                return valueAddress.getAddressValue();
            }
            Object value = AssumptionToEdgeAllocator.this.modelAtEdge.getValueFromMemory(pIastArraySubscriptExpression, valueAddress);
            return value;
        }

        @Override
        public Object visit(CFieldReference pIastFieldReference) {
            Address address = this.evaluateAddress(pIastFieldReference);
            if (address.isUnknown()) {
                return this.lookupReference(pIastFieldReference);
            }
            CType type = pIastFieldReference.getExpressionType().getCanonicalType();
            if (type instanceof CArrayType || this.isStructOrUnionType(type)) {
                if (address.isSymbolic()) {
                    return null;
                }
                return address.getAddressValue();
            }
            Object value = AssumptionToEdgeAllocator.this.modelAtEdge.getValueFromMemory(pIastFieldReference, address);
            if (value == null) {
                return this.lookupReference(pIastFieldReference);
            }
            return value;
        }

        private Object lookupReference(CFieldReference pIastFieldReference) {
            FieldReference fieldReference = AssumptionToEdgeAllocator.this.getFieldReference(pIastFieldReference, this.functionName);
            if (fieldReference != null && AssumptionToEdgeAllocator.this.modelAtEdge.hasValueForLeftHandSide(fieldReference)) {
                return AssumptionToEdgeAllocator.this.modelAtEdge.getVariableValue(fieldReference);
            }
            return null;
        }

        private BigDecimal getFieldOffset(CFieldReference fieldReference) {
            CType fieldOwnerType = fieldReference.getFieldOwner().getExpressionType().getCanonicalType();
            return this.getFieldOffset(fieldOwnerType, fieldReference.getFieldName());
        }

        private BigDecimal getFieldOffset(CType ownerType, String fieldName) {
            if (ownerType instanceof CElaboratedType) {
                CComplexType realType = ((CElaboratedType)ownerType).getRealType();
                if (realType == null) {
                    return null;
                }
                return this.getFieldOffset(realType.getCanonicalType(), fieldName);
            }
            if (ownerType instanceof CCompositeType) {
                return this.getFieldOffset((CCompositeType)ownerType, fieldName);
            }
            if (ownerType instanceof CPointerType) {
                CType type = ((CPointerType)ownerType).getType().getCanonicalType();
                return this.getFieldOffset(type, fieldName);
            }
            throw new AssertionError();
        }

        private BigDecimal getFieldOffset(CCompositeType ownerType, String fieldName) {
            List<CCompositeType.CCompositeTypeMemberDeclaration> membersOfType = ownerType.getMembers();
            int offset = 0;
            for (CCompositeType.CCompositeTypeMemberDeclaration typeMember : membersOfType) {
                String memberName = typeMember.getName();
                if (memberName.equals(fieldName)) {
                    return BigDecimal.valueOf(offset);
                }
                if (ownerType.getKind() == CComplexType.ComplexTypeKind.UNION) continue;
                offset += AssumptionToEdgeAllocator.this.machineModel.getSizeof(typeMember.getType().getCanonicalType());
            }
            return null;
        }

        @Override
        public Object visit(CIdExpression pCIdExpression) {
            CSimpleDeclaration dcl = pCIdExpression.getDeclaration();
            Address address = this.evaluateAddress(pCIdExpression);
            if (address.isUnknown()) {
                return this.lookupVariable(dcl);
            }
            CType type = pCIdExpression.getExpressionType().getCanonicalType();
            if (type instanceof CArrayType || this.isStructOrUnionType(type)) {
                if (address.isSymbolic()) {
                    return this.lookupVariable(dcl);
                }
                return address.getAddressValue();
            }
            Object value = AssumptionToEdgeAllocator.this.modelAtEdge.getValueFromMemory(pCIdExpression, address);
            if (value == null) {
                return this.lookupVariable(dcl);
            }
            return value;
        }

        @Nullable
        private Object handleVariableDeclaration(CSimpleDeclaration pDcl) {
            if (pDcl instanceof CFunctionDeclaration || pDcl instanceof CTypeDeclaration) {
                return null;
            }
            CIdExpression representingIdExpression = new CIdExpression(pDcl.getFileLocation(), pDcl);
            return this.visit(representingIdExpression);
        }

        private Object lookupVariable(CSimpleDeclaration pVarDcl) {
            IDExpression varName = this.getIDExpression(pVarDcl);
            if (AssumptionToEdgeAllocator.this.modelAtEdge.hasValueForLeftHandSide(varName)) {
                return AssumptionToEdgeAllocator.this.modelAtEdge.getVariableValue(varName);
            }
            return null;
        }

        private IDExpression getIDExpression(CSimpleDeclaration pDcl) {
            String name = pDcl.getName();
            if (pDcl instanceof CDeclaration && ((CDeclaration)pDcl).isGlobal()) {
                return new IDExpression(name);
            }
            return new IDExpression(name, this.functionName);
        }

        @Override
        public Object visit(CPointerExpression pPointerExpression) {
            Address address = this.evaluateAddress(pPointerExpression);
            if (address.isUnknown()) {
                return null;
            }
            CType type = pPointerExpression.getExpressionType().getCanonicalType();
            if (type instanceof CArrayType || this.isStructOrUnionType(type)) {
                if (address.isSymbolic()) {
                    return null;
                }
                return address.getAddressValue();
            }
            return AssumptionToEdgeAllocator.this.modelAtEdge.getValueFromMemory(pPointerExpression, address);
        }

        boolean isStructOrUnionType(CType rValueType) {
            if ((rValueType = rValueType.getCanonicalType()) instanceof CElaboratedType) {
                CElaboratedType type = (CElaboratedType)rValueType;
                return type.getKind() != CComplexType.ComplexTypeKind.ENUM;
            }
            if (rValueType instanceof CCompositeType) {
                CCompositeType type = (CCompositeType)rValueType;
                return type.getKind() != CComplexType.ComplexTypeKind.ENUM;
            }
            return false;
        }

        @Override
        public Object visit(CComplexCastExpression pComplexCastExpression) {
            return null;
        }

        private class ModelExpressionValueVisitor
        extends AbstractExpressionValueVisitor {
            public ModelExpressionValueVisitor(String pFunctionName, MachineModel pMachineModel, LogManagerWithoutDuplicates pLogger) {
                super(pFunctionName, pMachineModel, pLogger);
            }

            @Override
            public Value visit(CBinaryExpression binaryExp) throws UnrecognizedCCodeException {
                CExpression lVarInBinaryExp = binaryExp.getOperand1();
                CExpression rVarInBinaryExp = binaryExp.getOperand2();
                CType lVarInBinaryExpType = lVarInBinaryExp.getExpressionType().getCanonicalType();
                CType rVarInBinaryExpType = rVarInBinaryExp.getExpressionType().getCanonicalType();
                boolean lVarIsAddress = lVarInBinaryExpType instanceof CPointerType || lVarInBinaryExpType instanceof CArrayType;
                boolean rVarIsAddress = rVarInBinaryExpType instanceof CPointerType || rVarInBinaryExpType instanceof CArrayType;
                CExpression address = null;
                CExpression pointerOffset = null;
                CType addressType = null;
                if (lVarIsAddress && rVarIsAddress) {
                    return Value.UnknownValue.getInstance();
                }
                if (lVarIsAddress) {
                    address = lVarInBinaryExp;
                    pointerOffset = rVarInBinaryExp;
                    addressType = lVarInBinaryExpType;
                } else if (rVarIsAddress) {
                    address = rVarInBinaryExp;
                    pointerOffset = lVarInBinaryExp;
                    addressType = rVarInBinaryExpType;
                } else {
                    return super.visit(binaryExp);
                }
                CBinaryExpression.BinaryOperator binaryOperator = binaryExp.getOperator();
                CType elementType = addressType instanceof CPointerType ? ((CPointerType)addressType).getType().getCanonicalType() : ((CArrayType)addressType).getType().getCanonicalType();
                switch (binaryOperator) {
                    case PLUS: 
                    case MINUS: {
                        Value addressValueV = address.accept(this);
                        Value offsetValueV = pointerOffset.accept(this);
                        if (addressValueV.isUnknown() || offsetValueV.isUnknown() || !addressValueV.isNumericValue() || !offsetValueV.isNumericValue()) {
                            return Value.UnknownValue.getInstance();
                        }
                        Number addressValueNumber = addressValueV.asNumericValue().getNumber();
                        BigDecimal addressValue = new BigDecimal(addressValueNumber.toString());
                        Number offsetValueNumber = offsetValueV.asNumericValue().getNumber();
                        BigDecimal offsetValue = new BigDecimal(offsetValueNumber.toString());
                        BigDecimal typeSize = BigDecimal.valueOf(this.getSizeof(elementType));
                        BigDecimal pointerOffsetValue = offsetValue.multiply(typeSize);
                        switch (binaryOperator) {
                            case PLUS: {
                                return new NumericValue(addressValue.add(pointerOffsetValue));
                            }
                            case MINUS: {
                                if (lVarIsAddress) {
                                    return new NumericValue(addressValue.subtract(pointerOffsetValue));
                                }
                                throw new UnrecognizedCCodeException("Expected pointer arithmetic  with + or - but found " + binaryExp.toASTString(), binaryExp);
                            }
                        }
                        throw new AssertionError();
                    }
                }
                return Value.UnknownValue.getInstance();
            }

            @Override
            public Value visit(CUnaryExpression pUnaryExpression) throws UnrecognizedCCodeException {
                if (pUnaryExpression.getOperator() == CUnaryExpression.UnaryOperator.AMPER) {
                    CExpression operand = pUnaryExpression.getOperand();
                    return this.handleAmper(operand);
                }
                return super.visit(pUnaryExpression);
            }

            private Value handleAmper(CExpression pOperand) {
                if (pOperand instanceof CLeftHandSide) {
                    Address address = LModelValueVisitor.this.evaluateAddress((CLeftHandSide)pOperand);
                    if (address.isConcrete()) {
                        return new NumericValue(address.getAddressValue());
                    }
                } else if (pOperand instanceof CCastExpression) {
                    return this.handleAmper(((CCastExpression)pOperand).getOperand());
                }
                return Value.UnknownValue.getInstance();
            }

            @Override
            protected Value evaluateCPointerExpression(CPointerExpression pCPointerExpression) throws UnrecognizedCCodeException {
                Object value = LModelValueVisitor.this.visit(pCPointerExpression);
                if (value == null || !(value instanceof Number)) {
                    return Value.UnknownValue.getInstance();
                }
                return new NumericValue((Number)value);
            }

            @Override
            protected Value evaluateCIdExpression(CIdExpression pCIdExpression) throws UnrecognizedCCodeException {
                Object value = LModelValueVisitor.this.visit(pCIdExpression);
                if (value == null || !(value instanceof Number)) {
                    return Value.UnknownValue.getInstance();
                }
                return new NumericValue((Number)value);
            }

            @Override
            protected Value evaluateJIdExpression(JIdExpression pVarName) {
                return Value.UnknownValue.getInstance();
            }

            @Override
            protected Value evaluateCFieldReference(CFieldReference pLValue) throws UnrecognizedCCodeException {
                Object value = LModelValueVisitor.this.visit(pLValue);
                if (value == null || !(value instanceof Number)) {
                    return Value.UnknownValue.getInstance();
                }
                return new NumericValue((Number)value);
            }

            @Override
            protected Value evaluateCArraySubscriptExpression(CArraySubscriptExpression pLValue) throws UnrecognizedCCodeException {
                Object value = LModelValueVisitor.this.visit(pLValue);
                if (value == null || !(value instanceof Number)) {
                    return Value.UnknownValue.getInstance();
                }
                return new NumericValue((Number)value);
            }
        }

        private class AddressValueVisitor
        implements CLeftHandSideVisitor<Address, RuntimeException> {
            private final LModelValueVisitor valueVisitor;

            public AddressValueVisitor(LModelValueVisitor pValueVisitor) {
                this.valueVisitor = pValueVisitor;
            }

            public Address getAddress(CSimpleDeclaration dcl) {
                IDExpression name = LModelValueVisitor.this.getIDExpression(dcl);
                if (AssumptionToEdgeAllocator.this.modelAtEdge.hasAddressOfVaribable(name)) {
                    return AssumptionToEdgeAllocator.this.modelAtEdge.getVariableAddress(name);
                }
                return Address.getUnknownAddress();
            }

            @Override
            public Address visit(CArraySubscriptExpression pIastArraySubscriptExpression) {
                CExpression arrayExpression = pIastArraySubscriptExpression.getArrayExpression();
                Address address = LModelValueVisitor.this.evaluateNumericalValueAsAddress(arrayExpression);
                if (address.isUnknown() || address.isSymbolic()) {
                    return Address.getUnknownAddress();
                }
                CExpression subscriptCExpression = pIastArraySubscriptExpression.getSubscriptExpression();
                Number subscriptValueNumber = LModelValueVisitor.this.evaluateNumericalValue(subscriptCExpression);
                if (subscriptValueNumber == null) {
                    return Address.getUnknownAddress();
                }
                BigDecimal subscriptValue = new BigDecimal(subscriptValueNumber.toString());
                BigDecimal typeSize = BigDecimal.valueOf(AssumptionToEdgeAllocator.this.machineModel.getSizeof(pIastArraySubscriptExpression.getExpressionType().getCanonicalType()));
                BigDecimal subscriptOffset = subscriptValue.multiply(typeSize);
                return address.addOffset(subscriptOffset);
            }

            @Override
            public Address visit(CFieldReference pIastFieldReference) {
                CExpression fieldOwner = pIastFieldReference.getFieldOwner();
                Address fieldOwnerAddress = LModelValueVisitor.this.evaluateNumericalValueAsAddress(fieldOwner);
                if (fieldOwnerAddress.isUnknown() || fieldOwnerAddress.isSymbolic()) {
                    return this.lookupReferenceAddress(pIastFieldReference);
                }
                BigDecimal fieldOffset = LModelValueVisitor.this.getFieldOffset(pIastFieldReference);
                if (fieldOffset == null) {
                    return this.lookupReferenceAddress(pIastFieldReference);
                }
                Address address = fieldOwnerAddress.addOffset(fieldOffset);
                if (address.isUnknown()) {
                    return this.lookupReferenceAddress(pIastFieldReference);
                }
                return address;
            }

            private Address lookupReferenceAddress(CFieldReference pIastFieldReference) {
                FieldReference fieldReferenceName = AssumptionToEdgeAllocator.this.getFieldReference(pIastFieldReference, LModelValueVisitor.this.functionName);
                if (fieldReferenceName != null && AssumptionToEdgeAllocator.this.modelAtEdge.hasAddressOfVaribable(fieldReferenceName)) {
                    return AssumptionToEdgeAllocator.this.modelAtEdge.getVariableAddress(fieldReferenceName);
                }
                return Address.getUnknownAddress();
            }

            @Override
            public Address visit(CIdExpression pIastIdExpression) {
                return this.getAddress(pIastIdExpression.getDeclaration());
            }

            @Override
            public Address visit(CPointerExpression pPointerExpression) {
                return this.valueVisitor.evaluateNumericalValueAsAddress(pPointerExpression.getOperand());
            }

            @Override
            public Address visit(CComplexCastExpression pComplexCastExpression) {
                return Address.getUnknownAddress();
            }
        }
    }
}

