/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.counterexample;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.counterexample.CStatementToOriginalCodeVisitor;

public class CFAEdgeWithAssumptions {
    private final CFAEdge edge;
    private final List<AExpressionStatement> expressionStmts;
    private final String comment;

    public CFAEdgeWithAssumptions(CFAEdge pEdge, List<AExpressionStatement> pExpStmt, String pComment) {
        assert (pExpStmt != null);
        assert (pComment != null);
        this.edge = pEdge;
        this.expressionStmts = pExpStmt;
        this.comment = pComment;
    }

    private CFAEdgeWithAssumptions(CFAEdgeWithAssumptions pEdgeWA, CFAEdgeWithAssumptions pEdgeWA2) {
        assert (pEdgeWA.edge.equals(pEdgeWA2.edge));
        this.edge = pEdgeWA.edge;
        List<AExpressionStatement> expStmts1 = pEdgeWA.getExpStmts();
        List<AExpressionStatement> expStmts2 = pEdgeWA2.getExpStmts();
        ArrayList<AExpressionStatement> result = new ArrayList<AExpressionStatement>(pEdgeWA.expressionStmts);
        for (AExpressionStatement expStmt2 : expStmts2) {
            if (expStmts1.contains(expStmt2)) continue;
            result.add(expStmt2);
        }
        this.comment = pEdgeWA.comment;
        this.expressionStmts = result;
    }

    public List<AExpressionStatement> getExpStmts() {
        return this.expressionStmts;
    }

    public CFAEdge getCFAEdge() {
        return this.edge;
    }

    public String getAsCode() {
        if (this.expressionStmts.size() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (AExpressionStatement expressionStmt : this.expressionStmts) {
            if (expressionStmt instanceof CExpressionStatement) {
                result.append(((CExpressionStatement)expressionStmt).accept(CStatementToOriginalCodeVisitor.INSTANCE));
                continue;
            }
            return "";
        }
        return result.toString();
    }

    public String prettyPrintCode(int numberOfTabsPerLine) {
        if (this.expressionStmts.size() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (AExpressionStatement expStmt : this.expressionStmts) {
            if (expStmt instanceof CExpressionStatement) {
                for (int c = 0; c < numberOfTabsPerLine; ++c) {
                    result.append("\t");
                }
                result.append(expStmt.toASTString());
                result.append(System.lineSeparator());
                continue;
            }
            return "";
        }
        return result.toString();
    }

    public String prettyPrint() {
        String expStmt = this.prettyPrintCode(0);
        String comment = this.getComment();
        return expStmt + comment;
    }

    public String printForHTML() {
        return this.prettyPrint().replace(System.lineSeparator(), "\n");
    }

    public String toString() {
        return this.edge.toString() + " " + this.expressionStmts.toString();
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    public CFAEdgeWithAssumptions mergeEdge(CFAEdgeWithAssumptions pEdge) {
        return new CFAEdgeWithAssumptions(this, pEdge);
    }
}

