/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.counterexample;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.ABinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAssumptions;

public final class CFAMultiEdgeWithAssumptions
extends CFAEdgeWithAssumptions
implements Iterable<CFAEdgeWithAssumptions> {
    private final List<CFAEdgeWithAssumptions> edgesWithAssignment;

    private CFAMultiEdgeWithAssumptions(MultiEdge pEdge, List<AExpressionStatement> pAssignments, List<CFAEdgeWithAssumptions> pEdges, String pComments) {
        super(pEdge, pAssignments, pComments);
        this.edgesWithAssignment = ImmutableList.copyOf(pEdges);
    }

    @Override
    public Iterator<CFAEdgeWithAssumptions> iterator() {
        return this.getEdgesWithAssignment().iterator();
    }

    public List<CFAEdgeWithAssumptions> getEdgesWithAssignment() {
        return this.edgesWithAssignment;
    }

    @Override
    public CFAEdgeWithAssumptions mergeEdge(CFAEdgeWithAssumptions pEdge) {
        if (!(pEdge instanceof CFAMultiEdgeWithAssumptions)) {
            return this;
        }
        CFAMultiEdgeWithAssumptions other = (CFAMultiEdgeWithAssumptions)pEdge;
        assert (pEdge.getCFAEdge().equals(this.getCFAEdge()));
        assert (other.edgesWithAssignment.size() == this.edgesWithAssignment.size());
        ArrayList<CFAEdgeWithAssumptions> result = new ArrayList<CFAEdgeWithAssumptions>();
        Iterator<CFAEdgeWithAssumptions> otherIt = other.iterator();
        for (CFAEdgeWithAssumptions thisEdge : this.edgesWithAssignment) {
            result.add(thisEdge.mergeEdge(otherIt.next()));
        }
        return CFAMultiEdgeWithAssumptions.valueOf((MultiEdge)pEdge.getCFAEdge(), result);
    }

    public static final CFAMultiEdgeWithAssumptions valueOf(MultiEdge pEdge, List<CFAEdgeWithAssumptions> pEdges) {
        LinkedHashMap<AExpression, AExpressionStatement> assignments = new LinkedHashMap<AExpression, AExpressionStatement>();
        for (CFAEdgeWithAssumptions edge : pEdges) {
            for (AExpressionStatement assignment : edge.getExpStmts()) {
                AExpression expression = assignment.getExpression();
                if (expression instanceof ABinaryExpression) {
                    ABinaryExpression binExp = (ABinaryExpression)expression;
                    if (!CFAMultiEdgeWithAssumptions.isDistinct(binExp)) continue;
                    assignments.put(binExp.getOperand1(), assignment);
                    continue;
                }
                throw new AssertionError((Object)"Assumption have to be binary expressions");
            }
        }
        return new CFAMultiEdgeWithAssumptions(pEdge, (List<AExpressionStatement>)ImmutableList.copyOf(assignments.values()), pEdges, "");
    }

    private static boolean isDistinct(ABinaryExpression pBinExp) {
        return pBinExp.getOperand1() instanceof AIdExpression;
    }
}

