/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.counterexample;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sosy_lab.common.JSON;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.counterexample.AssumptionToEdgeAllocator;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.CFAMultiEdgeWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteState;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteStatePath;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;

public class CFAPathWithAssumptions
implements Iterable<CFAEdgeWithAssumptions> {
    private final List<CFAEdgeWithAssumptions> pathWithAssignments;

    private CFAPathWithAssumptions(List<CFAEdgeWithAssumptions> pPathWithAssignments) {
        this.pathWithAssignments = ImmutableList.copyOf(pPathWithAssignments);
    }

    private CFAPathWithAssumptions(CFAPathWithAssumptions pPathWithAssignments, CFAPathWithAssumptions pPathWithAssignments2) {
        assert (pPathWithAssignments.size() == pPathWithAssignments2.size());
        ArrayList<CFAEdgeWithAssumptions> result = new ArrayList<CFAEdgeWithAssumptions>(pPathWithAssignments.size());
        Iterator<CFAEdgeWithAssumptions> path2Iterator = pPathWithAssignments2.iterator();
        for (CFAEdgeWithAssumptions edge : pPathWithAssignments) {
            CFAEdgeWithAssumptions resultEdge = edge.mergeEdge(path2Iterator.next());
            result.add(resultEdge);
        }
        this.pathWithAssignments = result;
    }

    public CFAPathWithAssumptions() {
        this.pathWithAssignments = ImmutableList.of();
    }

    @Nullable
    public CFAPathWithAssumptions getExactVariableValues(List<CFAEdge> pPath) {
        if (this.fitsPath(pPath)) {
            return this;
        }
        int index = this.pathWithAssignments.size() - pPath.size();
        if (index < 0) {
            return null;
        }
        ArrayList<CFAEdgeWithAssumptions> result = new ArrayList<CFAEdgeWithAssumptions>(pPath.size());
        for (CFAEdge edge : pPath) {
            if (index > this.pathWithAssignments.size()) {
                return null;
            }
            CFAEdgeWithAssumptions cfaWithAssignment = this.pathWithAssignments.get(index);
            if (!edge.equals(cfaWithAssignment.getCFAEdge())) {
                return null;
            }
            result.add(cfaWithAssignment);
            ++index;
        }
        return new CFAPathWithAssumptions(result);
    }

    private boolean fitsPath(List<CFAEdge> pPath) {
        if (pPath.size() != this.pathWithAssignments.size()) {
            return false;
        }
        int index = 0;
        for (CFAEdge edge : pPath) {
            CFAEdgeWithAssumptions cfaWithAssignment;
            if (!edge.equals((cfaWithAssignment = this.pathWithAssignments.get(index)).getCFAEdge())) {
                return false;
            }
            ++index;
        }
        return true;
    }

    @Nullable
    public Map<ARGState, CFAEdgeWithAssumptions> getExactVariableValues(ARGPath pPath) {
        if (pPath.getInnerEdges().size() != this.pathWithAssignments.size()) {
            return null;
        }
        HashMap<ARGState, CFAEdgeWithAssumptions> result = new HashMap<ARGState, CFAEdgeWithAssumptions>();
        ARGPath.PathIterator pathIterator = pPath.pathIterator();
        while (pathIterator.hasNext()) {
            CFAEdgeWithAssumptions edgeWithAssignment = this.pathWithAssignments.get(pathIterator.getIndex());
            CFAEdge argPathEdge = pathIterator.getOutgoingEdge();
            if (!edgeWithAssignment.getCFAEdge().equals(argPathEdge)) {
                return null;
            }
            result.put(pathIterator.getAbstractState(), edgeWithAssignment);
            pathIterator.advance();
        }
        return result;
    }

    public static CFAPathWithAssumptions of(ConcreteStatePath statePath, LogManager pLogger, MachineModel pMachineModel) {
        ArrayList<CFAEdgeWithAssumptions> result = new ArrayList<CFAEdgeWithAssumptions>(statePath.size());
        for (ConcreteStatePath.ConcerteStatePathNode node : statePath) {
            CFAEdgeWithAssumptions edge;
            if (node instanceof ConcreteStatePath.SingleConcreteState) {
                ConcreteStatePath.SingleConcreteState singleState = (ConcreteStatePath.SingleConcreteState)node;
                edge = CFAPathWithAssumptions.createCFAEdgeWithAssignment(singleState, pLogger, pMachineModel);
                result.add(edge);
                continue;
            }
            ConcreteStatePath.MultiConcreteState multiState = (ConcreteStatePath.MultiConcreteState)node;
            edge = CFAPathWithAssumptions.createCFAEdgeWithAssignment(multiState, pLogger, pMachineModel);
            result.add(edge);
        }
        return new CFAPathWithAssumptions(result);
    }

    private static CFAEdgeWithAssumptions createCFAEdgeWithAssignment(ConcreteStatePath.MultiConcreteState state, LogManager pLogger, MachineModel pMachineModel) {
        MultiEdge cfaEdge = state.getCfaEdge();
        ArrayList<CFAEdgeWithAssumptions> pEdges = new ArrayList<CFAEdgeWithAssumptions>(cfaEdge.getEdges().size());
        for (ConcreteStatePath.SingleConcreteState node : state) {
            pEdges.add(CFAPathWithAssumptions.createCFAEdgeWithAssignment(node, pLogger, pMachineModel));
        }
        CFAMultiEdgeWithAssumptions edge = CFAMultiEdgeWithAssumptions.valueOf(cfaEdge, pEdges);
        return edge;
    }

    private static CFAEdgeWithAssumptions createCFAEdgeWithAssignment(ConcreteStatePath.SingleConcreteState state, LogManager pLogger, MachineModel pMachineModel) {
        CFAEdge cfaEdge = state.getCfaEdge();
        ConcreteState concreteState = state.getConcreteState();
        AssumptionToEdgeAllocator allocator = new AssumptionToEdgeAllocator(pLogger, cfaEdge, concreteState, pMachineModel);
        return allocator.allocateAssumptionsToEdge();
    }

    public boolean isEmpty() {
        return this.pathWithAssignments.isEmpty();
    }

    public String toString() {
        return this.pathWithAssignments.toString();
    }

    public CFAEdge getCFAEdgeAtPosition(int index) {
        return this.pathWithAssignments.get(index).getCFAEdge();
    }

    public int size() {
        return this.pathWithAssignments.size();
    }

    @Override
    public Iterator<CFAEdgeWithAssumptions> iterator() {
        return this.pathWithAssignments.iterator();
    }

    public void toJSON(Appendable sb, ARGPath argPath) throws IOException {
        ArrayList path = new ArrayList(this.size());
        if (argPath.getInnerEdges().size() != this.pathWithAssignments.size()) {
            argPath.toJSON(sb);
            return;
        }
        int index = 0;
        for (Pair pair : Pair.zipWithPadding(argPath.asStatesList(), argPath.asEdgesList())) {
            HashMap<String, Object> elem = new HashMap<String, Object>();
            ARGState argelem = (ARGState)pair.getFirst();
            CFAEdge edge = (CFAEdge)pair.getSecond();
            if (edge == null) continue;
            elem.put("argelem", argelem.getStateId());
            elem.put("source", edge.getPredecessor().getNodeNumber());
            elem.put("target", edge.getSuccessor().getNodeNumber());
            elem.put("desc", edge.getDescription().replaceAll("\n", " "));
            elem.put("line", edge.getFileLocation().getStartingLineNumber());
            elem.put("file", edge.getFileLocation().getFileName());
            if (index == this.pathWithAssignments.size()) {
                elem.put("val", "");
            } else {
                CFAEdgeWithAssumptions edgeWithAssignment = this.pathWithAssignments.get(index);
                elem.put("val", edgeWithAssignment.printForHTML());
            }
            path.add(elem);
            ++index;
        }
        JSON.writeJSONString(path, (Appendable)sb);
    }

    public CFAPathWithAssumptions mergePaths(CFAPathWithAssumptions pOtherPath) {
        if (pOtherPath.size() != this.size()) {
            return this;
        }
        return new CFAPathWithAssumptions(this, pOtherPath);
    }
}

