/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.counterexample;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import org.sosy_lab.cpachecker.cfa.ast.AArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAddressOfLabelExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayRangeDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatorVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatementVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;

public enum CStatementToOriginalCodeVisitor implements CStatementVisitor<String, RuntimeException>
{
    INSTANCE;


    @Override
    public String visit(CExpressionStatement pIastExpressionStatement) {
        return pIastExpressionStatement.getExpression().accept(ExpressionToOrinalCodeVisitor.VISITOR_INSTANCE) + ";";
    }

    @Override
    public String visit(CExpressionAssignmentStatement pIastExpressionAssignmentStatement) {
        ExpressionToOrinalCodeVisitor expressionToOrinalCodeVisitor = ExpressionToOrinalCodeVisitor.VISITOR_INSTANCE;
        String leftHandSide = pIastExpressionAssignmentStatement.getLeftHandSide().accept(expressionToOrinalCodeVisitor);
        String rightHandSide = pIastExpressionAssignmentStatement.getRightHandSide().accept(expressionToOrinalCodeVisitor);
        return leftHandSide + " = " + rightHandSide + "; ";
    }

    @Override
    public String visit(CFunctionCallAssignmentStatement pIastFunctionCallAssignmentStatement) {
        ExpressionToOrinalCodeVisitor expressionToOrinalCodeVisitor = ExpressionToOrinalCodeVisitor.VISITOR_INSTANCE;
        String leftHandSide = pIastFunctionCallAssignmentStatement.getLeftHandSide().accept(expressionToOrinalCodeVisitor);
        String rightHandSide = CStatementToOriginalCodeVisitor.handleFunctionCallExpression(pIastFunctionCallAssignmentStatement.getFunctionCallExpression());
        return leftHandSide + " = " + rightHandSide + "; ";
    }

    @Override
    public String visit(CFunctionCallStatement pIastFunctionCallStatement) {
        return CStatementToOriginalCodeVisitor.handleFunctionCallExpression(pIastFunctionCallStatement.getFunctionCallExpression()) + ";";
    }

    private static String handleFunctionCallExpression(CFunctionCallExpression pFunctionCallExpression) {
        StringBuilder lASTString = new StringBuilder();
        lASTString.append(CStatementToOriginalCodeVisitor.parenthesize(pFunctionCallExpression.getFunctionNameExpression()));
        lASTString.append("(");
        Joiner.on((String)", ").appendTo(lASTString, Iterables.transform(pFunctionCallExpression.getParameterExpressions(), (Function)new Function<CExpression, String>(){

            public String apply(CExpression pInput) {
                return pInput.accept(ExpressionToOrinalCodeVisitor.VISITOR_INSTANCE);
            }
        }));
        lASTString.append(")");
        return lASTString.toString();
    }

    private static String parenthesize(String pInput) {
        return "(" + pInput + ")";
    }

    private static String parenthesize(CExpression pInput) {
        String result = pInput.accept(ExpressionToOrinalCodeVisitor.VISITOR_INSTANCE);
        if (pInput instanceof CIdExpression) {
            return result;
        }
        return CStatementToOriginalCodeVisitor.parenthesize(result);
    }

    private static enum DesignatorToOriginalCodeVisitor implements CDesignatorVisitor<String, RuntimeException>
    {
        VISITOR_INSTANCE;

        public static final Function<CDesignator, String> TO_CODE;

        @Override
        public String visit(CArrayDesignator pArrayDesignator) {
            return "[" + pArrayDesignator.getSubscriptExpression().accept(ExpressionToOrinalCodeVisitor.VISITOR_INSTANCE) + "]";
        }

        @Override
        public String visit(CArrayRangeDesignator pArrayRangeDesignator) {
            return "[" + pArrayRangeDesignator.getFloorExpression().accept(ExpressionToOrinalCodeVisitor.VISITOR_INSTANCE) + " ... " + pArrayRangeDesignator.getCeilExpression().accept(ExpressionToOrinalCodeVisitor.VISITOR_INSTANCE) + "]";
        }

        @Override
        public String visit(CFieldDesignator pFieldDesignator) {
            return "." + pFieldDesignator.getFieldName();
        }

        static {
            TO_CODE = new Function<CDesignator, String>(){

                public String apply(CDesignator pArg0) {
                    return pArg0.accept(VISITOR_INSTANCE);
                }
            };
        }
    }

    private static enum CInitializerToOriginalCodeVisitor implements CInitializerVisitor<String, RuntimeException>
    {
        VISITOR_INSTANCE;

        public static final Function<CInitializer, String> TO_CODE;

        @Override
        public String visit(CInitializerExpression pInitializerExpression) {
            return pInitializerExpression.getExpression().accept(ExpressionToOrinalCodeVisitor.VISITOR_INSTANCE);
        }

        @Override
        public String visit(CInitializerList pInitializerList) {
            StringBuilder code = new StringBuilder();
            code.append("{ ");
            Joiner.on((String)", ").appendTo(code, Iterables.transform(pInitializerList.getInitializers(), TO_CODE));
            code.append(" }");
            return code.toString();
        }

        @Override
        public String visit(CDesignatedInitializer pCStructInitializerPart) {
            return FluentIterable.from(pCStructInitializerPart.getDesignators()).transform(DesignatorToOriginalCodeVisitor.TO_CODE).join(Joiner.on((String)"")) + " = " + pCStructInitializerPart.getRightHandSide().accept(this);
        }

        static {
            TO_CODE = new Function<CInitializer, String>(){

                public String apply(CInitializer pArg0) {
                    return pArg0.accept(VISITOR_INSTANCE);
                }
            };
        }
    }

    private static enum ExpressionToOrinalCodeVisitor implements CExpressionVisitor<String, RuntimeException>
    {
        VISITOR_INSTANCE;


        @Override
        public String visit(CArraySubscriptExpression pIastArraySubscriptExpression) {
            CExpression arrayExpression = pIastArraySubscriptExpression.getArrayExpression();
            String left = arrayExpression instanceof AArraySubscriptExpression ? arrayExpression.accept(this) : CStatementToOriginalCodeVisitor.parenthesize(arrayExpression);
            CExpression subscriptExpression = pIastArraySubscriptExpression.getSubscriptExpression();
            return left + "[" + subscriptExpression.accept(this) + "]";
        }

        @Override
        public String visit(CFieldReference pIastFieldReference) {
            String left = pIastFieldReference.getFieldOwner() instanceof CFieldReference ? pIastFieldReference.getFieldOwner().accept(this) : CStatementToOriginalCodeVisitor.parenthesize(pIastFieldReference.getFieldOwner());
            String op = pIastFieldReference.isPointerDereference() ? "->" : ".";
            return left + op + pIastFieldReference.getFieldName();
        }

        @Override
        public String visit(CIdExpression pIastIdExpression) {
            return pIastIdExpression.getDeclaration().getOrigName();
        }

        @Override
        public String visit(CPointerExpression pPointerExpression) {
            return "*" + CStatementToOriginalCodeVisitor.parenthesize(pPointerExpression.getOperand().accept(this));
        }

        @Override
        public String visit(CComplexCastExpression pComplexCastExpression) {
            String operand = pComplexCastExpression.getOperand().accept(this);
            if (pComplexCastExpression.isRealCast()) {
                return "__real__ " + operand;
            }
            return "__imag__ " + operand;
        }

        @Override
        public String visit(CBinaryExpression pIastBinaryExpression) {
            return CStatementToOriginalCodeVisitor.parenthesize(pIastBinaryExpression.getOperand1()) + " " + pIastBinaryExpression.getOperator().getOperator() + " " + CStatementToOriginalCodeVisitor.parenthesize(pIastBinaryExpression.getOperand2());
        }

        @Override
        public String visit(CCastExpression pIastCastExpression) {
            CType type = pIastCastExpression.getExpressionType();
            String typeCode = type.toASTString("");
            return CStatementToOriginalCodeVisitor.parenthesize(typeCode) + CStatementToOriginalCodeVisitor.parenthesize(pIastCastExpression.getOperand());
        }

        @Override
        public String visit(CCharLiteralExpression pIastCharLiteralExpression) {
            char c = pIastCharLiteralExpression.getCharacter();
            if (c >= ' ' && c < '\u0080') {
                return "'" + c + "'";
            }
            return "'\\x" + Integer.toHexString(c) + "'";
        }

        @Override
        public String visit(CFloatLiteralExpression pIastFloatLiteralExpression) {
            return pIastFloatLiteralExpression.getValue().toString();
        }

        @Override
        public String visit(CIntegerLiteralExpression pIastIntegerLiteralExpression) {
            String suffix = "";
            CType cType = pIastIntegerLiteralExpression.getExpressionType();
            if (cType instanceof CSimpleType) {
                CSimpleType type = (CSimpleType)cType;
                if (type.isUnsigned()) {
                    suffix = suffix + "U";
                }
                if (type.isLong()) {
                    suffix = suffix + "L";
                } else if (type.isLongLong()) {
                    suffix = suffix + "LL";
                }
            }
            return pIastIntegerLiteralExpression.getValue().toString() + suffix;
        }

        @Override
        public String visit(CStringLiteralExpression pIastStringLiteralExpression) {
            return pIastStringLiteralExpression.getValue();
        }

        @Override
        public String visit(CTypeIdExpression pIastTypeIdExpression) {
            return pIastTypeIdExpression.getOperator().getOperator() + CStatementToOriginalCodeVisitor.parenthesize(pIastTypeIdExpression.getType().getCanonicalType().toASTString(""));
        }

        @Override
        public String visit(CUnaryExpression pIastUnaryExpression) {
            CUnaryExpression.UnaryOperator operator = pIastUnaryExpression.getOperator();
            if (operator == CUnaryExpression.UnaryOperator.SIZEOF) {
                return operator.getOperator() + CStatementToOriginalCodeVisitor.parenthesize(pIastUnaryExpression.getOperand().accept(this));
            }
            return operator.getOperator() + CStatementToOriginalCodeVisitor.parenthesize(pIastUnaryExpression.getOperand());
        }

        @Override
        public String visit(CImaginaryLiteralExpression pIastLiteralExpression) {
            return pIastLiteralExpression.getValue().toString() + "i";
        }

        @Override
        public String visit(CAddressOfLabelExpression pAddressOfLabelExpression) {
            return pAddressOfLabelExpression.toASTString();
        }
    }
}

