/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.counterexample;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.core.counterexample.Address;
import org.sosy_lab.cpachecker.core.counterexample.LeftHandSide;
import org.sosy_lab.cpachecker.core.counterexample.Memory;
import org.sosy_lab.cpachecker.core.counterexample.MemoryName;

public final class ConcreteState {
    private static final ConcreteState EMPTY_CONCRETE_STATE = new ConcreteState();
    private final Map<LeftHandSide, Object> variables;
    private final Map<String, Memory> allocatedMemory;
    private final Map<LeftHandSide, Address> variableAddressMap;
    private final MemoryName memoryNameAllocator;

    public ConcreteState(Map<LeftHandSide, Object> pVariables, Map<String, Memory> pAllocatedMemory, Map<LeftHandSide, Address> pVariableAddressMap, MemoryName pMemoryName) {
        this.variableAddressMap = ImmutableMap.copyOf(pVariableAddressMap);
        this.allocatedMemory = ImmutableMap.copyOf(pAllocatedMemory);
        this.variables = ImmutableMap.copyOf(pVariables);
        this.memoryNameAllocator = pMemoryName;
    }

    private ConcreteState() {
        this.variableAddressMap = ImmutableMap.of();
        this.allocatedMemory = ImmutableMap.of();
        this.variables = ImmutableMap.of();
        this.memoryNameAllocator = new MemoryName(){

            @Override
            public String getMemoryName(CRightHandSide pExp, Address pAddress) {
                return "";
            }
        };
    }

    public Object getValueFromMemory(CRightHandSide exp, Address address) {
        String memoryName = this.memoryNameAllocator.getMemoryName(exp, address);
        if (!this.allocatedMemory.containsKey(memoryName)) {
            return null;
        }
        Memory memory = this.allocatedMemory.get(memoryName);
        if (memory.hasValue(address)) {
            return memory.getValue(address);
        }
        return null;
    }

    public boolean hasValueForLeftHandSide(LeftHandSide variable) {
        return this.variables.containsKey(variable);
    }

    public Object getVariableValue(LeftHandSide variable) {
        Preconditions.checkArgument((boolean)this.variables.containsKey(variable));
        return this.variables.get(variable);
    }

    public boolean hasAddressOfVaribable(LeftHandSide variable) {
        return this.variableAddressMap.containsKey(variable);
    }

    public Address getVariableAddress(LeftHandSide variable) {
        Preconditions.checkArgument((boolean)this.variableAddressMap.containsKey(variable));
        return this.variableAddressMap.get(variable);
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    @SuppressFBWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object obj) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "variables=" + this.variables + System.lineSeparator() + "allocatedMemory=" + this.allocatedMemory + System.lineSeparator() + " variableAddressMap=" + this.variableAddressMap;
    }

    public static ConcreteState empty() {
        return EMPTY_CONCRETE_STATE;
    }
}

