/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.counterexample;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteState;

public final class ConcreteStatePath
implements Iterable<ConcerteStatePathNode> {
    private final List<ConcerteStatePathNode> list;

    public ConcreteStatePath(List<ConcerteStatePathNode> pList) {
        this.list = ImmutableList.copyOf(pList);
    }

    @Override
    public final Iterator<ConcerteStatePathNode> iterator() {
        return this.list.iterator();
    }

    public static ConcerteStatePathNode valueOfPathNode(ConcreteState pConcreteState, CFAEdge cfaEdge) {
        Preconditions.checkArgument((cfaEdge.getEdgeType() != CFAEdgeType.MultiEdge ? 1 : 0) != 0);
        return new SingleConcreteState(cfaEdge, pConcreteState);
    }

    public static ConcerteStatePathNode valueOfPathNode(List<ConcreteState> pConcreteStates, MultiEdge multiEdge) {
        ImmutableList<CFAEdge> edges = multiEdge.getEdges();
        assert (pConcreteStates.size() == edges.size());
        ArrayList<SingleConcreteState> result = new ArrayList<SingleConcreteState>(pConcreteStates.size());
        int concreteStateCounter = 0;
        for (CFAEdge edge : edges) {
            result.add(new SingleConcreteState(edge, pConcreteStates.get(concreteStateCounter)));
            ++concreteStateCounter;
        }
        return new MultiConcreteState(multiEdge, result);
    }

    public int size() {
        return this.list.size();
    }

    @SuppressFBWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object pObj) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "ConcreteStatePath:" + this.list.toString();
    }

    static final class MultiConcreteState
    extends ConcerteStatePathNode
    implements Iterable<SingleConcreteState> {
        private final List<SingleConcreteState> concreteStates;

        public MultiConcreteState(MultiEdge pCfaEdge, List<SingleConcreteState> pConcreteStates) {
            super(pCfaEdge);
            this.concreteStates = ImmutableList.copyOf(pConcreteStates);
        }

        @Override
        public MultiEdge getCfaEdge() {
            return (MultiEdge)super.getCfaEdge();
        }

        @Override
        public Iterator<SingleConcreteState> iterator() {
            return this.concreteStates.iterator();
        }
    }

    static final class SingleConcreteState
    extends ConcerteStatePathNode {
        private final ConcreteState concreteState;

        public SingleConcreteState(CFAEdge cfaEdge, ConcreteState pConcreteState) {
            super(cfaEdge);
            this.concreteState = pConcreteState;
            assert (this.concreteState != null);
        }

        public ConcreteState getConcreteState() {
            return this.concreteState;
        }

        public String toString() {
            return "[" + this.getCfaEdge().toString() + " " + this.concreteState.toString() + "]";
        }
    }

    public static abstract class ConcerteStatePathNode {
        private final CFAEdge cfaEdge;

        public ConcerteStatePathNode(CFAEdge pCfaEdge) {
            this.cfaEdge = pCfaEdge;
        }

        public CFAEdge getCfaEdge() {
            return this.cfaEdge;
        }
    }
}

