/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.counterexample;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sosy_lab.cpachecker.core.counterexample.LeftHandSide;

public final class FieldReference
extends LeftHandSide {
    private final List<String> fieldNames;

    public FieldReference(String pName, String pFunctionName, List<String> pFieldNames) {
        super(pName, pFunctionName);
        assert (pFieldNames.size() > 0);
        this.fieldNames = ImmutableList.copyOf(pFieldNames);
    }

    public FieldReference(String pName, List<String> pFieldNames) {
        super(pName);
        assert (pFieldNames.size() > 0);
        this.fieldNames = ImmutableList.copyOf(pFieldNames);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldReference other = (FieldReference)obj;
        if (this.isGlobal() ? !other.isGlobal() : !this.getFunctionName().equals(!other.isGlobal() ? other.getFunctionName() : null)) {
            return false;
        }
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        return !(this.fieldNames == null ? other.fieldNames != null : !this.fieldNames.equals(other.fieldNames));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isGlobal() ? 0 : this.getFunctionName().hashCode());
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.fieldNames == null ? 0 : this.fieldNames.hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(super.toString());
        for (String fieldName : this.fieldNames) {
            result.append("$" + fieldName);
        }
        return result.toString();
    }
}

