/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.counterexample;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAssumptions;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;

public class Model
extends ForwardingMap<AssignableTerm, Object>
implements Appender {
    private final Map<AssignableTerm, Object> mModel;
    private final CFAPathWithAssumptions assignments;
    private final Multimap<CFAEdge, AssignableTerm> assignableTermsPerCFAEdge;
    private static final Joiner.MapJoiner joiner = Joiner.on((String)System.lineSeparator()).withKeyValueSeparator(": ");

    protected Map<AssignableTerm, Object> delegate() {
        return this.mModel;
    }

    public static Model empty() {
        return new Model();
    }

    private Model() {
        this.mModel = ImmutableMap.of();
        this.assignments = new CFAPathWithAssumptions();
        this.assignableTermsPerCFAEdge = ImmutableListMultimap.of();
    }

    public Model(Map<AssignableTerm, Object> content) {
        this.mModel = ImmutableMap.copyOf(content);
        this.assignments = new CFAPathWithAssumptions();
        this.assignableTermsPerCFAEdge = ImmutableListMultimap.of();
    }

    public Model(Map<AssignableTerm, Object> content, CFAPathWithAssumptions pAssignments) {
        this.mModel = ImmutableMap.copyOf(content);
        this.assignments = pAssignments;
        this.assignableTermsPerCFAEdge = ImmutableListMultimap.of();
    }

    public Model(Map<AssignableTerm, Object> content, CFAPathWithAssumptions pAssignments, Multimap<CFAEdge, AssignableTerm> pAssignableTermsPerCFAEdge) {
        this.mModel = ImmutableMap.copyOf(content);
        this.assignments = pAssignments;
        this.assignableTermsPerCFAEdge = pAssignableTermsPerCFAEdge;
    }

    public Model withAssignmentInformation(CFAPathWithAssumptions pAssignments) {
        Preconditions.checkState((boolean)this.assignments.isEmpty());
        return new Model(this.mModel, pAssignments);
    }

    public Model withAssignmentInformation(CFAPathWithAssumptions pAssignments, Multimap<CFAEdge, AssignableTerm> pAssignableTermsPerCFAEdge) {
        Preconditions.checkState((boolean)this.assignments.isEmpty());
        return new Model(this.mModel, pAssignments);
    }

    @Nullable
    public CFAPathWithAssumptions getCFAPathWithAssignments() {
        return this.assignments;
    }

    public Multimap<CFAEdge, AssignableTerm> getAssignedTermsPerEdge() {
        return this.assignableTermsPerCFAEdge;
    }

    public Collection<AssignableTerm> getAllAssignedTerms(CFAEdge pEdge) {
        return this.assignableTermsPerCFAEdge.get((Object)pEdge);
    }

    @Nullable
    public Map<ARGState, CFAEdgeWithAssumptions> getExactVariableValues(ARGPath pPath) {
        if (this.assignments.isEmpty()) {
            return null;
        }
        return this.assignments.getExactVariableValues(pPath);
    }

    @Nullable
    public CFAPathWithAssumptions getExactVariableValuePath(List<CFAEdge> pPath) {
        if (this.assignments.isEmpty()) {
            return null;
        }
        return this.assignments.getExactVariableValues(pPath);
    }

    public void appendTo(Appendable output) throws IOException {
        ImmutableSortedMap sorted = ImmutableSortedMap.copyOf(this.mModel, (Comparator)Ordering.usingToString());
        joiner.appendTo(output, (Map)sorted);
    }

    public String toString() {
        return Appenders.toString((Appender)this);
    }

    public static class Function
    implements AssignableTerm {
        private final String mName;
        private final TermType mReturnType;
        private final List<Object> mArguments;
        private int mHashCode;

        public Function(String pName, TermType pReturnType, Object[] pArguments) {
            this.mName = pName;
            this.mReturnType = pReturnType;
            this.mArguments = ImmutableList.copyOf((Object[])pArguments);
            this.mHashCode = 32453 + this.mName.hashCode() + this.mReturnType.hashCode();
            for (Object lValue : this.mArguments) {
                this.mHashCode += lValue.hashCode();
            }
        }

        @Override
        public String getName() {
            return this.mName;
        }

        @Override
        public TermType getType() {
            return this.mReturnType;
        }

        public int getArity() {
            return this.mArguments.size();
        }

        public Object getArgument(int lArgumentIndex) {
            return this.mArguments.get(lArgumentIndex);
        }

        public String toString() {
            return this.mName + "(" + Joiner.on((char)',').join(this.mArguments) + ") : " + (Object)((Object)this.mReturnType);
        }

        public int hashCode() {
            return this.mHashCode;
        }

        public boolean equals(Object pOther) {
            if (this == pOther) {
                return true;
            }
            if (pOther == null) {
                return false;
            }
            if (!this.getClass().equals(pOther.getClass())) {
                return false;
            }
            Function lFunction = (Function)pOther;
            return lFunction.mName.equals(this.mName) && lFunction.mReturnType.equals((Object)this.mReturnType) && lFunction.mArguments.equals(this.mArguments);
        }
    }

    public static class Variable
    extends Constant
    implements AssignableTerm {
        private final int ssaIndex;

        public Variable(String name, int ssaIndex, TermType type) {
            super(name, type);
            this.ssaIndex = ssaIndex;
        }

        public int getSSAIndex() {
            return this.ssaIndex;
        }

        @Override
        public String toString() {
            return this.name + "@" + this.ssaIndex + " : " + (Object)((Object)this.type);
        }

        @Override
        public int hashCode() {
            return 324 + this.name.hashCode() + this.ssaIndex + this.type.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!this.getClass().equals(other.getClass())) {
                return false;
            }
            Variable otherVariable = (Variable)other;
            return this.name.equals(otherVariable.name) && this.ssaIndex == otherVariable.ssaIndex && this.type.equals((Object)otherVariable.type);
        }
    }

    public static class Constant
    implements AssignableTerm {
        protected final String name;
        protected final TermType type;

        public Constant(String name, TermType type) {
            this.name = name;
            this.type = type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public TermType getType() {
            return this.type;
        }

        public String toString() {
            return this.name + " : " + (Object)((Object)this.type);
        }

        public int hashCode() {
            return 324 + this.name.hashCode() + this.type.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!this.getClass().equals(other.getClass())) {
                return false;
            }
            Constant otherConstant = (Constant)other;
            return this.name.equals(otherConstant.name) && this.type.equals((Object)otherConstant.type);
        }
    }

    public static interface AssignableTerm {
        public TermType getType();

        public String getName();
    }

    public static enum TermType {
        Boolean,
        Uninterpreted,
        Integer,
        Real,
        FloatingPoint,
        Bitvector;

    }
}

