/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.defaults;

import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class BreakOnTargetsPrecisionAdjustment
implements PrecisionAdjustment {
    private int foundTargetCounter = 0;
    private int extraIterations = 0;
    private int previousReachedSetSize = 0;
    private final int foundTargetLimit;
    private final int extraIterationsLimit;
    private static PrecisionAdjustment instance;

    public static PrecisionAdjustment getInstance(int pFoundTargetLimit, int pExtraIterationsLimit) {
        if (instance == null) {
            instance = new BreakOnTargetsPrecisionAdjustment(pFoundTargetLimit, pExtraIterationsLimit);
        }
        return instance;
    }

    private BreakOnTargetsPrecisionAdjustment(int pFoundTargetLimit, int pExtraIterationsLimit) {
        this.foundTargetLimit = pFoundTargetLimit;
        this.extraIterationsLimit = pExtraIterationsLimit;
    }

    @Override
    public PrecisionAdjustment.PrecisionAdjustmentResult prec(AbstractState pState, Precision pPrecision, UnmodifiableReachedSet pStates, AbstractState fullState) throws CPAException {
        this.resetCountersIfNecessary(pStates);
        if (this.foundTargetCounter > 0) {
            ++this.extraIterations;
        }
        if (this.extraIterationsLimitReached()) {
            return PrecisionAdjustment.PrecisionAdjustmentResult.create(pState, pPrecision, PrecisionAdjustment.Action.BREAK);
        }
        if (((Targetable)((Object)pState)).isTarget()) {
            ++this.foundTargetCounter;
            if (this.foundTargetLimitReached()) {
                return PrecisionAdjustment.PrecisionAdjustmentResult.create(pState, pPrecision, PrecisionAdjustment.Action.BREAK);
            }
        }
        return PrecisionAdjustment.PrecisionAdjustmentResult.create(pState, pPrecision, PrecisionAdjustment.Action.CONTINUE);
    }

    private boolean foundTargetLimitReached() {
        return this.foundTargetCounter >= this.foundTargetLimit;
    }

    private boolean extraIterationsLimitReached() {
        return this.foundTargetCounter > 0 && this.extraIterationsLimit != -1 && this.extraIterations > this.extraIterationsLimit;
    }

    private void resetCountersIfNecessary(UnmodifiableReachedSet pStates) {
        if (pStates.size() < this.previousReachedSetSize) {
            this.resetCounters();
        }
        this.previousReachedSetSize = pStates.size();
    }

    private void resetCounters() {
        this.foundTargetCounter = 0;
        this.extraIterations = 0;
    }
}

