/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.defaults;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.java.JBasicType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.util.VariableClassification;

public abstract class VariableTrackingPrecision
implements Precision {
    public static VariableTrackingPrecision createStaticPrecision(Configuration config, Optional<VariableClassification> vc, Class<? extends ConfigurableProgramAnalysis> cpaClass) throws InvalidConfigurationException {
        return new ConfigurablePrecision(config, vc, cpaClass);
    }

    public static VariableTrackingPrecision createRefineablePrecision(Configuration config, VariableTrackingPrecision pBaseline) throws InvalidConfigurationException {
        Preconditions.checkNotNull((Object)pBaseline);
        RefinablePrecisionOptions options = new RefinablePrecisionOptions(config);
        switch (options.sharing) {
            case LOCATION: {
                return new LocalizedRefinablePrecision(pBaseline);
            }
            case SCOPE: {
                return new ScopedRefinablePrecision(pBaseline);
            }
        }
        throw new AssertionError((Object)"Unhandled case in switch statement");
    }

    public static Predicate<Precision> isMatchingCPAClass(final Class<? extends ConfigurableProgramAnalysis> cpaClass) {
        return new Predicate<Precision>(){

            public boolean apply(Precision pPrecision) {
                if (!(pPrecision instanceof VariableTrackingPrecision)) {
                    return false;
                }
                return ((VariableTrackingPrecision)pPrecision).getCPAClass() == cpaClass;
            }
        };
    }

    public abstract boolean allowsAbstraction();

    public abstract boolean isTracking(ValueAnalysisState.MemoryLocation var1, Type var2, CFANode var3);

    public abstract VariableTrackingPrecision withIncrement(Multimap<CFANode, ValueAnalysisState.MemoryLocation> var1);

    public abstract int getSize();

    public abstract void serialize(Writer var1) throws IOException;

    public abstract VariableTrackingPrecision join(VariableTrackingPrecision var1);

    public abstract boolean isEmpty();

    protected abstract Class<? extends ConfigurableProgramAnalysis> getCPAClass();

    public static class ScopedRefinablePrecision
    extends RefinablePrecision {
        private ImmutableSortedSet<ValueAnalysisState.MemoryLocation> rawPrecision;

        private ScopedRefinablePrecision(VariableTrackingPrecision pBaseline) {
            super(pBaseline);
            this.rawPrecision = ImmutableSortedSet.of();
        }

        private ScopedRefinablePrecision(VariableTrackingPrecision pBaseline, ImmutableSortedSet<ValueAnalysisState.MemoryLocation> pRawPrecision) {
            super(pBaseline);
            this.rawPrecision = pRawPrecision;
        }

        @Override
        public ScopedRefinablePrecision withIncrement(Multimap<CFANode, ValueAnalysisState.MemoryLocation> increment) {
            if (this.rawPrecision.containsAll(increment.values())) {
                return this;
            }
            TreeSet<ValueAnalysisState.MemoryLocation> refinedPrec = new TreeSet<ValueAnalysisState.MemoryLocation>((SortedSet<ValueAnalysisState.MemoryLocation>)this.rawPrecision);
            refinedPrec.addAll(increment.values());
            return new ScopedRefinablePrecision(((RefinablePrecision)this).baseline, (ImmutableSortedSet<ValueAnalysisState.MemoryLocation>)ImmutableSortedSet.copyOf(refinedPrec));
        }

        @Override
        public void serialize(Writer writer) throws IOException {
            ArrayList<String> globals = new ArrayList<String>();
            String previousScope = null;
            for (ValueAnalysisState.MemoryLocation variable : this.rawPrecision) {
                if (variable.isOnFunctionStack()) {
                    String functionName = variable.getFunctionName();
                    if (!functionName.equals(previousScope)) {
                        writer.write("\n" + functionName + ":\n");
                    }
                    writer.write(variable.serialize() + "\n");
                    previousScope = functionName;
                    continue;
                }
                globals.add(variable.serialize());
            }
            if (previousScope != null) {
                writer.write("\n");
            }
            writer.write("*:\n" + Joiner.on((String)"\n").join(globals));
        }

        @Override
        public VariableTrackingPrecision join(VariableTrackingPrecision consolidatedPrecision) {
            Preconditions.checkArgument((boolean)this.getClass().equals(consolidatedPrecision.getClass()));
            Preconditions.checkArgument((boolean)((RefinablePrecision)this).baseline.equals(((ScopedRefinablePrecision)consolidatedPrecision).getBaseline()));
            TreeSet<ValueAnalysisState.MemoryLocation> joinedPrec = new TreeSet<ValueAnalysisState.MemoryLocation>((SortedSet<ValueAnalysisState.MemoryLocation>)this.rawPrecision);
            joinedPrec.addAll((Collection<ValueAnalysisState.MemoryLocation>)((ScopedRefinablePrecision)consolidatedPrecision).rawPrecision);
            return new ScopedRefinablePrecision(((RefinablePrecision)this).baseline, (ImmutableSortedSet<ValueAnalysisState.MemoryLocation>)ImmutableSortedSet.copyOf(joinedPrec));
        }

        @Override
        public int getSize() {
            return this.rawPrecision.size();
        }

        public String toString() {
            return this.rawPrecision.toString();
        }

        @Override
        public boolean isEmpty() {
            return this.rawPrecision.isEmpty();
        }

        @Override
        public boolean isTracking(ValueAnalysisState.MemoryLocation pVariable, Type pType, CFANode pLocation) {
            return super.isTracking(pVariable, pType, pLocation) && this.rawPrecision.contains((Object)pVariable);
        }
    }

    public static class LocalizedRefinablePrecision
    extends RefinablePrecision {
        private final ImmutableMultimap<CFANode, ValueAnalysisState.MemoryLocation> rawPrecision;

        private LocalizedRefinablePrecision(VariableTrackingPrecision pBaseline) {
            super(pBaseline);
            this.rawPrecision = ImmutableMultimap.of();
        }

        private LocalizedRefinablePrecision(VariableTrackingPrecision pBaseline, ImmutableMultimap<CFANode, ValueAnalysisState.MemoryLocation> pRawPrecision) {
            super(pBaseline);
            this.rawPrecision = pRawPrecision;
        }

        @Override
        public LocalizedRefinablePrecision withIncrement(Multimap<CFANode, ValueAnalysisState.MemoryLocation> increment) {
            if (this.rawPrecision.entries().containsAll(increment.entries())) {
                return this;
            }
            TreeMultimap refinedPrec = TreeMultimap.create(this.rawPrecision);
            refinedPrec.putAll(increment);
            return new LocalizedRefinablePrecision(((RefinablePrecision)this).baseline, (ImmutableMultimap<CFANode, ValueAnalysisState.MemoryLocation>)ImmutableMultimap.copyOf((Multimap)refinedPrec));
        }

        @Override
        public void serialize(Writer writer) throws IOException {
            for (CFANode currentLocation : this.rawPrecision.keySet()) {
                writer.write("\n" + currentLocation + ":\n");
                for (ValueAnalysisState.MemoryLocation variable : this.rawPrecision.get((Object)currentLocation)) {
                    writer.write(variable.serialize() + "\n");
                }
            }
        }

        @Override
        public VariableTrackingPrecision join(VariableTrackingPrecision consolidatedPrecision) {
            Preconditions.checkArgument((boolean)this.getClass().equals(consolidatedPrecision.getClass()));
            Preconditions.checkArgument((boolean)((RefinablePrecision)this).baseline.equals(((LocalizedRefinablePrecision)consolidatedPrecision).getBaseline()));
            TreeMultimap joinedPrec = TreeMultimap.create(this.rawPrecision);
            joinedPrec.putAll(((LocalizedRefinablePrecision)consolidatedPrecision).rawPrecision);
            return new LocalizedRefinablePrecision(((RefinablePrecision)this).baseline, (ImmutableMultimap<CFANode, ValueAnalysisState.MemoryLocation>)ImmutableMultimap.copyOf((Multimap)joinedPrec));
        }

        @Override
        public int getSize() {
            return this.rawPrecision.size();
        }

        public String toString() {
            return this.rawPrecision.toString();
        }

        @Override
        public boolean isEmpty() {
            return this.rawPrecision.isEmpty();
        }

        @Override
        public boolean isTracking(ValueAnalysisState.MemoryLocation pVariable, Type pType, CFANode pLocation) {
            return super.isTracking(pVariable, pType, pLocation) && this.rawPrecision.containsEntry((Object)pLocation, (Object)pVariable);
        }
    }

    public static abstract class RefinablePrecision
    extends VariableTrackingPrecision {
        private VariableTrackingPrecision baseline;

        private RefinablePrecision(VariableTrackingPrecision pBaseline) {
            this.baseline = pBaseline;
        }

        @Override
        public final boolean allowsAbstraction() {
            return true;
        }

        @Override
        public boolean isTracking(ValueAnalysisState.MemoryLocation pVariable, Type pType, CFANode pLocation) {
            Preconditions.checkNotNull((Object)pVariable);
            Preconditions.checkNotNull((Object)pType);
            Preconditions.checkNotNull((Object)pLocation);
            return this.baseline.isTracking(pVariable, pType, pLocation);
        }

        protected VariableTrackingPrecision getBaseline() {
            return this.baseline;
        }

        @Override
        public final Class<? extends ConfigurableProgramAnalysis> getCPAClass() {
            return this.baseline.getCPAClass();
        }
    }

    @Options(prefix="precision")
    public static class ConfigurablePrecision
    extends VariableTrackingPrecision {
        @Option(secure=true, name="variableBlacklist", description="blacklist regex for variables that won't be tracked by the CPA using this precision")
        private Pattern variableBlacklist = Pattern.compile("");
        @Option(secure=true, name="variableWhitelist", description="whitelist regex for variables that will always be tracked by the CPA using this precision")
        private Pattern variableWhitelist = Pattern.compile("");
        @Option(secure=true, description="If this option is used, booleans from the cfa are tracked.")
        private boolean trackBooleanVariables = true;
        @Option(secure=true, description="If this option is used, variables that are only compared for equality are tracked.")
        private boolean trackIntEqualVariables = true;
        @Option(secure=true, description="If this option is used, variables, that are only used in simple calculations (add, sub, lt, gt, eq) are tracked.")
        private boolean trackIntAddVariables = true;
        @Option(secure=true, description="If this option is used, variables that have type double or float are tracked.")
        private boolean trackFloatVariables = true;
        @Option(secure=true, description="If this option is used, variables that are addressed may get tracked depending on the rest of the precision. When this option is disabled, a variable that is addressed is definitely not tracked.")
        private boolean trackAddressedVariables = true;
        @Option(secure=true, description="If this option is used, all variables that are of a different classification than IntAdd, IntEq and Boolean get tracked by the precision.")
        private boolean trackVariablesBesidesEqAddBool = true;
        private Optional<VariableClassification> vc;
        private final Class<? extends ConfigurableProgramAnalysis> cpaClass;

        private ConfigurablePrecision(Configuration config, Optional<VariableClassification> pVc, Class<? extends ConfigurableProgramAnalysis> cpaClass) throws InvalidConfigurationException {
            config.inject((Object)this);
            this.cpaClass = cpaClass;
            this.vc = pVc;
        }

        @Override
        public boolean allowsAbstraction() {
            return !this.trackBooleanVariables || !this.trackIntEqualVariables || !this.trackIntAddVariables || !this.trackAddressedVariables || !this.trackVariablesBesidesEqAddBool || !this.variableBlacklist.toString().isEmpty();
        }

        @Override
        public boolean isTracking(ValueAnalysisState.MemoryLocation pVariable, Type pType, CFANode location) {
            if (this.trackFloatVariables) {
                return this.isTracking(pVariable);
            }
            return (!(pType instanceof CSimpleType) || ((CSimpleType)pType).getType() != CBasicType.FLOAT && ((CSimpleType)pType).getType() != CBasicType.DOUBLE) && (!(pType instanceof JSimpleType) || ((JSimpleType)pType).getType() != JBasicType.FLOAT && ((JSimpleType)pType).getType() != JBasicType.DOUBLE) && this.isTracking(pVariable);
        }

        private boolean isTracking(ValueAnalysisState.MemoryLocation pVariable) {
            return this.isOnWhitelist(pVariable.getIdentifier()) || !this.isOnBlacklist(pVariable.getIdentifier()) && this.isInTrackedVarClass(pVariable.getAsSimpleString());
        }

        private boolean isOnBlacklist(String variable) {
            return !this.variableBlacklist.toString().isEmpty() && this.variableBlacklist.matcher(variable).matches();
        }

        private boolean isOnWhitelist(String variable) {
            return !this.variableWhitelist.toString().isEmpty() && this.variableWhitelist.matcher(variable).matches();
        }

        private boolean isInTrackedVarClass(String variableName) {
            if (!this.vc.isPresent()) {
                return true;
            }
            VariableClassification varClass = (VariableClassification)this.vc.get();
            boolean varIsAddressed = varClass.getAddressedVariables().contains(variableName);
            if (varIsAddressed && !this.trackAddressedVariables) {
                return false;
            }
            boolean varIsBoolean = varClass.getIntBoolVars().contains(variableName);
            boolean varIsIntEqual = varClass.getIntEqualVars().contains(variableName);
            boolean varIsIntAdd = varClass.getIntAddVars().contains(variableName);
            if (!(varIsBoolean || varIsIntAdd || varIsIntEqual)) {
                return this.trackVariablesBesidesEqAddBool;
            }
            boolean isTrackedBoolean = this.trackBooleanVariables && varIsBoolean;
            boolean isTrackedIntEqual = this.trackIntEqualVariables && varIsIntEqual;
            boolean isTrackedIntAdd = this.trackIntAddVariables && varIsIntAdd;
            return isTrackedBoolean || isTrackedIntAdd || isTrackedIntEqual;
        }

        @Override
        public VariableTrackingPrecision withIncrement(Multimap<CFANode, ValueAnalysisState.MemoryLocation> pIncrement) {
            return this;
        }

        @Override
        public void serialize(Writer writer) throws IOException {
            writer.write("# configured precision used - nothing to show here");
        }

        @Override
        public VariableTrackingPrecision join(VariableTrackingPrecision consolidatedPrecision) {
            Preconditions.checkArgument((boolean)this.getClass().equals(consolidatedPrecision.getClass()));
            return this;
        }

        @Override
        public int getSize() {
            return -1;
        }

        @Override
        public boolean isEmpty() {
            if (!this.variableWhitelist.toString().isEmpty()) {
                return false;
            }
            if (!this.vc.isPresent()) {
                return true;
            }
            VariableClassification varClass = (VariableClassification)this.vc.get();
            boolean trackSomeIntBools = this.trackBooleanVariables && !varClass.getIntBoolVars().isEmpty();
            boolean trackSomeIntEquals = this.trackIntEqualVariables && !varClass.getIntEqualVars().isEmpty();
            boolean trackSomeIntAdds = this.trackIntAddVariables && !varClass.getIntAddVars().isEmpty();
            return !trackSomeIntBools && !trackSomeIntEquals && !trackSomeIntAdds && !this.trackVariablesBesidesEqAddBool;
        }

        @Override
        protected Class<? extends ConfigurableProgramAnalysis> getCPAClass() {
            return this.cpaClass;
        }
    }

    @Options(prefix="precision")
    private static class RefinablePrecisionOptions {
        @Option(secure=true, description="whether to track relevant variables only at the exact program location (sharing=location), or within their respective (function-/global-) scope (sharing=scoped).")
        private Sharing sharing = Sharing.SCOPE;

        private RefinablePrecisionOptions(Configuration config) throws InvalidConfigurationException {
            config.inject((Object)this);
        }

        static enum Sharing {
            SCOPE,
            LOCATION;

        }
    }
}

