/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.interfaces;

import com.google.common.base.Preconditions;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public interface PrecisionAdjustment {
    public PrecisionAdjustmentResult prec(AbstractState var1, Precision var2, UnmodifiableReachedSet var3, AbstractState var4) throws CPAException, InterruptedException;

    @Immutable
    public static final class PrecisionAdjustmentResult {
        private final AbstractState abstractState;
        private final Precision precision;
        private final Action action;

        private PrecisionAdjustmentResult(AbstractState pState, Precision pPrecision, Action pAction) {
            this.abstractState = (AbstractState)Preconditions.checkNotNull((Object)pState);
            this.precision = (Precision)Preconditions.checkNotNull((Object)pPrecision);
            this.action = (Action)((Object)Preconditions.checkNotNull((Object)((Object)pAction)));
        }

        public static PrecisionAdjustmentResult create(AbstractState pState, Precision pPrecision, Action pAction) {
            return new PrecisionAdjustmentResult(pState, pPrecision, pAction);
        }

        public AbstractState abstractState() {
            return this.abstractState;
        }

        public Precision precision() {
            return this.precision;
        }

        public Action action() {
            return this.action;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.abstractState.hashCode();
            result = 31 * result + this.action.hashCode();
            result = 31 * result + this.precision.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PrecisionAdjustmentResult)) {
                return false;
            }
            PrecisionAdjustmentResult other = (PrecisionAdjustmentResult)obj;
            return this.abstractState.equals(other.abstractState) && this.precision.equals(other.precision) && this.action.equals((Object)other.action);
        }

        @CheckReturnValue
        public PrecisionAdjustmentResult withAbstractState(AbstractState newAbstractState) {
            return new PrecisionAdjustmentResult(newAbstractState, this.precision, this.action);
        }

        @CheckReturnValue
        public PrecisionAdjustmentResult withPrecision(Precision newPrecision) {
            return new PrecisionAdjustmentResult(this.abstractState, newPrecision, this.action);
        }

        @CheckReturnValue
        public PrecisionAdjustmentResult withAction(Action newAction) {
            return new PrecisionAdjustmentResult(this.abstractState, this.precision, newAction);
        }
    }

    public static enum Action {
        CONTINUE,
        BREAK;

    }
}

