/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.interfaces;

import com.google.common.testing.ClassSanityTester;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;

public class PrecisionAdjustmentResultTest {
    @Test
    public void testCreation() {
        AbstractState state = (AbstractState)Mockito.mock(AbstractState.class);
        Precision precision = (Precision)Mockito.mock(Precision.class);
        PrecisionAdjustment.Action action = PrecisionAdjustment.Action.BREAK;
        PrecisionAdjustment.PrecisionAdjustmentResult r = PrecisionAdjustment.PrecisionAdjustmentResult.create(state, precision, action);
        Assert.assertSame((Object)state, (Object)r.abstractState());
        Assert.assertSame((Object)precision, (Object)r.precision());
        Assert.assertSame((Object)((Object)action), (Object)((Object)r.action()));
    }

    @Test
    public void testEquals() {
        new ClassSanityTester().testEquals(PrecisionAdjustment.PrecisionAdjustmentResult.class);
    }

    @Test
    public void testNulls() {
        new ClassSanityTester().testNulls(PrecisionAdjustment.PrecisionAdjustmentResult.class);
    }

    @Test
    public void testWithAbstractState() {
        PrecisionAdjustment.PrecisionAdjustmentResult r1 = PrecisionAdjustment.PrecisionAdjustmentResult.create((AbstractState)Mockito.mock(AbstractState.class), (Precision)Mockito.mock(Precision.class), PrecisionAdjustment.Action.CONTINUE);
        AbstractState newState = (AbstractState)Mockito.mock(AbstractState.class);
        PrecisionAdjustment.PrecisionAdjustmentResult r2 = r1.withAbstractState(newState);
        Assert.assertSame((Object)newState, (Object)r2.abstractState());
        Assert.assertSame((Object)r1.precision(), (Object)r2.precision());
        Assert.assertSame((Object)((Object)r1.action()), (Object)((Object)r2.action()));
        Assert.assertNotEquals((Object)r1.abstractState(), (Object)r2.abstractState());
        Assert.assertNotEquals((Object)r1, (Object)r2);
    }

    @Test
    public void testWithPrecision() {
        PrecisionAdjustment.PrecisionAdjustmentResult r1 = PrecisionAdjustment.PrecisionAdjustmentResult.create((AbstractState)Mockito.mock(AbstractState.class), (Precision)Mockito.mock(Precision.class), PrecisionAdjustment.Action.CONTINUE);
        Precision newPrecision = (Precision)Mockito.mock(Precision.class);
        PrecisionAdjustment.PrecisionAdjustmentResult r2 = r1.withPrecision(newPrecision);
        Assert.assertSame((Object)r1.abstractState(), (Object)r2.abstractState());
        Assert.assertSame((Object)newPrecision, (Object)r2.precision());
        Assert.assertSame((Object)((Object)r1.action()), (Object)((Object)r2.action()));
        Assert.assertNotEquals((Object)r1.precision(), (Object)r2.precision());
        Assert.assertNotEquals((Object)r1, (Object)r2);
    }

    @Test
    public void testWithAction() {
        PrecisionAdjustment.PrecisionAdjustmentResult r1 = PrecisionAdjustment.PrecisionAdjustmentResult.create((AbstractState)Mockito.mock(AbstractState.class), (Precision)Mockito.mock(Precision.class), PrecisionAdjustment.Action.CONTINUE);
        PrecisionAdjustment.Action newAction = PrecisionAdjustment.Action.BREAK;
        PrecisionAdjustment.PrecisionAdjustmentResult r2 = r1.withAction(newAction);
        Assert.assertSame((Object)r1.abstractState(), (Object)r2.abstractState());
        Assert.assertSame((Object)r1.precision(), (Object)r2.precision());
        Assert.assertSame((Object)((Object)newAction), (Object)((Object)r2.action()));
        Assert.assertNotEquals((Object)((Object)r1.action()), (Object)((Object)r2.action()));
        Assert.assertNotEquals((Object)r1, (Object)r2);
    }
}

