/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.reachedset;

import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.reachedset.DefaultReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.LocationMappedReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.PartitionedReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.waitlist.AutomatonFailedMatchesWaitlist;
import org.sosy_lab.cpachecker.core.waitlist.AutomatonMatchesWaitlist;
import org.sosy_lab.cpachecker.core.waitlist.CallstackSortedWaitlist;
import org.sosy_lab.cpachecker.core.waitlist.ExplicitSortedWaitlist;
import org.sosy_lab.cpachecker.core.waitlist.PostorderSortedWaitlist;
import org.sosy_lab.cpachecker.core.waitlist.ReversePostorderSortedWaitlist;
import org.sosy_lab.cpachecker.core.waitlist.Waitlist;

@Options(prefix="analysis")
public class ReachedSetFactory {
    @Option(secure=true, name="traversal.order", description="which strategy to adopt for visiting states?")
    Waitlist.TraversalMethod traversalMethod = Waitlist.TraversalMethod.DFS;
    @Option(secure=true, name="traversal.useCallstack", description="handle states with a deeper callstack first?\nThis needs the CallstackCPA to have any effect.")
    boolean useCallstack = false;
    @Option(secure=true, name="traversal.useReversePostorder", description="Use an implementation of reverse postorder strategy that allows to select a secondary strategy that is used if there are two states with the same reverse postorder id. The secondary strategy is selected with 'analysis.traversal.order'.")
    boolean useReversePostorder = false;
    @Option(secure=true, name="traversal.usePostorder", description="Use an implementation of postorder strategy that allows to select a secondary strategy that is used if there are two states with the same postorder id. The secondary strategy is selected with 'analysis.traversal.order'.")
    boolean usePostorder = false;
    @Option(secure=true, name="traversal.useExplicitInformation", description="handle more abstract states (with less information) first? (only for ExplicitCPA)")
    boolean useExplicitInformation = false;
    @Option(secure=true, name="traversal.useAutomatonInformation", description="handle abstract states with more automaton matches first? (only if AutomatonCPA enabled)")
    boolean useAutomatonInformation = false;
    @Option(secure=true, name="reachedSet", description="which reached set implementation to use?\nNORMAL: just a simple set\nLOCATIONMAPPED: a different set per location (faster, states with different locations cannot be merged)\nPARTITIONED: partitioning depending on CPAs (e.g Location, Callstack etc.)")
    ReachedSetType reachedSet = ReachedSetType.PARTITIONED;

    public ReachedSetFactory(Configuration config, LogManager logger) throws InvalidConfigurationException {
        config.inject((Object)this);
    }

    public ReachedSet create() {
        Waitlist.WaitlistFactory waitlistFactory = this.traversalMethod;
        if (this.useAutomatonInformation) {
            waitlistFactory = AutomatonMatchesWaitlist.factory(waitlistFactory);
            waitlistFactory = AutomatonFailedMatchesWaitlist.factory(waitlistFactory);
        }
        if (this.useReversePostorder) {
            waitlistFactory = ReversePostorderSortedWaitlist.factory(waitlistFactory);
        }
        if (this.usePostorder) {
            waitlistFactory = PostorderSortedWaitlist.factory(waitlistFactory);
        }
        if (this.useCallstack) {
            waitlistFactory = CallstackSortedWaitlist.factory(waitlistFactory);
        }
        if (this.useExplicitInformation) {
            waitlistFactory = ExplicitSortedWaitlist.factory(waitlistFactory);
        }
        switch (this.reachedSet) {
            case PARTITIONED: {
                return new PartitionedReachedSet(waitlistFactory);
            }
            case LOCATIONMAPPED: {
                return new LocationMappedReachedSet(waitlistFactory);
            }
        }
        return new DefaultReachedSet(waitlistFactory);
    }

    private static enum ReachedSetType {
        NORMAL,
        LOCATIONMAPPED,
        PARTITIONED;

    }
}

