/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.reachedset;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;

public class UnmodifiableReachedSetView
implements UnmodifiableReachedSet {
    private final UnmodifiableReachedSet underlying;
    private final Function<? super AbstractState, AbstractState> mapStateFunction;
    private final Function<? super Precision, Precision> mapPrecisionFunction;

    public UnmodifiableReachedSetView(UnmodifiableReachedSet pUnderlyingSet, Function<? super AbstractState, AbstractState> pMapStateFunction, Function<? super Precision, Precision> pMapPrecisionFunction) {
        assert (pUnderlyingSet != null);
        assert (pMapStateFunction != null);
        assert (pMapPrecisionFunction != null);
        this.underlying = pUnderlyingSet;
        this.mapStateFunction = pMapStateFunction;
        this.mapPrecisionFunction = pMapPrecisionFunction;
    }

    @Override
    public AbstractState getFirstState() {
        return (AbstractState)this.mapStateFunction.apply((Object)this.underlying.getFirstState());
    }

    @Override
    public AbstractState getLastState() {
        return (AbstractState)this.mapStateFunction.apply((Object)this.underlying.getLastState());
    }

    @Override
    public Precision getPrecision(AbstractState pState) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Unwrapping prevents reverse mapping");
    }

    @Override
    public Collection<AbstractState> asCollection() {
        return Collections2.transform(this.underlying.asCollection(), this.mapStateFunction);
    }

    @Override
    public Collection<AbstractState> getReached(AbstractState pState) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Unwrapping may prevent to know the location");
    }

    @Override
    public Collection<AbstractState> getReached(CFANode pLocation) {
        return Collections2.transform(this.underlying.getReached(pLocation), this.mapStateFunction);
    }

    @Override
    public Collection<Precision> getPrecisions() {
        return Collections2.transform(this.underlying.getPrecisions(), this.mapPrecisionFunction);
    }

    @Override
    public Collection<AbstractState> getWaitlist() {
        return Collections2.transform(this.underlying.getWaitlist(), this.mapStateFunction);
    }

    @Override
    public int getWaitlistSize() {
        return this.underlying.getWaitlistSize();
    }

    @Override
    public boolean hasWaitingState() {
        return this.underlying.hasWaitingState();
    }

    @Override
    public Iterator<AbstractState> iterator() {
        return Iterators.transform(this.underlying.iterator(), this.mapStateFunction);
    }

    @Override
    public boolean contains(AbstractState pState) {
        throw new UnsupportedOperationException("Unwrapping may prevent to check contains");
    }

    @Override
    public boolean isEmpty() {
        return this.underlying.isEmpty();
    }

    @Override
    public int size() {
        return this.underlying.size();
    }
}

