/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.waitlist;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.waitlist.Waitlist;

public abstract class AbstractSortedWaitlist<K extends Comparable<K>>
implements Waitlist {
    private final Waitlist.WaitlistFactory wrappedWaitlist;
    private final NavigableMap<K, Waitlist> waitlist = new TreeMap<K, Waitlist>();
    private int size = 0;

    protected AbstractSortedWaitlist(Waitlist.WaitlistFactory pSecondaryStrategy) {
        this.wrappedWaitlist = (Waitlist.WaitlistFactory)Preconditions.checkNotNull((Object)pSecondaryStrategy);
    }

    protected abstract K getSortKey(AbstractState var1);

    @Override
    public void add(AbstractState pState) {
        K key = this.getSortKey(pState);
        Waitlist localWaitlist = (Waitlist)this.waitlist.get(key);
        if (localWaitlist == null) {
            localWaitlist = this.wrappedWaitlist.createWaitlistInstance();
            this.waitlist.put(key, localWaitlist);
        } else assert (!localWaitlist.isEmpty());
        localWaitlist.add(pState);
        ++this.size;
    }

    @Override
    public boolean contains(AbstractState pState) {
        K key = this.getSortKey(pState);
        Waitlist localWaitlist = (Waitlist)this.waitlist.get(key);
        if (localWaitlist == null) {
            return false;
        }
        assert (!localWaitlist.isEmpty());
        return localWaitlist.contains(pState);
    }

    @Override
    public void clear() {
        this.waitlist.clear();
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        assert (this.waitlist.isEmpty() == (this.size == 0));
        return this.waitlist.isEmpty();
    }

    @Override
    public Iterator<AbstractState> iterator() {
        return Iterables.concat(this.waitlist.values()).iterator();
    }

    @Override
    public final AbstractState pop() {
        Map.Entry<K, Waitlist> highestEntry = null;
        highestEntry = this.waitlist.lastEntry();
        Waitlist localWaitlist = highestEntry.getValue();
        assert (!localWaitlist.isEmpty());
        AbstractState result = localWaitlist.pop();
        if (localWaitlist.isEmpty()) {
            this.waitlist.remove(highestEntry.getKey());
        }
        --this.size;
        return result;
    }

    @Override
    public boolean remove(AbstractState pState) {
        K key = this.getSortKey(pState);
        Waitlist localWaitlist = (Waitlist)this.waitlist.get(key);
        if (localWaitlist == null) {
            return false;
        }
        assert (!localWaitlist.isEmpty());
        boolean result = localWaitlist.remove(pState);
        if (result) {
            if (localWaitlist.isEmpty()) {
                this.waitlist.remove(key);
            }
            --this.size;
        }
        return result;
    }

    @Override
    public int size() {
        return this.size;
    }

    public String toString() {
        return this.waitlist.toString();
    }
}

