/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.waitlist;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.LinkedList;
import java.util.Random;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.waitlist.AbstractWaitlist;
import org.sosy_lab.cpachecker.util.AbstractStates;

@SuppressFBWarnings(value={"BC_BAD_CAST_TO_CONCRETE_COLLECTION"}, justification="warnings is only because of casts introduced by generics")
public class RandomPathWaitlist
extends AbstractWaitlist<LinkedList<AbstractState>> {
    private final Random rand = new Random();
    private int successorsOfParent = 0;
    private CFANode parent;

    protected RandomPathWaitlist() {
        super(new LinkedList());
    }

    @Override
    public void add(AbstractState pStat) {
        super.add(pStat);
        CFANode location = AbstractStates.extractLocation(pStat);
        if (this.parent == null || !this.parent.hasEdgeTo(location)) {
            this.parent = location;
            this.successorsOfParent = 0;
        } else {
            ++this.successorsOfParent;
        }
    }

    @Override
    public AbstractState pop() {
        AbstractState state;
        if (((LinkedList)this.waitlist).size() < 2 || this.successorsOfParent < 2) {
            state = (AbstractState)((LinkedList)this.waitlist).getLast();
        } else {
            int r = this.rand.nextInt(this.successorsOfParent) + 1;
            state = (AbstractState)((LinkedList)this.waitlist).get(((LinkedList)this.waitlist).size() - r);
        }
        if (this.successorsOfParent > 0) {
            --this.successorsOfParent;
            this.parent = AbstractStates.extractLocation(state);
        } else {
            this.parent = null;
        }
        return state;
    }
}

