/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.PropertyChecker;

import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.pcc.PropertyChecker;
import org.sosy_lab.cpachecker.pcc.propertychecker.PropertyCheckerBuilder;

@Options
public class PropertyCheckerCPA
extends AbstractSingleWrapperCPA {
    @Option(secure=true, name="cpa.propertychecker.className", description="Qualified name for class which checks that the computed abstraction adheres to the desired property.")
    private String checkerClass = "org.sosy_lab.cpachecker.pcc.propertychecker.DefaultPropertyChecker";
    @Option(secure=true, name="cpa.propertychecker.parameters", description="List of parameters for constructor of propertychecker.className. Parameter values are specified in the order the parameters are defined in the respective constructor. Every parameter value is finished with \",\". The empty string represents an empty parameter list.")
    private String checkerParamList = "";
    private PropertyChecker propChecker;

    public PropertyCheckerCPA(ConfigurableProgramAnalysis pCpa, Configuration pConfig) throws InvalidConfigurationException {
        super(pCpa);
        pConfig.inject((Object)this);
        this.propChecker = PropertyCheckerBuilder.buildPropertyChecker(this.checkerClass, this.checkerParamList);
    }

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(PropertyCheckerCPA.class);
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.getWrappedCpa().getAbstractDomain();
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.getWrappedCpa().getTransferRelation();
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.getWrappedCpa().getMergeOperator();
    }

    @Override
    public StopOperator getStopOperator() {
        return this.getWrappedCpa().getStopOperator();
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.getWrappedCpa().getPrecisionAdjustment();
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        return this.getWrappedCpa().getInitialState(pNode, pPartition);
    }

    public PropertyChecker getPropChecker() {
        return this.propChecker;
    }
}

