/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.andersen.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class DirectedGraph {
    private final Map<String, Node> nameMapping = new HashMap<String, Node>();

    public Node detectAndCollapseCycleContainingEdge(Edge edge) {
        HashSet<Node> reached = new HashSet<Node>();
        LinkedList<LinkedList> stack = new LinkedList<LinkedList>();
        LinkedList cycle = null;
        LinkedList path = new LinkedList();
        path.add(edge.src);
        path.add(edge.dest);
        stack.push(path);
        reached.add(edge.src);
        reached.add(edge.dest);
        block0: while (!stack.isEmpty()) {
            path = (LinkedList)stack.poll();
            Node cur = (Node)path.getLast();
            for (Node succ : cur.getSuccessors()) {
                if (reached.contains(succ)) {
                    if (!succ.equals(edge.src)) continue;
                    cycle = path;
                    break block0;
                }
                reached.add(succ);
                LinkedList extPath = (LinkedList)path.clone();
                extPath.add(succ);
                stack.push(extPath);
            }
        }
        if (cycle == null) {
            return null;
        }
        return this.mergeNodes((Node)cycle.poll(), cycle);
    }

    public Node mergeNodes(Node merged, Collection<Node> nodes) {
        if (nodes != null) {
            for (Node n : nodes) {
                this.mergeNodes(merged, n);
            }
        }
        return merged;
    }

    public Node mergeNodes(Node merged, Node old) {
        old.replacement = merged;
        for (Node oldPred : old.predecessors) {
            oldPred.successors.remove(old);
            this.addEdge(oldPred, merged);
        }
        for (Node oldSucc : old.successors) {
            oldSucc.predecessors.remove(old);
            this.addEdge(merged, oldSucc);
        }
        old.propagatePointerTargetsTo(merged);
        return merged;
    }

    public Node getNode(String var) {
        Node n = this.nameMapping.get(var);
        if (n == null) {
            n = new Node();
            this.nameMapping.put(var, n);
        } else if (!n.isValid()) {
            while (!(n = n.getReplacement()).isValid()) {
            }
            this.nameMapping.put(var, n);
        }
        return n;
    }

    public Set<Map.Entry<String, Node>> getNameMappings() {
        Set<Map.Entry<String, Node>> entrySet = this.nameMapping.entrySet();
        for (Map.Entry<String, Node> entry : entrySet) {
            Node val = entry.getValue();
            while (!val.isValid()) {
                val = val.getReplacement();
                entry.setValue(val);
            }
        }
        return this.nameMapping.entrySet();
    }

    public void addEdge(Node src, Node dest) {
        if (src == dest) {
            return;
        }
        src.successors.add(dest);
        dest.predecessors.add(src);
    }

    public static class Edge {
        public final Node src;
        public final Node dest;

        public Edge(Node src, Node dest) {
            this.src = src;
            this.dest = dest;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!other.getClass().equals(this.getClass())) {
                return false;
            }
            Edge o = (Edge)other;
            return this.src.equals(o.src) && this.dest.equals(o.dest);
        }

        public int hashCode() {
            int hash = 61;
            hash = 31 * hash + this.src.hashCode();
            hash = 31 * hash + this.dest.hashCode();
            return hash;
        }
    }

    public class Node {
        private Node replacement = null;
        public int dfs = 0;
        public int lowlink = 0;
        public Node mergePts = null;
        public final Set<String> complexConstrMeSub = new HashSet<String>();
        public final Set<String> complexConstrMeSuper = new HashSet<String>();
        private final Set<String> pointsToSet = new HashSet<String>();
        private final Set<Node> predecessors = new HashSet<Node>();
        private final Set<Node> successors = new HashSet<Node>();

        private Node() {
        }

        public boolean isValid() {
            return this.replacement == null;
        }

        public Node getReplacement() {
            return this.replacement;
        }

        public boolean isSuccessor(Node succ) {
            return this.successors.contains(succ);
        }

        public Collection<Node> getSuccessors() {
            return this.successors;
        }

        public boolean propagatePointerTargetsTo(Node other) {
            return other.pointsToSet.addAll(this.pointsToSet);
        }

        public void addPointerTarget(String var) {
            this.pointsToSet.add(var);
        }

        public Collection<String> getPointsToSet() {
            return this.pointsToSet;
        }

        public Set<Node> getPointsToNodesSet() {
            HashSet<Node> ptNSet = new HashSet<Node>();
            for (String n : this.getPointsToSet()) {
                ptNSet.add(DirectedGraph.this.getNode(n));
            }
            return ptNSet;
        }
    }
}

