/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.apron;

import apron.ApronException;
import java.util.Collection;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.defaults.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.cpa.apron.ApronDomain;
import org.sosy_lab.cpachecker.cpa.apron.ApronManager;
import org.sosy_lab.cpachecker.cpa.apron.ApronMergeOperator;
import org.sosy_lab.cpachecker.cpa.apron.ApronState;
import org.sosy_lab.cpachecker.cpa.apron.ApronTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.InvalidCFAException;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;

@Options(prefix="cpa.apron")
public final class ApronCPA
implements ConfigurableProgramAnalysis,
ProofChecker {
    @Option(secure=true, name="initialPrecisionType", toUppercase=true, values={"STATIC_FULL", "REFINEABLE_EMPTY"}, description="this option determines which initial precision should be used")
    private String precisionType = "STATIC_FULL";
    @Option(secure=true, name="splitDisequalities", description="split disequalities considering integer operands into two states or use disequality provided by apron library ")
    private boolean splitDisequalities = true;
    private final AbstractDomain abstractDomain;
    private final TransferRelation transferRelation;
    private final MergeOperator mergeOperator;
    private final StopOperator stopOperator;
    private final PrecisionAdjustment precisionAdjustment;
    private final LogManager logger;
    private final Precision precision;
    private final Configuration config;
    private final ShutdownNotifier shutdownNotifier;
    private final CFA cfa;
    private final ApronManager apronManager;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(ApronCPA.class);
    }

    private ApronCPA(Configuration config, LogManager log, ShutdownNotifier shutdownNotifier, CFA cfa) throws InvalidConfigurationException, InvalidCFAException {
        config.inject((Object)this);
        this.logger = log;
        ApronDomain apronDomain = new ApronDomain(this.logger);
        this.apronManager = new ApronManager(config);
        GlobalInfo.getInstance().storeApronManager(this.apronManager);
        this.transferRelation = new ApronTransferRelation(this.logger, cfa, this.splitDisequalities);
        MergeOperator apronMergeOp = ApronMergeOperator.getInstance(apronDomain, config);
        StopSepOperator apronStopOp = new StopSepOperator(apronDomain);
        this.abstractDomain = apronDomain;
        this.mergeOperator = apronMergeOp;
        this.stopOperator = apronStopOp;
        this.precisionAdjustment = StaticPrecisionAdjustment.getInstance();
        this.config = config;
        this.shutdownNotifier = shutdownNotifier;
        this.cfa = cfa;
        this.precision = this.precisionType.equals("REFINEABLE_EMPTY") ? VariableTrackingPrecision.createRefineablePrecision(config, VariableTrackingPrecision.createStaticPrecision(config, cfa.getVarClassification(), this.getClass())) : VariableTrackingPrecision.createStaticPrecision(config, cfa.getVarClassification(), this.getClass());
    }

    public ApronManager getManager() {
        return this.apronManager;
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.precisionAdjustment;
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        try {
            return new ApronState(this.logger, this.apronManager);
        }
        catch (ApronException e) {
            throw new RuntimeException("An error occured while operating with the apron library", e);
        }
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) {
        return this.precision;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public LogManager getLogger() {
        return this.logger;
    }

    public ShutdownNotifier getShutdownNotifier() {
        return this.shutdownNotifier;
    }

    public CFA getCFA() {
        return this.cfa;
    }

    public boolean isSplitDisequalites() {
        return this.splitDisequalities;
    }

    @Override
    public boolean areAbstractSuccessors(AbstractState pState, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors) throws CPATransferException, InterruptedException {
        try {
            Collection<? extends AbstractState> computedSuccessors = this.transferRelation.getAbstractSuccessorsForEdge(pState, this.precision, pCfaEdge);
            for (AbstractState abstractState : computedSuccessors) {
                boolean found = false;
                for (AbstractState abstractState2 : pSuccessors) {
                    if (!this.isCoveredBy(abstractState, abstractState2)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        catch (CPAException e) {
            throw new CPATransferException("Cannot compare abstract successors", e);
        }
        return true;
    }

    @Override
    public boolean isCoveredBy(AbstractState pState, AbstractState pOtherState) throws CPAException, InterruptedException {
        return this.abstractDomain.isLessOrEqual(pState, pOtherState);
    }
}

