/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.apron;

import apron.Abstract0;
import apron.ApronException;
import java.util.HashMap;
import java.util.HashSet;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.apron.ApronState;

class ApronDomain
implements AbstractDomain {
    private final LogManager logger;

    public ApronDomain(LogManager log) throws InvalidConfigurationException {
        this.logger = log;
    }

    @Override
    public boolean isLessOrEqual(AbstractState element1, AbstractState element2) {
        HashMap covers = new HashMap();
        ApronState apronState1 = (ApronState)element1;
        ApronState apronState2 = (ApronState)element2;
        if (covers.containsKey(apronState2) && ((HashSet)covers.get(apronState2)).contains(apronState1)) {
            return true;
        }
        try {
            return apronState1.isLessOrEquals(apronState2);
        }
        catch (ApronException e) {
            throw new RuntimeException("An error occured while operating with the apron library", e);
        }
    }

    @Override
    public AbstractState join(AbstractState successor, AbstractState reached) {
        Abstract0 newApronState;
        ApronState firstState;
        Pair<ApronState, ApronState> shrinkedStates;
        try {
            shrinkedStates = this.getShrinkedStates((ApronState)successor, (ApronState)reached);
            firstState = (ApronState)shrinkedStates.getFirst();
            newApronState = firstState.getApronNativeState().joinCopy(firstState.getManager().getManager(), ((ApronState)shrinkedStates.getSecond()).getApronNativeState());
        }
        catch (ApronException e) {
            throw new RuntimeException("An error occured while operating with the apron library", e);
        }
        ApronState newState = new ApronState(newApronState, firstState.getManager(), ((ApronState)shrinkedStates.getFirst()).getIntegerVariableToIndexMap(), ((ApronState)shrinkedStates.getFirst()).getRealVariableToIndexMap(), ((ApronState)shrinkedStates.getFirst()).getVariableToTypeMap(), ((ApronState)successor).isLoopHead(), this.logger);
        if (newState.equals(reached)) {
            return reached;
        }
        if (newState.equals(successor)) {
            return successor;
        }
        return newState;
    }

    public AbstractState widening(ApronState successorState, ApronState reachedState) {
        Abstract0 newApronState;
        try {
            Pair<ApronState, ApronState> shrinkedStates = this.getShrinkedStates(successorState, reachedState);
            successorState = (ApronState)shrinkedStates.getFirst();
            reachedState = (ApronState)shrinkedStates.getSecond();
            newApronState = reachedState.getApronNativeState().widening(reachedState.getManager().getManager(), successorState.getApronNativeState());
        }
        catch (ApronException e) {
            throw new RuntimeException("An error occured while operating with the apron library", e);
        }
        ApronState newState = new ApronState(newApronState, reachedState.getManager(), successorState.getIntegerVariableToIndexMap(), successorState.getRealVariableToIndexMap(), successorState.getVariableToTypeMap(), successorState.isLoopHead(), this.logger);
        if (newState.equals(successorState)) {
            return successorState;
        }
        if (newState.equals(reachedState)) {
            return reachedState;
        }
        return newState;
    }

    private Pair<ApronState, ApronState> getShrinkedStates(ApronState succ, ApronState reached) throws ApronException {
        if (succ.sizeOfVariables() > reached.sizeOfVariables()) {
            Pair<ApronState, ApronState> tmp = succ.shrinkToFittingSize(reached);
            succ = (ApronState)tmp.getFirst();
            reached = (ApronState)tmp.getSecond();
        } else {
            Pair<ApronState, ApronState> tmp = reached.shrinkToFittingSize(succ);
            succ = (ApronState)tmp.getSecond();
            reached = (ApronState)tmp.getFirst();
        }
        return Pair.of((Object)succ, (Object)reached);
    }
}

