/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.apron;

import apron.Box;
import apron.Manager;
import apron.Octagon;
import apron.Polka;
import apron.PolkaEq;
import apron.SetUp;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;

@Options(prefix="cpa.apron")
public class ApronManager {
    @Option(secure=true, name="domain", toUppercase=true, values={"BOX", "OCTAGON", "POLKA", "POLKA_STRICT", "POLKA_EQ"}, description="Use this to change the underlying abstract domain in the APRON library")
    private String domainType = "OCTAGON";
    private Manager manager;

    public ApronManager(Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
        if (this.domainType.equals("BOX")) {
            this.manager = new Box();
        } else if (this.domainType.equals("OCTAGON")) {
            this.manager = new Octagon();
        } else if (this.domainType.equals("POLKA")) {
            this.manager = new Polka(false);
        } else if (this.domainType.equals("POLKA_STRICT")) {
            this.manager = new Polka(true);
        } else if (this.domainType.equals("POLKA_EQ")) {
            this.manager = new PolkaEq();
        } else {
            throw new InvalidConfigurationException("Invalid argument for domain option.");
        }
    }

    public Manager getManager() {
        return this.manager;
    }

    static {
        SetUp.init((String)"lib/native/x86_64-linux/apron/");
    }
}

