/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.apron;

import apron.Coeff;
import apron.DoubleScalar;
import apron.Interval;
import apron.Linexpr0;
import apron.Linterm0;
import apron.Scalar;
import apron.Tcons0;
import apron.Texpr0BinNode;
import apron.Texpr0CstNode;
import apron.Texpr0DimNode;
import apron.Texpr0Intern;
import apron.Texpr0Node;
import apron.Texpr0UnNode;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.core.defaults.ForwardingTransferRelation;
import org.sosy_lab.cpachecker.core.defaults.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.apron.ApronManager;
import org.sosy_lab.cpachecker.cpa.apron.ApronState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.InvalidCFAException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCCodeException;
import org.sosy_lab.cpachecker.util.LoopStructure;

public class ApronTransferRelation
extends ForwardingTransferRelation<Set<ApronState>, ApronState, VariableTrackingPrecision> {
    private static final Texpr0CstNode constantMin = new Texpr0CstNode((Coeff)new DoubleScalar(1.0E-14));
    private static final Map<String, String> UNSUPPORTED_FUNCTIONS = ImmutableMap.of((Object)"pthread_create", (Object)"threads");
    private final LogManager logger;
    private final boolean splitDisequalities;
    private final Set<CFANode> loopHeads;
    boolean done = false;

    public ApronTransferRelation(LogManager log, CFA cfa, boolean pSplitDisequalities) throws InvalidCFAException {
        this.logger = log;
        this.splitDisequalities = pSplitDisequalities;
        if (!cfa.getLoopStructure().isPresent()) {
            throw new InvalidCFAException("OctagonCPA does not work without loop information!");
        }
        LoopStructure loops = (LoopStructure)cfa.getLoopStructure().get();
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (LoopStructure.Loop l : loops.getAllLoops()) {
            builder.addAll(l.getLoopHeads());
        }
        this.loopHeads = builder.build();
    }

    @Override
    public Collection<ApronState> getAbstractSuccessorsForEdge(AbstractState abstractState, Precision abstractPrecision, CFAEdge cfaEdge) throws CPATransferException {
        Collection<ApronState> preCheck;
        this.setInfo(abstractState, abstractPrecision, cfaEdge);
        if (!this.done) {
            try {
                new ApronManager(Configuration.defaultConfiguration());
            }
            catch (InvalidConfigurationException e) {
                throw new AssertionError((Object)e);
            }
            this.done = true;
        }
        if ((preCheck = this.preCheck()) != null) {
            return preCheck;
        }
        ArrayList successors = new ArrayList();
        switch (cfaEdge.getEdgeType()) {
            case AssumeEdge: {
                AssumeEdge assumption = (AssumeEdge)cfaEdge;
                successors.addAll((Collection)this.handleAssumption(assumption, assumption.getExpression(), assumption.getTruthAssumption()));
                break;
            }
            case FunctionCallEdge: {
                FunctionCallEdge fnkCall = (FunctionCallEdge)cfaEdge;
                FunctionEntryNode succ = fnkCall.getSuccessor();
                String calledFunctionName = succ.getFunctionName();
                successors.addAll((Collection)this.handleFunctionCallEdge(fnkCall, fnkCall.getArguments(), succ.getFunctionParameters(), calledFunctionName));
                break;
            }
            case FunctionReturnEdge: {
                String callerFunctionName = cfaEdge.getSuccessor().getFunctionName();
                FunctionReturnEdge fnkReturnEdge = (FunctionReturnEdge)cfaEdge;
                FunctionSummaryEdge summaryEdge = fnkReturnEdge.getSummaryEdge();
                successors.addAll((Collection)this.handleFunctionReturnEdge(fnkReturnEdge, summaryEdge, summaryEdge.getExpression(), callerFunctionName));
                break;
            }
            case MultiEdge: {
                successors.addAll((Collection)this.handleMultiEdge((MultiEdge)cfaEdge));
                break;
            }
            default: {
                successors.addAll((Collection)this.handleSimpleEdge(cfaEdge));
            }
        }
        successors.removeAll(Collections.singleton(null));
        Iterator states = successors.iterator();
        while (states.hasNext()) {
            ApronState st = (ApronState)states.next();
            if (!st.isEmpty()) continue;
            states.remove();
            this.logger.log(Level.FINER, new Object[]{"removing state because of unsatisfiable constraints:\n" + st + "________________\nEdge was:\n" + cfaEdge.getDescription()});
        }
        HashSet<ApronState> returnStates = new HashSet<ApronState>(successors);
        if (this.loopHeads.contains(cfaEdge.getSuccessor())) {
            HashSet<ApronState> newStates = new HashSet<ApronState>();
            for (ApronState s : successors) {
                newStates.add(s.asLoopHead());
            }
            returnStates = newStates;
        }
        this.resetInfo();
        return returnStates;
    }

    @Override
    protected Set<ApronState> handleBlankEdge(BlankEdge cfaEdge) throws CPATransferException {
        return Collections.singleton(this.state);
    }

    @Override
    protected Set<ApronState> handleAssumption(CAssumeEdge cfaEdge, CExpression expression, boolean truthAssumption) throws CPATransferException {
        if (expression instanceof CLiteralExpression) {
            if (expression instanceof CIntegerLiteralExpression) {
                return this.handleLiteralBooleanExpression(((CIntegerLiteralExpression)expression).asLong(), truthAssumption, (ApronState)this.state);
            }
            if (expression instanceof CCharLiteralExpression) {
                return this.handleLiteralBooleanExpression(((CCharLiteralExpression)expression).getCharacter(), truthAssumption, (ApronState)this.state);
            }
            if (expression instanceof CFloatLiteralExpression) {
                int val = Math.abs(((CFloatLiteralExpression)expression).getValue().signum());
                return this.handleLiteralBooleanExpression(val, truthAssumption, (ApronState)this.state);
            }
            return Collections.singleton(this.state);
        }
        if (expression instanceof CBinaryExpression) {
            return this.handleBinaryAssumption(expression, truthAssumption);
        }
        Set<Texpr0Node> coeffs = expression.accept(new CApronExpressionVisitor());
        if (coeffs.isEmpty()) {
            return Collections.singleton(this.state);
        }
        HashSet<ApronState> possibleStates = new HashSet<ApronState>();
        for (Texpr0Node coeff : coeffs) {
            if (truthAssumption) {
                possibleStates.add(((ApronState)this.state).addConstraint(new Tcons0(0, coeff)));
                continue;
            }
            possibleStates.add(((ApronState)this.state).addConstraint(new Tcons0(2, coeff)));
            possibleStates.add(((ApronState)this.state).addConstraint(new Tcons0(2, (Texpr0Node)new Texpr0UnNode(6, coeff))));
        }
        return possibleStates;
    }

    private Set<ApronState> handleBinaryAssumption(CExpression expression, boolean truthAssumption) throws CPATransferException {
        CBinaryExpression binExp = (CBinaryExpression)expression;
        Double leftVal = binExp.getOperand1().accept(new CLiteralExpressionVisitor());
        Double rightVal = binExp.getOperand2().accept(new CLiteralExpressionVisitor());
        if (leftVal != null && rightVal != null) {
            return this.handleLiteralBinExpAssumption(leftVal, rightVal, binExp.getOperator(), truthAssumption);
        }
        Set<Texpr0Node> leftCoeffs = binExp.getOperand1().accept(new CApronExpressionVisitor());
        Set<Texpr0Node> rightCoeffs = binExp.getOperand2().accept(new CApronExpressionVisitor());
        if (leftCoeffs.isEmpty() || rightCoeffs.isEmpty()) {
            return Collections.singleton(this.state);
        }
        HashSet<ApronState> possibleStates = new HashSet<ApronState>();
        for (Texpr0Node left : leftCoeffs) {
            block18: for (Texpr0Node right : rightCoeffs) {
                switch (binExp.getOperator()) {
                    case BINARY_AND: 
                    case BINARY_OR: 
                    case BINARY_XOR: 
                    case SHIFT_RIGHT: 
                    case SHIFT_LEFT: {
                        return Collections.singleton(this.state);
                    }
                    case EQUALS: {
                        Texpr0BinNode increasedLeft;
                        Texpr0BinNode increasedRight;
                        if (truthAssumption) {
                            possibleStates.add(((ApronState)this.state).addConstraint(new Tcons0(0, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, left, right)))));
                            continue block18;
                        }
                        if (left instanceof Texpr0DimNode && !((ApronState)this.state).isInt(((Texpr0DimNode)left).dim) || right instanceof Texpr0DimNode && !((ApronState)this.state).isInt(((Texpr0DimNode)right).dim)) {
                            increasedRight = new Texpr0BinNode(0, right, (Texpr0Node)constantMin);
                            increasedLeft = new Texpr0BinNode(0, left, (Texpr0Node)constantMin);
                            possibleStates.add(((ApronState)this.state).addConstraint(new Tcons0(2, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, left, (Texpr0Node)increasedRight)))));
                            possibleStates.add(((ApronState)this.state).addConstraint(new Tcons0(2, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, right, (Texpr0Node)increasedLeft)))));
                            continue block18;
                        }
                        if (this.splitDisequalities) {
                            possibleStates.add(((ApronState)this.state).addConstraint(new Tcons0(2, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, left, right)))));
                            possibleStates.add(((ApronState)this.state).addConstraint(new Tcons0(2, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, right, left)))));
                            continue block18;
                        }
                        possibleStates.add(((ApronState)this.state).addConstraint(new Tcons0(4, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, left, right)))));
                        continue block18;
                    }
                    case GREATER_EQUAL: {
                        Tcons0 act;
                        if (truthAssumption) {
                            act = new Tcons0(1, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, left, right)));
                            possibleStates.add(((ApronState)this.state).addConstraint(act));
                            continue block18;
                        }
                        act = new Tcons0(2, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, right, left)));
                        possibleStates.add(((ApronState)this.state).addConstraint(act));
                        continue block18;
                    }
                    case GREATER_THAN: {
                        Tcons0 act;
                        if (truthAssumption) {
                            if (left instanceof Texpr0DimNode && !((ApronState)this.state).isInt(((Texpr0DimNode)left).dim) || right instanceof Texpr0DimNode && !((ApronState)this.state).isInt(((Texpr0DimNode)right).dim)) {
                                Texpr0BinNode increasedRight = new Texpr0BinNode(0, right, (Texpr0Node)constantMin);
                                act = new Tcons0(2, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, left, (Texpr0Node)increasedRight)));
                            } else {
                                act = new Tcons0(2, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, left, right)));
                            }
                            possibleStates.add(((ApronState)this.state).addConstraint(act));
                            continue block18;
                        }
                        act = new Tcons0(1, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, right, left)));
                        possibleStates.add(((ApronState)this.state).addConstraint(act));
                        continue block18;
                    }
                    case LESS_EQUAL: {
                        Tcons0 act;
                        if (truthAssumption) {
                            act = new Tcons0(1, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, right, left)));
                            possibleStates.add(((ApronState)this.state).addConstraint(act));
                            continue block18;
                        }
                        act = new Tcons0(2, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, left, right)));
                        possibleStates.add(((ApronState)this.state).addConstraint(act));
                        continue block18;
                    }
                    case LESS_THAN: {
                        Tcons0 act;
                        Texpr0BinNode increasedLeft;
                        if (truthAssumption) {
                            if (left instanceof Texpr0DimNode && !((ApronState)this.state).isInt(((Texpr0DimNode)left).dim) || right instanceof Texpr0DimNode && !((ApronState)this.state).isInt(((Texpr0DimNode)right).dim)) {
                                increasedLeft = new Texpr0BinNode(0, left, (Texpr0Node)constantMin);
                                act = new Tcons0(2, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, right, (Texpr0Node)increasedLeft)));
                            } else {
                                act = new Tcons0(2, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, right, left)));
                            }
                            possibleStates.add(((ApronState)this.state).addConstraint(act));
                            continue block18;
                        }
                        act = new Tcons0(1, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, left, right)));
                        possibleStates.add(((ApronState)this.state).addConstraint(act));
                        continue block18;
                    }
                    case NOT_EQUALS: {
                        Texpr0BinNode increasedLeft;
                        Texpr0BinNode increasedRight;
                        if (truthAssumption) {
                            if (left instanceof Texpr0DimNode && !((ApronState)this.state).isInt(((Texpr0DimNode)left).dim) || right instanceof Texpr0DimNode && !((ApronState)this.state).isInt(((Texpr0DimNode)right).dim)) {
                                increasedRight = new Texpr0BinNode(0, right, (Texpr0Node)constantMin);
                                increasedLeft = new Texpr0BinNode(0, left, (Texpr0Node)constantMin);
                                possibleStates.add(((ApronState)this.state).addConstraint(new Tcons0(2, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, left, (Texpr0Node)increasedRight)))));
                                possibleStates.add(((ApronState)this.state).addConstraint(new Tcons0(2, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, right, (Texpr0Node)increasedLeft)))));
                                continue block18;
                            }
                            if (this.splitDisequalities) {
                                possibleStates.add(((ApronState)this.state).addConstraint(new Tcons0(2, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, left, right)))));
                                possibleStates.add(((ApronState)this.state).addConstraint(new Tcons0(2, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, right, left)))));
                                continue block18;
                            }
                            possibleStates.add(((ApronState)this.state).addConstraint(new Tcons0(4, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, left, right)))));
                            continue block18;
                        }
                        possibleStates.add(((ApronState)this.state).addConstraint(new Tcons0(0, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, left, right)))));
                        continue block18;
                    }
                    case DIVIDE: 
                    case MINUS: 
                    case MODULO: 
                    case MULTIPLY: 
                    case PLUS: {
                        Texpr0BinNode innerExp = null;
                        switch (binExp.getOperator()) {
                            case DIVIDE: {
                                innerExp = new Texpr0BinNode(3, left, right);
                                break;
                            }
                            case MINUS: {
                                innerExp = new Texpr0BinNode(1, left, right);
                                break;
                            }
                            case MODULO: {
                                innerExp = new Texpr0BinNode(4, left, right);
                                break;
                            }
                            case MULTIPLY: {
                                innerExp = new Texpr0BinNode(2, left, right);
                                break;
                            }
                            case PLUS: {
                                innerExp = new Texpr0BinNode(0, left, right);
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        if (truthAssumption) {
                            possibleStates.add(((ApronState)this.state).addConstraint(new Tcons0(0, (Texpr0Node)innerExp)));
                            continue block18;
                        }
                        possibleStates.add(((ApronState)this.state).addConstraint(new Tcons0(2, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, (Texpr0Node)innerExp, (Texpr0Node)constantMin)))));
                        possibleStates.add(((ApronState)this.state).addConstraint(new Tcons0(2, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, (Texpr0Node)constantMin, (Texpr0Node)innerExp)))));
                        continue block18;
                    }
                }
                throw new UnrecognizedCCodeException("unknown binary operator", this.edge, binExp);
            }
        }
        return possibleStates;
    }

    private Set<ApronState> handleLiteralBinExpAssumption(double pLeftVal, double pRightVal, CBinaryExpression.BinaryOperator pBinaryOperator, boolean truthAssumption) {
        boolean result;
        switch (pBinaryOperator) {
            case BINARY_AND: 
            case BINARY_OR: 
            case BINARY_XOR: 
            case SHIFT_RIGHT: 
            case SHIFT_LEFT: {
                return Collections.singleton(this.state);
            }
            case NOT_EQUALS: {
                result = pLeftVal != pRightVal;
                break;
            }
            case EQUALS: {
                result = pLeftVal == pRightVal;
                break;
            }
            case GREATER_EQUAL: {
                result = pLeftVal >= pRightVal;
                break;
            }
            case GREATER_THAN: {
                result = pLeftVal > pRightVal;
                break;
            }
            case LESS_EQUAL: {
                result = pLeftVal <= pRightVal;
                break;
            }
            case LESS_THAN: {
                result = pLeftVal < pRightVal;
                break;
            }
            case MINUS: {
                result = pLeftVal - pRightVal != 0.0;
                break;
            }
            case MODULO: {
                result = pLeftVal % pRightVal != 0.0;
                break;
            }
            case MULTIPLY: {
                result = pLeftVal * pRightVal != 0.0;
                break;
            }
            case DIVIDE: {
                result = pLeftVal / pRightVal != 0.0;
                break;
            }
            case PLUS: {
                result = pLeftVal + pRightVal != 0.0;
                break;
            }
            default: {
                throw new AssertionError((Object)("unhandled binary operator" + pBinaryOperator));
            }
        }
        if (truthAssumption && result || !truthAssumption && !result) {
            return Collections.singleton(this.state);
        }
        return Collections.emptySet();
    }

    private Set<ApronState> handleLiteralBooleanExpression(long value, boolean truthAssumption, ApronState state) {
        if (value == 0L) {
            if (truthAssumption) {
                return Collections.singleton(state);
            }
            return Collections.emptySet();
        }
        if (truthAssumption) {
            return Collections.emptySet();
        }
        return Collections.singleton(state);
    }

    private ApronState.Type getCorrespondingOctStateType(CType type) {
        if (type instanceof CSimpleType && (((CSimpleType)type).getType() == CBasicType.FLOAT || ((CSimpleType)type).getType() == CBasicType.DOUBLE)) {
            return ApronState.Type.FLOAT;
        }
        return ApronState.Type.INT;
    }

    private boolean isHandleableVariable(CExpression var) {
        if (var instanceof CArraySubscriptExpression || var instanceof CFieldReference || var instanceof CPointerExpression || var instanceof CStringLiteralExpression || var instanceof CFieldReference && ((CFieldReference)var).isPointerDereference()) {
            return false;
        }
        return this.isHandleAbleType(var.getExpressionType());
    }

    private boolean isHandleAbleType(CType type) {
        type = type.getCanonicalType();
        while (type instanceof CTypedefType) {
            type = ((CTypedefType)type).getRealType();
        }
        return !(type instanceof CPointerType) && !(type instanceof CCompositeType) && !(type instanceof CArrayType);
    }

    @Override
    protected Set<ApronState> handleFunctionCallEdge(CFunctionCallEdge cfaEdge, List<CExpression> arguments, List<CParameterDeclaration> parameters, String calledFunctionName) throws CPATransferException {
        CFunctionEntryNode functionEntryNode = cfaEdge.getSuccessor();
        List<String> paramNames = functionEntryNode.getFunctionParameterNames();
        if (!cfaEdge.getSuccessor().getFunctionDefinition().getType().takesVarArgs() ? !$assertionsDisabled && parameters.size() != arguments.size() : !$assertionsDisabled && parameters.size() > arguments.size()) {
            throw new AssertionError();
        }
        HashSet<ApronState> possibleStates = new HashSet<ApronState>();
        if (functionEntryNode.getReturnVariable().isPresent()) {
            possibleStates.add(((ApronState)this.state).declareVariable(ValueAnalysisState.MemoryLocation.valueOf(calledFunctionName, ((CVariableDeclaration)functionEntryNode.getReturnVariable().get()).getName(), 0L), this.getCorrespondingOctStateType(cfaEdge.getSuccessor().getFunctionDefinition().getType().getReturnType())));
        } else {
            possibleStates.add((ApronState)this.state);
        }
        for (int i = 0; i < parameters.size(); ++i) {
            ValueAnalysisState.MemoryLocation formalParamName;
            CExpression arg = arguments.get(i);
            if (!this.isHandleAbleType(parameters.get(i).getType()) || !((VariableTrackingPrecision)this.precision).isTracking(formalParamName = ValueAnalysisState.MemoryLocation.valueOf(calledFunctionName, paramNames.get(i), 0L), parameters.get(i).getType(), functionEntryNode)) continue;
            Set<Texpr0Node> coeffsList = arg.accept(new CApronExpressionVisitor());
            HashSet<ApronState> newPossibleStates = new HashSet<ApronState>();
            for (ApronState st : possibleStates) {
                ApronState tmpState = st.declareVariable(formalParamName, this.getCorrespondingOctStateType(parameters.get(i).getType()));
                if (coeffsList.isEmpty()) {
                    newPossibleStates.add(tmpState);
                }
                for (Texpr0Node coeffs : coeffsList) {
                    tmpState = tmpState.makeAssignment(formalParamName, coeffs);
                    newPossibleStates.add(tmpState);
                }
            }
            possibleStates = newPossibleStates;
        }
        return possibleStates;
    }

    @Override
    protected Set<ApronState> handleFunctionReturnEdge(CFunctionReturnEdge cfaEdge, CFunctionSummaryEdge fnkCall, CFunctionCall summaryExpr, String callerFunctionName) throws CPATransferException {
        CFunctionCall exprOnSummary = fnkCall.getExpression();
        String calledFunctionName = cfaEdge.getPredecessor().getFunctionName();
        if (exprOnSummary instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement binExp = (CFunctionCallAssignmentStatement)exprOnSummary;
            CLeftHandSide op1 = binExp.getLeftHandSide();
            ValueAnalysisState.MemoryLocation assignedVarName = this.buildVarName(op1, callerFunctionName);
            if (!this.isHandleableVariable(op1) || !((VariableTrackingPrecision)this.precision).isTracking(assignedVarName, op1.getExpressionType(), cfaEdge.getSuccessor())) {
                return Collections.singleton(((ApronState)this.state).removeLocalVars(calledFunctionName));
            }
            ValueAnalysisState.MemoryLocation returnVarName = ValueAnalysisState.MemoryLocation.valueOf(calledFunctionName, ((CVariableDeclaration)fnkCall.getFunctionEntry().getReturnVariable().get()).getName(), 0L);
            Texpr0DimNode right = new Texpr0DimNode(((ApronState)this.state).getVariableIndexFor(returnVarName));
            this.state = ((ApronState)this.state).makeAssignment(assignedVarName, (Texpr0Node)right);
        } else if (!(exprOnSummary instanceof CFunctionCallStatement)) {
            throw new UnrecognizedCCodeException("on function return", (CFAEdge)cfaEdge, exprOnSummary);
        }
        return Collections.singleton(((ApronState)this.state).removeLocalVars(calledFunctionName));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected Set<ApronState> handleDeclarationEdge(CDeclarationEdge cfaEdge, CDeclaration decl) throws CPATransferException {
        Iterator<Texpr0Node> i$;
        HashSet<ApronState> possibleStates;
        ValueAnalysisState.MemoryLocation variableName;
        if (cfaEdge.getDeclaration() instanceof CVariableDeclaration) {
            CVariableDeclaration declaration = (CVariableDeclaration)decl;
            if (!this.isHandleAbleType(declaration.getType())) {
                return Collections.singleton(this.state);
            }
            variableName = decl.isGlobal() ? ValueAnalysisState.MemoryLocation.valueOf(decl.getName()) : ValueAnalysisState.MemoryLocation.valueOf(this.functionName, decl.getName(), 0L);
            if (!((VariableTrackingPrecision)this.precision).isTracking(variableName, declaration.getType(), cfaEdge.getSuccessor())) {
                return Collections.singleton(this.state);
            }
            CInitializer init = declaration.getInitializer();
            if (!((ApronState)this.state).existsVariable(variableName) && (init == null || init instanceof CInitializerExpression)) {
                this.state = ((ApronState)this.state).declareVariable(variableName, this.getCorrespondingOctStateType(declaration.getType()));
            }
            possibleStates = new HashSet<ApronState>();
            if (init != null) {
                if (init instanceof CInitializerExpression) {
                    CExpression exp = ((CInitializerExpression)init).getExpression();
                    Set<Texpr0Node> initCoeffs = exp.accept(new CApronExpressionVisitor());
                    if (initCoeffs.isEmpty()) {
                        possibleStates.add((ApronState)this.state);
                    }
                    i$ = initCoeffs.iterator();
                    break block16;
                } else {
                    if (init instanceof CInitializerList) {
                        return Collections.singleton(this.state);
                    }
                    throw new AssertionError((Object)("Unhandled Expression Type: " + init.getClass()));
                }
            }
            if (decl.isGlobal()) {
                possibleStates.add(((ApronState)this.state).makeAssignment(variableName, (Texpr0Node)new Texpr0CstNode()));
            }
        } else {
            block16: {
                if (!(cfaEdge.getDeclaration() instanceof CTypeDeclaration) && !(cfaEdge.getDeclaration() instanceof CFunctionDeclaration)) {
                    throw new AssertionError((Object)(cfaEdge.getDeclaration() + " (" + cfaEdge.getDeclaration().getClass() + ")"));
                }
                return Collections.singleton(this.state);
            }
            while (i$.hasNext()) {
                Texpr0Node coeffs = i$.next();
                ApronState st = ((ApronState)this.state).makeAssignment(variableName, coeffs);
                assert (!st.isEmpty()) : "states with assignments / declarations should never be empty";
                possibleStates.add(st);
            }
        }
        if (possibleStates.isEmpty()) {
            assert (!((ApronState)this.state).isEmpty()) : "states with assignments / declarations should never be empty";
            possibleStates.add((ApronState)this.state);
        }
        return possibleStates;
    }

    @Override
    protected Set<ApronState> handleStatementEdge(CStatementEdge cfaEdge, CStatement statement) throws CPATransferException {
        String func;
        CExpression fn;
        if (statement instanceof CFunctionCall && (fn = ((CFunctionCall)statement).getFunctionCallExpression().getFunctionNameExpression()) instanceof CIdExpression && UNSUPPORTED_FUNCTIONS.containsKey(func = ((CIdExpression)fn).getName())) {
            throw new UnsupportedCCodeException(UNSUPPORTED_FUNCTIONS.get(func), (CFAEdge)cfaEdge, fn);
        }
        if (statement instanceof CAssignment) {
            CLeftHandSide left = ((CAssignment)statement).getLeftHandSide();
            CRightHandSide right = ((CAssignment)statement).getRightHandSide();
            ValueAnalysisState.MemoryLocation variableName = this.buildVarName(left, this.functionName);
            if (!this.isHandleableVariable(left) || !((VariableTrackingPrecision)this.precision).isTracking(variableName, left.getExpressionType(), cfaEdge.getSuccessor())) {
                assert (!((ApronState)this.state).existsVariable(variableName)) : "variablename '" + variableName + "' is in map although it can not be handled";
                return Collections.singleton(this.state);
            }
            Set<Texpr0Node> coeffsList = right.accept(new CApronExpressionVisitor());
            if (coeffsList.isEmpty()) {
                return Collections.singleton(this.state);
            }
            HashSet<ApronState> possibleStates = new HashSet<ApronState>();
            for (Texpr0Node coeffs : coeffsList) {
                ApronState st = ((ApronState)this.state).makeAssignment(variableName, coeffs);
                assert (!st.isEmpty()) : "states with assignments / declarations should never be empty";
                possibleStates.add(st);
            }
            return possibleStates;
        }
        if (statement instanceof CFunctionCallStatement || statement instanceof CExpressionStatement) {
            return Collections.singleton(this.state);
        }
        throw new UnrecognizedCCodeException("unknown statement", (CFAEdge)cfaEdge, statement);
    }

    private ValueAnalysisState.MemoryLocation buildVarName(CLeftHandSide left, String functionName) {
        String variableName = null;
        variableName = left instanceof CArraySubscriptExpression ? ((CArraySubscriptExpression)left).getArrayExpression().toASTString() : (left instanceof CPointerExpression ? ((CPointerExpression)left).getOperand().toASTString() : (left instanceof CFieldReference ? ((CFieldReference)left).getFieldOwner().toASTString() : ((CIdExpression)left).toASTString()));
        if (!ApronTransferRelation.isGlobal(left)) {
            return ValueAnalysisState.MemoryLocation.valueOf(functionName, variableName, 0L);
        }
        return ValueAnalysisState.MemoryLocation.valueOf(variableName);
    }

    @Override
    protected Set<ApronState> handleReturnStatementEdge(CReturnStatementEdge cfaEdge) throws CPATransferException {
        if (!cfaEdge.getExpression().isPresent()) {
            return Collections.singleton(this.state);
        }
        ValueAnalysisState.MemoryLocation tempVarName = ValueAnalysisState.MemoryLocation.valueOf(cfaEdge.getPredecessor().getFunctionName(), ((CIdExpression)((CAssignment)cfaEdge.asAssignment().get()).getLeftHandSide()).getName(), 0L);
        if (!((ApronState)this.state).existsVariable(tempVarName)) {
            return Collections.singleton(this.state);
        }
        HashSet<ApronState> possibleStates = new HashSet<ApronState>();
        Set<Texpr0Node> coeffsList = ((CExpression)cfaEdge.getExpression().get()).accept(new CApronExpressionVisitor());
        if (coeffsList.isEmpty()) {
            return Collections.singleton(this.state);
        }
        for (Texpr0Node coeffs : coeffsList) {
            possibleStates.add(((ApronState)this.state).makeAssignment(tempVarName, coeffs));
        }
        return possibleStates;
    }

    @Override
    protected Set<ApronState> handleFunctionSummaryEdge(CFunctionSummaryEdge cfaEdge) throws CPATransferException {
        return Collections.emptySet();
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState pState, List<AbstractState> pOtherStates, CFAEdge pCfaEdge, Precision pPrecision) throws CPATransferException, InterruptedException {
        return null;
    }

    static class CLiteralExpressionVisitor
    extends DefaultCExpressionVisitor<Double, CPATransferException> {
        CLiteralExpressionVisitor() {
        }

        @Override
        protected Double visitDefault(CExpression pExp) throws CPATransferException {
            return null;
        }

        @Override
        public Double visit(CFloatLiteralExpression e) throws CPATransferException {
            return e.getValue().doubleValue();
        }

        @Override
        public Double visit(CIntegerLiteralExpression e) throws CPATransferException {
            return e.getValue().doubleValue();
        }

        @Override
        public Double visit(CCharLiteralExpression e) throws CPATransferException {
            return e.getCharacter();
        }

        @Override
        public Double visit(CBinaryExpression e) throws CPATransferException {
            Double left = e.getOperand1().accept(this);
            Double right = e.getOperand2().accept(this);
            if (left == null || right == null) {
                return null;
            }
            switch (e.getOperator()) {
                case BINARY_AND: 
                case BINARY_OR: 
                case BINARY_XOR: 
                case SHIFT_RIGHT: 
                case SHIFT_LEFT: {
                    return null;
                }
                case DIVIDE: {
                    return left / right;
                }
                case EQUALS: {
                    return left.equals(right) ? 1.0 : 0.0;
                }
                case GREATER_EQUAL: {
                    return left >= right ? 1.0 : 0.0;
                }
                case GREATER_THAN: {
                    return left > right ? 1.0 : 0.0;
                }
                case LESS_EQUAL: {
                    return left <= right ? 1.0 : 0.0;
                }
                case LESS_THAN: {
                    return left < right ? 1.0 : 0.0;
                }
                case NOT_EQUALS: {
                    break;
                }
                case MINUS: {
                    return left - right;
                }
                case MODULO: {
                    return left % right;
                }
                case MULTIPLY: {
                    return left * right;
                }
                case PLUS: {
                    return left + right;
                }
            }
            return null;
        }

        @Override
        public Double visit(CUnaryExpression e) throws CPATransferException {
            Double op = e.getOperand().accept(this);
            if (op == null) {
                return null;
            }
            switch (e.getOperator()) {
                case AMPER: 
                case SIZEOF: 
                case TILDE: 
                case ALIGNOF: {
                    return null;
                }
                case MINUS: {
                    return -op.doubleValue();
                }
            }
            return null;
        }

        @Override
        public Double visit(CCastExpression e) throws CPATransferException {
            Double op = e.getOperand().accept(this);
            if (op != null && e.getExpressionType() instanceof CSimpleType && (((CSimpleType)e.getExpressionType()).getType() == CBasicType.INT || ((CSimpleType)e.getExpressionType()).getType() == CBasicType.CHAR)) {
                return op.intValue();
            }
            return op;
        }
    }

    class CApronExpressionVisitor
    extends DefaultCExpressionVisitor<Set<Texpr0Node>, CPATransferException>
    implements CRightHandSideVisitor<Set<Texpr0Node>, CPATransferException> {
        @Override
        protected Set<Texpr0Node> visitDefault(CExpression pExp) throws CPATransferException {
            return Collections.emptySet();
        }

        @Override
        public Set<Texpr0Node> visit(CBinaryExpression e) throws CPATransferException {
            Set<Texpr0Node> left = e.getOperand1().accept(this);
            Set<Texpr0Node> right = e.getOperand2().accept(this);
            HashSet<Texpr0Node> returnCoefficients = new HashSet<Texpr0Node>();
            for (Texpr0Node leftCoeffs : left) {
                block15: for (Texpr0Node rightCoeffs : right) {
                    switch (e.getOperator()) {
                        case BINARY_AND: 
                        case BINARY_OR: 
                        case BINARY_XOR: 
                        case SHIFT_RIGHT: 
                        case SHIFT_LEFT: {
                            return Collections.emptySet();
                        }
                        case MODULO: {
                            returnCoefficients.add((Texpr0Node)new Texpr0BinNode(4, leftCoeffs, rightCoeffs));
                            continue block15;
                        }
                        case DIVIDE: {
                            returnCoefficients.add((Texpr0Node)new Texpr0BinNode(3, leftCoeffs, rightCoeffs));
                            continue block15;
                        }
                        case MULTIPLY: {
                            returnCoefficients.add((Texpr0Node)new Texpr0BinNode(2, leftCoeffs, rightCoeffs));
                            continue block15;
                        }
                        case MINUS: {
                            returnCoefficients.add((Texpr0Node)new Texpr0BinNode(1, leftCoeffs, rightCoeffs));
                            continue block15;
                        }
                        case PLUS: {
                            returnCoefficients.add((Texpr0Node)new Texpr0BinNode(0, leftCoeffs, rightCoeffs));
                            continue block15;
                        }
                        case EQUALS: {
                            Tcons0 constraint = new Tcons0(0, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, leftCoeffs, rightCoeffs)));
                            if (!((ApronState)ApronTransferRelation.this.state).satisfies(constraint)) {
                                returnCoefficients.add((Texpr0Node)new Texpr0CstNode());
                            }
                            if (((ApronState)ApronTransferRelation.this.state).addConstraint(constraint).isEmpty()) continue block15;
                            returnCoefficients.add((Texpr0Node)new Texpr0CstNode((Coeff)new Interval(1, 1)));
                            continue block15;
                        }
                        case GREATER_EQUAL: {
                            Tcons0 constraint = new Tcons0(1, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, leftCoeffs, rightCoeffs)));
                            if (!((ApronState)ApronTransferRelation.this.state).satisfies(constraint)) {
                                returnCoefficients.add((Texpr0Node)new Texpr0CstNode());
                            }
                            if (((ApronState)ApronTransferRelation.this.state).addConstraint(constraint).isEmpty()) continue block15;
                            returnCoefficients.add((Texpr0Node)new Texpr0CstNode((Coeff)new Interval(1, 1)));
                            continue block15;
                        }
                        case GREATER_THAN: {
                            Tcons0 constraint = new Tcons0(2, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, leftCoeffs, rightCoeffs)));
                            if (!((ApronState)ApronTransferRelation.this.state).satisfies(constraint)) {
                                returnCoefficients.add((Texpr0Node)new Texpr0CstNode());
                            }
                            if (((ApronState)ApronTransferRelation.this.state).addConstraint(constraint).isEmpty()) continue block15;
                            returnCoefficients.add((Texpr0Node)new Texpr0CstNode((Coeff)new Interval(1, 1)));
                            continue block15;
                        }
                        case LESS_EQUAL: {
                            Tcons0 constraint = new Tcons0(1, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, rightCoeffs, leftCoeffs)));
                            if (!((ApronState)ApronTransferRelation.this.state).satisfies(constraint)) {
                                returnCoefficients.add((Texpr0Node)new Texpr0CstNode());
                            }
                            if (((ApronState)ApronTransferRelation.this.state).addConstraint(constraint).isEmpty()) continue block15;
                            returnCoefficients.add((Texpr0Node)new Texpr0CstNode((Coeff)new Interval(1, 1)));
                            continue block15;
                        }
                        case LESS_THAN: {
                            Tcons0 constraint = new Tcons0(2, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, rightCoeffs, leftCoeffs)));
                            if (!((ApronState)ApronTransferRelation.this.state).satisfies(constraint)) {
                                returnCoefficients.add((Texpr0Node)new Texpr0CstNode());
                            }
                            if (((ApronState)ApronTransferRelation.this.state).addConstraint(constraint).isEmpty()) continue block15;
                            returnCoefficients.add((Texpr0Node)new Texpr0CstNode((Coeff)new Interval(1, 1)));
                            continue block15;
                        }
                        case NOT_EQUALS: {
                            Tcons0 constraint = new Tcons0(4, new Texpr0Intern((Texpr0Node)new Texpr0BinNode(1, leftCoeffs, rightCoeffs)));
                            if (!((ApronState)ApronTransferRelation.this.state).satisfies(constraint)) {
                                returnCoefficients.add((Texpr0Node)new Texpr0CstNode());
                            }
                            if (((ApronState)ApronTransferRelation.this.state).addConstraint(constraint).isEmpty()) continue block15;
                            returnCoefficients.add((Texpr0Node)new Texpr0CstNode((Coeff)new Interval(1, 1)));
                            continue block15;
                        }
                    }
                    throw new AssertionError((Object)"Unhandled case statement");
                }
            }
            return returnCoefficients;
        }

        @Override
        public Set<Texpr0Node> visit(CCastExpression e) throws CPATransferException {
            return e.getOperand().accept(this);
        }

        @Override
        public Set<Texpr0Node> visit(CIdExpression e) throws CPATransferException {
            ValueAnalysisState.MemoryLocation varName = ApronTransferRelation.this.buildVarName(e, ApronTransferRelation.this.functionName);
            Integer varIndex = ((ApronState)ApronTransferRelation.this.state).getVariableIndexFor(varName);
            if (varIndex == -1) {
                return Collections.emptySet();
            }
            return Collections.singleton(new Texpr0DimNode(varIndex.intValue()));
        }

        @Override
        public Set<Texpr0Node> visit(CCharLiteralExpression e) throws CPATransferException {
            return Collections.singleton(Texpr0Node.fromLinexpr0((Linexpr0)new Linexpr0(new Linterm0[0], (Coeff)new DoubleScalar((double)e.getCharacter()))));
        }

        @Override
        public Set<Texpr0Node> visit(CFloatLiteralExpression e) throws CPATransferException {
            return Collections.singleton(Texpr0Node.fromLinexpr0((Linexpr0)new Linexpr0(new Linterm0[0], (Coeff)new DoubleScalar(e.getValue().doubleValue()))));
        }

        @Override
        public Set<Texpr0Node> visit(CIntegerLiteralExpression e) throws CPATransferException {
            return Collections.singleton(Texpr0Node.fromLinexpr0((Linexpr0)new Linexpr0(new Linterm0[0], (Coeff)new DoubleScalar(e.getValue().doubleValue()))));
        }

        @Override
        public Set<Texpr0Node> visit(CUnaryExpression e) throws CPATransferException {
            Set<Texpr0Node> operand = e.getOperand().accept(this);
            switch (e.getOperator()) {
                case AMPER: 
                case SIZEOF: 
                case TILDE: {
                    return Collections.emptySet();
                }
                case MINUS: {
                    HashSet<Texpr0Node> returnCoefficients = new HashSet<Texpr0Node>();
                    for (Texpr0Node coeffs : operand) {
                        returnCoefficients.add((Texpr0Node)new Texpr0UnNode(6, coeffs));
                    }
                    return returnCoefficients;
                }
            }
            throw new AssertionError((Object)"Unhandled case in switch clause.");
        }

        @Override
        public Set<Texpr0Node> visit(CFunctionCallExpression e) throws CPATransferException {
            if (e.getFunctionNameExpression() instanceof CIdExpression) {
                String functionName = ((CIdExpression)e.getFunctionNameExpression()).getName();
                if (functionName.equals("__VERIFIER_nondet_int")) {
                    Scalar sup = Scalar.create();
                    sup.setInfty(1);
                    Scalar inf = Scalar.create();
                    inf.setInfty(-1);
                    Interval interval = new Interval(inf, sup);
                    return Collections.singleton(new Texpr0CstNode((Coeff)interval));
                }
                if (functionName.equals("__VERIFIER_nondet_uint")) {
                    Interval interval = new Interval();
                    Scalar sup = Scalar.create();
                    sup.setInfty(1);
                    interval.setSup(sup);
                    return Collections.singleton(new Texpr0CstNode((Coeff)interval));
                }
                if (functionName.equals("__VERIFIER_nondet_bool")) {
                    Interval interval = new Interval(0, 1);
                    return Collections.singleton(new Texpr0CstNode((Coeff)interval));
                }
            }
            return Collections.emptySet();
        }
    }
}

