/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.apron.refiner;

import apron.ApronException;
import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.defaults.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.cpa.apron.ApronCPA;
import org.sosy_lab.cpachecker.cpa.apron.ApronState;
import org.sosy_lab.cpachecker.cpa.apron.ApronTransferRelation;
import org.sosy_lab.cpachecker.cpa.arg.MutableARGPath;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.AssumptionUseDefinitionCollector;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class ApronAnalysisFeasabilityChecker {
    private final ApronTransferRelation transfer;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final MutableARGPath checkedPath;
    private final MutableARGPath foundPath;

    public ApronAnalysisFeasabilityChecker(CFA cfa, LogManager log, ShutdownNotifier pShutdownNotifier, MutableARGPath path, ApronCPA cpa) throws InvalidConfigurationException, CPAException, InterruptedException, ApronException {
        this.logger = log;
        this.shutdownNotifier = pShutdownNotifier;
        this.transfer = new ApronTransferRelation(this.logger, cfa, cpa.isSplitDisequalites());
        this.checkedPath = path;
        this.foundPath = this.getInfeasiblePrefix(VariableTrackingPrecision.createStaticPrecision(cpa.getConfiguration(), cfa.getVarClassification(), ApronCPA.class), new ApronState(this.logger, cpa.getManager()));
    }

    public boolean isFeasible() {
        return this.checkedPath.size() == this.foundPath.size();
    }

    public Multimap<CFANode, ValueAnalysisState.MemoryLocation> getPrecisionIncrement(VariableTrackingPrecision precision) {
        if (this.isFeasible()) {
            return ArrayListMultimap.create();
        }
        HashSet varNames = new HashSet();
        LinkedList<CFAEdge> edgesList = new LinkedList<CFAEdge>(this.foundPath.asEdgesList());
        do {
            varNames.addAll(FluentIterable.from(new AssumptionUseDefinitionCollector().obtainUseDefInformation(edgesList)).transform((Function)new Function<String, ValueAnalysisState.MemoryLocation>(){

                public ValueAnalysisState.MemoryLocation apply(String pInput) {
                    return ValueAnalysisState.MemoryLocation.valueOf(pInput);
                }
            }).toSet());
            edgesList.removeLast();
            while (!edgesList.isEmpty() && !(edgesList.getLast() instanceof AssumeEdge)) {
                edgesList.removeLast();
            }
        } while (varNames.isEmpty() && !edgesList.isEmpty());
        ArrayListMultimap increment = ArrayListMultimap.create();
        for (ValueAnalysisState.MemoryLocation loc : varNames) {
            increment.put((Object)new CFANode("BOGUS-NODE"), (Object)loc);
        }
        return increment;
    }

    private MutableARGPath getInfeasiblePrefix(VariableTrackingPrecision pPrecision, ApronState pInitial) throws CPAException, InterruptedException {
        try {
            ArrayList next = Lists.newArrayList((Object[])new ApronState[]{pInitial});
            MutableARGPath prefix = new MutableARGPath();
            HashSet<ApronState> successors = new HashSet<ApronState>();
            for (Pair pathElement : this.checkedPath) {
                successors.clear();
                for (ApronState st : next) {
                    successors.addAll(this.transfer.getAbstractSuccessorsForEdge(st, pPrecision, (CFAEdge)pathElement.getSecond()));
                    if (!this.shutdownNotifier.shouldShutdown()) continue;
                    this.logger.log(Level.INFO, new Object[]{"Cancelling feasibility check with octagon Analysis, timelimit reached"});
                    return this.checkedPath;
                }
                prefix.addLast(pathElement);
                if (successors.isEmpty()) break;
                next.clear();
                next.addAll(successors);
            }
            return prefix;
        }
        catch (CPATransferException e) {
            throw new CPAException("Computation of successor failed for checking path: " + e.getMessage(), e);
        }
    }
}

