/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.apron.refiner;

import apron.ApronException;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.PrintStream;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.TimeSpanOption;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.core.defaults.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.apron.ApronCPA;
import org.sosy_lab.cpachecker.cpa.apron.refiner.ApronAnalysisFeasabilityChecker;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.AbstractARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.arg.MutableARGPath;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisPathInterpolator;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.ValueAnalysisFeasibilityChecker;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.resources.ResourceLimit;
import org.sosy_lab.cpachecker.util.resources.ResourceLimitChecker;
import org.sosy_lab.cpachecker.util.resources.WalltimeLimit;

@Options(prefix="cpa.apron.refiner")
public class ApronDelegatingRefiner
extends AbstractARGBasedRefiner
implements Statistics,
StatisticsProvider {
    private ValueAnalysisPathInterpolator interpolatingRefiner;
    private int previousErrorPathID = -1;
    @Option(secure=true, description="whether or not to check for repeated refinements, to then reset the refinement root")
    private boolean checkForRepeatedRefinements = true;
    @Option(secure=true, description="Timelimit for the backup feasibility check with the apron analysis.(use seconds or specify a unit; 0 for infinite)")
    @TimeSpanOption(codeUnit=TimeUnit.NANOSECONDS, defaultUserUnit=TimeUnit.SECONDS, min=0L)
    private TimeSpan timeForApronFeasibilityCheck = TimeSpan.ofNanos((long)0L);
    private int numberOfValueAnalysisRefinements = 0;
    private int numberOfSuccessfulValueAnalysisRefinements = 0;
    private int previousRefinementId = 0;
    private boolean existsExplicitApronRefinement = false;
    private final CFA cfa;
    private final ApronCPA apronCPA;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;

    public static ApronDelegatingRefiner create(ConfigurableProgramAnalysis cpa) throws CPAException, InvalidConfigurationException {
        if (!(cpa instanceof WrapperCPA)) {
            throw new InvalidConfigurationException(ApronDelegatingRefiner.class.getSimpleName() + " could not find the ApronCPA");
        }
        ApronCPA apronCPA = ((WrapperCPA)((Object)cpa)).retrieveWrappedCpa(ApronCPA.class);
        if (apronCPA == null) {
            throw new InvalidConfigurationException(ApronDelegatingRefiner.class.getSimpleName() + " needs an ApronCPA");
        }
        ApronDelegatingRefiner refiner = new ApronDelegatingRefiner(cpa, apronCPA);
        return refiner;
    }

    private ApronDelegatingRefiner(ConfigurableProgramAnalysis pCpa, ApronCPA pApronCPA) throws CPAException, InvalidConfigurationException {
        super(pCpa);
        pApronCPA.getConfiguration().inject((Object)this);
        this.cfa = pApronCPA.getCFA();
        this.logger = pApronCPA.getLogger();
        this.shutdownNotifier = pApronCPA.getShutdownNotifier();
        this.apronCPA = pApronCPA;
        this.interpolatingRefiner = new ValueAnalysisPathInterpolator(pApronCPA.getConfiguration(), this.logger, this.shutdownNotifier, this.cfa);
    }

    @Override
    protected CounterexampleInfo performRefinement(ARGReachedSet reached, ARGPath pErrorPath) throws CPAException, InterruptedException {
        ApronAnalysisFeasabilityChecker apronChecker;
        MutableARGPath errorPath = pErrorPath.mutableCopy();
        if (!this.isPathFeasable(pErrorPath) && !this.existsExplicitApronRefinement && this.performValueAnalysisRefinement(reached, errorPath)) {
            return CounterexampleInfo.spurious();
        }
        try {
            apronChecker = this.createApronFeasibilityChecker(errorPath);
        }
        catch (ApronException e) {
            throw new RuntimeException("An error occured while operating with the apron library", e);
        }
        if (!apronChecker.isFeasible() && this.performApronAnalysisRefinement(reached, apronChecker)) {
            this.existsExplicitApronRefinement = true;
            return CounterexampleInfo.spurious();
        }
        return CounterexampleInfo.feasible(pErrorPath, Model.empty());
    }

    private boolean performValueAnalysisRefinement(ARGReachedSet reached, MutableARGPath errorPath) throws CPAException, InterruptedException {
        VariableTrackingPrecision refinedApronPrecision;
        ++this.numberOfValueAnalysisRefinements;
        UnmodifiableReachedSet reachedSet = reached.asReachedSet();
        Precision precision = reachedSet.getPrecision(reachedSet.getLastState());
        VariableTrackingPrecision apronPrecision = (VariableTrackingPrecision)Precisions.asIterable(precision).filter(VariableTrackingPrecision.isMatchingCPAClass(ApronCPA.class)).get(0);
        Multimap<CFANode, ValueAnalysisState.MemoryLocation> increment = this.interpolatingRefiner.determinePrecisionIncrement(errorPath);
        Pair<ARGState, CFAEdge> refinementRoot = this.interpolatingRefiner.determineRefinementRoot(errorPath, increment, false);
        if (increment.isEmpty()) {
            return false;
        }
        if (this.checkForRepeatedRefinements && this.isRepeatedRefinement(increment, refinementRoot)) {
            refinementRoot = this.interpolatingRefiner.determineRefinementRoot(errorPath, increment, true);
        }
        if (this.valueAnalysisRefinementWasSuccessful(errorPath, apronPrecision, refinedApronPrecision = apronPrecision.withIncrement(increment))) {
            ++this.numberOfSuccessfulValueAnalysisRefinements;
            reached.removeSubtree((ARGState)refinementRoot.getFirst(), refinedApronPrecision, VariableTrackingPrecision.isMatchingCPAClass(ApronCPA.class));
            return true;
        }
        return false;
    }

    private boolean performApronAnalysisRefinement(ARGReachedSet reached, ApronAnalysisFeasabilityChecker checker) {
        UnmodifiableReachedSet reachedSet = reached.asReachedSet();
        Precision precision = reachedSet.getPrecision(reachedSet.getLastState());
        VariableTrackingPrecision apronPrecision = (VariableTrackingPrecision)Precisions.asIterable(precision).filter(VariableTrackingPrecision.isMatchingCPAClass(ApronCPA.class)).get(0);
        Multimap<CFANode, ValueAnalysisState.MemoryLocation> increment = checker.getPrecisionIncrement(apronPrecision);
        if (increment.isEmpty()) {
            // empty if block
        }
        reached.removeSubtree(((ARGState)reachedSet.getFirstState()).getChildren().iterator().next(), apronPrecision.withIncrement(increment), VariableTrackingPrecision.isMatchingCPAClass(ApronCPA.class));
        this.logger.log(Level.INFO, new Object[]{"Refinement successful, precision incremented, following variables are now tracked additionally:\n" + increment});
        return true;
    }

    private boolean isRepeatedRefinement(Multimap<CFANode, ValueAnalysisState.MemoryLocation> increment, Pair<ARGState, CFAEdge> refinementRoot) {
        int currentRefinementId = ((CFAEdge)refinementRoot.getSecond()).getSuccessor().getNodeNumber();
        boolean result = this.previousRefinementId == currentRefinementId;
        this.previousRefinementId = currentRefinementId;
        return result;
    }

    private boolean valueAnalysisRefinementWasSuccessful(MutableARGPath errorPath, VariableTrackingPrecision valueAnalysisPrecision, VariableTrackingPrecision refinedValueAnalysisPrecision) {
        boolean success = errorPath.toString().hashCode() != this.previousErrorPathID || refinedValueAnalysisPrecision.getSize() > valueAnalysisPrecision.getSize();
        this.previousErrorPathID = errorPath.toString().hashCode();
        return success;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this);
        pStatsCollection.add(this.interpolatingRefiner);
    }

    @Override
    public String getName() {
        return "ApronAnalysisDelegatingRefiner";
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
        out.println("  number of value analysis refinements:                " + this.numberOfValueAnalysisRefinements);
        out.println("  number of successful valueAnalysis refinements:      " + this.numberOfSuccessfulValueAnalysisRefinements);
    }

    boolean isPathFeasable(ARGPath path) throws CPAException {
        try {
            ValueAnalysisFeasibilityChecker checker = new ValueAnalysisFeasibilityChecker(this.logger, this.cfa, this.apronCPA.getConfiguration());
            return checker.isFeasible(path);
        }
        catch (InterruptedException | InvalidConfigurationException e) {
            throw new CPAException("counterexample-check failed: ", e);
        }
    }

    private ApronAnalysisFeasabilityChecker createApronFeasibilityChecker(MutableARGPath path) throws CPAException, ApronException {
        try {
            ApronAnalysisFeasabilityChecker checker;
            if (this.timeForApronFeasibilityCheck.isEmpty()) {
                checker = new ApronAnalysisFeasabilityChecker(this.cfa, this.logger, this.shutdownNotifier, path, this.apronCPA);
            } else {
                ShutdownNotifier notifier = ShutdownNotifier.createWithParent(this.shutdownNotifier);
                WalltimeLimit l = WalltimeLimit.fromNowOn(this.timeForApronFeasibilityCheck);
                ResourceLimitChecker limits = new ResourceLimitChecker(notifier, Lists.newArrayList((Object[])new ResourceLimit[]{l}));
                limits.start();
                checker = new ApronAnalysisFeasabilityChecker(this.cfa, this.logger, notifier, path, this.apronCPA);
                limits.cancel();
            }
            return checker;
        }
        catch (InterruptedException | InvalidConfigurationException e) {
            throw new CPAException("counterexample-check failed: ", e);
        }
    }
}

