/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.configuration.ClassOption;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.FlatLatticeDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.SimplePrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithBAM;
import org.sosy_lab.cpachecker.core.interfaces.ForcedCoveringStopOperator;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.cpa.arg.ARGMergeJoin;
import org.sosy_lab.cpachecker.cpa.arg.ARGMergeJoinPredicatedAnalysis;
import org.sosy_lab.cpachecker.cpa.arg.ARGPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.arg.ARGReducer;
import org.sosy_lab.cpachecker.cpa.arg.ARGSimplePrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGStatistics;
import org.sosy_lab.cpachecker.cpa.arg.ARGStopSep;
import org.sosy_lab.cpachecker.cpa.arg.ARGToDotWriter;
import org.sosy_lab.cpachecker.cpa.arg.ARGTransferRelation;
import org.sosy_lab.cpachecker.cpa.arg.counterexamples.CEXExporter;
import org.sosy_lab.cpachecker.cpa.arg.counterexamples.ConjunctiveCounterexampleFilter;
import org.sosy_lab.cpachecker.cpa.arg.counterexamples.CounterexampleFilter;
import org.sosy_lab.cpachecker.cpa.arg.counterexamples.NullCounterexampleFilter;
import org.sosy_lab.cpachecker.cpa.arg.counterexamples.PathEqualityCounterexampleFilter;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

@Options(prefix="cpa.arg")
public class ARGCPA
extends AbstractSingleWrapperCPA
implements ConfigurableProgramAnalysisWithBAM,
ProofChecker {
    @Option(secure=true, description="inform ARG CPA if it is run in a predicated analysis because then it mustbehave differntly during merge.")
    private boolean inPredicatedAnalysis = false;
    @Option(secure=true, description="inform merge operator in predicated analysis that it should delete the subgraph of the merged nodewhich is required to get at most one successor per CFA edge.")
    private boolean deleteInPredicatedAnalysis = false;
    @Option(secure=true, name="errorPath.filters", description="Filter for irrelevant counterexamples to reduce the number of similar counterexamples reported. Only relevant with analysis.stopAfterErrors=false and cpa.arg.errorPath.exportImmediately=true. Put the weakest and cheapest filter first, e.g., PathEqualityCounterexampleFilter.")
    @ClassOption(packagePrefix={"org.sosy_lab.cpachecker.cpa.arg.counterexamples"})
    private List<Class<? extends CounterexampleFilter>> cexFilterClasses = ImmutableList.of(PathEqualityCounterexampleFilter.class);
    private final CounterexampleFilter cexFilter;
    private final LogManager logger;
    private final AbstractDomain abstractDomain;
    private final ARGTransferRelation transferRelation;
    private final MergeOperator mergeOperator;
    private final ARGStopSep stopOperator;
    private final PrecisionAdjustment precisionAdjustment;
    private final Reducer reducer;
    private final ARGStatistics stats;
    private final ProofChecker wrappedProofChecker;
    private final CEXExporter cexExporter;
    private final Map<ARGState, CounterexampleInfo> counterexamples = new WeakHashMap<ARGState, CounterexampleInfo>();
    private final MachineModel machineModel;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(ARGCPA.class);
    }

    private ARGCPA(ConfigurableProgramAnalysis cpa, Configuration config, LogManager logger, CFA cfa) throws InvalidConfigurationException {
        super(cpa);
        Reducer wrappedReducer;
        config.inject((Object)this);
        this.logger = logger;
        this.abstractDomain = new FlatLatticeDomain();
        this.transferRelation = new ARGTransferRelation(cpa.getTransferRelation());
        PrecisionAdjustment wrappedPrec = cpa.getPrecisionAdjustment();
        this.precisionAdjustment = wrappedPrec instanceof SimplePrecisionAdjustment ? new ARGSimplePrecisionAdjustment((SimplePrecisionAdjustment)wrappedPrec) : new ARGPrecisionAdjustment(cpa.getPrecisionAdjustment(), this.inPredicatedAnalysis);
        this.reducer = cpa instanceof ConfigurableProgramAnalysisWithBAM ? ((wrappedReducer = ((ConfigurableProgramAnalysisWithBAM)cpa).getReducer()) != null ? new ARGReducer(wrappedReducer) : null) : null;
        this.wrappedProofChecker = cpa instanceof ProofChecker ? (ProofChecker)((Object)cpa) : null;
        MergeOperator wrappedMerge = this.getWrappedCpa().getMergeOperator();
        this.mergeOperator = wrappedMerge == MergeSepOperator.getInstance() ? MergeSepOperator.getInstance() : (this.inPredicatedAnalysis ? new ARGMergeJoinPredicatedAnalysis(wrappedMerge, this.deleteInPredicatedAnalysis) : new ARGMergeJoin(wrappedMerge));
        this.stopOperator = new ARGStopSep(this.getWrappedCpa().getStopOperator(), logger, config);
        this.cexFilter = this.createCounterexampleFilter(config, logger, cpa);
        this.cexExporter = new CEXExporter(config, logger);
        this.stats = new ARGStatistics(config, this);
        this.machineModel = cfa.getMachineModel();
    }

    private CounterexampleFilter createCounterexampleFilter(Configuration config, LogManager logger, ConfigurableProgramAnalysis cpa) throws InvalidConfigurationException {
        Object[] argumentValues = new Object[]{config, logger, cpa};
        Class[] argumentTypes = new Class[]{Configuration.class, LogManager.class, ConfigurableProgramAnalysis.class};
        switch (this.cexFilterClasses.size()) {
            case 0: {
                return new NullCounterexampleFilter();
            }
            case 1: {
                return (CounterexampleFilter)Classes.createInstance(CounterexampleFilter.class, this.cexFilterClasses.get(0), (Class[])argumentTypes, (Object[])argumentValues, InvalidConfigurationException.class);
            }
        }
        ArrayList<CounterexampleFilter> filters = new ArrayList<CounterexampleFilter>(this.cexFilterClasses.size());
        for (Class<? extends CounterexampleFilter> cls : this.cexFilterClasses) {
            filters.add((CounterexampleFilter)Classes.createInstance(CounterexampleFilter.class, cls, (Class[])argumentTypes, (Object[])argumentValues, InvalidConfigurationException.class));
        }
        return new ConjunctiveCounterexampleFilter(filters);
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public ForcedCoveringStopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.precisionAdjustment;
    }

    @Override
    public Reducer getReducer() {
        return this.reducer;
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        return new ARGState(this.getWrappedCpa().getInitialState(pNode, pPartition), null);
    }

    protected LogManager getLogger() {
        return this.logger;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
        super.collectStatistics(pStatsCollection);
    }

    public Map<ARGState, CounterexampleInfo> getCounterexamples() {
        return Collections.unmodifiableMap(this.counterexamples);
    }

    public void addCounterexample(ARGState targetState, CounterexampleInfo pCounterexample) {
        Preconditions.checkArgument((boolean)targetState.isTarget());
        Preconditions.checkArgument((!pCounterexample.isSpurious() ? 1 : 0) != 0);
        if (pCounterexample.getTargetPath() != null) {
            Preconditions.checkArgument((boolean)pCounterexample.getTargetPath().getLastState().isTarget());
        }
        this.counterexamples.put(targetState, pCounterexample);
    }

    public void clearCounterexamples(Set<ARGState> toRemove) {
        this.counterexamples.keySet().removeAll(toRemove);
    }

    ARGToDotWriter getRefinementGraphWriter() {
        return this.stats.getRefinementGraphWriter();
    }

    @Override
    public boolean areAbstractSuccessors(AbstractState pElement, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors) throws CPATransferException, InterruptedException {
        Preconditions.checkNotNull((Object)this.wrappedProofChecker, (Object)"Wrapped CPA has to implement ProofChecker interface");
        return this.transferRelation.areAbstractSuccessors(pElement, pCfaEdge, pSuccessors, this.wrappedProofChecker);
    }

    @Override
    public boolean isCoveredBy(AbstractState pElement, AbstractState pOtherElement) throws CPAException, InterruptedException {
        Preconditions.checkNotNull((Object)this.wrappedProofChecker, (Object)"Wrapped CPA has to implement ProofChecker interface");
        return this.stopOperator.isCoveredBy(pElement, pOtherElement, this.wrappedProofChecker);
    }

    void exportCounterexampleOnTheFly(ARGState pTargetState, CounterexampleInfo pCounterexampleInfo, int cexIndex) throws InterruptedException {
        if (this.cexExporter.shouldDumpErrorPathImmediately()) {
            if (this.cexFilter.isRelevant(pCounterexampleInfo)) {
                this.cexExporter.exportCounterexample(pTargetState, pCounterexampleInfo, cexIndex, null, true);
            } else {
                this.logger.log(Level.FINEST, new Object[]{"Skipping counterexample printing because it is similar to one of already printed."});
            }
        }
    }

    public MachineModel getMachineModel() {
        return this.machineModel;
    }
}

