/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.PredicatedAnalysisPropertyViolationException;

public class ARGMergeJoinPredicatedAnalysis
implements MergeOperator {
    private final boolean deleteSubgraphAfterMerge;
    private final MergeOperator wrappedMerge;
    private final ArrayList<ARGState> toDeleteFromReached = new ArrayList();

    public ARGMergeJoinPredicatedAnalysis(MergeOperator pWrappedMerge, boolean pDeleteSubgraph) {
        this.wrappedMerge = pWrappedMerge;
        this.deleteSubgraphAfterMerge = pDeleteSubgraph;
    }

    @Override
    public AbstractState merge(AbstractState pState1, AbstractState pState2, Precision pPrecision) throws CPAException, InterruptedException {
        AbstractState wrappedState2;
        ARGState argElement1 = (ARGState)pState1;
        ARGState argElement2 = (ARGState)pState2;
        assert (!argElement1.isCovered()) : "Trying to merge covered element " + argElement1;
        if (!argElement2.mayCover()) {
            return pState2;
        }
        if (argElement1.getMergedWith() != null) {
            return pState2;
        }
        AbstractState wrappedState1 = argElement1.getWrappedState();
        AbstractState retElement = this.wrappedMerge.merge(wrappedState1, wrappedState2 = argElement2.getWrappedState(), pPrecision);
        if (retElement.equals(wrappedState2)) {
            return pState2;
        }
        ARGState mergedElement = new ARGState(retElement, null);
        if (this.deleteSubgraphAfterMerge) {
            this.deleteChildren2(argElement2);
        }
        argElement2.replaceInARGWith(mergedElement);
        argElement1.setMergedWith(mergedElement);
        if (mergedElement.isTarget()) {
            throw new PredicatedAnalysisPropertyViolationException("Property violated during merge", argElement1, true);
        }
        return mergedElement;
    }

    private void deleteChildren(ARGState parent) {
        Stack<ARGState> toProcess = new Stack<ARGState>();
        HashSet<ARGState> delete = new HashSet<ARGState>();
        toProcess.add(parent);
        while (!toProcess.isEmpty()) {
            ARGState current = (ARGState)toProcess.pop();
            this.toDeleteFromReached.add(current);
            delete.add(current);
            while (current.getChildren().size() != 0) {
                ARGState child = current.getChildren().iterator().next();
                current.deleteChild(child);
                if (child.getParents().size() != 0) continue;
                if (child.getCoveredByThis().size() != 0) {
                    ARGState covered;
                    Iterator<ARGState> coveredElems = child.getCoveredByThis().iterator();
                    do {
                        if ((covered = coveredElems.next()).getParents().size() != 0) continue;
                        covered = null;
                    } while (covered == null && coveredElems.hasNext());
                    if (covered != null) {
                        covered.uncover();
                        covered.replaceInARGWith(child);
                        continue;
                    }
                    if (child.isCovered()) {
                        child.uncover();
                    }
                    toProcess.add(child);
                    continue;
                }
                if (child.isCovered()) {
                    child.uncover();
                }
                toProcess.add(child);
            }
        }
    }

    private void deleteChildren2(ARGState parent) {
        ARGState covered;
        ARGState child;
        ARGState current;
        HashSet<ARGState> subtreeNodes = this.getSubtreeNodes(parent);
        HashSet<ARGState> laterCovered = new HashSet<ARGState>();
        Stack<ARGState> toProcess = new Stack<ARGState>();
        toProcess.add(parent);
        while (!toProcess.isEmpty()) {
            current = (ARGState)toProcess.pop();
            this.toDeleteFromReached.add(current);
            while (current.getChildren().size() != 0) {
                child = current.getChildren().iterator().next();
                current.deleteChild(child);
                assert (child.getParents().size() == 0);
                if (child.getCoveredByThis().size() != 0) {
                    covered = this.getCoveredNodeFromDifferentSubtree(subtreeNodes, child);
                    if (covered != null) {
                        covered.uncover();
                        covered.replaceInARGWith(child);
                        subtreeNodes.removeAll(this.getSubtreeNodes(child));
                        continue;
                    }
                    laterCovered.add(child);
                    continue;
                }
                if (child.isCovered()) {
                    child.uncover();
                }
                toProcess.add(child);
            }
        }
        toProcess.addAll(laterCovered);
        while (!toProcess.isEmpty()) {
            current = (ARGState)toProcess.pop();
            for (ARGState c : current.getChildren()) {
                assert (c.getParents().size() == 1);
                if (c.getCoveredByThis().size() != 0) {
                    covered = this.getCoveredNodeFromDifferentSubtree(subtreeNodes, c);
                    if (covered != null) {
                        current.deleteChild(c);
                        new ARGState(c.getWrappedState(), current).setCovered(c);
                        covered.uncover();
                        covered.replaceInARGWith(c);
                        subtreeNodes.removeAll(this.getSubtreeNodes(c));
                        continue;
                    }
                    laterCovered.add(c);
                    toProcess.add(c);
                    continue;
                }
                toProcess.add(c);
            }
        }
        boolean changed = true;
        block4: while (changed) {
            changed = false;
            for (ARGState later : laterCovered) {
                if (later.getCoveredByThis().size() == 0 || (covered = this.getCoveredNodeFromDifferentSubtree(subtreeNodes, later)) == null) continue;
                assert (later.getParents().size() <= 1);
                if (later.getParents().size() == 1) {
                    new ARGState(later.getWrappedState(), later.getParents().iterator().next()).setCovered(later);
                    later.getParents().iterator().next().deleteChild(later);
                }
                covered.uncover();
                covered.replaceInARGWith(later);
                subtreeNodes.removeAll(this.getSubtreeNodes(later));
                laterCovered.remove(later);
                changed = true;
                continue block4;
            }
        }
        toProcess.addAll(laterCovered);
        while (!toProcess.isEmpty()) {
            current = (ARGState)toProcess.pop();
            this.toDeleteFromReached.add(current);
            while (current.getChildren().size() != 0) {
                child = current.getChildren().iterator().next();
                current.deleteChild(child);
                toProcess.add(child);
            }
        }
    }

    private ARGState getCoveredNodeFromDifferentSubtree(HashSet<ARGState> subtreeNodes, ARGState elem) {
        ARGState covered;
        Iterator<ARGState> coveredElems = elem.getCoveredByThis().iterator();
        do {
            covered = coveredElems.next();
            assert (covered.getCoveredByThis().size() == 0);
            if (covered.getParents().size() != 0 && !subtreeNodes.contains(covered)) continue;
            covered = null;
        } while (covered == null && coveredElems.hasNext());
        return covered;
    }

    private HashSet<ARGState> getSubtreeNodes(ARGState top) {
        Stack<ARGState> toProcess = new Stack<ARGState>();
        HashSet<ARGState> nodes = new HashSet<ARGState>();
        toProcess.push(top);
        nodes.add(top);
        while (!toProcess.isEmpty()) {
            top = (ARGState)toProcess.pop();
            for (ARGState child : top.getChildren()) {
                if (!nodes.add(child)) continue;
                toProcess.push(child);
            }
        }
        return nodes;
    }

    public void cleanUp(ReachedSet pReachedSet) {
        pReachedSet.removeAll(this.toDeleteFromReached);
        this.toDeleteFromReached.clear();
    }
}

