/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.JSON;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.MutableARGPath;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;

@Immutable
public class ARGPath
implements Appender {
    private final ImmutableList<ARGState> states;
    private final List<CFAEdge> edges;

    ARGPath(List<ARGState> pStates) {
        Preconditions.checkArgument((!pStates.isEmpty() ? 1 : 0) != 0, (Object)"ARGPaths may not be empty");
        this.states = ImmutableList.copyOf(pStates);
        ArrayList<Object> edgesBuilder = new ArrayList<Object>(this.states.size());
        for (int i = 0; i < this.states.size() - 1; ++i) {
            ARGState parent = (ARGState)this.states.get(i);
            ARGState child = (ARGState)this.states.get(i + 1);
            edgesBuilder.add(parent.getEdgeToChild(child));
        }
        CFANode lastLoc = AbstractStates.extractLocation((AbstractState)this.states.get(this.states.size() - 1));
        edgesBuilder.add(CFAUtils.leavingEdges(lastLoc).first().orNull());
        this.edges = Collections.unmodifiableList(edgesBuilder);
        assert (this.states.size() == this.edges.size());
    }

    ARGPath(List<ARGState> pStates, List<CFAEdge> pEdges) {
        Preconditions.checkArgument((!pStates.isEmpty() ? 1 : 0) != 0, (Object)"ARGPaths may not be empty");
        Preconditions.checkArgument((pStates.size() == pEdges.size() ? 1 : 0) != 0, (Object)"ARGPaths must have equal number of states and edges");
        CFAEdge lastEdge = pEdges.get(pEdges.size() - 1);
        if (lastEdge != null) {
            CFANode lastLoc = AbstractStates.extractLocation(pStates.get(pStates.size() - 1));
            Preconditions.checkArgument((boolean)CFAUtils.leavingEdges(lastLoc).contains((Object)lastEdge));
        }
        this.states = ImmutableList.copyOf(pStates);
        this.edges = Collections.unmodifiableList(new ArrayList<CFAEdge>(pEdges));
    }

    public ImmutableList<ARGState> asStatesList() {
        return this.states;
    }

    public List<CFAEdge> asEdgesList() {
        return this.edges;
    }

    public ARGPath obtainSuffix(int pOffset) {
        Preconditions.checkElementIndex((int)pOffset, (int)this.states.size());
        return new ARGPath((List<ARGState>)this.states.subList(pOffset, this.states.size()), this.edges.subList(pOffset, this.edges.size()));
    }

    public List<CFAEdge> getInnerEdges() {
        return this.edges.subList(0, this.edges.size() - 1);
    }

    public ImmutableSet<ARGState> getStateSet() {
        return ImmutableSet.copyOf(this.states);
    }

    public MutableARGPath mutableCopy() {
        MutableARGPath result = new MutableARGPath();
        Iterables.addAll((Collection)result, (Iterable)Pair.zipWithPadding(this.states, this.edges));
        return result;
    }

    public PathIterator pathIterator() {
        return new DefaultPathIterator(this);
    }

    public PathIterator reversePathIterator() {
        return new ReversePathIterator(this);
    }

    public int size() {
        return this.states.size();
    }

    public ARGState getFirstState() {
        return (ARGState)this.states.get(0);
    }

    public ARGState getLastState() {
        return (ARGState)Iterables.getLast(this.states);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.edges == null ? 0 : this.edges.hashCode());
        return result;
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (!(pOther instanceof ARGPath)) {
            return false;
        }
        ARGPath other = (ARGPath)pOther;
        return !(this.edges == null ? other.edges != null : !this.edges.equals(other.edges));
    }

    public void appendTo(Appendable appendable) throws IOException {
        Joiner.on((char)'\n').skipNulls().appendTo(appendable, this.getInnerEdges());
    }

    public String toString() {
        return Joiner.on((char)'\n').skipNulls().join(this.getInnerEdges());
    }

    public void toJSON(Appendable sb) throws IOException {
        ArrayList path = new ArrayList(this.size());
        for (Pair pair : Pair.zipWithPadding(this.states, this.edges)) {
            HashMap<String, Object> elem = new HashMap<String, Object>();
            ARGState argelem = (ARGState)pair.getFirst();
            CFAEdge edge = (CFAEdge)pair.getSecond();
            if (edge == null) continue;
            elem.put("argelem", argelem.getStateId());
            elem.put("source", edge.getPredecessor().getNodeNumber());
            elem.put("target", edge.getSuccessor().getNodeNumber());
            elem.put("desc", edge.getDescription().replaceAll("\n", " "));
            elem.put("val", "");
            elem.put("line", edge.getFileLocation().getStartingLineNumber());
            elem.put("file", edge.getFileLocation().getFileName());
            path.add(elem);
        }
        JSON.writeJSONString(path, (Appendable)sb);
    }

    private static class ReversePathIterator
    extends PathIterator {
        private ReversePathIterator(ARGPath pPath, int pPos) {
            super(pPath, pPos);
        }

        private ReversePathIterator(ARGPath pPath) {
            super(pPath, pPath.states.size() - 1);
        }

        @Override
        public void advance() throws IllegalStateException {
            Preconditions.checkState((boolean)this.hasNext(), (Object)"No more states in PathIterator.");
            --this.pos;
        }

        @Override
        public boolean hasNext() {
            return this.pos > 0;
        }
    }

    private static class DefaultPathIterator
    extends PathIterator {
        private DefaultPathIterator(ARGPath pPath, int pPos) {
            super(pPath, pPos);
        }

        private DefaultPathIterator(ARGPath pPath) {
            super(pPath, 0);
        }

        @Override
        public void advance() throws IllegalStateException {
            Preconditions.checkState((boolean)this.hasNext(), (Object)"No more states in PathIterator.");
            ++this.pos;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.path.states.size() - 1;
        }
    }

    public static final class PathPosition {
        private final int pos;
        private final ARGPath path;

        private PathPosition(ARGPath pPath, int pPosition) {
            this.path = pPath;
            this.pos = pPosition;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.path.hashCode();
            result = 31 * result + this.pos;
            return result;
        }

        public boolean equals(Object pObj) {
            if (!(pObj instanceof PathPosition)) {
                return false;
            }
            PathPosition other = (PathPosition)pObj;
            return this.pos == other.pos && this.path.equals(other.path);
        }

        public PathIterator iterator() {
            return new DefaultPathIterator(this.path, this.pos);
        }

        public PathIterator reverseIterator() {
            return new ReversePathIterator(this.path, this.pos);
        }

        public CFANode getLocation() {
            return this.iterator().getLocation();
        }

        public ARGPath getPath() {
            return this.path;
        }
    }

    public static abstract class PathIterator {
        protected int pos;
        protected final ARGPath path;

        private PathIterator(ARGPath pPath, int pPos) {
            this.path = pPath;
            this.pos = pPos;
        }

        public abstract boolean hasNext();

        public int getIndex() {
            return this.pos;
        }

        public PathPosition getPosition() {
            return new PathPosition(this.path, this.getIndex());
        }

        public abstract void advance() throws IllegalStateException;

        public ARGState getAbstractState() {
            return (ARGState)this.path.states.get(this.pos);
        }

        public CFANode getLocation() {
            return AbstractStates.extractLocation(this.getAbstractState());
        }

        @Nullable
        public CFAEdge getIncomingEdge() {
            Preconditions.checkState((this.pos > 0 ? 1 : 0) != 0, (Object)"First state in ARGPath has no incoming edge.");
            return (CFAEdge)this.path.edges.get(this.pos - 1);
        }

        @Nullable
        public CFAEdge getOutgoingEdge() {
            Preconditions.checkState((boolean)this.hasNext(), (Object)"Last state in ARGPath has no outgoing edge.");
            return (CFAEdge)this.path.edges.get(this.pos);
        }
    }
}

