/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAddressOfLabelExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.SourceLocationMapper;
import org.sosy_lab.cpachecker.util.automaton.AutomatonGraphmlCommon;
import org.w3c.dom.Element;

@Options(prefix="cpa.arg.witness")
public class ARGPathExport {
    @Option(secure=true, description="Verification witness: Include function calls and function returns?")
    boolean exportFunctionCallsAndReturns = true;
    @Option(secure=true, description="Verification witness: Include assumptions (C statements)?")
    boolean exportAssumptions = true;
    @Option(secure=true, description="Verification witness: Include the considered case of an assume?")
    boolean exportAssumeCaseInfo = true;
    @Option(secure=true, description="Verification witness: Include the (starting) line numbers of the operations on the transitions?")
    boolean exportLineNumbers = true;
    @Option(secure=true, description="Verification witness: Include the sourcecode of the operations?")
    boolean exportSourcecode = true;
    @Option(secure=true, description="Verification witness: Include the offset within the file?")
    boolean exportOffset = true;

    public ARGPathExport(Configuration pConfig) throws InvalidConfigurationException {
        Preconditions.checkNotNull((Object)pConfig);
        pConfig.inject((Object)this);
    }

    private String getStateIdent(ARGState pState) {
        return this.getStateIdent(pState, "");
    }

    private String getStateIdent(ARGState pState, String pIdentPostfix) {
        return String.format("A%d%s", pState.getStateId(), pIdentPostfix);
    }

    private String getPseudoStateIdent(ARGState pState, int pSubStateNo, int pSubStateCount) {
        return this.getStateIdent(pState, String.format("_%d_%d", pSubStateNo, pSubStateCount));
    }

    public void writePath(Appendable pTarget, ARGState pRootState, Function<? super ARGState, ? extends Iterable<ARGState>> pSuccessorFunction, Predicate<? super ARGState> pPathElements, CounterexampleInfo pCounterExample) throws IOException {
        String defaultFileName = this.getInitialFileName(pRootState);
        WitnessWriter writer = new WitnessWriter(defaultFileName);
        writer.writePath(pTarget, pRootState, pSuccessorFunction, pPathElements, pCounterExample);
    }

    private String getInitialFileName(ARGState pRootState) {
        CFANode initialLoc = AbstractStates.extractLocation(pRootState);
        ArrayDeque worklist = Queues.newArrayDeque();
        worklist.push(initialLoc);
        while (!worklist.isEmpty()) {
            CFANode l = (CFANode)worklist.pop();
            for (CFAEdge e : CFAUtils.leavingEdges(l)) {
                String fileName;
                Set<FileLocation> fileLocations = SourceLocationMapper.getFileLocationsFromCfaEdge(e);
                if (fileLocations.size() > 0 && (fileName = fileLocations.iterator().next().getFileName()) != null) {
                    return fileName;
                }
                worklist.push(e.getSuccessor());
            }
        }
        throw new RuntimeException("Could not determine file name based on abstract state!");
    }

    private static class AssignsParameterOfOtherFunction
    implements Predicate<AExpressionStatement> {
        private final CFAEdge edge;
        private final String qualifier;

        public AssignsParameterOfOtherFunction(CFAEdge pEdge) {
            this.edge = pEdge;
            String currentFunctionName = pEdge.getPredecessor().getFunctionName();
            this.qualifier = Strings.isNullOrEmpty((String)currentFunctionName) ? "" : currentFunctionName + "::";
        }

        public boolean apply(AExpressionStatement pArg0) {
            AExpression exp = pArg0.getExpression();
            if (!(exp instanceof CExpression)) {
                return false;
            }
            CExpression cExp = (CExpression)exp;
            return cExp.accept(new CExpressionVisitor<Boolean, RuntimeException>(){

                @Override
                public Boolean visit(CArraySubscriptExpression pIastArraySubscriptExpression) {
                    return pIastArraySubscriptExpression.getArrayExpression().accept(this) != false && pIastArraySubscriptExpression.getSubscriptExpression().accept(this) != false;
                }

                @Override
                public Boolean visit(CFieldReference pIastFieldReference) {
                    return pIastFieldReference.getFieldOwner().accept(this);
                }

                @Override
                public Boolean visit(CIdExpression pIastIdExpression) {
                    CSimpleDeclaration declaration = pIastIdExpression.getDeclaration();
                    if (declaration instanceof CParameterDeclaration && AssignsParameterOfOtherFunction.this.edge instanceof FunctionCallEdge) {
                        return declaration.getQualifiedName().startsWith(AssignsParameterOfOtherFunction.this.qualifier);
                    }
                    return true;
                }

                @Override
                public Boolean visit(CPointerExpression pPointerExpression) {
                    return pPointerExpression.getOperand().accept(this);
                }

                @Override
                public Boolean visit(CComplexCastExpression pComplexCastExpression) {
                    return pComplexCastExpression.getOperand().accept(this);
                }

                @Override
                public Boolean visit(CBinaryExpression pIastBinaryExpression) {
                    return pIastBinaryExpression.getOperand1().accept(this) != false && pIastBinaryExpression.getOperand2().accept(this) != false;
                }

                @Override
                public Boolean visit(CCastExpression pIastCastExpression) {
                    return pIastCastExpression.getOperand().accept(this);
                }

                @Override
                public Boolean visit(CCharLiteralExpression pIastCharLiteralExpression) {
                    return true;
                }

                @Override
                public Boolean visit(CFloatLiteralExpression pIastFloatLiteralExpression) {
                    return true;
                }

                @Override
                public Boolean visit(CIntegerLiteralExpression pIastIntegerLiteralExpression) {
                    return true;
                }

                @Override
                public Boolean visit(CStringLiteralExpression pIastStringLiteralExpression) {
                    return true;
                }

                @Override
                public Boolean visit(CTypeIdExpression pIastTypeIdExpression) {
                    return true;
                }

                @Override
                public Boolean visit(CUnaryExpression pIastUnaryExpression) {
                    return pIastUnaryExpression.getOperand().accept(this);
                }

                @Override
                public Boolean visit(CImaginaryLiteralExpression pIastLiteralExpression) {
                    return pIastLiteralExpression.getValue().accept(this);
                }

                @Override
                public Boolean visit(CAddressOfLabelExpression pAddressOfLabelExpression) {
                    return true;
                }
            });
        }
    }

    private static class DelayedAssignmentsKey {
        private final String from;
        private final CFAEdge edge;
        private final ARGState state;

        public DelayedAssignmentsKey(String pFrom, CFAEdge pEdge, ARGState pState) {
            this.from = pFrom;
            this.edge = pEdge;
            this.state = pState;
        }

        public int hashCode() {
            return Objects.hash(this.from, this.edge, this.state);
        }

        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (pObj instanceof DelayedAssignmentsKey) {
                DelayedAssignmentsKey other = (DelayedAssignmentsKey)pObj;
                return Objects.equals(this.from, other.from) && Objects.equals(this.edge, other.edge) && Objects.equals(this.state, other.state);
            }
            return false;
        }
    }

    private class WitnessWriter {
        private final Multimap<String, AggregatedEdge> sourceToTargetMap = HashMultimap.create();
        private final Multimap<String, AggregatedEdge> targetToSourceMap = HashMultimap.create();
        private final Multimap<String, AutomatonGraphmlCommon.NodeFlag> nodeFlags = HashMultimap.create();
        private final Map<String, Element> delayedNodes = Maps.newHashMap();
        private final Map<DelayedAssignmentsKey, CFAEdgeWithAssumptions> delayedAssignments = Maps.newHashMap();
        private final String defaultSourcefileName;

        public WitnessWriter(String pDefaultSourcefileName) {
            this.defaultSourcefileName = pDefaultSourcefileName;
        }

        private boolean isNodeRepresentingOneOf(Collection<AggregatedEdge> pTargets, String pNodeId) {
            for (AggregatedEdge t : pTargets) {
                if (!t.targetRepresentedBy.equals(pNodeId)) continue;
                return true;
            }
            return false;
        }

        private boolean containsRestrictedEdgeTo(Collection<AggregatedEdge> pTargets, String pNodeId) {
            for (AggregatedEdge t : pTargets) {
                if (!t.targetRepresentedBy.equals(pNodeId) || !t.condition.hasTransitionRestrictions()) continue;
                return true;
            }
            return false;
        }

        private void appendNewPathNode(AutomatonGraphmlCommon.GraphMlBuilder pDoc, String pNodeId) throws IOException {
            Element result = pDoc.createNodeElement(pNodeId, AutomatonGraphmlCommon.NodeType.ONPATH);
            for (AutomatonGraphmlCommon.NodeFlag f : this.nodeFlags.get((Object)pNodeId)) {
                pDoc.addDataElementChild(result, f.key, "true");
            }
            Collection existingEdgesTo = this.targetToSourceMap.get((Object)pNodeId);
            if (this.containsRestrictedEdgeTo(existingEdgesTo, pNodeId)) {
                pDoc.appendToAppendable(result);
            } else {
                this.delayedNodes.put(pNodeId, result);
            }
        }

        private void appendDelayedNode(AutomatonGraphmlCommon.GraphMlBuilder pDoc, String pNodeId) {
            Element e = this.delayedNodes.get(pNodeId);
            if (e != null) {
                this.delayedNodes.remove(pNodeId);
                pDoc.appendToAppendable(e);
            }
        }

        private void appendNewEdge(AutomatonGraphmlCommon.GraphMlBuilder pDoc, String pFrom, String pTo, CFAEdge pEdge, ARGState pFromState, Map<ARGState, CFAEdgeWithAssumptions> pValueMap) throws IOException {
            TransitionCondition desc = this.constructTransitionCondition(pFrom, pTo, pEdge, pFromState, pValueMap);
            if (!this.nodeFlags.containsKey((Object)pTo) && this.aggregateToPrevEdge(pFrom, pTo, desc)) {
                return;
            }
            Collection edgesToTheSourceNode = this.targetToSourceMap.get((Object)pFrom);
            if (edgesToTheSourceNode.size() == 1) {
                AggregatedEdge aggregationEdge = (AggregatedEdge)edgesToTheSourceNode.iterator().next();
                pFrom = aggregationEdge.targetRepresentedBy;
                if (!aggregationEdge.condition.hasTransitionRestrictions()) {
                    pFrom = aggregationEdge.source;
                }
            }
            if (desc.hasTransitionRestrictions()) {
                this.appendDelayedNode(pDoc, pFrom);
                this.appendDelayedNode(pDoc, pTo);
                Element result = pDoc.createEdgeElement(pFrom, pTo);
                for (AutomatonGraphmlCommon.KeyDef k : desc.keyValues.keySet()) {
                    pDoc.addDataElementChild(result, k, desc.keyValues.get((Object)k));
                }
                pDoc.appendToAppendable(result);
            }
            AggregatedEdge t = new AggregatedEdge(pFrom, pTo, desc);
            this.sourceToTargetMap.put((Object)pFrom, (Object)t);
            this.targetToSourceMap.put((Object)pTo, (Object)t);
        }

        private boolean aggregateToPrevEdge(String pFrom, String pTo, TransitionCondition pDesc) {
            Collection edgesToTheSourceNode = this.targetToSourceMap.get((Object)pFrom);
            if (edgesToTheSourceNode.size() == 1) {
                AggregatedEdge aggregationEdge = (AggregatedEdge)edgesToTheSourceNode.iterator().next();
                if (aggregationEdge.condition.equals(pDesc)) {
                    aggregationEdge.aggregatesTargets.add(pTo);
                    this.targetToSourceMap.put((Object)pTo, (Object)aggregationEdge);
                    return true;
                }
            }
            return false;
        }

        private TransitionCondition constructTransitionCondition(String pFrom, String pTo, CFAEdge pEdge, ARGState pFromState, Map<ARGState, CFAEdgeWithAssumptions> pValueMap) {
            FileLocation l;
            Set<FileLocation> locations;
            AssumeEdge a;
            TransitionCondition result = new TransitionCondition();
            if (AutomatonGraphmlCommon.handleAsEpsilonEdge(pEdge)) {
                return result;
            }
            if (ARGPathExport.this.exportFunctionCallsAndReturns) {
                if (pEdge.getSuccessor() instanceof FunctionEntryNode) {
                    FunctionEntryNode in = (FunctionEntryNode)pEdge.getSuccessor();
                    result.put(AutomatonGraphmlCommon.KeyDef.FUNCTIONENTRY, in.getFunctionName());
                } else if (pEdge.getSuccessor() instanceof FunctionExitNode) {
                    FunctionExitNode out = (FunctionExitNode)pEdge.getSuccessor();
                    result.put(AutomatonGraphmlCommon.KeyDef.FUNCTIONEXIT, out.getFunctionName());
                }
            }
            if (ARGPathExport.this.exportAssumptions && pFromState != null) {
                DelayedAssignmentsKey key = new DelayedAssignmentsKey(pFrom, pEdge, pFromState);
                CFAEdgeWithAssumptions cfaEdgeWithAssignments = this.delayedAssignments.get(key);
                if (pValueMap != null && pValueMap.containsKey(pFromState)) {
                    CFAEdgeWithAssumptions currentEdgeWithAssignments = pValueMap.get(pFromState);
                    if (cfaEdgeWithAssignments == null) {
                        cfaEdgeWithAssignments = currentEdgeWithAssignments;
                    } else {
                        ImmutableList.Builder allAssignments = ImmutableList.builder();
                        allAssignments.addAll(cfaEdgeWithAssignments.getExpStmts());
                        allAssignments.addAll(currentEdgeWithAssignments.getExpStmts());
                        cfaEdgeWithAssignments = new CFAEdgeWithAssumptions(pEdge, (List<AExpressionStatement>)allAssignments.build(), currentEdgeWithAssignments.getComment());
                    }
                }
                if (cfaEdgeWithAssignments != null) {
                    String code;
                    List<AExpressionStatement> assignments = cfaEdgeWithAssignments.getExpStmts();
                    AssignsParameterOfOtherFunction assignsParameterOfOtherFunction = new AssignsParameterOfOtherFunction(pEdge);
                    ImmutableList functionValidAssignments = FluentIterable.from(assignments).filter((Predicate)assignsParameterOfOtherFunction).toList();
                    if (functionValidAssignments.size() < assignments.size()) {
                        cfaEdgeWithAssignments = new CFAEdgeWithAssumptions(pEdge, (List<AExpressionStatement>)functionValidAssignments, cfaEdgeWithAssignments.getComment());
                        FluentIterable<CFAEdge> nextEdges = CFAUtils.leavingEdges(pEdge.getSuccessor());
                        if (nextEdges.size() == 1 && pFromState.getChildren().size() == 1) {
                            String keyFrom = pTo;
                            CFAEdge keyEdge = (CFAEdge)Iterables.getOnlyElement(nextEdges);
                            ARGState keyState = (ARGState)Iterables.getOnlyElement(pFromState.getChildren());
                            ImmutableList valueAssignments = FluentIterable.from(assignments).filter(Predicates.not((Predicate)assignsParameterOfOtherFunction)).toList();
                            CFAEdgeWithAssumptions valueCFAEdgeWithAssignments = new CFAEdgeWithAssumptions(keyEdge, (List<AExpressionStatement>)valueAssignments, "");
                            this.delayedAssignments.put(new DelayedAssignmentsKey(keyFrom, keyEdge, keyState), valueCFAEdgeWithAssignments);
                        }
                    }
                    if (!(code = cfaEdgeWithAssignments.getAsCode()).isEmpty()) {
                        result.put(AutomatonGraphmlCommon.KeyDef.ASSUMPTION, code);
                    }
                }
            }
            if (ARGPathExport.this.exportAssumeCaseInfo && pEdge instanceof AssumeEdge && !(a = (AssumeEdge)pEdge).getTruthAssumption()) {
                result.put(AutomatonGraphmlCommon.KeyDef.NEGATIVECASE, "true");
            }
            if (ARGPathExport.this.exportLineNumbers && (locations = SourceLocationMapper.getFileLocationsFromCfaEdge(pEdge)).size() > 0) {
                l = locations.iterator().next();
                if (!l.getFileName().equals(this.defaultSourcefileName)) {
                    result.put(AutomatonGraphmlCommon.KeyDef.ORIGINFILE, l.getFileName());
                }
                result.put(AutomatonGraphmlCommon.KeyDef.ORIGINLINE, Integer.toString(l.getStartingLineInOrigin()));
            }
            if (ARGPathExport.this.exportOffset && (locations = SourceLocationMapper.getFileLocationsFromCfaEdge(pEdge)).size() > 0) {
                l = locations.iterator().next();
                if (!l.getFileName().equals(this.defaultSourcefileName)) {
                    result.put(AutomatonGraphmlCommon.KeyDef.ORIGINFILE, l.getFileName());
                }
                result.put(AutomatonGraphmlCommon.KeyDef.OFFSET, Integer.toString(l.getNodeOffset()));
            }
            if (ARGPathExport.this.exportSourcecode) {
                result.put(AutomatonGraphmlCommon.KeyDef.SOURCECODE, pEdge.getRawStatement());
            }
            return result;
        }

        private void appendKeyDefinitions(AutomatonGraphmlCommon.GraphMlBuilder pDoc, AutomatonGraphmlCommon.GraphType pGraphType) {
            if (pGraphType == AutomatonGraphmlCommon.GraphType.CONDITION) {
                pDoc.appendNewKeyDef(AutomatonGraphmlCommon.KeyDef.INVARIANT, null);
                pDoc.appendNewKeyDef(AutomatonGraphmlCommon.KeyDef.NAMED, null);
            }
            pDoc.appendNewKeyDef(AutomatonGraphmlCommon.KeyDef.ASSUMPTION, null);
            pDoc.appendNewKeyDef(AutomatonGraphmlCommon.KeyDef.SOURCECODE, null);
            pDoc.appendNewKeyDef(AutomatonGraphmlCommon.KeyDef.SOURCECODELANGUAGE, null);
            pDoc.appendNewKeyDef(AutomatonGraphmlCommon.KeyDef.NEGATIVECASE, "false");
            pDoc.appendNewKeyDef(AutomatonGraphmlCommon.KeyDef.ORIGINLINE, null);
            pDoc.appendNewKeyDef(AutomatonGraphmlCommon.KeyDef.ORIGINFILE, this.defaultSourcefileName);
            pDoc.appendNewKeyDef(AutomatonGraphmlCommon.KeyDef.NODETYPE, AutomatonGraphmlCommon.defaultNodeType.text);
            for (AutomatonGraphmlCommon.NodeFlag f : AutomatonGraphmlCommon.NodeFlag.values()) {
                pDoc.appendNewKeyDef(f.key, "false");
            }
            pDoc.appendNewKeyDef(AutomatonGraphmlCommon.KeyDef.FUNCTIONENTRY, null);
            pDoc.appendNewKeyDef(AutomatonGraphmlCommon.KeyDef.FUNCTIONEXIT, null);
        }

        public void writePath(Appendable pTarget, ARGState pRootState, Function<? super ARGState, ? extends Iterable<ARGState>> pSuccessorFunction, Predicate<? super ARGState> pPathStates, CounterexampleInfo pCounterExample) throws IOException {
            ARGState s;
            AutomatonGraphmlCommon.GraphMlBuilder doc;
            Model model;
            CFAPathWithAssumptions cfaPath;
            Map<ARGState, CFAEdgeWithAssumptions> valueMap = null;
            if (pCounterExample != null && (cfaPath = (model = pCounterExample.getTargetPathModel()).getCFAPathWithAssignments()) != null) {
                ARGPath targetPath = pCounterExample.getTargetPath();
                valueMap = model.getExactVariableValues(targetPath);
            }
            HashSet<ARGState> processed = new HashSet<ARGState>();
            AutomatonGraphmlCommon.GraphType graphType = AutomatonGraphmlCommon.GraphType.PROGRAMPATH;
            try {
                doc = new AutomatonGraphmlCommon.GraphMlBuilder(pTarget);
            }
            catch (ParserConfigurationException e) {
                throw new IOException(e);
            }
            String entryStateNodeId = ARGPathExport.this.getStateIdent(pRootState);
            boolean containsSinkNode = false;
            int multiEdgeCount = 0;
            doc.appendDocHeader();
            this.appendKeyDefinitions(doc, graphType);
            doc.appendGraphHeader(graphType, "C");
            ArrayDeque<ARGState> worklist = new ArrayDeque<ARGState>();
            worklist.add(pRootState);
            while (!worklist.isEmpty()) {
                s = (ARGState)worklist.removeLast();
                if (!processed.add(s)) continue;
                String sourceStateNodeId = ARGPathExport.this.getStateIdent(s);
                EnumSet<AutomatonGraphmlCommon.NodeFlag> sourceNodeFlags = EnumSet.noneOf(AutomatonGraphmlCommon.NodeFlag.class);
                if (sourceStateNodeId.equals(entryStateNodeId)) {
                    sourceNodeFlags = EnumSet.of(AutomatonGraphmlCommon.NodeFlag.ISENTRY);
                }
                if (s.isTarget()) {
                    sourceNodeFlags.add(AutomatonGraphmlCommon.NodeFlag.ISVIOLATION);
                }
                this.nodeFlags.putAll((Object)sourceStateNodeId, sourceNodeFlags);
                for (ARGState child : (Iterable)pSuccessorFunction.apply((Object)s)) {
                    if (child.isCovered()) {
                        child = child.getCoveringState();
                        assert (!child.isCovered());
                    }
                    boolean isEdgeOnPath = true;
                    if (!s.getChildren().contains(child)) continue;
                    if (isEdgeOnPath) {
                        worklist.add(child);
                        continue;
                    }
                    containsSinkNode = true;
                }
            }
            if (containsSinkNode) {
                this.nodeFlags.put((Object)"sink", (Object)AutomatonGraphmlCommon.NodeFlag.ISSINKNODE);
                this.appendNewPathNode(doc, "sink");
                this.appendDelayedNode(doc, "sink");
            }
            worklist.add(pRootState);
            processed.clear();
            while (!worklist.isEmpty()) {
                s = (ARGState)worklist.removeLast();
                if (!pPathStates.apply((Object)s) || !processed.add(s)) continue;
                CFANode loc = AbstractStates.extractLocation(s);
                String sourceStateNodeId = ARGPathExport.this.getStateIdent(s);
                this.appendNewPathNode(doc, sourceStateNodeId);
                for (ARGState child : (Iterable)pSuccessorFunction.apply((Object)s)) {
                    if (child.isCovered()) {
                        child = child.getCoveringState();
                        assert (!child.isCovered());
                    }
                    String childStateId = ARGPathExport.this.getStateIdent(child);
                    CFANode childLoc = AbstractStates.extractLocation(child);
                    CFAEdge edgeToNextState = loc.getEdgeTo(childLoc);
                    String prevStateId = sourceStateNodeId;
                    if (edgeToNextState instanceof MultiEdge) {
                        ++multiEdgeCount;
                        ImmutableList<CFAEdge> edges = ((MultiEdge)edgeToNextState).getEdges();
                        for (int i = 0; i < edges.size() - 1; ++i) {
                            CFAEdge innerEdge = (CFAEdge)edges.get(i);
                            String pseudoStateId = ARGPathExport.this.getPseudoStateIdent(child, i, multiEdgeCount);
                            assert (!(innerEdge instanceof AssumeEdge));
                            this.appendNewPathNode(doc, pseudoStateId);
                            this.appendNewEdge(doc, prevStateId, pseudoStateId, innerEdge, i == 0 ? s : null, valueMap);
                            prevStateId = pseudoStateId;
                        }
                        edgeToNextState = (CFAEdge)edges.get(edges.size() - 1);
                    }
                    boolean isEdgeOnPath = true;
                    if (!s.getChildren().contains(child)) continue;
                    if (isEdgeOnPath) {
                        this.appendNewEdge(doc, prevStateId, childStateId, edgeToNextState, s, valueMap);
                        worklist.add(child);
                        continue;
                    }
                    this.appendNewEdge(doc, prevStateId, "sink", edgeToNextState, s, valueMap);
                }
            }
            doc.appendFooter();
        }
    }

    private static class AggregatedEdge {
        public final String source;
        public final String targetRepresentedBy;
        public final TransitionCondition condition;
        public final Set<String> aggregatesTargets = Sets.newHashSet();

        public AggregatedEdge(String pSource, String pTargetRepresentedBy, TransitionCondition pCondition) {
            this.source = pSource;
            this.condition = pCondition;
            this.targetRepresentedBy = pTargetRepresentedBy;
            this.aggregatesTargets.add(pTargetRepresentedBy);
        }
    }

    private static class TransitionCondition {
        public final Map<AutomatonGraphmlCommon.KeyDef, String> keyValues = Maps.newHashMap();

        private TransitionCondition() {
        }

        public void put(AutomatonGraphmlCommon.KeyDef pKey, String pValue) {
            this.keyValues.put(pKey, pValue);
        }

        public boolean equals(Object pOther) {
            if (!(pOther instanceof TransitionCondition)) {
                return false;
            }
            TransitionCondition oT = (TransitionCondition)pOther;
            return this.keyValues.equals(oT.keyValues);
        }

        public boolean hasTransitionRestrictions() {
            return !this.keyValues.isEmpty();
        }

        public int hashCode() {
            return this.keyValues.hashCode();
        }
    }
}

