/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSetView;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.PredicatedAnalysisPropertyViolationException;

public class ARGPrecisionAdjustment
implements PrecisionAdjustment {
    private final PrecisionAdjustment wrappedPrecAdjustment;
    protected final boolean inPredicatedAnalysis;

    public ARGPrecisionAdjustment(PrecisionAdjustment pWrappedPrecAdjustment, boolean pInPredicatedAnalysis) {
        this.wrappedPrecAdjustment = pWrappedPrecAdjustment;
        this.inPredicatedAnalysis = pInPredicatedAnalysis;
    }

    @Override
    public PrecisionAdjustment.PrecisionAdjustmentResult prec(AbstractState pElement, Precision oldPrecision, UnmodifiableReachedSet pElements, AbstractState fullState) throws CPAException, InterruptedException {
        Preconditions.checkArgument((boolean)(pElement instanceof ARGState));
        ARGState element = (ARGState)pElement;
        if (this.inPredicatedAnalysis && element.isTarget()) {
            throw new PredicatedAnalysisPropertyViolationException("Property violated during successor computation", element, false);
        }
        UnmodifiableReachedSetView elements = new UnmodifiableReachedSetView(pElements, ARGState.getUnwrapFunction(), (Function<? super Precision, Precision>)Functions.identity());
        AbstractState oldElement = element.getWrappedState();
        PrecisionAdjustment.PrecisionAdjustmentResult unwrappedResult = this.wrappedPrecAdjustment.prec(oldElement, oldPrecision, elements, fullState);
        if (unwrappedResult.action() == PrecisionAdjustment.Action.BREAK && this.elementHasSiblings(element)) {
            this.removeUnreachedSiblingsFromARG(element, pElements);
        }
        AbstractState newElement = unwrappedResult.abstractState();
        Precision newPrecision = unwrappedResult.precision();
        PrecisionAdjustment.Action action = unwrappedResult.action();
        if (oldElement == newElement && oldPrecision == newPrecision) {
            return PrecisionAdjustment.PrecisionAdjustmentResult.create(pElement, oldPrecision, action);
        }
        ARGState resultElement = new ARGState(newElement, null);
        element.replaceInARGWith(resultElement);
        return PrecisionAdjustment.PrecisionAdjustmentResult.create(resultElement, newPrecision, action);
    }

    private void removeUnreachedSiblingsFromARG(ARGState element, UnmodifiableReachedSet pReachedSet) {
        HashSet<ARGState> scheduledForDeletion = new HashSet<ARGState>();
        for (ARGState sibling : ((ARGState)Iterables.getOnlyElement(element.getParents())).getChildren()) {
            if (sibling == element || pReachedSet.contains(sibling)) continue;
            scheduledForDeletion.add(sibling);
        }
        for (ARGState sibling : scheduledForDeletion) {
            sibling.removeFromARG();
        }
    }

    private boolean elementHasSiblings(ARGState element) {
        return ((ARGState)Iterables.getOnlyElement(element.getParents())).getChildren().size() > 1;
    }
}

