/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSetWrapper;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGToDotWriter;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.Precisions;

public class ARGReachedSet {
    private final int refinementNumber;
    private final ARGCPA cpa;
    private final ReachedSet mReached;
    private final UnmodifiableReachedSet mUnmodifiableReached;

    public ARGReachedSet(ReachedSet pReached) {
        this(pReached, null);
    }

    public ARGReachedSet(ReachedSet pReached, ARGCPA pCpa) {
        this(pReached, pCpa, -1);
    }

    public ARGReachedSet(ReachedSet pReached, ARGCPA pCpa, int pRefinementNumber) {
        this.mReached = (ReachedSet)Preconditions.checkNotNull((Object)pReached);
        this.mUnmodifiableReached = new UnmodifiableReachedSetWrapper(this.mReached);
        this.cpa = pCpa;
        this.refinementNumber = pRefinementNumber;
    }

    public UnmodifiableReachedSet asReachedSet() {
        return this.mUnmodifiableReached;
    }

    public void removeSubtree(ARGState e) {
        Set<ARGState> toWaitlist = this.removeSubtree0(e);
        for (ARGState ae : toWaitlist) {
            this.mReached.reAddToWaitlist(ae);
        }
    }

    public void removeSubtree(ARGState e, Precision p, Predicate<? super Precision> pPrecisionType) {
        for (ARGState ae : this.removeSubtree0(e)) {
            this.mReached.updatePrecision(ae, this.adaptPrecision(this.mReached.getPrecision(ae), p, pPrecisionType));
            this.mReached.reAddToWaitlist(ae);
        }
    }

    public void removeSubtree(ARGState e, List<Precision> precisions, List<Predicate<? super Precision>> precisionTypes) {
        Preconditions.checkArgument((precisions.size() == precisionTypes.size() ? 1 : 0) != 0);
        Set<ARGState> toWaitlist = this.removeSubtree0(e);
        for (ARGState ae : toWaitlist) {
            Precision prec = this.mReached.getPrecision(ae);
            for (int i = 0; i < precisions.size(); ++i) {
                prec = this.adaptPrecision(prec, precisions.get(i), precisionTypes.get(i));
            }
            this.mReached.updatePrecision(ae, prec);
            this.mReached.reAddToWaitlist(ae);
        }
    }

    public void removeInfeasiblePartofARG(ARGState rootOfInfeasiblePart) {
        Set<ARGState> infeasibleSubtree = rootOfInfeasiblePart.getSubgraph();
        for (ARGState removedNode : infeasibleSubtree) {
            this.removeCoverageOf(removedNode);
        }
        ImmutableSet parentsOfRoot = ImmutableSet.copyOf(rootOfInfeasiblePart.getParents());
        SortedSet<ARGState> parentsOfRemovedStates = this.removeSet(infeasibleSubtree);
        assert (parentsOfRoot.equals(parentsOfRemovedStates));
    }

    public void cutOffSubtree(ARGState argState) {
        this.mReached.removeAll(argState.getSubgraph());
    }

    public void readdToWaitlist(ARGState state, Precision precision, Predicate<? super Precision> pPrecisionType) {
        this.mReached.updatePrecision(state, this.adaptPrecision(this.mReached.getPrecision(state), precision, pPrecisionType));
        this.mReached.reAddToWaitlist(state);
    }

    public void updatePrecisionGlobally(Precision pNewPrecision, Predicate<? super Precision> pPrecisionType) {
        IdentityHashMap precisionUpdateCache = Maps.newIdentityHashMap();
        for (AbstractState s : this.mReached) {
            Precision oldPrecision = this.mReached.getPrecision(s);
            Precision newPrecision = (Precision)precisionUpdateCache.get(oldPrecision);
            if (newPrecision == null) {
                newPrecision = this.adaptPrecision(oldPrecision, pNewPrecision, pPrecisionType);
                precisionUpdateCache.put(oldPrecision, newPrecision);
            }
            this.mReached.updatePrecision(s, newPrecision);
        }
    }

    private Precision adaptPrecision(Precision pOldPrecision, Precision pNewPrecision, Predicate<? super Precision> pPrecisionType) {
        return Precisions.replaceByType(pOldPrecision, pNewPrecision, pPrecisionType);
    }

    private Set<ARGState> removeSubtree0(ARGState e) {
        Preconditions.checkNotNull((Object)e);
        Preconditions.checkArgument((!e.getParents().isEmpty() ? 1 : 0) != 0, (Object)"May not remove the initial element from the ARG/reached set");
        this.dumpSubgraph(e);
        Set<ARGState> toUnreach = e.getSubgraph();
        ArrayList<ARGState> newToUnreach = new ArrayList<ARGState>();
        for (ARGState ae : toUnreach) {
            newToUnreach.addAll(ae.getCoveredByThis());
        }
        toUnreach.addAll(newToUnreach);
        SortedSet<ARGState> toWaitlist = this.removeSet(toUnreach);
        return toWaitlist;
    }

    private void dumpSubgraph(ARGState e) {
        if (this.cpa == null) {
            return;
        }
        ARGToDotWriter refinementGraph = this.cpa.getRefinementGraphWriter();
        if (refinementGraph == null) {
            return;
        }
        SetMultimap<ARGState, ARGState> successors = ARGUtils.projectARG(e, ARGUtils.CHILDREN_OF_STATE, ARGUtils.RELEVANT_STATE);
        SetMultimap<ARGState, ARGState> predecessors = ARGUtils.projectARG(e, ARGUtils.PARENTS_OF_STATE, ARGUtils.RELEVANT_STATE);
        try {
            refinementGraph.enterSubgraph("cluster_" + this.refinementNumber, "Refinement " + this.refinementNumber);
            refinementGraph.writeSubgraph(e, (Function<? super ARGState, ? extends Iterable<ARGState>>)Functions.forMap((Map)successors.asMap(), (Object)ImmutableSet.of()), (Predicate<? super ARGState>)Predicates.alwaysTrue(), (Predicate<? super Pair<ARGState, ARGState>>)Predicates.alwaysFalse());
            refinementGraph.leaveSubgraph();
            for (ARGState predecessor : predecessors.get((Object)e)) {
                refinementGraph.writeEdge(predecessor, e);
            }
        }
        catch (IOException ex) {
            this.cpa.getLogger().logUserException(Level.WARNING, (Throwable)ex, "Could not write refinement graph to file");
        }
    }

    private SortedSet<ARGState> removeSet(Set<ARGState> elements) {
        if (this.cpa != null) {
            this.cpa.clearCounterexamples(elements);
        }
        this.mReached.removeAll(elements);
        TreeSet<ARGState> toWaitlist = new TreeSet<ARGState>();
        for (ARGState ae : elements) {
            for (ARGState parent : ae.getParents()) {
                if (elements.contains(parent)) continue;
                toWaitlist.add(parent);
            }
            ae.removeFromARG();
        }
        return toWaitlist;
    }

    public void removeCoverageOf(ARGState v) {
        for (ARGState coveredByChildOfV : ImmutableList.copyOf(v.getCoveredByThis())) {
            this.uncover(coveredByChildOfV);
        }
        assert (v.getCoveredByThis().isEmpty());
    }

    private void uncover(ARGState element) {
        element.uncover();
        Set<ARGState> uncoveredSubTree = element.getSubgraph();
        for (ARGState e : uncoveredSubTree) {
            assert (!e.isCovered());
            e.setHasCoveredParent(false);
            if (e.wasExpanded()) continue;
            this.mReached.reAddToWaitlist(e);
        }
    }

    public boolean tryToCover(ARGState v) throws CPAException, InterruptedException {
        assert (v.mayCover());
        this.cpa.getStopOperator().stop(v, this.mReached.getReached(v), this.mReached.getPrecision(v));
        if (v.isCovered()) {
            Set<ARGState> subtree = v.getSubgraph();
            subtree.remove(v);
            this.removeCoverageOf(v);
            for (ARGState childOfV : subtree) {
                this.removeCoverageOf(childOfV);
            }
            for (ARGState childOfV : subtree) {
                if (!childOfV.isCovered()) continue;
                childOfV.uncover();
            }
            for (ARGState childOfV : subtree) {
                this.mReached.removeOnlyFromWaitlist(childOfV);
                childOfV.setHasCoveredParent(true);
                assert (childOfV.getCoveredByThis().isEmpty());
                assert (!childOfV.mayCover());
            }
            this.mReached.removeOnlyFromWaitlist(v);
            return true;
        }
        return false;
    }

    public boolean tryToCover(ARGState v, boolean beUnsound) throws CPAException, InterruptedException {
        assert (v.mayCover());
        if (beUnsound) {
            this.cpa.getStopOperator().stop(v, this.mReached.getReached(v), this.mReached.getPrecision(v));
            return v.isCovered();
        }
        return this.tryToCover(v);
    }

    public static class ForwardingARGReachedSet
    extends ARGReachedSet {
        protected final ARGReachedSet delegate;

        public ForwardingARGReachedSet(ARGReachedSet pReached) {
            super(pReached.mReached);
            this.delegate = pReached;
        }

        @Override
        public UnmodifiableReachedSet asReachedSet() {
            return this.delegate.asReachedSet();
        }

        @Override
        public void removeSubtree(ARGState pE) {
            this.delegate.removeSubtree(pE);
        }

        @Override
        public void removeSubtree(ARGState pE, Precision pP, Predicate<? super Precision> pPrecisionType) {
            this.delegate.removeSubtree(pE, pP, pPrecisionType);
        }
    }
}

