/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.UniqueIdGenerator;

public class ARGState
extends AbstractSingleWrapperState
implements Comparable<ARGState>,
Graphable {
    private static final long serialVersionUID = 2608287648397165040L;
    private final Collection<ARGState> children = new ArrayList<ARGState>(1);
    private final Collection<ARGState> parents = new ArrayList<ARGState>(1);
    private ARGState mCoveredBy = null;
    private Set<ARGState> mCoveredByThis = null;
    private boolean wasExpanded = false;
    private boolean mayCover = true;
    private boolean destroyed = false;
    private boolean hasCoveredParent = false;
    private ARGState mergedWith = null;
    private final int stateId = idGenerator.getFreshId();
    private static final UniqueIdGenerator idGenerator = new UniqueIdGenerator();
    private static final Function<ARGState, Integer> TO_STATE_ID = new Function<ARGState, Integer>(){

        public Integer apply(ARGState pInput) {
            return pInput.stateId;
        }
    };

    public ARGState(@Nullable AbstractState pWrappedState, @Nullable ARGState pParentElement) {
        super(pWrappedState);
        if (pParentElement != null) {
            this.addParent(pParentElement);
        }
    }

    public Collection<ARGState> getParents() {
        return Collections.unmodifiableCollection(this.parents);
    }

    public void addParent(ARGState pOtherParent) {
        Preconditions.checkNotNull((Object)pOtherParent);
        assert (!this.destroyed) : "Don't use destroyed ARGState " + this;
        if (!this.parents.contains(pOtherParent)) {
            assert (!pOtherParent.children.contains(this));
            this.parents.add(pOtherParent);
            pOtherParent.children.add(this);
        } else assert (pOtherParent.children.contains(this));
    }

    public Collection<ARGState> getChildren() {
        assert (!this.destroyed) : "Don't use destroyed ARGState " + this;
        return Collections.unmodifiableCollection(this.children);
    }

    @Nullable
    public CFAEdge getEdgeToChild(ARGState pChild) {
        CFANode childLoc;
        CFANode currentLoc = AbstractStates.extractLocation(this);
        if (currentLoc.hasEdgeTo(childLoc = AbstractStates.extractLocation(pChild))) {
            return currentLoc.getEdgeTo(childLoc);
        }
        if (currentLoc.getLeavingSummaryEdge() != null && currentLoc.getLeavingSummaryEdge().getSuccessor().equals(childLoc)) {
            return currentLoc.getLeavingSummaryEdge();
        }
        if (childLoc.hasEdgeTo(currentLoc)) {
            return childLoc.getEdgeTo(currentLoc);
        }
        if (currentLoc.getEnteringSummaryEdge() != null && currentLoc.getEnteringSummaryEdge().getSuccessor().equals(childLoc)) {
            return currentLoc.getEnteringSummaryEdge();
        }
        return null;
    }

    public Set<ARGState> getSubgraph() {
        assert (!this.destroyed) : "Don't use destroyed ARGState " + this;
        HashSet<ARGState> result = new HashSet<ARGState>();
        ArrayDeque<ARGState> workList = new ArrayDeque<ARGState>();
        workList.add(this);
        while (!workList.isEmpty()) {
            ARGState currentElement = (ARGState)workList.removeFirst();
            if (!result.add(currentElement)) continue;
            workList.addAll(currentElement.children);
        }
        return result;
    }

    public void setCovered(@Nonnull ARGState pCoveredBy) {
        Preconditions.checkState((!this.isCovered() ? 1 : 0) != 0, (String)"Cannot cover already covered element %s", (Object[])new Object[]{this});
        Preconditions.checkNotNull((Object)pCoveredBy);
        Preconditions.checkArgument((boolean)pCoveredBy.mayCover, (String)"Trying to cover with non-covering element %s", (Object[])new Object[]{pCoveredBy});
        this.mCoveredBy = pCoveredBy;
        if (pCoveredBy.mCoveredByThis == null) {
            pCoveredBy.mCoveredByThis = new LinkedHashSet<ARGState>(2);
        }
        pCoveredBy.mCoveredByThis.add(this);
    }

    public void uncover() {
        assert (this.isCovered());
        assert (this.mCoveredBy.mCoveredByThis.contains(this));
        this.mCoveredBy.mCoveredByThis.remove(this);
        this.mCoveredBy = null;
    }

    public boolean isCovered() {
        assert (!this.destroyed) : "Don't use destroyed ARGState " + this;
        return this.mCoveredBy != null;
    }

    public ARGState getCoveringState() {
        Preconditions.checkState((boolean)this.isCovered());
        return this.mCoveredBy;
    }

    public Set<ARGState> getCoveredByThis() {
        assert (!this.destroyed) : "Don't use destroyed ARGState " + this;
        if (this.mCoveredByThis == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.mCoveredByThis);
    }

    public boolean mayCover() {
        return this.mayCover && !this.hasCoveredParent && !this.isCovered();
    }

    public void setNotCovering() {
        assert (!this.destroyed) : "Don't use destroyed ARGState " + this;
        this.mayCover = false;
    }

    void setHasCoveredParent(boolean pHasCoveredParent) {
        assert (!this.destroyed) : "Don't use destroyed ARGState " + this;
        this.hasCoveredParent = pHasCoveredParent;
    }

    void setMergedWith(ARGState pMergedWith) {
        assert (!this.destroyed) : "Don't use destroyed ARGState " + this;
        assert (this.mergedWith == null) : "Second merging of element " + this;
        this.mergedWith = pMergedWith;
    }

    public ARGState getMergedWith() {
        return this.mergedWith;
    }

    boolean wasExpanded() {
        return this.wasExpanded;
    }

    void markExpanded() {
        this.wasExpanded = true;
    }

    void deleteChild(ARGState child) {
        assert (this.children.contains(child));
        this.children.remove(child);
        child.parents.remove(this);
    }

    public int getStateId() {
        return this.stateId;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public final int compareTo(ARGState pO) {
        return Integer.compare(this.stateId, pO.stateId);
    }

    public final boolean equals(Object pObj) {
        return super.equals(pObj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public boolean isOlderThan(ARGState other) {
        return this.stateId < other.stateId;
    }

    @Override
    public boolean isTarget() {
        return !this.hasCoveredParent && !this.isCovered() && super.isTarget();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.destroyed) {
            sb.append("Destroyed ");
        }
        if (this.mCoveredBy != null) {
            sb.append("Covered ");
        }
        sb.append("ARG State (Id: ");
        sb.append(this.stateId);
        if (!this.destroyed) {
            sb.append(", Parents: ");
            sb.append(this.stateIdsOf(this.parents));
            sb.append(", Children: ");
            sb.append(this.stateIdsOf(this.children));
            if (this.mCoveredBy != null) {
                sb.append(", Covered by: ");
                sb.append(this.mCoveredBy.stateId);
            } else {
                sb.append(", Covering: ");
                sb.append(this.stateIdsOf(this.getCoveredByThis()));
            }
        }
        sb.append(") ");
        sb.append(this.getWrappedState());
        return sb.toString();
    }

    @Override
    public String toDOTLabel() {
        if (this.getWrappedState() instanceof Graphable) {
            return ((Graphable)((Object)this.getWrappedState())).toDOTLabel();
        }
        return "";
    }

    @Override
    public boolean shouldBeHighlighted() {
        if (this.getWrappedState() instanceof Graphable) {
            return ((Graphable)((Object)this.getWrappedState())).shouldBeHighlighted();
        }
        return false;
    }

    private final Iterable<Integer> stateIdsOf(Iterable<ARGState> elements) {
        return FluentIterable.from(elements).transform(TO_STATE_ID);
    }

    public void removeFromARG() {
        assert (!this.destroyed) : "Don't use destroyed ARGState " + this;
        for (ARGState child : this.children) {
            assert (child.parents.contains(this));
            child.parents.remove(this);
        }
        this.children.clear();
        for (ARGState parent : this.parents) {
            assert (parent.children.contains(this));
            parent.children.remove(this);
        }
        this.parents.clear();
        if (this.isCovered()) {
            assert (this.mCoveredBy.mCoveredByThis.contains(this));
            this.mCoveredBy.mCoveredByThis.remove(this);
            this.mCoveredBy = null;
        }
        if (this.mCoveredByThis != null) {
            for (ARGState covered : this.mCoveredByThis) {
                covered.mCoveredBy = null;
            }
            this.mCoveredByThis.clear();
            this.mCoveredByThis = null;
        }
        this.destroyed = true;
    }

    public void replaceInARGWith(ARGState replacement) {
        assert (!this.destroyed) : "Don't use destroyed ARGState " + this;
        assert (!replacement.destroyed) : "Don't use destroyed ARGState " + replacement;
        assert (!this.isCovered()) : "Not implemented: Replacement of covered element " + this;
        assert (!replacement.isCovered()) : "Cannot replace with covered element " + replacement;
        for (ARGState child : this.children) {
            assert (child.parents.contains(this)) : "Inconsistent ARG at " + this;
            child.parents.remove(this);
            child.addParent(replacement);
        }
        this.children.clear();
        for (ARGState parent : this.parents) {
            assert (parent.children.contains(this)) : "Inconsistent ARG at " + this;
            parent.children.remove(this);
            replacement.addParent(parent);
        }
        this.parents.clear();
        if (this.mCoveredByThis != null) {
            if (replacement.mCoveredByThis == null) {
                replacement.mCoveredByThis = Sets.newHashSetWithExpectedSize((int)this.mCoveredByThis.size());
            }
            for (ARGState covered : this.mCoveredByThis) {
                assert (covered.mCoveredBy == this) : "Inconsistent coverage relation at " + this;
                covered.mCoveredBy = replacement;
                replacement.mCoveredByThis.add(covered);
            }
            this.mCoveredByThis.clear();
            this.mCoveredByThis = null;
        }
        this.destroyed = true;
    }
}

