/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteStatePath;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithConcreteCex;
import org.sosy_lab.cpachecker.core.interfaces.IterationStatistics;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGToDotWriter;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.counterexamples.CEXExporter;
import org.sosy_lab.cpachecker.cpa.partitioning.PartitioningCPA;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;

@Options(prefix="cpa.arg")
public class ARGStatistics
implements IterationStatistics {
    @Option(secure=true, name="dumpAfterIteration", description="Dump all ARG related statistics files after each iteration of the CPA algorithm? (for debugging and demonstration)")
    private boolean dumpArgInEachCpaIteration = false;
    @Option(secure=true, name="export", description="export final ARG as .dot file")
    private boolean exportARG = true;
    @Option(secure=true, name="file", description="export final ARG as .dot file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path argFile = Paths.get((String)"ARG.dot", (String[])new String[0]);
    @Option(secure=true, name="simplifiedARG.file", description="export final ARG as .dot file, showing only loop heads and function entries/exits")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path simplifiedArgFile = Paths.get((String)"ARGSimplified.dot", (String[])new String[0]);
    @Option(secure=true, name="refinements.file", description="export simplified ARG that shows all refinements to .dot file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path refinementGraphFile = Paths.get((String)"ARGRefinements.dot", (String[])new String[0]);
    @Option(secure=true, name="errorPath.export", description="export error path to file, if one is found")
    private boolean exportErrorPath = true;
    private final ARGCPA cpa;
    private Writer refinementGraphUnderlyingWriter = null;
    private ARGToDotWriter refinementGraphWriter = null;
    private final CEXExporter cexExporter;

    public ARGStatistics(Configuration config, ARGCPA cpa) throws InvalidConfigurationException {
        this.cpa = cpa;
        config.inject((Object)this);
        this.cexExporter = new CEXExporter(config, cpa.getLogger());
        if (this.argFile == null && this.simplifiedArgFile == null && this.refinementGraphFile == null) {
            this.exportARG = false;
        }
    }

    ARGToDotWriter getRefinementGraphWriter() {
        if (!this.exportARG || this.refinementGraphFile == null) {
            return null;
        }
        if (this.refinementGraphWriter == null) {
            try {
                this.refinementGraphUnderlyingWriter = Files.openOutputFile((Path)this.refinementGraphFile, (FileWriteMode[])new FileWriteMode[0]);
                this.refinementGraphWriter = new ARGToDotWriter(this.refinementGraphUnderlyingWriter);
            }
            catch (IOException e) {
                if (this.refinementGraphUnderlyingWriter != null) {
                    try {
                        this.refinementGraphUnderlyingWriter.close();
                    }
                    catch (IOException innerException) {
                        e.addSuppressed(innerException);
                    }
                }
                this.cpa.getLogger().logUserException(Level.WARNING, (Throwable)e, "Could not write refinement graph to file");
                this.refinementGraphFile = null;
                this.refinementGraphUnderlyingWriter = null;
                this.refinementGraphWriter = null;
            }
        }
        assert (this.refinementGraphUnderlyingWriter == null == (this.refinementGraphWriter == null));
        return this.refinementGraphWriter;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, ReachedSet pReached) {
        if (!this.exportARG && !this.exportErrorPath) {
            assert (this.refinementGraphWriter == null);
            return;
        }
        HashSet<Pair<ARGState, ARGState>> allTargetPathEdges = new HashSet<Pair<ARGState, ARGState>>();
        int cexIndex = 0;
        for (Map.Entry<ARGState, CounterexampleInfo> cex : this.getAllCounterexamples(pReached).entrySet()) {
            this.cexExporter.exportCounterexample(cex.getKey(), cex.getValue(), cexIndex++, allTargetPathEdges, !this.cexExporter.shouldDumpErrorPathImmediately());
        }
        if (this.exportARG) {
            boolean partitionedArg = AbstractStates.extractStateByType(pReached.getFirstState(), PartitioningCPA.PartitionState.class) != null;
            Set<ARGState> rootStates = partitionedArg ? ARGUtils.getRootStates(pReached) : Collections.singleton(AbstractStates.extractStateByType(pReached.getFirstState(), ARGState.class));
            for (ARGState rootState : rootStates) {
                this.exportARG(rootState, (Predicate<Pair<ARGState, ARGState>>)Predicates.in(allTargetPathEdges));
            }
        }
    }

    private Path adjustPathNameForPartitioning(ARGState rootState, Path pPath) {
        if (pPath == null) {
            return null;
        }
        PartitioningCPA.PartitionState partyState = AbstractStates.extractStateByType(rootState, PartitioningCPA.PartitionState.class);
        if (partyState == null) {
            return pPath;
        }
        String partitionKey = partyState.getStateSpacePartition().getPartitionKey().toString();
        int sepIx = pPath.getPath().lastIndexOf(".");
        String prefix = pPath.getPath().substring(0, sepIx);
        String extension = pPath.getPath().substring(sepIx, pPath.getPath().length());
        return Paths.get((String)(prefix + "-" + partitionKey + extension), (String[])new String[0]);
    }

    private void exportARG(ARGState rootState, Predicate<Pair<ARGState, ARGState>> isTargetPathEdge) {
        Throwable throwable;
        Writer w;
        SetMultimap<ARGState, ARGState> relevantSuccessorRelation = ARGUtils.projectARG(rootState, ARGUtils.CHILDREN_OF_STATE, ARGUtils.RELEVANT_STATE);
        Function relevantSuccessorFunction = Functions.forMap((Map)relevantSuccessorRelation.asMap(), (Object)ImmutableSet.of());
        if (this.argFile != null) {
            try {
                w = Files.openOutputFile((Path)this.adjustPathNameForPartitioning(rootState, this.argFile), (FileWriteMode[])new FileWriteMode[0]);
                throwable = null;
                try {
                    ARGToDotWriter.write(w, rootState, ARGUtils.CHILDREN_OF_STATE, (Predicate<? super ARGState>)Predicates.alwaysTrue(), isTargetPathEdge);
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (w != null) {
                        if (throwable != null) {
                            try {
                                w.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            w.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                this.cpa.getLogger().logUserException(Level.WARNING, (Throwable)e, "Could not write ARG to file");
            }
        }
        if (this.simplifiedArgFile != null) {
            try {
                w = Files.openOutputFile((Path)this.adjustPathNameForPartitioning(rootState, this.simplifiedArgFile), (FileWriteMode[])new FileWriteMode[0]);
                throwable = null;
                try {
                    ARGToDotWriter.write(w, rootState, (Function<? super ARGState, ? extends Iterable<ARGState>>)relevantSuccessorFunction, (Predicate<? super ARGState>)Predicates.alwaysTrue(), (Predicate<? super Pair<ARGState, ARGState>>)Predicates.alwaysFalse());
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (w != null) {
                        if (throwable != null) {
                            try {
                                w.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            w.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                this.cpa.getLogger().logUserException(Level.WARNING, (Throwable)e, "Could not write ARG to file");
            }
        }
        assert (this.refinementGraphUnderlyingWriter == null == (this.refinementGraphWriter == null));
        if (this.refinementGraphUnderlyingWriter != null) {
            try {
                w = this.refinementGraphUnderlyingWriter;
                throwable = null;
                try {
                    this.refinementGraphWriter.writeSubgraph(rootState, (Function<? super ARGState, ? extends Iterable<ARGState>>)relevantSuccessorFunction, (Predicate<? super ARGState>)Predicates.alwaysTrue(), (Predicate<? super Pair<ARGState, ARGState>>)Predicates.alwaysFalse());
                    this.refinementGraphWriter.finish();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (w != null) {
                        if (throwable != null) {
                            try {
                                w.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            w.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                this.cpa.getLogger().logUserException(Level.WARNING, (Throwable)e, "Could not write refinement graph to file");
            }
        }
    }

    private Map<ARGState, CounterexampleInfo> getAllCounterexamples(ReachedSet pReached) {
        Map<ARGState, CounterexampleInfo> probableCounterexample = this.cpa.getCounterexamples();
        HashMap<ARGState, CounterexampleInfo> counterexamples = new HashMap<ARGState, CounterexampleInfo>();
        for (AbstractState targetState : FluentIterable.from((Iterable)pReached).filter(AbstractStates.IS_TARGET_STATE)) {
            ARGPath path;
            ARGState s = (ARGState)targetState;
            CounterexampleInfo cex = probableCounterexample.get(s);
            if (cex == null && !(path = ARGUtils.getOnePathTo(s)).getInnerEdges().contains(null)) {
                Model model = this.createModelForPath(path);
                cex = CounterexampleInfo.feasible(path, model);
            }
            if (cex == null) continue;
            counterexamples.put(s, cex);
        }
        return counterexamples;
    }

    private Model createModelForPath(ARGPath pPath) {
        FluentIterable cpas = CPAs.asIterable(this.cpa).filter(ConfigurableProgramAnalysisWithConcreteCex.class);
        CFAPathWithAssumptions result = null;
        for (ConfigurableProgramAnalysisWithConcreteCex wrappedCpa : cpas) {
            ConcreteStatePath path = wrappedCpa.createConcreteStatePath(pPath);
            CFAPathWithAssumptions cexPath = CFAPathWithAssumptions.of(path, this.cpa.getLogger(), this.cpa.getMachineModel());
            if (result != null) {
                result = result.mergePaths(cexPath);
                continue;
            }
            result = cexPath;
        }
        if (result == null) {
            return Model.empty();
        }
        return Model.empty().withAssignmentInformation(result);
    }

    @Override
    public void printIterationStatistics(PrintStream pOut, ReachedSet pReached) {
        if (this.dumpArgInEachCpaIteration) {
            this.printStatistics(pOut, CPAcheckerResult.Result.UNKNOWN, pReached);
        }
    }
}

