/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ForcedCoveringStopOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPAException;

@Options(prefix="cpa.arg")
public class ARGStopSep
implements StopOperator,
ForcedCoveringStopOperator {
    @Option(secure=true, description="whether to keep covered states in the reached set as addition to keeping them in the ARG")
    private boolean keepCoveredStatesInReached = false;
    @Option(secure=true, description="inform ARG CPA if it is run in a predicated analysis because then it mustbehave differntly during merge.")
    private boolean inPredicatedAnalysis = false;
    private final StopOperator wrappedStop;
    private final LogManager logger;

    public ARGStopSep(StopOperator pWrappedStop, LogManager pLogger, Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.wrappedStop = pWrappedStop;
        this.logger = pLogger;
    }

    @Override
    public boolean stop(AbstractState pElement, Collection<AbstractState> pReached, Precision pPrecision) throws CPAException, InterruptedException {
        ARGState argElement = (ARGState)pElement;
        assert (!argElement.isCovered()) : "Passing element to stop which is already covered: " + argElement;
        if (argElement.getMergedWith() != null) {
            ARGState mergedWith = argElement.getMergedWith();
            if (pReached.contains(mergedWith)) {
                if (this.wrappedStop.stop(argElement.getWrappedState(), Collections.singleton(mergedWith.getWrappedState()), pPrecision)) {
                    if (this.inPredicatedAnalysis) {
                        argElement.setCovered(mergedWith);
                    } else {
                        argElement.removeFromARG();
                    }
                    this.logger.log(Level.FINEST, new Object[]{"Element is covered by the element it was merged into"});
                    return true;
                }
                this.logger.log(Level.FINEST, new Object[]{"Element was merged but not covered:", pElement});
            } else {
                this.logger.log(Level.FINEST, new Object[]{"Element was merged into an element that's not in the reached set, merged-with element is", mergedWith});
            }
        }
        if (argElement.isTarget()) {
            return false;
        }
        for (AbstractState reachedState : pReached) {
            ARGState argReachedState = (ARGState)reachedState;
            if (!this.stop(argElement, argReachedState, pPrecision)) continue;
            return !this.keepCoveredStatesInReached;
        }
        return false;
    }

    private boolean stop(ARGState pElement, ARGState pReachedState, Precision pPrecision) throws CPAException, InterruptedException {
        AbstractState wrappedReachedState;
        if (!pReachedState.mayCover()) {
            return false;
        }
        if (pElement == pReachedState) {
            return false;
        }
        if (pElement.isOlderThan(pReachedState)) {
            return false;
        }
        AbstractState wrappedState = pElement.getWrappedState();
        boolean stop = this.wrappedStop.stop(wrappedState, Collections.singleton(wrappedReachedState = pReachedState.getWrappedState()), pPrecision);
        if (stop) {
            pElement.setCovered(pReachedState);
        }
        return stop;
    }

    boolean isCoveredBy(AbstractState pElement, AbstractState pOtherElement, ProofChecker wrappedProofChecker) throws CPAException, InterruptedException {
        ARGState argElement = (ARGState)pElement;
        ARGState otherArtElement = (ARGState)pOtherElement;
        AbstractState wrappedState = argElement.getWrappedState();
        AbstractState wrappedOtherElement = otherArtElement.getWrappedState();
        return wrappedProofChecker.isCoveredBy(wrappedState, wrappedOtherElement);
    }

    @Override
    public boolean isForcedCoveringPossible(AbstractState pElement, AbstractState pReachedState, Precision pPrecision) throws CPAException, InterruptedException {
        if (!(this.wrappedStop instanceof ForcedCoveringStopOperator)) {
            return false;
        }
        ARGState element = (ARGState)pElement;
        ARGState reachedState = (ARGState)pReachedState;
        if (reachedState.isCovered() || !reachedState.mayCover()) {
            return false;
        }
        if (element.isOlderThan(reachedState)) {
            return false;
        }
        return ((ForcedCoveringStopOperator)this.wrappedStop).isForcedCoveringPossible(element.getWrappedState(), reachedState.getWrappedState(), pPrecision);
    }
}

