/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.export.DOTBuilder;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class ARGToDotWriter {
    private final Appendable sb;

    ARGToDotWriter(Appendable pSb) throws IOException {
        this.sb = pSb;
        this.sb.append("digraph ARG {\n");
        this.sb.append("node [style=\"filled\" shape=\"box\" color=\"white\"]\n");
    }

    public static void write(Appendable sb, ARGState rootState, Function<? super ARGState, ? extends Iterable<ARGState>> successorFunction, Predicate<? super ARGState> displayedElements, Predicate<? super Pair<ARGState, ARGState>> highlightEdge) throws IOException {
        ARGToDotWriter toDotWriter = new ARGToDotWriter(sb);
        toDotWriter.writeSubgraph(rootState, successorFunction, displayedElements, highlightEdge);
        toDotWriter.finish();
    }

    public static void write(Appendable sb, Set<ARGState> rootStates, Multimap<ARGState, ARGState> connections, Function<? super ARGState, ? extends Iterable<ARGState>> successorFunction, Predicate<? super ARGState> displayedElements, Predicate<? super Pair<ARGState, ARGState>> highlightEdge) throws IOException {
        ARGToDotWriter toDotWriter = new ARGToDotWriter(sb);
        for (ARGState rootState : rootStates) {
            toDotWriter.enterSubgraph("cluster_" + rootState.getStateId(), "reachedset_" + rootState.getStateId());
            toDotWriter.writeSubgraph(rootState, successorFunction, displayedElements, highlightEdge);
            toDotWriter.leaveSubgraph();
        }
        for (Map.Entry connection : connections.entries()) {
            sb.append(((ARGState)connection.getKey()).getStateId() + " -> " + ((ARGState)connection.getValue()).getStateId());
            sb.append(" [color=green style=bold]\n");
        }
        toDotWriter.finish();
    }

    void writeSubgraph(ARGState rootState, Function<? super ARGState, ? extends Iterable<ARGState>> successorFunction, Predicate<? super ARGState> displayedElements, Predicate<? super Pair<ARGState, ARGState>> highlightEdge) throws IOException {
        ArrayDeque<ARGState> worklist = new ArrayDeque<ARGState>();
        HashSet<ARGState> processed = new HashSet<ARGState>();
        StringBuilder edges = new StringBuilder();
        worklist.add(rootState);
        while (!worklist.isEmpty()) {
            ARGState currentElement = (ARGState)worklist.removeLast();
            if (!displayedElements.apply((Object)currentElement) || !processed.add(currentElement)) continue;
            this.sb.append(ARGToDotWriter.determineNode(currentElement));
            this.sb.append(ARGToDotWriter.determineStateHint(currentElement));
            for (ARGState covered : currentElement.getCoveredByThis()) {
                edges.append(covered.getStateId());
                edges.append(" -> ");
                edges.append(currentElement.getStateId());
                edges.append(" [style=\"dashed\" weight=\"0\" label=\"covered by\"]\n");
            }
            for (ARGState child : (Iterable)successorFunction.apply((Object)currentElement)) {
                edges.append(ARGToDotWriter.determineEdge(highlightEdge, currentElement, child));
                worklist.add(child);
            }
        }
        this.sb.append(edges);
    }

    private static String determineEdge(Predicate<? super Pair<ARGState, ARGState>> highlightEdge, ARGState state, ARGState succesorState) {
        StringBuilder builder = new StringBuilder();
        builder.append(state.getStateId()).append(" -> ").append(succesorState.getStateId());
        builder.append(" [");
        if (state.getChildren().contains(succesorState)) {
            CFAEdge edge = state.getEdgeToChild(succesorState);
            if (edge == null) {
                builder.append("style=\"bold\" color=\"blue\" label=\"dummy edge\"");
            } else {
                boolean colored = highlightEdge.apply((Object)Pair.of((Object)state, (Object)succesorState));
                if (colored) {
                    builder.append("color=\"red\" ");
                }
                builder.append("label=\"");
                builder.append("Line ");
                builder.append(edge.getLineNumber());
                builder.append(": ");
                builder.append(edge.getDescription().replaceAll("\n", " ").replace('\"', '\''));
                builder.append("\"");
            }
            builder.append(" id=\"");
            builder.append(state.getStateId());
            builder.append(" -> ");
            builder.append(succesorState.getStateId());
            builder.append("\"");
        }
        builder.append("]\n");
        return builder.toString();
    }

    void writeEdge(ARGState start, ARGState end) throws IOException {
        this.sb.append("" + start.getStateId());
        this.sb.append(" -> ");
        this.sb.append("" + end.getStateId());
        this.sb.append("\n");
    }

    void enterSubgraph(String name, String label) throws IOException {
        this.sb.append("subgraph ");
        this.sb.append(name);
        this.sb.append(" {\n");
        this.sb.append("label=\"");
        this.sb.append(label);
        this.sb.append("\"\n");
    }

    void leaveSubgraph() throws IOException {
        this.sb.append("}\n");
    }

    void finish() throws IOException {
        this.sb.append("}\n");
    }

    private static String escapeLabelString(String rawString) {
        return rawString;
    }

    private static String determineStateHint(ARGState currentElement) {
        String stateNodeId = Integer.toString(currentElement.getStateId());
        String hintNodeId = stateNodeId + "hint";
        String hintLabel = "";
        StringBuilder builder = new StringBuilder();
        if (hintLabel != "") {
            builder.append(" {");
            builder.append(" rank=same;\n");
            builder.append(" ");
            builder.append(stateNodeId);
            builder.append(";\n");
            builder.append(" \"");
            builder.append(hintNodeId);
            builder.append("\" [label=\"");
            builder.append(ARGToDotWriter.escapeLabelString(hintLabel));
            builder.append("\", shape=box, style=filled, fillcolor=gray];\n");
            builder.append(" ");
            builder.append(stateNodeId);
            builder.append(" -> ");
            builder.append("\"");
            builder.append(hintNodeId);
            builder.append("\"");
            builder.append(" [arrowhead=none, color=gray, style=solid]");
            builder.append(";\n");
            builder.append(" }\n");
        }
        return builder.toString();
    }

    private static String determineNode(ARGState currentElement) {
        StringBuilder builder = new StringBuilder();
        builder.append(currentElement.getStateId());
        builder.append(" [");
        String color = ARGToDotWriter.determineColor(currentElement);
        if (color != null) {
            builder.append("fillcolor=\"").append(color).append("\" ");
        }
        builder.append("label=\"").append(ARGToDotWriter.determineLabel(currentElement)).append("\" ");
        builder.append("id=\"").append(currentElement.getStateId()).append("\"]\n");
        return builder.toString();
    }

    private static String determineLabel(ARGState currentElement) {
        StringBuilder builder = new StringBuilder();
        builder.append(currentElement.getStateId());
        CFANode loc = AbstractStates.extractLocation(currentElement);
        if (loc != null) {
            builder.append(" @ ");
            builder.append(loc.toString());
            builder.append("\\n");
            builder.append(loc.getFunctionName());
            if (loc instanceof FunctionEntryNode) {
                builder.append(" entry");
            } else if (loc instanceof FunctionExitNode) {
                builder.append(" exit");
            }
        }
        builder.append("\\n");
        builder.append(DOTBuilder.escapeGraphvizLabel(currentElement.toDOTLabel(), "\\\\n"));
        return builder.toString().trim();
    }

    private static String determineColor(ARGState currentElement) {
        if (currentElement.isCovered()) {
            return "green";
        }
        if (currentElement.isTarget()) {
            return "red";
        }
        if (!currentElement.wasExpanded()) {
            return "orange";
        }
        if (currentElement.shouldBeHighlighted()) {
            return "cornflowerblue";
        }
        return null;
    }
}

