/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class ARGTransferRelation
implements TransferRelation {
    private final TransferRelation transferRelation;

    public ARGTransferRelation(TransferRelation tr) {
        this.transferRelation = tr;
    }

    public Collection<ARGState> getAbstractSuccessors(AbstractState pElement, Precision pPrecision) throws CPATransferException, InterruptedException {
        ARGState element = (ARGState)pElement;
        if (element.isCovered()) {
            return Collections.emptySet();
        }
        element.markExpanded();
        AbstractState wrappedState = element.getWrappedState();
        Collection<? extends AbstractState> successors = this.transferRelation.getAbstractSuccessors(wrappedState, pPrecision);
        if (successors.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<ARGState> wrappedSuccessors = new ArrayList<ARGState>();
        for (AbstractState abstractState : successors) {
            ARGState successorElem = new ARGState(abstractState, element);
            wrappedSuccessors.add(successorElem);
        }
        return wrappedSuccessors;
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) {
        throw new UnsupportedOperationException("ARGCPA needs to be used as the outer-most CPA, thus it does not support returning successors for a single edge.");
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState element, List<AbstractState> otherElements, CFAEdge cfaEdge, Precision precision) {
        return null;
    }

    boolean areAbstractSuccessors(AbstractState pElement, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors, ProofChecker wrappedProofChecker) throws CPATransferException, InterruptedException {
        ARGState element = (ARGState)pElement;
        assert (Iterables.elementsEqual(element.getChildren(), pSuccessors));
        AbstractState wrappedState = element.getWrappedState();
        HashMultimap wrappedSuccessors = HashMultimap.create();
        for (AbstractState abstractState : pSuccessors) {
            ARGState successorElem = (ARGState)abstractState;
            wrappedSuccessors.put((Object)element.getEdgeToChild(successorElem), (Object)successorElem.getWrappedState());
        }
        if (pCfaEdge != null) {
            return wrappedProofChecker.areAbstractSuccessors(wrappedState, pCfaEdge, wrappedSuccessors.get((Object)pCfaEdge));
        }
        CFANode loc = AbstractStates.extractLocation(element);
        for (CFAEdge edge : CFAUtils.leavingEdges(loc)) {
            if (wrappedProofChecker.areAbstractSuccessors(wrappedState, edge, wrappedSuccessors.get((Object)edge))) continue;
            return false;
        }
        return true;
    }
}

