/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGToDotWriter;
import org.sosy_lab.cpachecker.cpa.arg.MutableARGPath;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.GraphUtils;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;

public class ARGUtils {
    public static final Function<ARGState, Collection<ARGState>> CHILDREN_OF_STATE = new Function<ARGState, Collection<ARGState>>(){

        public Collection<ARGState> apply(ARGState pInput) {
            return pInput.getChildren();
        }
    };
    public static final Function<ARGState, Collection<ARGState>> PARENTS_OF_STATE = new Function<ARGState, Collection<ARGState>>(){

        public Collection<ARGState> apply(ARGState pInput) {
            return pInput.getParents();
        }
    };
    public static final Predicate<AbstractState> AT_RELEVANT_LOCATION = Predicates.compose((Predicate)new Predicate<CFANode>(){

        public boolean apply(CFANode pInput) {
            return pInput.isLoopStart() || pInput instanceof FunctionEntryNode || pInput instanceof FunctionExitNode;
        }
    }, AbstractStates.EXTRACT_LOCATION);
    public static final Predicate<ARGState> RELEVANT_STATE = Predicates.or((Predicate[])new Predicate[]{AbstractStates.IS_TARGET_STATE, AT_RELEVANT_LOCATION, new Predicate<ARGState>(){

        public boolean apply(ARGState pInput) {
            return !pInput.wasExpanded();
        }
    }, new Predicate<ARGState>(){

        public boolean apply(ARGState pInput) {
            return pInput.shouldBeHighlighted();
        }
    }});

    private ARGUtils() {
    }

    public static Set<ARGState> getAllStatesOnPathsTo(ARGState pLastElement) {
        HashSet<ARGState> result = new HashSet<ARGState>();
        ArrayDeque<ARGState> waitList = new ArrayDeque<ARGState>();
        result.add(pLastElement);
        waitList.add(pLastElement);
        while (!waitList.isEmpty()) {
            ARGState currentElement = (ARGState)waitList.poll();
            for (ARGState parent : currentElement.getParents()) {
                if (!result.add(parent)) continue;
                waitList.push(parent);
            }
        }
        return result;
    }

    public static Set<ARGState> getRootStates(ReachedSet pReached) {
        HashSet<ARGState> result = new HashSet<ARGState>();
        for (AbstractState e : pReached) {
            ARGState state = AbstractStates.extractStateByType(e, ARGState.class);
            if (!state.getParents().isEmpty()) continue;
            result.add(state);
        }
        return result;
    }

    public static ARGPath getOnePathTo(ARGState pLastElement) {
        ArrayList<ARGState> states = new ArrayList<ARGState>();
        HashSet<ARGState> seenElements = new HashSet<ARGState>();
        ARGState currentARGState = pLastElement;
        states.add(currentARGState);
        seenElements.add(currentARGState);
        while (!currentARGState.getParents().isEmpty()) {
            Iterator<ARGState> parents = currentARGState.getParents().iterator();
            ARGState parentElement = parents.next();
            while (!seenElements.add(parentElement) && parents.hasNext()) {
                parentElement = parents.next();
            }
            states.add(parentElement);
            currentARGState = parentElement;
        }
        return new ARGPath(Lists.reverse(states));
    }

    public static Optional<ARGPath> getOnePathTo(final ARGState pEndState, Collection<ARGPath> pOtherPathThan) {
        ArrayList<ARGState> states = new ArrayList<ARGState>();
        HashSet<ARGState> seenElements = new HashSet<ARGState>();
        ARGState currentARGState = pEndState;
        CFANode currentLocation = AbstractStates.extractLocation(pEndState);
        states.add(currentARGState);
        seenElements.add(currentARGState);
        Collection<ARGPath.PathPosition> tracePrefixesToAvoid = Collections2.transform(pOtherPathThan, (Function)new Function<ARGPath, ARGPath.PathPosition>(){

            public ARGPath.PathPosition apply(ARGPath pArg0) {
                ARGPath.PathPosition result = pArg0.reversePathIterator().getPosition();
                CFANode expectedPostfixLoc = AbstractStates.extractLocation(pEndState);
                Verify.verify((boolean)result.getLocation().equals(expectedPostfixLoc));
                return result;
            }
        });
        tracePrefixesToAvoid = ARGUtils.getTracePrefixesBeforePostfix(tracePrefixesToAvoid, currentLocation);
        boolean lastTransitionIsDifferent = false;
        while (!currentARGState.getParents().isEmpty()) {
            ArrayList potentialParents = Lists.newArrayList();
            potentialParents.addAll(currentARGState.getParents());
            if (!tracePrefixesToAvoid.isEmpty()) {
                potentialParents.addAll(currentARGState.getCoveredByThis());
            }
            Iterator parents = potentialParents.iterator();
            boolean uniqueParentFound = false;
            ARGState parentElement = (ARGState)parents.next();
            while (true) {
                if (!seenElements.add(parentElement) && parents.hasNext()) {
                    parentElement = (ARGState)parents.next();
                    continue;
                }
                uniqueParentFound = true;
                CFANode parentLocation = AbstractStates.extractLocation(parentElement);
                for (ARGPath.PathPosition t : tracePrefixesToAvoid) {
                    if (!t.getLocation().equals(parentLocation)) continue;
                    uniqueParentFound = false;
                    lastTransitionIsDifferent = false;
                    break;
                }
                lastTransitionIsDifferent = tracePrefixesToAvoid.isEmpty();
                if (uniqueParentFound || !parents.hasNext()) break;
            }
            states.add(parentElement);
            currentARGState = parentElement;
            currentLocation = AbstractStates.extractLocation(currentARGState);
            tracePrefixesToAvoid = ARGUtils.getTracePrefixesBeforePostfix(tracePrefixesToAvoid, currentLocation);
        }
        if (!lastTransitionIsDifferent) {
            return Optional.absent();
        }
        return Optional.of((Object)new ARGPath(Lists.reverse(states)));
    }

    public static Collection<ARGPath.PathPosition> getTracePrefixesBeforePostfix(Collection<ARGPath.PathPosition> pTracePosition, CFANode pPostfixLocation) {
        Preconditions.checkNotNull(pTracePosition);
        Preconditions.checkNotNull((Object)pPostfixLocation);
        ImmutableList.Builder result = ImmutableList.builder();
        for (ARGPath.PathPosition p : pTracePosition) {
            ARGPath.PathIterator it;
            if (!pPostfixLocation.equals(p.getLocation()) || !(it = p.reverseIterator()).hasNext()) continue;
            it.advance();
            result.add((Object)it.getPosition());
        }
        return result.build();
    }

    public static MutableARGPath getOneMutablePathTo(ARGState pLastElement) {
        MutableARGPath path = new MutableARGPath();
        HashSet<ARGState> seenElements = new HashSet<ARGState>();
        ARGState currentARGState = pLastElement;
        CFANode loc = AbstractStates.extractLocation(currentARGState);
        CFAEdge lastEdge = (CFAEdge)CFAUtils.leavingEdges(loc).first().orNull();
        path.addFirst(Pair.of((Object)currentARGState, (Object)lastEdge));
        seenElements.add(currentARGState);
        while (!currentARGState.getParents().isEmpty()) {
            Iterator<ARGState> parents = currentARGState.getParents().iterator();
            ARGState parentElement = parents.next();
            while (!seenElements.add(parentElement) && parents.hasNext()) {
                parentElement = parents.next();
            }
            CFAEdge edge = parentElement.getEdgeToChild(currentARGState);
            path.addFirst(Pair.of((Object)parentElement, (Object)edge));
            currentARGState = parentElement;
        }
        return path;
    }

    public static ARGPath getRandomPath(ARGState root) {
        Preconditions.checkArgument((boolean)root.getParents().isEmpty());
        ArrayList<ARGState> states = new ArrayList<ARGState>();
        ARGState currentElement = root;
        while (currentElement.getChildren().size() > 0) {
            states.add(currentElement);
            currentElement = currentElement.getChildren().iterator().next();
        }
        states.add(currentElement);
        return new ARGPath(states);
    }

    public static SetMultimap<ARGState, ARGState> projectARG(ARGState root, Function<? super ARGState, ? extends Iterable<ARGState>> successorFunction, Predicate<? super ARGState> isRelevant) {
        return GraphUtils.projectARG(root, successorFunction, isRelevant);
    }

    public static void writeARGAsDot(Appendable pSb, ARGState pRootState) throws IOException {
        ARGToDotWriter.write(pSb, pRootState, CHILDREN_OF_STATE, (Predicate<? super ARGState>)Predicates.alwaysTrue(), (Predicate<? super Pair<ARGState, ARGState>>)Predicates.alwaysFalse());
    }

    public static ARGPath getPathFromBranchingInformation(ARGState root, Set<? extends AbstractState> arg, Map<Integer, Boolean> branchingInformation) throws IllegalArgumentException {
        Preconditions.checkArgument((boolean)arg.contains(root));
        ArrayList<ARGState> states = new ArrayList<ARGState>();
        ArrayList<CFAEdge> edges = new ArrayList<CFAEdge>();
        ARGState currentElement = root;
        while (!currentElement.isTarget()) {
            CFAEdge edge;
            ARGState child;
            Collection<ARGState> children = currentElement.getChildren();
            switch (children.size()) {
                case 0: {
                    throw new IllegalArgumentException("ARG target path terminates without reaching target state!");
                }
                case 1: {
                    child = (ARGState)Iterables.getOnlyElement(children);
                    edge = currentElement.getEdgeToChild(child);
                    break;
                }
                case 2: {
                    CFAEdge trueEdge = null;
                    CFAEdge falseEdge = null;
                    ARGState trueChild = null;
                    ARGState falseChild = null;
                    CFANode loc = AbstractStates.extractLocation(currentElement);
                    if (!CFAUtils.leavingEdges(loc).allMatch(Predicates.instanceOf(AssumeEdge.class))) {
                        ImmutableSet candidates = Sets.intersection((Set)Sets.newHashSet(children), arg).immutableCopy();
                        if (candidates.size() != 1) {
                            throw new IllegalArgumentException("ARG branches where there is no AssumeEdge!");
                        }
                        child = (ARGState)Iterables.getOnlyElement((Iterable)candidates);
                        edge = currentElement.getEdgeToChild(child);
                        break;
                    }
                    for (ARGState currentChild : children) {
                        CFAEdge currentEdge = currentElement.getEdgeToChild(currentChild);
                        if (((AssumeEdge)currentEdge).getTruthAssumption()) {
                            trueEdge = currentEdge;
                            trueChild = currentChild;
                            continue;
                        }
                        falseEdge = currentEdge;
                        falseChild = currentChild;
                    }
                    if (trueEdge == null || falseEdge == null) {
                        throw new IllegalArgumentException("ARG branches with non-complementary AssumeEdges!");
                    }
                    assert (trueChild != null);
                    assert (falseChild != null);
                    Boolean predValue = branchingInformation.get(currentElement.getStateId());
                    if (predValue == null) {
                        throw new IllegalArgumentException("ARG branches without direction information!");
                    }
                    if (predValue.booleanValue()) {
                        edge = trueEdge;
                        child = trueChild;
                        break;
                    }
                    edge = falseEdge;
                    child = falseChild;
                    break;
                }
                default: {
                    ImmutableSet candidates = Sets.intersection((Set)Sets.newHashSet(children), arg).immutableCopy();
                    if (candidates.size() != 1) {
                        throw new IllegalArgumentException("ARG splits with more than two branches!");
                    }
                    child = (ARGState)Iterables.getOnlyElement((Iterable)candidates);
                    edge = currentElement.getEdgeToChild(child);
                }
            }
            if (!arg.contains(child)) {
                throw new IllegalArgumentException("ARG and direction information from solver disagree!");
            }
            states.add(currentElement);
            edges.add(edge);
            currentElement = child;
        }
        CFANode loc = AbstractStates.extractLocation(currentElement);
        CFAEdge lastEdge = (CFAEdge)CFAUtils.leavingEdges(loc).first().orNull();
        states.add(currentElement);
        edges.add(lastEdge);
        return new ARGPath(states, edges);
    }

    public static ARGPath getPathFromBranchingInformation(ARGState root, ARGState target, Set<? extends AbstractState> arg, Map<Integer, Boolean> branchingInformation) throws IllegalArgumentException {
        Preconditions.checkArgument((boolean)arg.contains(target));
        Preconditions.checkArgument((boolean)target.isTarget());
        ARGPath result = ARGUtils.getPathFromBranchingInformation(root, arg, branchingInformation);
        if (result.getLastState() != target) {
            throw new IllegalArgumentException("ARG target path reached the wrong target state!");
        }
        return result;
    }

    public static final Collection<ARGState> getUncoveredChildrenView(final ARGState s) {
        return new AbstractCollection<ARGState>(){

            @Override
            public Iterator<ARGState> iterator() {
                return new UnmodifiableIterator<ARGState>(){
                    private final Iterator<ARGState> children;
                    {
                        this.children = s.getChildren().iterator();
                    }

                    public boolean hasNext() {
                        return this.children.hasNext();
                    }

                    public ARGState next() {
                        ARGState child = this.children.next();
                        if (child.isCovered()) {
                            return (ARGState)Preconditions.checkNotNull((Object)child.getCoveringState());
                        }
                        return child;
                    }
                };
            }

            @Override
            public int size() {
                return s.getChildren().size();
            }
        };
    }

    public static boolean checkARG(ReachedSet pReached) {
        for (ARGState e : FluentIterable.from((Iterable)pReached).transform(AbstractStates.toState(ARGState.class))) {
            assert (e != null) : "Reached set contains abstract state without ARGState.";
            assert (!e.isDestroyed()) : "Reached set contains destroyed ARGState, which should have been removed.";
            for (ARGState parent : e.getParents()) {
                assert (parent.getChildren().contains(e)) : "Reference from parent to child is missing in ARG";
                assert (pReached.contains(parent)) : "Referenced parent is missing in reached";
            }
            for (ARGState child : e.getChildren()) {
                assert (child.getParents().contains(e)) : "Reference from child to parent is missing in ARG";
                if (!pReached.contains(child)) assert (child.isCovered() && child.getChildren().isEmpty() || pReached.getWaitlist().containsAll(child.getParents())) : "Referenced child is missing in reached set.";
            }
        }
        return true;
    }

    public static void produceTestGenPathAutomaton(Appendable sb, String name, CounterexampleTraceInfo pCounterExampleTrace) throws IOException {
        Model model = pCounterExampleTrace.getModel();
        CFAPathWithAssumptions assignmentCFAPath = model.getCFAPathWithAssignments();
        int stateCounter = 1;
        sb.append("CONTROL AUTOMATON " + name + "\n\n");
        sb.append("INITIAL STATE STATE" + stateCounter + ";\n\n");
        Iterator<CFAEdgeWithAssumptions> it = assignmentCFAPath.iterator();
        while (it.hasNext()) {
            CFAEdgeWithAssumptions edge = it.next();
            sb.append("STATE USEFIRST STATE" + stateCounter + " :\n");
            sb.append("    MATCH \"");
            ARGUtils.escape(edge.getCFAEdge().getRawStatement(), sb);
            sb.append("\" -> ");
            if (it.hasNext()) {
                String code = edge.getAsCode();
                String assumption = code.isEmpty() ? "" : "ASSUME {" + code + "}";
                sb.append(assumption + "GOTO STATE" + ++stateCounter);
            } else {
                sb.append("GOTO EndLoop");
            }
            sb.append(";\n");
            sb.append("    TRUE -> STOP;\n\n");
        }
        sb.append("STATE USEFIRST EndLoop :\n");
        sb.append("    MATCH EXIT -> BREAK;\n");
        sb.append("    TRUE -> GOTO EndLoop;\n\n");
        sb.append("END AUTOMATON\n");
    }

    public static void produceTestGenPathAutomaton(Appendable sb, ARGState pRootState, Set<ARGState> pPathStates, String name, CounterexampleInfo pCounterExample, boolean generateAssumes) throws IOException {
        Preconditions.checkNotNull((Object)pCounterExample);
        Map<ARGState, CFAEdgeWithAssumptions> valueMap = null;
        Model model = pCounterExample.getTargetPathModel();
        CFAPathWithAssumptions cfaPath = model.getCFAPathWithAssignments();
        if (cfaPath != null) {
            ARGPath targetPath = pCounterExample.getTargetPath();
            valueMap = model.getExactVariableValues(targetPath);
        }
        sb.append("CONTROL AUTOMATON " + name + "\n\n");
        sb.append("INITIAL STATE ARG" + pRootState.getStateId() + ";\n\n");
        int multiEdgeCount = 0;
        ARGState lastState = pCounterExample.getTargetPath().getLastState();
        for (ARGState s : pPathStates) {
            CFANode loc = AbstractStates.extractLocation(s);
            sb.append("STATE USEFIRST ARG" + s.getStateId() + " :\n");
            for (ARGState child : s.getChildren()) {
                if (child.isCovered()) {
                    child = child.getCoveringState();
                    assert (!child.isCovered());
                }
                if (!pPathStates.contains(child)) continue;
                CFANode childLoc = AbstractStates.extractLocation(child);
                CFAEdge edge = loc.getEdgeTo(childLoc);
                if (edge instanceof MultiEdge) {
                    int i;
                    ++multiEdgeCount;
                    ImmutableList<CFAEdge> edges = ((MultiEdge)edge).getEdges();
                    sb.append("    MATCH \"");
                    ARGUtils.escape(((CFAEdge)edges.get(i)).getRawStatement(), sb);
                    sb.append("\" -> ");
                    sb.append("GOTO ARG" + child.getStateId() + "_" + (i + 1) + "_" + multiEdgeCount);
                    sb.append(";\n");
                    for (i = 0; i < edges.size() - 1; ++i) {
                        sb.append("STATE USEFIRST ARG" + child.getStateId() + "_" + i + "_" + multiEdgeCount + " :\n");
                        sb.append("    MATCH \"");
                        ARGUtils.escape(((CFAEdge)edges.get(i)).getRawStatement(), sb);
                        sb.append("\" -> ");
                        sb.append("GOTO ARG" + child.getStateId() + "_" + (i + 1) + "_" + multiEdgeCount);
                        sb.append(";\n");
                    }
                    edge = (CFAEdge)edges.get(i);
                    sb.append("STATE USEFIRST ARG" + child.getStateId() + "_" + i + "_" + multiEdgeCount + " :\n");
                }
                sb.append("    MATCH \"");
                ARGUtils.escape(edge.getRawStatement(), sb);
                sb.append("\" -> ");
                if (child.isTarget()) {
                    sb.append("ERROR");
                } else {
                    if (generateAssumes) {
                        ARGUtils.addAssumption(valueMap, s, sb);
                    }
                    sb.append("GOTO ARG" + child.getStateId());
                }
                sb.append(";\n");
            }
            if (s.equals(lastState)) continue;
            sb.append("    TRUE -> STOP;\n\n");
        }
        CFAEdge lastEdge = (CFAEdge)Iterables.getLast(pCounterExample.getTargetPath().asEdgesList());
        if (lastEdge != null) {
            sb.append("    MATCH \"");
            ARGUtils.escape(lastEdge.getRawStatement(), sb);
            sb.append("\" -> ");
            sb.append("GOTO EndLoop");
            sb.append(";\n");
            sb.append("    TRUE -> STOP;\n\n");
            sb.append("STATE USEFIRST EndLoop :\n");
            sb.append("    MATCH EXIT -> BREAK;\n");
            sb.append("    TRUE -> GOTO EndLoop;\n\n");
        } else {
            sb.append("    TRUE -> STOP;\n\n");
        }
        sb.append("END AUTOMATON\n");
    }

    public static void producePathAutomaton(Appendable sb, ARGState pRootState, Set<ARGState> pPathStates, String name, @Nullable CounterexampleInfo pCounterExample) throws IOException {
        Model model;
        CFAPathWithAssumptions cfaPath;
        Object valueMap = null;
        if (pCounterExample != null && (cfaPath = (model = pCounterExample.getTargetPathModel()).getCFAPathWithAssignments()) != null) {
            ARGPath targetPath = pCounterExample.getTargetPath();
            valueMap = model.getExactVariableValues(targetPath);
        }
        if (valueMap == null) {
            valueMap = ImmutableMap.of();
        }
        sb.append("CONTROL AUTOMATON " + name + "\n\n");
        sb.append("INITIAL STATE ARG" + pRootState.getStateId() + ";\n\n");
        int multiEdgeCount = 0;
        for (ARGState s : pPathStates) {
            CFANode loc = AbstractStates.extractLocation(s);
            sb.append("STATE USEFIRST ARG" + s.getStateId() + " :\n");
            for (ARGState child : s.getChildren()) {
                if (child.isCovered()) {
                    child = child.getCoveringState();
                    assert (!child.isCovered());
                }
                if (!pPathStates.contains(child)) continue;
                CFANode childLoc = AbstractStates.extractLocation(child);
                CFAEdge edge = loc.getEdgeTo(childLoc);
                if (edge instanceof MultiEdge) {
                    int i;
                    ++multiEdgeCount;
                    ImmutableList<CFAEdge> edges = ((MultiEdge)edge).getEdges();
                    sb.append("    MATCH \"");
                    ARGUtils.escape(((CFAEdge)edges.get(i)).getRawStatement(), sb);
                    sb.append("\" -> ");
                    sb.append("GOTO ARG" + child.getStateId() + "_" + (i + 1) + "_" + multiEdgeCount);
                    sb.append(";\n");
                    for (i = 0; i < edges.size() - 1; ++i) {
                        sb.append("STATE USEFIRST ARG" + child.getStateId() + "_" + i + "_" + multiEdgeCount + " :\n");
                        sb.append("    MATCH \"");
                        ARGUtils.escape(((CFAEdge)edges.get(i)).getRawStatement(), sb);
                        sb.append("\" -> ");
                        sb.append("GOTO ARG" + child.getStateId() + "_" + (i + 1) + "_" + multiEdgeCount);
                        sb.append(";\n");
                    }
                    edge = (CFAEdge)edges.get(i);
                    sb.append("STATE USEFIRST ARG" + child.getStateId() + "_" + i + "_" + multiEdgeCount + " :\n");
                }
                sb.append("    MATCH \"");
                ARGUtils.escape(edge.getRawStatement(), sb);
                sb.append("\" -> ");
                if (child.isTarget()) {
                    sb.append("ERROR");
                } else {
                    ARGUtils.addAssumption((Map<ARGState, CFAEdgeWithAssumptions>)valueMap, s, sb);
                    sb.append("GOTO ARG" + child.getStateId());
                }
                sb.append(";\n");
            }
            sb.append("    TRUE -> STOP;\n\n");
        }
        sb.append("END AUTOMATON\n");
    }

    private static void addAssumption(Map<ARGState, CFAEdgeWithAssumptions> pValueMap, ARGState pState, Appendable sb) throws IOException {
        String code;
        CFAEdgeWithAssumptions cfaEdgeWithAssignments = pValueMap.get(pState);
        if (cfaEdgeWithAssignments != null && !(code = cfaEdgeWithAssignments.getAsCode()).isEmpty()) {
            sb.append("ASSUME {" + code + "} ");
        }
    }

    private static void escape(String s, Appendable appendTo) throws IOException {
        block6: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    appendTo.append("\\n");
                    continue block6;
                }
                case '\r': {
                    appendTo.append("\\r");
                    continue block6;
                }
                case '\"': {
                    appendTo.append("\\\"");
                    continue block6;
                }
                case '\\': {
                    appendTo.append("\\\\");
                    continue block6;
                }
                default: {
                    appendTo.append(c);
                }
            }
        }
    }
}

