/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;

public abstract class AbstractARGBasedRefiner
implements Refiner {
    private int refinementNumber;
    private final ARGCPA argCpa;
    private final LogManager logger;
    private int counterexamplesCounter = 0;
    private static final Function<CFAEdge, String> pathToFunctionCalls = new Function<CFAEdge, String>(){

        public String apply(CFAEdge arg) {
            if (arg instanceof CFunctionCallEdge) {
                CFunctionCallEdge funcEdge = (CFunctionCallEdge)arg;
                return funcEdge.toString();
            }
            return null;
        }
    };

    protected AbstractARGBasedRefiner(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        if (!(pCpa instanceof WrapperCPA)) {
            throw new InvalidConfigurationException("ARG CPA needed for refinement");
        }
        this.argCpa = ((WrapperCPA)((Object)pCpa)).retrieveWrappedCpa(ARGCPA.class);
        if (this.argCpa == null) {
            throw new InvalidConfigurationException("ARG CPA needed for refinement");
        }
        this.logger = this.argCpa.getLogger();
    }

    protected final ARGCPA getArgCpa() {
        return this.argCpa;
    }

    @Override
    public final boolean performRefinement(ReachedSet pReached) throws CPAException, InterruptedException {
        CounterexampleInfo counterexample;
        this.logger.log(Level.FINEST, new Object[]{"Starting ARG based refinement"});
        assert (ARGUtils.checkARG(pReached)) : "ARG and reached set do not match before refinement";
        ARGState lastElement = (ARGState)pReached.getLastState();
        assert (lastElement.isTarget()) : "Last element in reached is not a target state before refinement";
        ARGReachedSet reached = new ARGReachedSet(pReached, this.argCpa, this.refinementNumber++);
        ARGPath path = this.computePath(lastElement, reached);
        if (this.logger.wouldBeLogged(Level.ALL) && path != null) {
            this.logger.log(Level.ALL, new Object[]{"Error path:\n", path});
            this.logger.log(Level.ALL, new Object[]{"Function calls on Error path:\n", Joiner.on((String)"\n ").skipNulls().join((Iterable)Collections2.transform(path.getInnerEdges(), pathToFunctionCalls))});
        }
        try {
            counterexample = this.performRefinement(reached, path);
        }
        catch (RefinementFailedException e) {
            if (e.getErrorPath() == null) {
                e.setErrorPath(path);
            }
            this.argCpa.addCounterexample(lastElement, CounterexampleInfo.feasible(e.getErrorPath(), Model.empty()));
            throw e;
        }
        assert (ARGUtils.checkARG(pReached)) : "ARG and reached set do not match after refinement";
        if (!counterexample.isSpurious()) {
            ARGPath targetPath = counterexample.getTargetPath();
            if (path != null) {
                assert (targetPath.getFirstState() == path.getFirstState()) : "Target path from refiner does not contain root node";
                assert (targetPath.getLastState() == path.getLastState()) : "Target path from refiner does not contain target state";
            }
            this.argCpa.addCounterexample(lastElement, counterexample);
            this.logger.log(Level.FINEST, new Object[]{"Counterexample", this.counterexamplesCounter, "has been found."});
            this.argCpa.exportCounterexampleOnTheFly(lastElement, counterexample, this.counterexamplesCounter);
            ++this.counterexamplesCounter;
        }
        this.logger.log(Level.FINEST, new Object[]{"ARG based refinement finished, result is", counterexample.isSpurious()});
        return counterexample.isSpurious();
    }

    protected abstract CounterexampleInfo performRefinement(ARGReachedSet var1, ARGPath var2) throws CPAException, InterruptedException;

    @Nullable
    protected ARGPath computePath(ARGState pLastElement, ARGReachedSet pReached) throws InterruptedException, CPAException {
        return ARGUtils.getOnePathTo(pLastElement);
    }
}

