/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.AAssignment;
import org.sosy_lab.cpachecker.cfa.ast.ABinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.AInitializer;
import org.sosy_lab.cpachecker.cfa.ast.ALeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.ALiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.AParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.ARightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.AUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.java.JBinaryExpression;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.util.AbstractStates;

public final class ErrorPathShrinker {
    private Deque<CFAEdge> shortPath;
    private Set<String> importantVars;
    private CFAEdge currentCFAEdge;

    public List<CFAEdge> shrinkErrorPath(ARGPath pTargetPath) {
        List<CFAEdge> targetPath = ErrorPathShrinker.getEdgesUntilTarget(pTargetPath);
        Iterator revIterator = Lists.reverse(targetPath).iterator();
        this.importantVars = new HashSet<String>();
        ArrayDeque<CFAEdge> shortErrorPath = new ArrayDeque<CFAEdge>();
        while (revIterator.hasNext()) {
            this.handleEdge((CFAEdge)revIterator.next(), shortErrorPath);
        }
        return ImmutableList.copyOf(shortErrorPath);
    }

    private static List<CFAEdge> getEdgesUntilTarget(ARGPath path) {
        int targetPos = Iterables.indexOf(path.asStatesList(), AbstractStates.IS_TARGET_STATE);
        if (targetPos > 0) {
            return path.getInnerEdges().subList(0, targetPos);
        }
        return path.getInnerEdges();
    }

    private void handleEdge(CFAEdge cfaEdge, Deque<CFAEdge> shortErrorPath) {
        this.currentCFAEdge = cfaEdge;
        this.shortPath = shortErrorPath;
        switch (cfaEdge.getEdgeType()) {
            case AssumeEdge: {
                this.handleAssumption(((AssumeEdge)cfaEdge).getExpression());
                break;
            }
            case FunctionCallEdge: {
                FunctionCallEdge fnkCall = (FunctionCallEdge)cfaEdge;
                FunctionEntryNode succ = fnkCall.getSuccessor();
                this.handleFunctionCallEdge(fnkCall.getArguments(), succ.getFunctionParameters());
                break;
            }
            case FunctionReturnEdge: {
                FunctionReturnEdge fnkReturnEdge = (FunctionReturnEdge)cfaEdge;
                FunctionSummaryEdge summaryEdge = fnkReturnEdge.getSummaryEdge();
                this.handleFunctionReturnEdge(fnkReturnEdge, summaryEdge.getExpression());
                break;
            }
            case MultiEdge: {
                this.handleMultiEdge((MultiEdge)cfaEdge);
                break;
            }
            default: {
                this.handleSimpleEdge(cfaEdge);
            }
        }
    }

    private void handleSimpleEdge(CFAEdge cfaEdge) {
        switch (cfaEdge.getEdgeType()) {
            case DeclarationEdge: {
                this.handleDeclarationEdge(((ADeclarationEdge)cfaEdge).getDeclaration());
                break;
            }
            case StatementEdge: {
                this.handleStatementEdge(((AStatementEdge)cfaEdge).getStatement());
                break;
            }
            case ReturnStatementEdge: {
                this.handleReturnStatementEdge((AReturnStatementEdge)cfaEdge);
                break;
            }
            case BlankEdge: {
                this.handleBlankEdge((BlankEdge)cfaEdge);
                break;
            }
            case CallToReturnEdge: {
                throw new AssertionError((Object)"function summaries not supported");
            }
            default: {
                throw new AssertionError((Object)"unknown edge type");
            }
        }
    }

    private void handleMultiEdge(MultiEdge cfaEdge) {
        Iterator i$ = Lists.reverse(cfaEdge.getEdges()).iterator();
        while (i$.hasNext()) {
            CFAEdge innerEdge;
            this.currentCFAEdge = innerEdge = (CFAEdge)i$.next();
            this.handleSimpleEdge(innerEdge);
        }
        this.currentCFAEdge = cfaEdge;
    }

    private void handleBlankEdge(BlankEdge cfaEdge) {
        assert (cfaEdge == this.currentCFAEdge);
        if (this.currentCFAEdge.getSuccessor().isLoopStart()) {
            this.addCurrentCFAEdgeToShortPath();
        }
    }

    private void handleReturnStatementEdge(AReturnStatementEdge returnEdge) {
        if (returnEdge.asAssignment().isPresent()) {
            AAssignment assignment = (AAssignment)returnEdge.asAssignment().get();
            this.handleAssignmentToVariable(assignment.getLeftHandSide(), assignment.getRightHandSide());
        }
    }

    private void handleFunctionReturnEdge(FunctionReturnEdge fnkReturnEdge, AFunctionCall expression) {
        Optional<? extends AVariableDeclaration> returnVar;
        if (expression instanceof AFunctionCallAssignmentStatement && (returnVar = fnkReturnEdge.getFunctionEntry().getReturnVariable()).isPresent() && this.isImportant((ASimpleDeclaration)returnVar.get())) {
            this.remove((ASimpleDeclaration)returnVar.get());
            this.track(((AVariableDeclaration)returnVar.get()).getQualifiedName());
        }
    }

    private void handleFunctionCallEdge(List<? extends AExpression> arguments, List<? extends AParameterDeclaration> functionParameters) {
        this.addCurrentCFAEdgeToShortPath();
        for (int i = 0; i < functionParameters.size(); ++i) {
            AExpression arg = arguments.get(i);
            String paramName = functionParameters.get(i).getQualifiedName();
            if (!this.isImportant(paramName)) continue;
            this.remove(paramName);
            this.addAllVarsInExpToSet(arg);
        }
    }

    private void handleStatementEdge(AStatement statementExp) {
        if (statementExp instanceof AAssignment) {
            this.handleAssignmentToVariable(((AAssignment)((Object)statementExp)).getLeftHandSide(), ((AAssignment)((Object)statementExp)).getRightHandSide());
        } else if (statementExp instanceof AFunctionCall) {
            this.addCurrentCFAEdgeToShortPath();
        }
    }

    private void handleAssignmentToVariable(ALeftHandSide lParam, ARightHandSide rightExp) {
        if (this.isImportant(lParam)) {
            this.addCurrentCFAEdgeToShortPath();
            this.remove(lParam);
            this.addAllVarsInExpToSet(rightExp);
        }
    }

    private void handleDeclarationEdge(ADeclaration declaration) {
        if (declaration.getName() != null && this.isImportant(declaration)) {
            AInitializer init;
            this.addCurrentCFAEdgeToShortPath();
            if (declaration instanceof AVariableDeclaration && (init = ((AVariableDeclaration)declaration).getInitializer()) != null) {
                ArrayDeque<AInitializer> inits = new ArrayDeque<AInitializer>();
                inits.add(init);
                while (!inits.isEmpty()) {
                    init = (AInitializer)inits.pop();
                    if (init instanceof CInitializerExpression) {
                        this.addAllVarsInExpToSet(((CInitializerExpression)init).getExpression());
                        continue;
                    }
                    if (!(init instanceof CInitializerList)) continue;
                    inits.addAll(((CInitializerList)init).getInitializers());
                }
            }
            this.remove(declaration);
        }
    }

    private void handleAssumption(AExpression assumeExp) {
        if (!this.isSwitchStatement(assumeExp)) {
            this.addAllVarsInExpToSet(assumeExp);
            this.addCurrentCFAEdgeToShortPath();
        }
    }

    private boolean isSwitchStatement(AExpression assumeExp) {
        if (!this.shortPath.isEmpty()) {
            AssumeEdge lastAss;
            AExpression lastExp;
            CFAEdge lastEdge = this.shortPath.getFirst();
            if (assumeExp instanceof ABinaryExpression && lastEdge instanceof AssumeEdge && (lastExp = (lastAss = (AssumeEdge)lastEdge).getExpression()) instanceof ABinaryExpression) {
                CBinaryExpression.BinaryOperator op;
                AExpression currentBinExpOp1 = ((ABinaryExpression)assumeExp).getOperand1();
                AExpression lastBinExpOp1 = ((ABinaryExpression)lastExp).getOperand1();
                boolean isEqualVarName = currentBinExpOp1.toASTString().equals(lastBinExpOp1.toASTString());
                ABinaryExpression aLastExp = (ABinaryExpression)lastExp;
                boolean isEqualOp = aLastExp instanceof CBinaryExpression ? (op = (CBinaryExpression.BinaryOperator)aLastExp.getOperator()) == CBinaryExpression.BinaryOperator.EQUALS && lastAss.getTruthAssumption() || op == CBinaryExpression.BinaryOperator.NOT_EQUALS && !lastAss.getTruthAssumption() : (op = (JBinaryExpression.BinaryOperator)aLastExp.getOperator()) == JBinaryExpression.BinaryOperator.EQUALS && lastAss.getTruthAssumption() || op == JBinaryExpression.BinaryOperator.NOT_EQUALS && !lastAss.getTruthAssumption();
                return isEqualVarName && isEqualOp;
            }
        }
        return false;
    }

    private void addAllVarsInExpToSet(ARightHandSide exp) {
        if (!(exp instanceof ALiteralExpression) && !(exp instanceof AFunctionCallExpression) && exp != null) {
            if (exp instanceof AIdExpression) {
                this.track((AIdExpression)exp);
            } else if (exp instanceof CCastExpression) {
                this.addAllVarsInExpToSet(((CCastExpression)exp).getOperand());
            } else if (exp instanceof AUnaryExpression) {
                this.addAllVarsInExpToSet(((AUnaryExpression)exp).getOperand());
            } else if (exp instanceof ABinaryExpression) {
                ABinaryExpression binExp = (ABinaryExpression)exp;
                this.addAllVarsInExpToSet(binExp.getOperand1());
                this.addAllVarsInExpToSet(binExp.getOperand2());
            } else if (exp instanceof CFieldReference) {
                this.track((CFieldReference)exp);
            }
        }
    }

    private boolean isImportant(AExpression exp) {
        return this.isImportant(this.str(exp));
    }

    private boolean isImportant(ASimpleDeclaration exp) {
        return this.isImportant(exp.getQualifiedName());
    }

    private boolean isImportant(String var) {
        return this.importantVars.contains(var);
    }

    private void track(AExpression exp) {
        this.track(this.str(exp));
    }

    private void track(String var) {
        this.importantVars.add(var);
    }

    private void remove(AExpression exp) {
        this.remove(this.str(exp));
    }

    private void remove(ASimpleDeclaration exp) {
        this.remove(exp.getQualifiedName());
    }

    private void remove(String var) {
        this.importantVars.remove(var);
    }

    private String str(AExpression exp) {
        if (exp instanceof AIdExpression) {
            return ((AIdExpression)exp).getDeclaration().getQualifiedName();
        }
        return exp.toASTString();
    }

    private void addCurrentCFAEdgeToShortPath() {
        this.shortPath.addFirst(this.currentCFAEdge);
    }
}

