/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg.counterexamples;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.CFAMultiEdgeWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGPathExport;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGToDotWriter;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.ErrorPathShrinker;
import org.sosy_lab.cpachecker.util.cwriter.PathToCTranslator;

@Options(prefix="cpa.arg.errorPath")
public class CEXExporter {
    @Option(secure=true, name="enabled", description="export error path to file, if one is found")
    private boolean exportErrorPath = true;
    @Option(secure=true, name="file", description="export error path to file, if one is found")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate errorPathFile = PathTemplate.ofFormatString((String)"ErrorPath.%d.txt");
    @Option(secure=true, name="core", description="export error path to file, if one is found")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate errorPathCoreFile = PathTemplate.ofFormatString((String)"ErrorPath.%d.core.txt");
    @Option(secure=true, name="source", description="export error path to file, if one is found")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate errorPathSourceFile = PathTemplate.ofFormatString((String)"ErrorPath.%d.c");
    @Option(secure=true, name="exportAsSource", description="translate error path to C program")
    private boolean exportSource = true;
    @Option(secure=true, name="json", description="export error path to file, if one is found")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate errorPathJson = PathTemplate.ofFormatString((String)"ErrorPath.%d.json");
    @Option(secure=true, name="assignment", description="export one variable assignment for error path to file, if one is found")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate errorPathAssignment = PathTemplate.ofFormatString((String)"ErrorPath.%d.assignment.txt");
    @Option(secure=true, name="graph", description="export error path to file, if one is found")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate errorPathGraphFile = PathTemplate.ofFormatString((String)"ErrorPath.%d.dot");
    @Option(secure=true, name="automaton", description="export error path to file as an automaton")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate errorPathAutomatonFile = PathTemplate.ofFormatString((String)"ErrorPath.%d.spc");
    @Option(secure=true, name="graphml", description="export error path to file as an automaton to a graphml file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate errorPathAutomatonGraphmlFile = null;
    @Option(secure=true, name="exportImmediately", description="export error paths to files immediately after they were found")
    private boolean dumpErrorPathImmediately = false;
    private final LogManager logger;
    private final ARGPathExport witnessExporter;

    public CEXExporter(Configuration config, LogManager logger) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = logger;
        this.witnessExporter = new ARGPathExport(config);
        if (!this.exportSource) {
            this.errorPathSourceFile = null;
        }
        if (this.errorPathAssignment == null && this.errorPathCoreFile == null && this.errorPathFile == null && this.errorPathGraphFile == null && this.errorPathJson == null && this.errorPathSourceFile == null && this.errorPathAutomatonFile == null && this.errorPathAutomatonGraphmlFile == null) {
            this.exportErrorPath = false;
        }
    }

    public void exportCounterexample(ARGState pTargetState, @Nullable CounterexampleInfo pCounterexampleInfo, int cexIndex, @Nullable Set<Pair<ARGState, ARGState>> allTargetPathEdges, boolean reallyWriteToDisk) {
        Preconditions.checkNotNull((Object)pTargetState);
        ARGPath targetPath = (ARGPath)Preconditions.checkNotNull((Object)this.getTargetPath(pTargetState, pCounterexampleInfo));
        Set<Pair<ARGState, ARGState>> targetPathEdges = CEXExporter.getEdgesOfPath(targetPath);
        if (allTargetPathEdges != null) {
            allTargetPathEdges.addAll(targetPathEdges);
        }
        if (reallyWriteToDisk && this.exportErrorPath && pCounterexampleInfo != null) {
            this.exportCounterexample(pTargetState, cexIndex, pCounterexampleInfo, targetPath, (Predicate<Pair<ARGState, ARGState>>)Predicates.in(targetPathEdges));
        }
    }

    private void exportCounterexample(ARGState lastState, final int cexIndex, final @Nullable CounterexampleInfo counterexample, final @Nonnull ARGPath targetPath, final Predicate<Pair<ARGState, ARGState>> isTargetPathEdge) {
        Set<ARGState> pathElements;
        final ARGState rootState = targetPath.getFirstState();
        this.writeErrorPathFile(this.errorPathFile, cexIndex, this.createErrorPathWithVariableAssignmentInformation(targetPath.getInnerEdges(), counterexample));
        if (this.errorPathCoreFile != null) {
            ErrorPathShrinker pathShrinker = new ErrorPathShrinker();
            List<CFAEdge> shrinkedErrorPath = pathShrinker.shrinkErrorPath(targetPath);
            this.writeErrorPathFile(this.errorPathCoreFile, cexIndex, this.createErrorPathWithVariableAssignmentInformation(shrinkedErrorPath, counterexample));
        }
        this.writeErrorPathFile(this.errorPathJson, cexIndex, new Appender(){

            public void appendTo(Appendable pAppendable) throws IOException {
                if (counterexample != null && counterexample.getTargetPathModel() != null && counterexample.getTargetPathModel().getCFAPathWithAssignments() != null) {
                    counterexample.getTargetPathModel().getCFAPathWithAssignments().toJSON(pAppendable, targetPath);
                } else {
                    targetPath.toJSON(pAppendable);
                }
            }
        });
        Appender pathProgram = null;
        if (counterexample != null && counterexample.getTargetPath() != null) {
            pathElements = targetPath.getStateSet();
            if (this.errorPathSourceFile != null) {
                pathProgram = PathToCTranslator.translateSinglePath(targetPath);
            }
        } else {
            pathElements = ARGUtils.getAllStatesOnPathsTo(lastState);
            if (this.errorPathSourceFile != null) {
                pathProgram = PathToCTranslator.translatePaths(rootState, pathElements);
            }
        }
        if (pathProgram != null) {
            this.writeErrorPathFile(this.errorPathSourceFile, cexIndex, pathProgram);
        }
        this.writeErrorPathFile(this.errorPathGraphFile, cexIndex, new Appender(){

            public void appendTo(Appendable pAppendable) throws IOException {
                ARGToDotWriter.write(pAppendable, rootState, ARGUtils.CHILDREN_OF_STATE, (Predicate<? super ARGState>)Predicates.in((Collection)pathElements), (Predicate<? super Pair<ARGState, ARGState>>)isTargetPathEdge);
            }
        });
        this.writeErrorPathFile(this.errorPathAutomatonFile, cexIndex, new Appender(){

            public void appendTo(Appendable pAppendable) throws IOException {
                ARGUtils.producePathAutomaton(pAppendable, rootState, pathElements, "ErrorPath" + cexIndex, counterexample);
            }
        });
        if (counterexample != null) {
            if (counterexample.getTargetPathModel() != null) {
                this.writeErrorPathFile(this.errorPathAssignment, cexIndex, (Object)counterexample.getTargetPathModel());
            }
            for (Pair<Object, PathTemplate> info : counterexample.getAllFurtherInformation()) {
                if (info.getSecond() == null) continue;
                this.writeErrorPathFile((PathTemplate)info.getSecond(), cexIndex, info.getFirst());
            }
        }
        this.writeErrorPathFile(this.errorPathAutomatonGraphmlFile, cexIndex, new Appender(){

            public void appendTo(Appendable pAppendable) throws IOException {
                CEXExporter.this.witnessExporter.writePath(pAppendable, rootState, ARGUtils.CHILDREN_OF_STATE, (Predicate<? super ARGState>)Predicates.in((Collection)pathElements), counterexample);
            }
        });
    }

    private Appender createErrorPathWithVariableAssignmentInformation(final List<CFAEdge> edgePath, CounterexampleInfo counterexample) {
        final Model model = counterexample == null ? null : counterexample.getTargetPathModel();
        return new Appender(){

            public void appendTo(Appendable out) throws IOException {
                CFAPathWithAssumptions exactValuePath = model.getExactVariableValuePath(edgePath);
                if (exactValuePath != null) {
                    this.printPreciseValues(out, exactValuePath);
                } else {
                    this.printAllValues(out, edgePath);
                }
            }

            private void printAllValues(Appendable out, List<CFAEdge> pEdgePath) throws IOException {
                for (CFAEdge edge : FluentIterable.from(pEdgePath).filter(Predicates.notNull())) {
                    out.append(edge.toString());
                    out.append(System.lineSeparator());
                    for (Model.AssignableTerm term : model.getAllAssignedTerms(edge)) {
                        out.append('\t');
                        out.append(term.toString());
                        out.append(": ");
                        out.append(model.get(term).toString());
                        out.append(System.lineSeparator());
                    }
                }
            }

            private void printPreciseValues(Appendable out, CFAPathWithAssumptions pExactValuePath) throws IOException {
                for (CFAEdgeWithAssumptions edgeWithAssignments : FluentIterable.from((Iterable)pExactValuePath).filter(Predicates.notNull())) {
                    if (edgeWithAssignments instanceof CFAMultiEdgeWithAssumptions) {
                        for (CFAEdgeWithAssumptions singleEdge : (CFAMultiEdgeWithAssumptions)edgeWithAssignments) {
                            this.printPreciseValues(out, singleEdge);
                        }
                        continue;
                    }
                    this.printPreciseValues(out, edgeWithAssignments);
                }
            }

            private void printPreciseValues(Appendable out, CFAEdgeWithAssumptions edgeWithAssignments) throws IOException {
                String comment;
                out.append(edgeWithAssignments.getCFAEdge().toString());
                out.append(System.lineSeparator());
                String cCode = edgeWithAssignments.prettyPrintCode(1);
                if (!cCode.isEmpty()) {
                    out.append(cCode);
                }
                if (!(comment = edgeWithAssignments.getComment()).isEmpty()) {
                    out.append('\t');
                    out.append(comment);
                    out.append(System.lineSeparator());
                }
            }
        };
    }

    private ARGPath getTargetPath(ARGState targetState, @Nullable CounterexampleInfo counterexample) {
        ARGPath targetPath = null;
        if (counterexample != null) {
            targetPath = counterexample.getTargetPath();
        }
        if (targetPath == null) {
            targetPath = ARGUtils.getOnePathTo(targetState);
        }
        return targetPath;
    }

    private void writeErrorPathFile(PathTemplate template, int cexIndex, Object content) {
        if (template != null) {
            Path file = template.getPath(new Object[]{cexIndex});
            try {
                Files.writeFile((Path)file, (Object)content);
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write information about the error path to file");
            }
        }
    }

    private static Set<Pair<ARGState, ARGState>> getEdgesOfPath(ARGPath pPath) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)pPath.size());
        UnmodifiableIterator it = pPath.asStatesList().iterator();
        assert (it.hasNext());
        ARGState lastElement = (ARGState)it.next();
        while (it.hasNext()) {
            ARGState currentElement = (ARGState)it.next();
            result.add(Pair.of((Object)lastElement, (Object)currentElement));
            lastElement = currentElement;
        }
        return result;
    }

    public boolean shouldDumpErrorPathImmediately() {
        return this.dumpErrorPathImmediately;
    }
}

