/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.assumptions.genericassumptions;

import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.assumptions.genericassumptions.GenericAssumptionBuilder;

public class ArithmeticOverflowAssumptionBuilder
implements GenericAssumptionBuilder {
    public static final CIntegerLiteralExpression INT_MAX = new CIntegerLiteralExpression(FileLocation.DUMMY, CNumericTypes.INT, BigInteger.valueOf(Integer.MAX_VALUE));
    public static final CIntegerLiteralExpression INT_MIN = new CIntegerLiteralExpression(FileLocation.DUMMY, CNumericTypes.INT, BigInteger.valueOf(Integer.MIN_VALUE));

    private static Pair<CIntegerLiteralExpression, CIntegerLiteralExpression> boundsForType(CType typ) {
        if (typ instanceof CSimpleType) {
            CSimpleType btyp = (CSimpleType)typ;
            switch (btyp.getType()) {
                case INT: {
                    return Pair.of((Object)INT_MIN, (Object)INT_MAX);
                }
            }
        }
        return Pair.of(null, null);
    }

    private static void conjunctPredicateForArithmeticExpression(CExpression exp, List<CExpression> result) {
        ArithmeticOverflowAssumptionBuilder.conjunctPredicateForArithmeticExpression(exp.getExpressionType(), exp, result);
    }

    private static void conjunctPredicateForArithmeticExpression(CType typ, CExpression exp, List<CExpression> result) {
        Pair<CIntegerLiteralExpression, CIntegerLiteralExpression> bounds = ArithmeticOverflowAssumptionBuilder.boundsForType(typ);
        if (bounds.getFirst() != null) {
            result.add(new CBinaryExpression(FileLocation.DUMMY, null, null, exp, (CExpression)bounds.getFirst(), CBinaryExpression.BinaryOperator.GREATER_EQUAL));
        }
        if (bounds.getSecond() != null) {
            result.add(new CBinaryExpression(FileLocation.DUMMY, null, null, exp, (CExpression)bounds.getSecond(), CBinaryExpression.BinaryOperator.LESS_EQUAL));
        }
    }

    private static void visit(CExpression pExpression, List<CExpression> result) {
        if (pExpression instanceof CIdExpression) {
            ArithmeticOverflowAssumptionBuilder.conjunctPredicateForArithmeticExpression(pExpression, result);
        } else if (pExpression instanceof CBinaryExpression) {
            CBinaryExpression binexp = (CBinaryExpression)pExpression;
            CExpression op1 = binexp.getOperand1();
            if (op1 instanceof CIdExpression) {
                ArithmeticOverflowAssumptionBuilder.conjunctPredicateForArithmeticExpression(op1, result);
            }
        } else if (pExpression instanceof CUnaryExpression) {
            CUnaryExpression unexp = (CUnaryExpression)pExpression;
            CExpression op1 = unexp.getOperand();
            if (op1 instanceof CIdExpression) {
                ArithmeticOverflowAssumptionBuilder.conjunctPredicateForArithmeticExpression(op1, result);
            }
        } else if (pExpression instanceof CCastExpression) {
            CCastExpression castexp = (CCastExpression)pExpression;
            CType toType = castexp.getExpressionType();
            ArithmeticOverflowAssumptionBuilder.conjunctPredicateForArithmeticExpression(toType, castexp.getOperand(), result);
        }
    }

    @Override
    public List<CExpression> assumptionsForEdge(CFAEdge pEdge) {
        ArrayList result = Lists.newArrayList();
        switch (pEdge.getEdgeType()) {
            case AssumeEdge: {
                CAssumeEdge assumeEdge = (CAssumeEdge)pEdge;
                ArithmeticOverflowAssumptionBuilder.visit(assumeEdge.getExpression(), result);
                break;
            }
            case FunctionCallEdge: {
                CFunctionCallEdge fcallEdge = (CFunctionCallEdge)pEdge;
                if (fcallEdge.getArguments().isEmpty()) break;
                CFunctionEntryNode fdefnode = fcallEdge.getSuccessor();
                List<CParameterDeclaration> formalParams = fdefnode.getFunctionParameters();
                for (CParameterDeclaration paramdecl : formalParams) {
                    CIdExpression exp = new CIdExpression(paramdecl.getFileLocation(), paramdecl);
                    ArithmeticOverflowAssumptionBuilder.visit(exp, result);
                }
                break;
            }
            case StatementEdge: {
                CStatementEdge stmtEdge = (CStatementEdge)pEdge;
                CStatement stmt = stmtEdge.getStatement();
                if (!(stmt instanceof CAssignment)) break;
                ArithmeticOverflowAssumptionBuilder.visit(((CAssignment)stmt).getLeftHandSide(), result);
                break;
            }
            case ReturnStatementEdge: {
                CReturnStatementEdge returnEdge = (CReturnStatementEdge)pEdge;
                if (!returnEdge.getExpression().isPresent()) break;
                ArithmeticOverflowAssumptionBuilder.visit((CExpression)returnEdge.getExpression().get(), result);
                break;
            }
        }
        return result;
    }
}

