/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.assumptions.storage;

import com.google.common.base.Preconditions;
import org.sosy_lab.common.Appender;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

public class AssumptionStorageState
implements AbstractState {
    private final BooleanFormula assumption;
    private final BooleanFormula stopFormula;
    private final FormulaManagerView fmgr;

    public AssumptionStorageState(FormulaManagerView pFmgr, BooleanFormula pAssumption, BooleanFormula pStopFormula) {
        this.assumption = (BooleanFormula)Preconditions.checkNotNull((Object)pAssumption);
        this.stopFormula = (BooleanFormula)Preconditions.checkNotNull((Object)pStopFormula);
        this.fmgr = pFmgr;
        assert (!this.fmgr.getBooleanFormulaManager().isFalse(this.assumption));
    }

    public BooleanFormula getAssumption() {
        return this.assumption;
    }

    public Appender getAssumptionAsString() {
        return this.fmgr.dumpFormula(this.assumption);
    }

    public boolean isAssumptionTrue() {
        return this.fmgr.getBooleanFormulaManager().isTrue(this.assumption);
    }

    public boolean isAssumptionFalse() {
        return this.fmgr.getBooleanFormulaManager().isFalse(this.assumption);
    }

    public BooleanFormula getStopFormula() {
        return this.stopFormula;
    }

    public boolean isStopFormulaTrue() {
        return this.fmgr.getBooleanFormulaManager().isTrue(this.stopFormula);
    }

    public boolean isStopFormulaFalse() {
        return this.fmgr.getBooleanFormulaManager().isFalse(this.stopFormula);
    }

    public String toString() {
        return (this.fmgr.getBooleanFormulaManager().isTrue(this.stopFormula) ? "" : "<STOP> ") + "assume: (" + this.assumption + " & " + this.stopFormula + ")";
    }

    public boolean isStop() {
        return !this.fmgr.getBooleanFormulaManager().isTrue(this.stopFormula);
    }

    public boolean equals(Object other) {
        if (other instanceof AssumptionStorageState) {
            AssumptionStorageState otherElement = (AssumptionStorageState)other;
            return this.assumption.equals(otherElement.assumption) && this.stopFormula.equals(otherElement.stopFormula);
        }
        return false;
    }

    public int hashCode() {
        return this.assumption.hashCode() + 17 * this.stopFormula.hashCode();
    }
}

