/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.assumptions.storage;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AssumptionReportingState;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AvoidanceReportingState;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaConverter;

public class AssumptionStorageTransferRelation
extends SingleEdgeTransferRelation {
    private final CtoFormulaConverter converter;
    private final FormulaManagerView formulaManager;
    private final Collection<AbstractState> topStateSet;

    public AssumptionStorageTransferRelation(CtoFormulaConverter pConverter, FormulaManagerView pFormulaManager, AbstractState pTopState) {
        this.converter = pConverter;
        this.formulaManager = pFormulaManager;
        this.topStateSet = Collections.singleton(pTopState);
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pElement, Precision pPrecision, CFAEdge pCfaEdge) {
        AssumptionStorageState element = (AssumptionStorageState)pElement;
        if (element.isStop()) {
            return Collections.emptySet();
        }
        return this.topStateSet;
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState el, List<AbstractState> others, CFAEdge edge, Precision p) throws CPATransferException, InterruptedException {
        AssumptionStorageState asmptStorageElem = (AssumptionStorageState)el;
        BooleanFormulaManagerView bfmgr = this.formulaManager.getBooleanFormulaManager();
        assert (bfmgr.isTrue(asmptStorageElem.getAssumption()));
        assert (bfmgr.isTrue(asmptStorageElem.getStopFormula()));
        String function = edge.getSuccessor() != null ? edge.getSuccessor().getFunctionName() : null;
        BooleanFormula assumption = bfmgr.makeBoolean(true);
        BooleanFormula stopFormula = bfmgr.makeBoolean(false);
        boolean stop = false;
        for (AbstractState element : AbstractStates.asFlatIterable(others)) {
            AvoidanceReportingState e;
            if (element instanceof AssumptionReportingState) {
                List<CExpression> assumptions = ((AssumptionReportingState)((Object)element)).getAssumptions();
                for (CExpression inv : assumptions) {
                    BooleanFormula invFormula = this.converter.makePredicate(inv, edge, function, SSAMap.emptySSAMap().builder());
                    assumption = bfmgr.and(assumption, this.formulaManager.uninstantiate(invFormula));
                }
            }
            if (!(element instanceof AvoidanceReportingState) || !(e = (AvoidanceReportingState)element).mustDumpAssumptionForAvoidance()) continue;
            stopFormula = bfmgr.or(stopFormula, e.getReasonFormula(this.formulaManager));
            stop = true;
        }
        Preconditions.checkState((!bfmgr.isTrue(stopFormula) ? 1 : 0) != 0);
        if (!stop) {
            stopFormula = bfmgr.makeBoolean(true);
        }
        if (bfmgr.isTrue(assumption) && bfmgr.isTrue(stopFormula)) {
            return null;
        }
        return Collections.singleton(new AssumptionStorageState(this.formulaManager, assumption, stopFormula));
    }
}

