/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.ast.c.CAddressOfLabelExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatementVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpressionArguments;
import org.sosy_lab.cpachecker.cpa.automaton.InvalidAutomatonException;
import org.sosy_lab.cpachecker.exceptions.CParserException;
import org.sosy_lab.cpachecker.exceptions.ParserException;

class AutomatonASTComparator {
    private static final String JOKER_EXPR = "CPAchecker_AutomatonAnalysis_JokerExpression";
    private static final String NUMBERED_JOKER_EXPR = "CPAchecker_AutomatonAnalysis_JokerExpression_Num";
    private static final Pattern NUMBERED_JOKER_PATTERN = Pattern.compile("\\$\\d+");

    AutomatonASTComparator() {
    }

    static ASTMatcher generatePatternAST(String pPattern, CParser parser, Scope scope) throws InvalidAutomatonException, InvalidConfigurationException {
        String tmp = AutomatonASTComparator.addFunctionDeclaration(AutomatonASTComparator.replaceJokersInPattern(pPattern));
        return AutomatonASTComparator.parse(tmp, parser, scope).accept(ASTMatcherGenerator.INSTANCE);
    }

    static CStatement generateSourceAST(String pSource, CParser parser, Scope scope) throws InvalidAutomatonException, InvalidConfigurationException {
        String tmp = AutomatonASTComparator.addFunctionDeclaration(pSource);
        return AutomatonASTComparator.parse(tmp, parser, scope);
    }

    static List<CStatement> generateSourceASTOfBlock(String pSource, CParser parser, Scope scope) throws InvalidAutomatonException, InvalidConfigurationException, CParserException {
        String tmp = AutomatonASTComparator.addFunctionDeclaration(pSource);
        return AutomatonASTComparator.parseBlockOfStatements(tmp, parser, scope);
    }

    @VisibleForTesting
    static String replaceJokersInPattern(String pPattern) {
        String tmp = pPattern.replaceAll("\\$\\?", " CPAchecker_AutomatonAnalysis_JokerExpression ");
        Matcher matcher = NUMBERED_JOKER_PATTERN.matcher(tmp);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(result, "");
            String key = tmp.substring(matcher.start() + 1, matcher.end());
            try {
                int varKey = Integer.parseInt(key);
                result.append(" CPAchecker_AutomatonAnalysis_JokerExpression_Num" + varKey + " ");
            }
            catch (NumberFormatException e) {
                result.append(matcher.group());
            }
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static String addFunctionDeclaration(String pBody) {
        if (pBody.trim().endsWith(";")) {
            return "void test() { " + pBody + "}";
        }
        return "void test() { " + pBody + ";}";
    }

    private static CStatement parse(String code, CParser parser, Scope scope) throws InvalidAutomatonException, InvalidConfigurationException {
        try {
            CAstNode statement = parser.parseSingleStatement(code, scope);
            if (!(statement instanceof CStatement)) {
                throw new InvalidAutomatonException("Not a valid statement: " + statement.toASTString());
            }
            return (CStatement)statement;
        }
        catch (ParserException e) {
            throw new InvalidAutomatonException("Error during parsing C code \"" + code + "\": " + e.getMessage());
        }
    }

    private static List<CStatement> parseBlockOfStatements(String code, CParser parser, Scope scope) throws InvalidAutomatonException, InvalidConfigurationException, CParserException {
        List<CAstNode> statements = parser.parseStatements(code, scope);
        for (CAstNode statement : statements) {
            if (statement instanceof CStatement) continue;
            throw new InvalidAutomatonException("Code in assumption: <" + statement.toASTString() + "> is not a valid assumption.");
        }
        Function<CAstNode, CStatement> function = new Function<CAstNode, CStatement>(){

            public CStatement apply(CAstNode statement) {
                return (CStatement)statement;
            }
        };
        return ImmutableList.copyOf((Collection)Lists.transform(statements, (Function)function));
    }

    private static class FunctionCallExpressionMatcher
    extends FunctionCallWildcardExpressionMatcher {
        private final List<ASTMatcher> parameterPatterns;

        protected FunctionCallExpressionMatcher(CFunctionCallExpression pPattern, ASTMatcher pFunctionNameExpression, List<ASTMatcher> pParameterPatterns) {
            super(pPattern, pFunctionNameExpression);
            this.parameterPatterns = pParameterPatterns;
        }

        @Override
        protected boolean matches2(CFunctionCallExpression pSource, AutomatonExpressionArguments pArg) {
            if (!super.matches2(pSource, pArg)) {
                return false;
            }
            if (this.parameterPatterns.size() != pSource.getParameterExpressions().size()) {
                return false;
            }
            for (Pair parameters : Pair.zipList(this.parameterPatterns, pSource.getParameterExpressions())) {
                if (((ASTMatcher)parameters.getFirst()).matches((CAstNode)parameters.getSecond(), pArg)) continue;
                return false;
            }
            return true;
        }

        @Override
        protected CExpression getOperandFrom(CFunctionCallExpression pSource) {
            return pSource.getFunctionNameExpression();
        }
    }

    private static class FunctionCallWildcardExpressionMatcher
    extends OneOperandExpressionMatcher<CFunctionCallExpression, Void> {
        protected FunctionCallWildcardExpressionMatcher(CFunctionCallExpression pPattern, ASTMatcher pFunctionNameExpression) {
            super(CFunctionCallExpression.class, pPattern, pFunctionNameExpression);
        }

        protected CExpression getOperandFrom(CFunctionCallExpression pSource) {
            return pSource.getFunctionNameExpression();
        }
    }

    private static class AddressOfLabelExpressionMatcher
    extends ExpressionWithFieldMatcher<CAddressOfLabelExpression, String> {
        public AddressOfLabelExpressionMatcher(CAddressOfLabelExpression pPattern) {
            super(CAddressOfLabelExpression.class, pPattern);
        }

        @Override
        protected String getFieldValueFrom(CAddressOfLabelExpression pSource) {
            return pSource.getLabelName();
        }
    }

    private static class TypeIdExpressionMatcher
    extends ExpressionWithFieldMatcher<CTypeIdExpression, CType> {
        private final CTypeIdExpression.TypeIdOperator operator;

        public TypeIdExpressionMatcher(CTypeIdExpression pPattern) {
            super(CTypeIdExpression.class, pPattern);
            this.operator = pPattern.getOperator();
        }

        @Override
        protected boolean matches2(CTypeIdExpression pSource, AutomatonExpressionArguments pArg) {
            return Objects.equals((Object)this.operator, (Object)pSource.getOperator()) && super.matches2(pSource, pArg);
        }

        @Override
        protected CType getFieldValueFrom(CTypeIdExpression pSource) {
            return pSource.getType();
        }
    }

    private static class PointerExpressionMatcher
    extends OneOperandExpressionMatcher<CPointerExpression, Void> {
        public PointerExpressionMatcher(CPointerExpression pPattern, ASTMatcher pOperand) {
            super(CPointerExpression.class, pPattern, pOperand);
        }

        protected CExpression getOperandFrom(CPointerExpression pSource) {
            return pSource.getOperand();
        }
    }

    private static class UnaryExpressionMatcher
    extends OneOperandExpressionMatcher<CUnaryExpression, CUnaryExpression.UnaryOperator> {
        public UnaryExpressionMatcher(CUnaryExpression pPattern, ASTMatcher pOperand) {
            super(CUnaryExpression.class, pPattern, pOperand);
        }

        protected CExpression getOperandFrom(CUnaryExpression pSource) {
            return pSource.getOperand();
        }

        @Override
        protected CUnaryExpression.UnaryOperator getFieldValueFrom(CUnaryExpression pSource) {
            return pSource.getOperator();
        }
    }

    private static class CIdExpressionMatcher
    extends ExpressionWithFieldMatcher<CIdExpression, String> {
        public CIdExpressionMatcher(CIdExpression pPattern) {
            super(CIdExpression.class, pPattern);
        }

        @Override
        protected String getFieldValueFrom(CIdExpression pSource) {
            return pSource.getName();
        }
    }

    private static class FieldReferenceMatcher
    extends OneOperandExpressionMatcher<CFieldReference, String> {
        public FieldReferenceMatcher(CFieldReference pPattern, ASTMatcher pOperand) {
            super(CFieldReference.class, pPattern, pOperand);
        }

        protected CExpression getOperandFrom(CFieldReference pSource) {
            return pSource.getFieldOwner();
        }

        @Override
        protected String getFieldValueFrom(CFieldReference pSource) {
            return pSource.getFieldName();
        }
    }

    private static class ComplexCastExpressionMatcher
    extends OneOperandExpressionWithTwoFieldsMatcher<CComplexCastExpression, Boolean, CType> {
        public ComplexCastExpressionMatcher(CComplexCastExpression pPattern, ASTMatcher pOperand) {
            super(CComplexCastExpression.class, pPattern, pOperand);
        }

        protected CExpression getOperandFrom(CComplexCastExpression pSource) {
            return pSource.getOperand();
        }

        @Override
        protected Boolean getFieldValue1From(CComplexCastExpression pSource) {
            return pSource.isRealCast();
        }

        @Override
        protected CType getFieldValue2From(CComplexCastExpression pSource) {
            return pSource.getType();
        }
    }

    private static class CastExpressionMatcher
    extends OneOperandExpressionMatcher<CCastExpression, CType> {
        public CastExpressionMatcher(CCastExpression pPattern, ASTMatcher pOperand) {
            super(CCastExpression.class, pPattern, pOperand);
        }

        protected CExpression getOperandFrom(CCastExpression pSource) {
            return pSource.getOperand();
        }

        @Override
        protected CType getFieldValueFrom(CCastExpression pSource) {
            return pSource.getExpressionType();
        }
    }

    private static class BinaryExpressionMatcher
    extends TwoOperandExpressionMatcher<CBinaryExpression, CBinaryExpression.BinaryOperator> {
        public BinaryExpressionMatcher(CBinaryExpression pPattern, ASTMatcher pOperand1, ASTMatcher pOperand2) {
            super(CBinaryExpression.class, pPattern, pOperand1, pOperand2);
        }

        protected CExpression getOperand1From(CBinaryExpression pSource) {
            return pSource.getOperand1();
        }

        protected CExpression getOperand2From(CBinaryExpression pSource) {
            return pSource.getOperand2();
        }

        @Override
        protected CBinaryExpression.BinaryOperator getFieldValueFrom(CBinaryExpression pSource) {
            return pSource.getOperator();
        }
    }

    private static class ArraySubscriptExpressionMatcher
    extends TwoOperandExpressionMatcher<CArraySubscriptExpression, Void> {
        public ArraySubscriptExpressionMatcher(CArraySubscriptExpression pPattern, ASTMatcher pOperand1, ASTMatcher pOperand2) {
            super(CArraySubscriptExpression.class, pPattern, pOperand1, pOperand2);
        }

        protected CExpression getOperand1From(CArraySubscriptExpression pSource) {
            return pSource.getArrayExpression();
        }

        protected CExpression getOperand2From(CArraySubscriptExpression pSource) {
            return pSource.getSubscriptExpression();
        }
    }

    private static class NumberedJokerMatcher
    implements ASTMatcher {
        private final int number;

        public NumberedJokerMatcher(int pNumber) {
            this.number = pNumber;
        }

        @Override
        public boolean matches(CAstNode pSource, AutomatonExpressionArguments pArgs) {
            String value = pSource.toASTString();
            pArgs.putTransitionVariable(this.number, value);
            return true;
        }

        public String toString() {
            return "$" + this.number;
        }
    }

    private static enum JokerMatcher implements ASTMatcher
    {
        INSTANCE;


        @Override
        public boolean matches(CAstNode pSource, AutomatonExpressionArguments pArgs) {
            return true;
        }

        public String toString() {
            return "$?";
        }
    }

    private static abstract class TwoOperandExpressionMatcher<T extends CAstNode, F>
    extends ExpressionWithFieldMatcher<T, F> {
        private final ASTMatcher operand1;
        private final ASTMatcher operand2;

        protected TwoOperandExpressionMatcher(Class<T> pCls, T pPattern, ASTMatcher pOperand1, ASTMatcher pOperand2) {
            super(pCls, pPattern);
            this.operand1 = pOperand1;
            this.operand2 = pOperand2;
        }

        @Override
        public final boolean matches2(T pSource, AutomatonExpressionArguments pArgs) {
            return super.matches2(pSource, pArgs) && this.operand1.matches(this.getOperand1From(pSource), pArgs) && this.operand2.matches(this.getOperand2From(pSource), pArgs);
        }

        protected abstract CRightHandSide getOperand1From(T var1);

        protected abstract CRightHandSide getOperand2From(T var1);
    }

    private static abstract class OneOperandExpressionWithTwoFieldsMatcher<T extends CAstNode, F, G>
    extends ExpressionWithTwoFieldsMatcher<T, F, G> {
        private final ASTMatcher operand;

        protected OneOperandExpressionWithTwoFieldsMatcher(Class<T> pCls, T pPattern, ASTMatcher pOperand) {
            super(pCls, pPattern);
            this.operand = pOperand;
        }

        @Override
        protected boolean matches2(T pSource, AutomatonExpressionArguments pArgs) {
            return super.matches2(pSource, pArgs) && this.operand.matches(this.getOperandFrom(pSource), pArgs);
        }

        protected abstract CRightHandSide getOperandFrom(T var1);
    }

    private static abstract class OneOperandExpressionMatcher<T extends CAstNode, F>
    extends ExpressionWithFieldMatcher<T, F> {
        private final ASTMatcher operand;

        protected OneOperandExpressionMatcher(Class<T> pCls, T pPattern, ASTMatcher pOperand) {
            super(pCls, pPattern);
            this.operand = pOperand;
        }

        @Override
        protected boolean matches2(T pSource, AutomatonExpressionArguments pArgs) {
            return super.matches2(pSource, pArgs) && this.operand.matches(this.getOperandFrom(pSource), pArgs);
        }

        protected abstract CRightHandSide getOperandFrom(T var1);
    }

    private static abstract class ExpressionWithTwoFieldsMatcher<T extends CAstNode, F, G>
    extends CheckedExpressionMatcher<T> {
        private final F field1;
        private final G field2;

        protected ExpressionWithTwoFieldsMatcher(Class<T> pCls, T pPattern) {
            super(pCls, pPattern);
            this.field1 = this.getFieldValue1From(pPattern);
            this.field2 = this.getFieldValue2From(pPattern);
        }

        @Override
        protected boolean matches2(T pSource, AutomatonExpressionArguments pArg) {
            return Objects.equals(this.field1, this.getFieldValue1From(pSource)) && Objects.equals(this.field2, this.getFieldValue2From(pSource));
        }

        protected F getFieldValue1From(T pSource) {
            return null;
        }

        protected G getFieldValue2From(T pSource) {
            return null;
        }
    }

    private static abstract class ExpressionWithFieldMatcher<T extends CAstNode, F>
    extends CheckedExpressionMatcher<T> {
        private final F field;

        protected ExpressionWithFieldMatcher(Class<T> pCls, T pPattern) {
            super(pCls, pPattern);
            this.field = this.getFieldValueFrom(pPattern);
        }

        @Override
        protected boolean matches2(T pSource, AutomatonExpressionArguments pArg) {
            return Objects.equals(this.field, this.getFieldValueFrom(pSource));
        }

        protected F getFieldValueFrom(T pSource) {
            return null;
        }
    }

    private static abstract class CheckedExpressionMatcher<T extends CAstNode>
    implements ASTMatcher {
        private final Class<T> cls;
        private final String rawSignature;

        protected CheckedExpressionMatcher(Class<T> pCls, T pPattern) {
            assert (pCls.isInstance(pPattern));
            this.cls = pCls;
            this.rawSignature = pPattern.toASTString();
        }

        @Override
        public final boolean matches(CAstNode pSource, AutomatonExpressionArguments pArgs) {
            if (this.cls.isInstance(pSource)) {
                return this.matches2((CAstNode)this.cls.cast(pSource), pArgs);
            }
            return false;
        }

        protected abstract boolean matches2(T var1, AutomatonExpressionArguments var2);

        public String toString() {
            return this.rawSignature;
        }
    }

    private static enum ASTMatcherGenerator implements CRightHandSideVisitor<ASTMatcher, InvalidAutomatonException>,
    CStatementVisitor<ASTMatcher, InvalidAutomatonException>
    {
        INSTANCE;


        @Override
        public ASTMatcher visit(CIdExpression exp) throws InvalidAutomatonException {
            String name = exp.getName();
            if (name.equals(AutomatonASTComparator.JOKER_EXPR)) {
                return JokerMatcher.INSTANCE;
            }
            if (name.startsWith(AutomatonASTComparator.NUMBERED_JOKER_EXPR)) {
                String s = name.substring(AutomatonASTComparator.NUMBERED_JOKER_EXPR.length());
                int i = Integer.parseInt(s);
                return new NumberedJokerMatcher(i);
            }
            return new CIdExpressionMatcher(exp);
        }

        @Override
        public ASTMatcher visit(CArraySubscriptExpression exp) throws InvalidAutomatonException {
            return new ArraySubscriptExpressionMatcher(exp, exp.getArrayExpression().accept(this), exp.getSubscriptExpression().accept(this));
        }

        @Override
        public ASTMatcher visit(CBinaryExpression exp) throws InvalidAutomatonException {
            return new BinaryExpressionMatcher(exp, exp.getOperand1().accept(this), exp.getOperand2().accept(this));
        }

        @Override
        public ASTMatcher visit(CCastExpression exp) throws InvalidAutomatonException {
            return new CastExpressionMatcher(exp, exp.getOperand().accept(this));
        }

        @Override
        public ASTMatcher visit(CComplexCastExpression exp) throws InvalidAutomatonException {
            return new ComplexCastExpressionMatcher(exp, exp.getOperand().accept(this));
        }

        @Override
        public ASTMatcher visit(CFieldReference exp) throws InvalidAutomatonException {
            return new FieldReferenceMatcher(exp, exp.getFieldOwner().accept(this));
        }

        @Override
        public ASTMatcher visit(CCharLiteralExpression exp) throws InvalidAutomatonException {
            return new ExpressionWithFieldMatcher<CCharLiteralExpression, Character>(CCharLiteralExpression.class, exp){

                @Override
                protected Character getFieldValueFrom(CCharLiteralExpression pSource) {
                    return Character.valueOf(pSource.getCharacter());
                }
            };
        }

        @Override
        public ASTMatcher visit(CFloatLiteralExpression exp) throws InvalidAutomatonException {
            return new ExpressionWithFieldMatcher<CFloatLiteralExpression, BigDecimal>(CFloatLiteralExpression.class, exp){

                @Override
                protected BigDecimal getFieldValueFrom(CFloatLiteralExpression pSource) {
                    return pSource.getValue();
                }
            };
        }

        @Override
        public ASTMatcher visit(CImaginaryLiteralExpression exp) throws InvalidAutomatonException {
            return new ExpressionWithFieldMatcher<CImaginaryLiteralExpression, CLiteralExpression>(CImaginaryLiteralExpression.class, exp){

                @Override
                protected CLiteralExpression getFieldValueFrom(CImaginaryLiteralExpression pSource) {
                    return pSource.getValue();
                }
            };
        }

        @Override
        public ASTMatcher visit(CIntegerLiteralExpression exp) throws InvalidAutomatonException {
            return new ExpressionWithFieldMatcher<CIntegerLiteralExpression, BigInteger>(CIntegerLiteralExpression.class, exp){

                @Override
                protected BigInteger getFieldValueFrom(CIntegerLiteralExpression pSource) {
                    return pSource.getValue();
                }
            };
        }

        @Override
        public ASTMatcher visit(CStringLiteralExpression exp) throws InvalidAutomatonException {
            return new ExpressionWithFieldMatcher<CStringLiteralExpression, String>(CStringLiteralExpression.class, exp){

                @Override
                protected String getFieldValueFrom(CStringLiteralExpression pSource) {
                    return pSource.getValue();
                }
            };
        }

        @Override
        public ASTMatcher visit(CTypeIdExpression exp) {
            return new TypeIdExpressionMatcher(exp);
        }

        @Override
        public ASTMatcher visit(CUnaryExpression exp) throws InvalidAutomatonException {
            return new UnaryExpressionMatcher(exp, exp.getOperand().accept(this));
        }

        @Override
        public ASTMatcher visit(CPointerExpression exp) throws InvalidAutomatonException {
            return new PointerExpressionMatcher(exp, exp.getOperand().accept(this));
        }

        @Override
        public ASTMatcher visit(CAddressOfLabelExpression exp) throws InvalidAutomatonException {
            return new AddressOfLabelExpressionMatcher(exp);
        }

        @Override
        public ASTMatcher visit(CFunctionCallExpression exp) throws InvalidAutomatonException {
            ArrayList<ASTMatcher> parameterPatterns = new ArrayList<ASTMatcher>(exp.getParameterExpressions().size());
            for (CExpression parameter : exp.getParameterExpressions()) {
                parameterPatterns.add(parameter.accept(this));
            }
            ASTMatcher functionNamePattern = exp.getFunctionNameExpression().accept(this);
            if (parameterPatterns.size() == 1 && parameterPatterns.get(0) == JokerMatcher.INSTANCE) {
                return new FunctionCallWildcardExpressionMatcher(exp, functionNamePattern);
            }
            return new FunctionCallExpressionMatcher(exp, functionNamePattern, parameterPatterns);
        }

        @Override
        public ASTMatcher visit(CExpressionStatement stmt) throws InvalidAutomatonException {
            return new OneOperandExpressionMatcher<CExpressionStatement, Void>(CExpressionStatement.class, stmt, stmt.getExpression().accept(this)){

                protected CExpression getOperandFrom(CExpressionStatement pSource) {
                    return pSource.getExpression();
                }
            };
        }

        private ASTMatcher visit(final CAssignment stmt) throws InvalidAutomatonException {
            final ASTMatcher leftHandSide = stmt.getLeftHandSide().accept(this);
            final ASTMatcher rightHandSide = stmt.getRightHandSide().accept(this);
            if (rightHandSide == JokerMatcher.INSTANCE) {
                return new ASTMatcher(){

                    @Override
                    public boolean matches(CAstNode pSource, AutomatonExpressionArguments pArgs) {
                        if (pSource instanceof CAssignment) {
                            CAssignment source = (CAssignment)pSource;
                            return leftHandSide.matches(source.getLeftHandSide(), pArgs);
                        }
                        return false;
                    }

                    public String toString() {
                        return stmt.toASTString();
                    }
                };
            }
            return new ASTMatcher(){

                @Override
                public boolean matches(CAstNode pSource, AutomatonExpressionArguments pArgs) {
                    if (pSource instanceof CAssignment) {
                        CAssignment source = (CAssignment)pSource;
                        return leftHandSide.matches(source.getLeftHandSide(), pArgs) && rightHandSide.matches(source.getRightHandSide(), pArgs);
                    }
                    return false;
                }

                public String toString() {
                    return stmt.toASTString();
                }
            };
        }

        @Override
        public ASTMatcher visit(CExpressionAssignmentStatement stmt) throws InvalidAutomatonException {
            return this.visit((CAssignment)stmt);
        }

        @Override
        public ASTMatcher visit(CFunctionCallAssignmentStatement stmt) throws InvalidAutomatonException {
            return this.visit((CAssignment)stmt);
        }

        @Override
        public ASTMatcher visit(CFunctionCallStatement stmt) throws InvalidAutomatonException {
            return new OneOperandExpressionMatcher<CFunctionCallStatement, Void>(CFunctionCallStatement.class, stmt, stmt.getFunctionCallExpression().accept(this)){

                @Override
                protected CRightHandSide getOperandFrom(CFunctionCallStatement pSource) {
                    return pSource.getFunctionCallExpression();
                }
            };
        }
    }

    static interface ASTMatcher {
        public boolean matches(CAstNode var1, AutomatonExpressionArguments var2);
    }
}

