/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.AAstNode;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CLabelNode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonASTComparator;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpression;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpressionArguments;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonIntExpr;
import org.sosy_lab.cpachecker.cpa.automaton.InvalidAutomatonException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.SourceLocationMapper;
import org.sosy_lab.cpachecker.util.automaton.AutomatonGraphmlCommon;

interface AutomatonBoolExpr
extends AutomatonExpression {
    public static final AutomatonExpression.ResultValue<Boolean> CONST_TRUE = new AutomatonExpression.ResultValue<Boolean>(Boolean.TRUE);
    public static final AutomatonExpression.ResultValue<Boolean> CONST_FALSE = new AutomatonExpression.ResultValue<Boolean>(Boolean.FALSE);
    public static final AutomatonBoolExpr TRUE = new AutomatonBoolExpr(){

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            return CONST_TRUE;
        }

        public String toString() {
            return "TRUE";
        }
    };
    public static final AutomatonBoolExpr FALSE = new AutomatonBoolExpr(){

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            return CONST_FALSE;
        }

        public String toString() {
            return "FALSE";
        }
    };

    public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments var1) throws CPATransferException;

    public static class BoolNotEqTest
    implements AutomatonBoolExpr {
        private final AutomatonBoolExpr a;
        private final AutomatonBoolExpr b;

        public BoolNotEqTest(AutomatonBoolExpr pA, AutomatonBoolExpr pB) {
            this.a = pA;
            this.b = pB;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) throws CPATransferException {
            AutomatonExpression.ResultValue<Boolean> resA = this.a.eval(pArgs);
            if (resA.canNotEvaluate()) {
                return resA;
            }
            AutomatonExpression.ResultValue<Boolean> resB = this.b.eval(pArgs);
            if (resB.canNotEvaluate()) {
                return resB;
            }
            if (!resA.getValue().equals(resB.getValue())) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return this.a + " != " + this.b;
        }
    }

    public static class BoolEqTest
    implements AutomatonBoolExpr {
        private final AutomatonBoolExpr a;
        private final AutomatonBoolExpr b;

        public BoolEqTest(AutomatonBoolExpr pA, AutomatonBoolExpr pB) {
            this.a = pA;
            this.b = pB;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) throws CPATransferException {
            AutomatonExpression.ResultValue<Boolean> resA = this.a.eval(pArgs);
            if (resA.canNotEvaluate()) {
                return resA;
            }
            AutomatonExpression.ResultValue<Boolean> resB = this.b.eval(pArgs);
            if (resB.canNotEvaluate()) {
                return resB;
            }
            if (resA.getValue().equals(resB.getValue())) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return this.a + " == " + this.b;
        }
    }

    public static class Negation
    implements AutomatonBoolExpr {
        private final AutomatonBoolExpr a;

        public Negation(AutomatonBoolExpr pA) {
            this.a = pA;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) throws CPATransferException {
            AutomatonExpression.ResultValue<Boolean> resA = this.a.eval(pArgs);
            if (resA.canNotEvaluate()) {
                return resA;
            }
            if (resA.getValue().equals(Boolean.TRUE)) {
                return CONST_FALSE;
            }
            return CONST_TRUE;
        }

        public String toString() {
            return "!" + this.a;
        }

        public AutomatonBoolExpr getA() {
            return this.a;
        }
    }

    public static class And
    implements AutomatonBoolExpr {
        private final AutomatonBoolExpr a;
        private final AutomatonBoolExpr b;

        public And(AutomatonBoolExpr pA, AutomatonBoolExpr pB) {
            this.a = pA;
            this.b = pB;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) throws CPATransferException {
            AutomatonExpression.ResultValue<Boolean> resA = this.a.eval(pArgs);
            if (resA.canNotEvaluate()) {
                AutomatonExpression.ResultValue<Boolean> resB = this.b.eval(pArgs);
                if (!resB.canNotEvaluate() && resB.getValue().equals(Boolean.FALSE)) {
                    return resB;
                }
                return resA;
            }
            if (resA.getValue().equals(Boolean.FALSE)) {
                return resA;
            }
            AutomatonExpression.ResultValue<Boolean> resB = this.b.eval(pArgs);
            if (resB.canNotEvaluate()) {
                return resB;
            }
            if (resB.getValue().equals(Boolean.FALSE)) {
                return resB;
            }
            return resA;
        }

        public String toString() {
            return "(" + this.a + " && " + this.b + ")";
        }

        public AutomatonBoolExpr getA() {
            return this.a;
        }

        public AutomatonBoolExpr getB() {
            return this.b;
        }
    }

    public static class Or
    implements AutomatonBoolExpr {
        private final AutomatonBoolExpr a;
        private final AutomatonBoolExpr b;

        public Or(AutomatonBoolExpr pA, AutomatonBoolExpr pB) {
            this.a = pA;
            this.b = pB;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) throws CPATransferException {
            AutomatonExpression.ResultValue<Boolean> resA = this.a.eval(pArgs);
            if (resA.canNotEvaluate()) {
                AutomatonExpression.ResultValue<Boolean> resB = this.b.eval(pArgs);
                if (!resB.canNotEvaluate() && resB.getValue().equals(Boolean.TRUE)) {
                    return resB;
                }
                return resA;
            }
            if (resA.getValue().equals(Boolean.TRUE)) {
                return resA;
            }
            AutomatonExpression.ResultValue<Boolean> resB = this.b.eval(pArgs);
            if (resB.canNotEvaluate()) {
                return resB;
            }
            if (resB.getValue().equals(Boolean.TRUE)) {
                return resB;
            }
            return resA;
        }

        public String toString() {
            return "(" + this.a + " || " + this.b + ")";
        }

        public AutomatonBoolExpr getA() {
            return this.a;
        }

        public AutomatonBoolExpr getB() {
            return this.b;
        }
    }

    public static class IntNotEqTest
    implements AutomatonBoolExpr {
        private final AutomatonIntExpr a;
        private final AutomatonIntExpr b;

        public IntNotEqTest(AutomatonIntExpr pA, AutomatonIntExpr pB) {
            this.a = pA;
            this.b = pB;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            AutomatonExpression.ResultValue<Integer> resA = this.a.eval(pArgs);
            AutomatonExpression.ResultValue<Integer> resB = this.b.eval(pArgs);
            if (resA.canNotEvaluate()) {
                return new AutomatonExpression.ResultValue<Boolean>(resA);
            }
            if (resB.canNotEvaluate()) {
                return new AutomatonExpression.ResultValue<Boolean>(resB);
            }
            if (!resA.getValue().equals(resB.getValue())) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return this.a + " != " + this.b;
        }
    }

    public static class IntEqTest
    implements AutomatonBoolExpr {
        private final AutomatonIntExpr a;
        private final AutomatonIntExpr b;

        public IntEqTest(AutomatonIntExpr pA, AutomatonIntExpr pB) {
            this.a = pA;
            this.b = pB;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            AutomatonExpression.ResultValue<Integer> resA = this.a.eval(pArgs);
            AutomatonExpression.ResultValue<Integer> resB = this.b.eval(pArgs);
            if (resA.canNotEvaluate()) {
                return new AutomatonExpression.ResultValue<Boolean>(resA);
            }
            if (resB.canNotEvaluate()) {
                return new AutomatonExpression.ResultValue<Boolean>(resB);
            }
            if (resA.getValue().equals(resB.getValue())) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return this.a + " == " + this.b;
        }
    }

    public static enum CheckAllCpasForTargetState implements AutomatonBoolExpr
    {
        INSTANCE;


        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) throws CPATransferException {
            if (pArgs.getAbstractStates().isEmpty()) {
                return new AutomatonExpression.ResultValue<Boolean>("No CPA elements available", "AutomatonBoolExpr.CheckAllCpasForTargetState");
            }
            for (AbstractState ae : pArgs.getAbstractStates()) {
                if (!AbstractStates.isTargetState(ae)) continue;
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "CHECK(IS_TARGET_STATE)";
        }
    }

    public static class CPAQuery
    implements AutomatonBoolExpr {
        private final String cpaName;
        private final String queryString;

        public CPAQuery(String pCPAName, String pQuery) {
            this.cpaName = pCPAName;
            this.queryString = pQuery;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            String modifiedQueryString = pArgs.replaceVariables(this.queryString);
            if (modifiedQueryString == null) {
                return new AutomatonExpression.ResultValue<Boolean>("Failed to modify queryString \"" + this.queryString + "\"", "AutomatonBoolExpr.CPAQuery");
            }
            LogManager logger = pArgs.getLogger();
            for (AbstractState ae : pArgs.getAbstractStates()) {
                AbstractQueryableState aqe;
                if (!(ae instanceof AbstractQueryableState) || !(aqe = (AbstractQueryableState)ae).getCPAName().equals(this.cpaName)) continue;
                try {
                    Object result = aqe.evaluateProperty(modifiedQueryString);
                    if (result instanceof Boolean) {
                        if (((Boolean)result).booleanValue()) {
                            if (logger.wouldBeLogged(Level.FINER)) {
                                String message = "CPA-Check succeeded: ModifiedCheckString: \"" + modifiedQueryString + "\" CPAElement: (" + aqe.getCPAName() + ") \"" + aqe.toString() + "\"";
                                logger.log(Level.FINER, new Object[]{message});
                            }
                            return CONST_TRUE;
                        }
                        if (logger.wouldBeLogged(Level.FINER)) {
                            String message = "CPA-Check failed: ModifiedCheckString: \"" + modifiedQueryString + "\" CPAElement: (" + aqe.getCPAName() + ") \"" + aqe.toString() + "\"";
                            logger.log(Level.FINER, new Object[]{message});
                        }
                        return CONST_FALSE;
                    }
                    logger.log(Level.WARNING, new Object[]{"Automaton got a non-Boolean value during Query of the " + this.cpaName + " CPA on Edge " + pArgs.getCfaEdge().getDescription() + ". Assuming FALSE."});
                    return CONST_FALSE;
                }
                catch (InvalidQueryException e) {
                    logger.logException(Level.WARNING, (Throwable)e, "Automaton encountered an Exception during Query of the " + this.cpaName + " CPA on Edge " + pArgs.getCfaEdge().getDescription());
                    return CONST_FALSE;
                }
            }
            return new AutomatonExpression.ResultValue<Boolean>("No State of CPA \"" + this.cpaName + "\" was found!", "AutomatonBoolExpr.CPAQuery");
        }

        public String toString() {
            return "CHECK(" + this.cpaName + "(\"" + this.queryString + "\"))";
        }
    }

    public static class ALLCPAQuery
    implements AutomatonBoolExpr {
        private final String queryString;

        public ALLCPAQuery(String pString) {
            this.queryString = pString;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            if (pArgs.getAbstractStates().isEmpty()) {
                return new AutomatonExpression.ResultValue<Boolean>("No CPA elements available", "AutomatonBoolExpr.ALLCPAQuery");
            }
            String modifiedQueryString = pArgs.replaceVariables(this.queryString);
            if (modifiedQueryString == null) {
                return new AutomatonExpression.ResultValue<Boolean>("Failed to modify queryString \"" + this.queryString + "\"", "AutomatonBoolExpr.ALLCPAQuery");
            }
            for (AbstractState ae : pArgs.getAbstractStates()) {
                if (!(ae instanceof AbstractQueryableState)) continue;
                AbstractQueryableState aqe = (AbstractQueryableState)ae;
                try {
                    Object result = aqe.evaluateProperty(modifiedQueryString);
                    if (!(result instanceof Boolean) || !((Boolean)result).booleanValue()) continue;
                    if (pArgs.getLogger().wouldBeLogged(Level.FINER)) {
                        String message = "CPA-Check succeeded: ModifiedCheckString: \"" + modifiedQueryString + "\" CPAElement: (" + aqe.getCPAName() + ") \"" + aqe.toString() + "\"";
                        pArgs.getLogger().log(Level.FINER, new Object[]{message});
                    }
                    return CONST_TRUE;
                }
                catch (InvalidQueryException e) {
                }
            }
            return CONST_FALSE;
        }
    }

    public static class MatchLocationDescriptor
    implements AutomatonBoolExpr {
        private final SourceLocationMapper.LocationDescriptor matchDescriptor;

        public MatchLocationDescriptor(SourceLocationMapper.LocationDescriptor pOriginDescriptor) {
            Preconditions.checkNotNull((Object)pOriginDescriptor);
            this.matchDescriptor = pOriginDescriptor;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            return this.eval(pArgs.getCfaEdge()) ? CONST_TRUE : CONST_FALSE;
        }

        protected boolean eval(CFAEdge edge) {
            Set<FileLocation> fileLocs = SourceLocationMapper.getFileLocationsFromCfaEdge(edge);
            for (FileLocation l : fileLocs) {
                if (!this.matchDescriptor.matches(l)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "MATCH " + this.matchDescriptor;
        }
    }

    public static class IntersectionMatchEdgeTokens
    extends MatchEdgeTokens {
        public IntersectionMatchEdgeTokens(Set<Comparable<Integer>> pTokens) {
            super(pTokens);
        }

        @Override
        protected boolean tokensMatching(Set<Integer> cfaEdgeTokens) {
            if (this.matchTokens.isEmpty()) {
                return cfaEdgeTokens.isEmpty();
            }
            return Sets.intersection(cfaEdgeTokens, (Set)this.matchTokens).size() > 0;
        }

        @Override
        public String toString() {
            return "MATCH TOKENS INTERSECT " + this.matchTokens;
        }
    }

    public static class SubsetMatchEdgeTokens
    extends MatchEdgeTokens {
        public SubsetMatchEdgeTokens(Set<Comparable<Integer>> pTokens) {
            super(pTokens);
        }

        @Override
        protected boolean tokensMatching(Set<Integer> cfaEdgeTokens) {
            if (this.matchTokens.isEmpty()) {
                return cfaEdgeTokens.isEmpty();
            }
            return cfaEdgeTokens.containsAll(this.matchTokens);
        }

        @Override
        public String toString() {
            return "MATCH TOKENS SUBSET " + this.matchTokens;
        }
    }

    public static abstract class MatchEdgeTokens
    implements OnRelevantEdgesBoolExpr {
        protected final Set<Comparable<Integer>> matchTokens;

        public MatchEdgeTokens(Set<Comparable<Integer>> pTokens) {
            this.matchTokens = pTokens;
        }

        protected abstract boolean tokensMatching(Set<Integer> var1);

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            Set<Integer> tokensSinceLastMatch;
            boolean match = false;
            Set<Integer> edgeTokens = AutomatonGraphmlCommon.handleAsEpsilonEdge(pArgs.getCfaEdge()) ? Collections.emptySet() : SourceLocationMapper.getAbsoluteTokensFromCFAEdge(pArgs.getCfaEdge(), true);
            match = this.tokensMatching(edgeTokens);
            if (!match && !(tokensSinceLastMatch = pArgs.getState().getTokensSinceLastMatch()).isEmpty()) {
                match = this.tokensMatching(tokensSinceLastMatch);
            }
            return match ? CONST_TRUE : CONST_FALSE;
        }

        public Set<Comparable<Integer>> getMatchTokens() {
            return this.matchTokens;
        }

        public String toString() {
            return "MATCH TOKENS " + this.matchTokens;
        }
    }

    public static class MatchNonEmptyEdgeTokens
    implements OnRelevantEdgesBoolExpr {
        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            Set<Object> edgeTokens = AutomatonGraphmlCommon.handleAsEpsilonEdge(pArgs.getCfaEdge()) ? Collections.emptySet() : SourceLocationMapper.getAbsoluteTokensFromCFAEdge(pArgs.getCfaEdge(), true);
            return edgeTokens.size() > 0 ? CONST_TRUE : CONST_FALSE;
        }

        public String toString() {
            return "MATCH NONEMPTY TOKENS";
        }
    }

    public static enum MatchPathRelevantEdgesBoolExpr implements OnRelevantEdgesBoolExpr
    {
        INSTANCE;


        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            return AutomatonGraphmlCommon.handleAsEpsilonEdge(pArgs.getCfaEdge()) ? CONST_FALSE : CONST_TRUE;
        }

        public String toString() {
            return "MATCH PATH RELEVANT EDGE";
        }
    }

    public static interface OnRelevantEdgesBoolExpr
    extends AutomatonBoolExpr {
    }

    public static class MatchAnySuccessorEdgesBoolExpr
    implements AutomatonBoolExpr {
        private final AutomatonBoolExpr operandExpression;

        MatchAnySuccessorEdgesBoolExpr(AutomatonBoolExpr pOperandExpression) {
            Preconditions.checkNotNull((Object)pOperandExpression);
            this.operandExpression = pOperandExpression;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) throws CPATransferException {
            if (pArgs.getCfaEdge().getSuccessor().getNumLeavingEdges() == 0) {
                return CONST_FALSE;
            }
            AutomatonExpression.ResultValue<Boolean> result = null;
            for (CFAEdge cfaEdge : CFAUtils.leavingEdges(pArgs.getCfaEdge().getSuccessor())) {
                result = this.operandExpression.eval(new AutomatonExpressionArguments(pArgs.getState(), pArgs.getAutomatonVariables(), pArgs.getAbstractStates(), cfaEdge, pArgs.getLogger()));
                if (result.canNotEvaluate() || !result.getValue().booleanValue()) continue;
                return result;
            }
            assert (result != null);
            return result;
        }

        public String toString() {
            return String.format("MATCH EXISTS SUCCESSOR EDGE (%s)", this.operandExpression);
        }
    }

    public static class MatchAllSuccessorEdgesBoolExpr
    implements AutomatonBoolExpr {
        private final AutomatonBoolExpr operandExpression;

        MatchAllSuccessorEdgesBoolExpr(AutomatonBoolExpr pOperandExpression) {
            Preconditions.checkNotNull((Object)pOperandExpression);
            this.operandExpression = pOperandExpression;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) throws CPATransferException {
            if (pArgs.getCfaEdge().getSuccessor().getNumLeavingEdges() == 0) {
                return CONST_TRUE;
            }
            AutomatonExpression.ResultValue<Boolean> result = null;
            for (CFAEdge cfaEdge : CFAUtils.leavingEdges(pArgs.getCfaEdge().getSuccessor())) {
                result = this.operandExpression.eval(new AutomatonExpressionArguments(pArgs.getState(), pArgs.getAutomatonVariables(), pArgs.getAbstractStates(), cfaEdge, pArgs.getLogger()));
                if (!result.canNotEvaluate() && result.getValue().booleanValue()) continue;
                return result;
            }
            assert (result != null);
            return result;
        }

        public String toString() {
            return String.format("MATCH FORALL SUCCESSOR EDGES (%s)", this.operandExpression);
        }
    }

    public static class MatchAssumeCase
    implements AutomatonBoolExpr {
        private final boolean matchPositiveCase;

        public MatchAssumeCase(boolean pMatchPositiveCase) {
            this.matchPositiveCase = pMatchPositiveCase;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            AssumeEdge a;
            if (pArgs.getCfaEdge() instanceof AssumeEdge && this.matchPositiveCase == (a = (AssumeEdge)pArgs.getCfaEdge()).getTruthAssumption()) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "MATCH ASSUME CASE " + this.matchPositiveCase;
        }
    }

    public static enum MatchAssumeEdge implements AutomatonBoolExpr
    {
        INSTANCE;


        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            return pArgs.getCfaEdge() instanceof AssumeEdge ? CONST_TRUE : CONST_FALSE;
        }

        public String toString() {
            return "MATCH ASSUME EDGE";
        }
    }

    public static class MatchJavaAssert
    implements AutomatonBoolExpr {
        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) throws CPATransferException {
            CFAEdge edge = pArgs.getCfaEdge();
            if (edge instanceof BlankEdge && edge.getDescription().equals("assert fail")) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "MATCH ASSERT";
        }
    }

    public static class MatchCFAEdgeExact
    implements AutomatonBoolExpr {
        private final String pattern;

        public MatchCFAEdgeExact(String pPattern) {
            this.pattern = pPattern;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            if (pArgs.getCfaEdge().getRawStatement().equals(this.pattern)) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "MATCH \"" + this.pattern + "\"";
        }
    }

    public static class MatchCFAEdgeRegEx
    implements AutomatonBoolExpr {
        private final Pattern pattern;

        public MatchCFAEdgeRegEx(String pPattern) {
            this.pattern = Pattern.compile(pPattern);
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            if (this.pattern.matcher(pArgs.getCfaEdge().getRawStatement()).matches()) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "MATCH [" + this.pattern + "]";
        }
    }

    public static class MatchCFAEdgeASTComparison
    implements AutomatonBoolExpr {
        private final AutomatonASTComparator.ASTMatcher patternAST;

        public MatchCFAEdgeASTComparison(AutomatonASTComparator.ASTMatcher pPatternAST) throws InvalidAutomatonException {
            this.patternAST = pPatternAST;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) throws UnrecognizedCFAEdgeException {
            Optional<? extends AAstNode> ast = pArgs.getCfaEdge().getRawAST();
            if (ast.isPresent()) {
                if (!(ast.get() instanceof CAstNode)) {
                    throw new UnrecognizedCFAEdgeException(pArgs.getCfaEdge());
                }
                if (this.patternAST.matches((CAstNode)ast.get(), pArgs)) {
                    return CONST_TRUE;
                }
                return CONST_FALSE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "MATCH {" + this.patternAST + "}";
        }
    }

    public static class MatchLabelRegEx
    implements AutomatonBoolExpr {
        private final Pattern pattern;

        public MatchLabelRegEx(String pPattern) {
            this.pattern = Pattern.compile(pPattern);
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            CFANode successorNode = pArgs.getCfaEdge().getSuccessor();
            if (successorNode instanceof CLabelNode) {
                String label = ((CLabelNode)successorNode).getLabel();
                if (this.pattern.matcher(label).matches()) {
                    return CONST_TRUE;
                }
                return CONST_FALSE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "MATCH LABEL [" + this.pattern + "]";
        }
    }

    public static class MatchLabelExact
    implements AutomatonBoolExpr {
        private final String label;

        public MatchLabelExact(String pLabel) {
            this.label = (String)Preconditions.checkNotNull((Object)pLabel);
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            CFANode successorNode = pArgs.getCfaEdge().getSuccessor();
            if (successorNode instanceof CLabelNode) {
                if (this.label.equals(((CLabelNode)successorNode).getLabel())) {
                    return CONST_TRUE;
                }
                return CONST_FALSE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "MATCH LABEL \"" + this.label + "\"";
        }
    }

    public static class MatchProgramExit
    implements AutomatonBoolExpr {
        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            if (pArgs.getCfaEdge().getSuccessor().getNumLeavingEdges() == 0) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }
    }
}

