/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.FileWriteMode;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.CProgramScope;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonASTComparator;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonAction;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonBoolExpr;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonInternalState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransition;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.cpa.automaton.InvalidAutomatonException;
import org.sosy_lab.cpachecker.exceptions.CParserException;
import org.sosy_lab.cpachecker.util.SourceLocationMapper;
import org.sosy_lab.cpachecker.util.automaton.AutomatonGraphmlCommon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Options(prefix="spec")
public class AutomatonGraphmlParser {
    @Option(secure=true, description="Consider assumptions that are provided with the path automaton?")
    private boolean considerAssumptions = true;
    @Option(secure=true, description="Legacy option for token-based matching with path automatons.")
    private boolean transitionToStopForNegatedTokensetMatch = false;
    @Option(secure=true, description="Match the source code provided with the witness.")
    private boolean matchSourcecodeData = false;
    @Option(secure=true, description="Match the line numbers within the origin (mapping done by preprocessor line markers).")
    private boolean matchOriginLine = true;
    @Option(secure=true, description="Match the character offset within the file.")
    private boolean matchOffset = true;
    @Option(secure=true, description="Match the branching information at a branching location.")
    private boolean matchAssumeCase = true;
    @Option(secure=true, description="Do not try to \"catch up\" with witness guards: If they do not match, go to the sink.")
    private boolean strictMatching = false;
    @Option(secure=true, description="File for exporting the path automaton in DOT format.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path automatonDumpFile = null;
    private Scope scope;
    private LogManager logger;
    private Configuration config;
    private MachineModel machine;

    public AutomatonGraphmlParser(Configuration pConfig, LogManager pLogger, MachineModel pMachine, Scope pScope) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.scope = pScope;
        this.machine = pMachine;
        this.logger = pLogger;
        this.config = pConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Automaton> parseAutomatonFile(Path pInputFile) throws InvalidConfigurationException {
        CParser cparser = CParser.Factory.getParser(this.config, this.logger, CParser.Factory.getOptions(this.config), this.machine);
        try (InputStream input = pInputFile.asByteSource().openStream();){
            Serializable transitions;
            int i;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(input);
            doc.getDocumentElement().normalize();
            GraphMlDocumentData docDat = new GraphMlDocumentData(doc);
            NodeList graphs = doc.getElementsByTagName(AutomatonGraphmlCommon.GraphMlTag.GRAPH.toString());
            Preconditions.checkArgument((graphs.getLength() == 1 ? 1 : 0) != 0, (Object)"The graph file must describe exactly one automaton.");
            Node graphNode = graphs.item(0);
            Node nameAttribute = graphNode.getAttributes().getNamedItem("name");
            String automatonName = nameAttribute == null ? "WitnessAutomaton" : nameAttribute.getTextContent();
            String initialStateName = null;
            NodeList edges = doc.getElementsByTagName(AutomatonGraphmlCommon.GraphMlTag.EDGE.toString());
            NodeList nodes = doc.getElementsByTagName(AutomatonGraphmlCommon.GraphMlTag.NODE.toString());
            HashMap stateTransitions = Maps.newHashMap();
            HashMap stacks = Maps.newHashMap();
            HashMultimap graph = HashMultimap.create();
            String entryNodeId = null;
            for (i = 0; i < edges.getLength(); ++i) {
                Node stateTransitionEdge = edges.item(i);
                String sourceStateId = GraphMlDocumentData.getAttributeValue(stateTransitionEdge, "source", "Every transition needs a source!");
                graph.put((Object)sourceStateId, (Object)stateTransitionEdge);
            }
            for (i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (!Boolean.parseBoolean(docDat.getDataValueWithDefault(node, AutomatonGraphmlCommon.KeyDef.ISENTRYNODE, "false"))) continue;
                entryNodeId = GraphMlDocumentData.getAttributeValue(node, "id", "Every node needs an id!");
                break;
            }
            Preconditions.checkNotNull(entryNodeId, (Object)"You must define an entry node.");
            HashSet visitedEdges = new HashSet();
            ArrayDeque<Node> waitingEdges = new ArrayDeque<Node>();
            waitingEdges.addAll(graph.get((Object)entryNodeId));
            visitedEdges.addAll(waitingEdges);
            while (!waitingEdges.isEmpty()) {
                SourceLocationMapper.FileNameDescriptor originDescriptor;
                Optional matchOriginFileName;
                Set originFileTags;
                Set functionExits;
                ArrayDeque<Object> currentStack;
                List<AutomatonBoolExpr> assertions;
                Node stateTransitionEdge = (Node)waitingEdges.poll();
                String sourceStateId = GraphMlDocumentData.getAttributeValue(stateTransitionEdge, "source", "Every transition needs a source!");
                String targetStateId = GraphMlDocumentData.getAttributeValue(stateTransitionEdge, "target", "Every transition needs a target!");
                for (Node successorEdge : graph.get((Object)targetStateId)) {
                    if (!visitedEdges.add(successorEdge)) continue;
                    waitingEdges.add(successorEdge);
                }
                Element targetStateNode = docDat.getNodeWithId(targetStateId);
                EnumSet<AutomatonGraphmlCommon.NodeFlag> targetNodeFlags = docDat.getNodeFlags(targetStateNode);
                if (!targetNodeFlags.contains((Object)AutomatonGraphmlCommon.NodeFlag.ISSINKNODE) && graph.get((Object)targetStateId).isEmpty() || targetNodeFlags.contains((Object)AutomatonGraphmlCommon.NodeFlag.ISVIOLATION)) {
                    AutomatonBoolExpr otherAutomataSafe = AutomatonGraphmlParser.and(AutomatonGraphmlParser.not(new AutomatonBoolExpr.ALLCPAQuery("internalStateIsTarget")), AutomatonGraphmlParser.not(new AutomatonBoolExpr.ALLCPAQuery("has-leaks")), AutomatonGraphmlParser.not(new AutomatonBoolExpr.ALLCPAQuery("has-invalid-frees")), AutomatonGraphmlParser.not(new AutomatonBoolExpr.ALLCPAQuery("has-invalid-reads")), AutomatonGraphmlParser.not(new AutomatonBoolExpr.ALLCPAQuery("has-invalid-writes")));
                    assertions = Collections.singletonList(otherAutomataSafe);
                } else {
                    assertions = Collections.emptyList();
                }
                List<AutomatonAction> actions2 = Collections.emptyList();
                ArrayList assumptions = Lists.newArrayList();
                LinkedList transitions2 = (LinkedList)stateTransitions.get(sourceStateId);
                if (transitions2 == null) {
                    transitions2 = Lists.newLinkedList();
                    stateTransitions.put(sourceStateId, transitions2);
                }
                if ((currentStack = (ArrayDeque<Object>)stacks.get(sourceStateId)) == null) {
                    currentStack = new ArrayDeque<Object>();
                    stacks.put(sourceStateId, currentStack);
                }
                ArrayDeque<Object> newStack = currentStack;
                Set functionEntries = GraphMlDocumentData.getDataOnNode(stateTransitionEdge, AutomatonGraphmlCommon.KeyDef.FUNCTIONENTRY);
                if (!functionEntries.isEmpty()) {
                    newStack = new ArrayDeque(newStack);
                    newStack.push(Iterables.getOnlyElement((Iterable)functionEntries));
                }
                if (!(functionExits = GraphMlDocumentData.getDataOnNode(stateTransitionEdge, AutomatonGraphmlCommon.KeyDef.FUNCTIONEXIT)).isEmpty()) {
                    String function = (String)Iterables.getOnlyElement((Iterable)functionExits);
                    if (newStack.isEmpty()) {
                        this.logger.log(Level.WARNING, new Object[]{"Trying to return from function", function, "although no function is on the stack."});
                    } else {
                        newStack = new ArrayDeque(newStack);
                        String oldFunction = (String)newStack.pop();
                        assert (oldFunction.equals(function));
                    }
                }
                stacks.put(targetStateId, newStack);
                AutomatonBoolExpr conjunctedTriggers = AutomatonBoolExpr.TRUE;
                if (this.considerAssumptions) {
                    Set transAssumes = GraphMlDocumentData.getDataOnNode(stateTransitionEdge, AutomatonGraphmlCommon.KeyDef.ASSUMPTION);
                    Scope scope = this.scope;
                    if (!newStack.isEmpty() && scope instanceof CProgramScope) {
                        scope = ((CProgramScope)scope).createFunctionScope((String)newStack.peek());
                    }
                    for (String assumeCode : transAssumes) {
                        assumptions.addAll(AutomatonGraphmlParser.removeDuplicates(AutomatonGraphmlParser.adjustCharAssignments(AutomatonASTComparator.generateSourceASTOfBlock(AutomatonGraphmlParser.tryFixArrayInitializers(assumeCode), cparser, scope))));
                    }
                }
                if (this.matchOriginLine) {
                    originFileTags = GraphMlDocumentData.getDataOnNode(stateTransitionEdge, AutomatonGraphmlCommon.KeyDef.ORIGINFILE);
                    Preconditions.checkArgument((originFileTags.size() < 2 ? 1 : 0) != 0, (Object)"At most one origin-file data tag must be provided for an edge!");
                    Set originLineTags = GraphMlDocumentData.getDataOnNode(stateTransitionEdge, AutomatonGraphmlCommon.KeyDef.ORIGINLINE);
                    Preconditions.checkArgument((originLineTags.size() < 2 ? 1 : 0) != 0, (Object)"At most one origin-line data tag must be provided for each edge!");
                    int matchOriginLineNumber = -1;
                    if (originLineTags.size() > 0) {
                        matchOriginLineNumber = Integer.parseInt((String)originLineTags.iterator().next());
                    }
                    if (matchOriginLineNumber > 0) {
                        matchOriginFileName = originFileTags.isEmpty() ? Optional.absent() : Optional.of(originFileTags.iterator().next());
                        originDescriptor = new SourceLocationMapper.OriginLineDescriptor((Optional<String>)matchOriginFileName, matchOriginLineNumber);
                        AutomatonBoolExpr.MatchLocationDescriptor startingLineMatchingExpr = new AutomatonBoolExpr.MatchLocationDescriptor(originDescriptor);
                        conjunctedTriggers = AutomatonGraphmlParser.and(conjunctedTriggers, (AutomatonBoolExpr)startingLineMatchingExpr);
                    }
                }
                if (this.matchOffset) {
                    originFileTags = GraphMlDocumentData.getDataOnNode(stateTransitionEdge, AutomatonGraphmlCommon.KeyDef.ORIGINFILE);
                    Preconditions.checkArgument((originFileTags.size() < 2 ? 1 : 0) != 0, (Object)"At most one origin-file data tag must be provided for an edge!");
                    Set offsetTags = GraphMlDocumentData.getDataOnNode(stateTransitionEdge, AutomatonGraphmlCommon.KeyDef.OFFSET);
                    Preconditions.checkArgument((offsetTags.size() < 2 ? 1 : 0) != 0, (Object)"At most one offset data tag must be provided for each edge!");
                    int offset = -1;
                    if (offsetTags.size() > 0) {
                        offset = Integer.parseInt((String)offsetTags.iterator().next());
                    }
                    if (offset >= 0) {
                        matchOriginFileName = originFileTags.isEmpty() ? Optional.absent() : Optional.of(originFileTags.iterator().next());
                        originDescriptor = new SourceLocationMapper.OffsetDescriptor((Optional<String>)matchOriginFileName, offset);
                        AutomatonBoolExpr.MatchLocationDescriptor offsetMatchingExpr = new AutomatonBoolExpr.MatchLocationDescriptor(originDescriptor);
                        conjunctedTriggers = AutomatonGraphmlParser.and(conjunctedTriggers, (AutomatonBoolExpr)offsetMatchingExpr);
                    }
                }
                if (this.matchSourcecodeData) {
                    Set sourceCodeDataTags = GraphMlDocumentData.getDataOnNode(stateTransitionEdge, AutomatonGraphmlCommon.KeyDef.SOURCECODE);
                    Preconditions.checkArgument((sourceCodeDataTags.size() < 2 ? 1 : 0) != 0, (Object)"At most one source-code data tag must be provided!");
                    String sourceCode = sourceCodeDataTags.isEmpty() ? "" : (String)sourceCodeDataTags.iterator().next();
                    AutomatonBoolExpr.MatchCFAEdgeExact exactEdgeMatch = new AutomatonBoolExpr.MatchCFAEdgeExact(sourceCode);
                    conjunctedTriggers = AutomatonGraphmlParser.and(conjunctedTriggers, (AutomatonBoolExpr)exactEdgeMatch);
                }
                ArrayList<AutomatonTransition> nonMatchingTransitions = new ArrayList<AutomatonTransition>();
                if (this.strictMatching) {
                    nonMatchingTransitions.add(AutomatonGraphmlParser.createAutomatonSinkTransition(AutomatonGraphmlParser.and(AutomatonGraphmlParser.not(conjunctedTriggers), (AutomatonBoolExpr)AutomatonBoolExpr.MatchPathRelevantEdgesBoolExpr.INSTANCE), Collections.emptyList(), Collections.emptyList()));
                    nonMatchingTransitions.add(AutomatonGraphmlParser.createAutomatonTransition(AutomatonGraphmlParser.and(AutomatonGraphmlParser.not(conjunctedTriggers), AutomatonGraphmlParser.not(AutomatonBoolExpr.MatchPathRelevantEdgesBoolExpr.INSTANCE)), assertions, Collections.emptyList(), sourceStateId));
                } else {
                    nonMatchingTransitions.add(AutomatonGraphmlParser.createAutomatonTransition(AutomatonGraphmlParser.not(conjunctedTriggers), assertions, Collections.emptyList(), sourceStateId));
                }
                if (this.matchAssumeCase) {
                    boolean assumeCase;
                    Set assumeCaseTags = GraphMlDocumentData.getDataOnNode(stateTransitionEdge, AutomatonGraphmlCommon.KeyDef.NEGATIVECASE);
                    if (assumeCaseTags.size() > 0) {
                        Preconditions.checkArgument((assumeCaseTags.size() < 2 ? 1 : 0) != 0, (Object)"At most one assume case tag must be provided for each edge!");
                        assumeCase = !Boolean.parseBoolean((String)assumeCaseTags.iterator().next());
                    } else {
                        assumeCase = true;
                    }
                    AutomatonBoolExpr assumeCaseMatchingExpr = AutomatonGraphmlParser.or(AutomatonGraphmlParser.not(AutomatonBoolExpr.MatchAssumeEdge.INSTANCE), new AutomatonBoolExpr.MatchAssumeCase(assumeCase));
                    conjunctedTriggers = AutomatonGraphmlParser.and(conjunctedTriggers, assumeCaseMatchingExpr);
                }
                conjunctedTriggers = AutomatonGraphmlParser.and(conjunctedTriggers, (AutomatonBoolExpr)AutomatonBoolExpr.MatchPathRelevantEdgesBoolExpr.INSTANCE);
                ArrayList<AutomatonTransition> matchingTransitions = new ArrayList<AutomatonTransition>();
                matchingTransitions.add(AutomatonGraphmlParser.createAutomatonTransition(conjunctedTriggers, assertions, actions2, targetStateId));
                if (this.strictMatching || !assumptions.isEmpty() || !actions2.isEmpty()) {
                    matchingTransitions.add(AutomatonGraphmlParser.createAutomatonTransition(AutomatonGraphmlParser.and(conjunctedTriggers, (AutomatonBoolExpr)new AutomatonBoolExpr.MatchAnySuccessorEdgesBoolExpr(conjunctedTriggers)), assertions, Collections.emptyList(), sourceStateId));
                }
                transitions2.addAll(matchingTransitions);
                transitions2.addAll(nonMatchingTransitions);
            }
            ArrayList automatonStates = Lists.newArrayList();
            for (String stateId : docDat.getIdToNodeMap().keySet()) {
                Element stateNode = docDat.getIdToNodeMap().get(stateId);
                EnumSet<AutomatonGraphmlCommon.NodeFlag> nodeFlags = docDat.getNodeFlags(stateNode);
                transitions = (ArrayList<AutomatonTransition>)stateTransitions.get(stateId);
                if (transitions == null) {
                    transitions = new ArrayList<AutomatonTransition>();
                }
                if (!nodeFlags.contains((Object)AutomatonGraphmlCommon.NodeFlag.ISSINKNODE) && graph.get((Object)stateId).isEmpty()) {
                    AutomatonBoolExpr otherAutomataSafe = AutomatonGraphmlParser.not(new AutomatonBoolExpr.ALLCPAQuery("internalStateIsTarget"));
                    List<AutomatonBoolExpr> assertions = Collections.singletonList(otherAutomataSafe);
                    transitions.add(AutomatonGraphmlParser.createAutomatonTransition(AutomatonBoolExpr.TRUE, assertions, Collections.emptyList(), stateId));
                }
                if (nodeFlags.contains((Object)AutomatonGraphmlCommon.NodeFlag.ISENTRY)) {
                    Preconditions.checkArgument((initialStateName == null ? 1 : 0) != 0, (Object)"Only one entrynode is supported!");
                    initialStateName = stateId;
                }
                boolean matchAll = true;
                AutomatonInternalState state = new AutomatonInternalState(stateId, (List<AutomatonTransition>)((Object)transitions), false, matchAll);
                automatonStates.add(state);
            }
            Preconditions.checkNotNull(initialStateName, (Object)"Every graph needs a specified entry node!");
            Map<String, AutomatonVariable> automatonVariables = Collections.emptyMap();
            ArrayList result = Lists.newArrayList();
            Automaton automaton = new Automaton(automatonName, automatonVariables, automatonStates, initialStateName);
            result.add(automaton);
            if (this.automatonDumpFile != null) {
                try {
                    Writer w = Files.openOutputFile((Path)this.automatonDumpFile, (FileWriteMode[])new FileWriteMode[0]);
                    transitions = null;
                    try {
                        automaton.writeDotFile(w);
                    }
                    catch (Throwable throwable) {
                        transitions = throwable;
                        throw throwable;
                    }
                    finally {
                        if (w != null) {
                            if (transitions != null) {
                                try {
                                    w.close();
                                }
                                catch (Throwable x2) {
                                    ((Throwable)transitions).addSuppressed(x2);
                                }
                            } else {
                                w.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        catch (FileNotFoundException e) {
            throw new InvalidConfigurationException("Invalid automaton file provided! File not found!: " + pInputFile.getPath());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new InvalidConfigurationException("Error while accessing automaton file!", (Throwable)e);
        }
        catch (InvalidAutomatonException e) {
            throw new InvalidConfigurationException("The automaton provided is invalid!", (Throwable)e);
        }
        catch (CParserException e) {
            throw new InvalidConfigurationException("The automaton contains invalid C code!", (Throwable)e);
        }
    }

    private static AutomatonTransition createAutomatonTransition(AutomatonBoolExpr pTriggers, List<AutomatonBoolExpr> pAssertions, List<AutomatonAction> pActions, String pTargetStateId) {
        if (pTargetStateId.equals("sink")) {
            return AutomatonGraphmlParser.createAutomatonSinkTransition(pTriggers, pAssertions, pActions);
        }
        return new AutomatonTransition(pTriggers, pAssertions, pActions, pTargetStateId);
    }

    private static AutomatonTransition createAutomatonSinkTransition(AutomatonBoolExpr pTriggers, List<AutomatonBoolExpr> pAssertions, List<AutomatonAction> pActions) {
        return new AutomatonTransition(pTriggers, pAssertions, pActions, AutomatonInternalState.BOTTOM);
    }

    private static Collection<CStatement> removeDuplicates(Iterable<? extends CStatement> pStatements) {
        HashMap<CAstNode, CStatement> result = new HashMap<CAstNode, CStatement>();
        for (CStatement cStatement : pStatements) {
            if (cStatement instanceof CExpressionAssignmentStatement) {
                CExpressionAssignmentStatement assignmentStatement = (CExpressionAssignmentStatement)cStatement;
                result.put(assignmentStatement.getLeftHandSide(), assignmentStatement);
                continue;
            }
            result.put(cStatement, cStatement);
        }
        return result.values();
    }

    private static Collection<CStatement> adjustCharAssignments(Iterable<? extends CStatement> pStatements) {
        return FluentIterable.from(pStatements).transform((Function)new Function<CStatement, CStatement>(){

            public CStatement apply(CStatement pStatement) {
                CSimpleType simpleType;
                CBasicType basicType;
                CExpressionAssignmentStatement statement;
                CLeftHandSide leftHandSide;
                CType canonicalType;
                if (pStatement instanceof CExpressionAssignmentStatement && (canonicalType = (leftHandSide = (statement = (CExpressionAssignmentStatement)pStatement).getLeftHandSide()).getExpressionType().getCanonicalType()) instanceof CSimpleType && (basicType = (simpleType = (CSimpleType)canonicalType).getType()).equals((Object)CBasicType.CHAR) && !simpleType.isSigned() && !simpleType.isUnsigned()) {
                    CExpression rightHandSide = statement.getRightHandSide();
                    CCastExpression castedRightHandSide = new CCastExpression(rightHandSide.getFileLocation(), canonicalType, rightHandSide);
                    return new CExpressionAssignmentStatement(statement.getFileLocation(), leftHandSide, castedRightHandSide);
                }
                return pStatement;
            }
        }).toList();
    }

    private static String tryFixArrayInitializers(String pAssumeCode) {
        String C_INTEGER = "([\\+\\-])?(0[xX])?[0-9a-fA-F]+";
        String assumeCode = pAssumeCode.trim();
        if (assumeCode.endsWith(";")) {
            assumeCode = assumeCode.substring(0, assumeCode.length() - 1);
        }
        if (assumeCode.matches(".+=\\s*\\{\\s*(" + C_INTEGER + "\\s*(,\\s*" + C_INTEGER + "\\s*)*)?\\}\\s*")) {
            Iterable assignmentParts = Splitter.on((char)'=').trimResults().split((CharSequence)assumeCode);
            Iterator assignmentPartIterator = assignmentParts.iterator();
            if (!assignmentPartIterator.hasNext()) {
                return pAssumeCode;
            }
            String leftHandSide = (String)assignmentPartIterator.next();
            if (!assignmentPartIterator.hasNext()) {
                return pAssumeCode;
            }
            String rightHandSide = ((String)assignmentPartIterator.next()).trim();
            if (assignmentPartIterator.hasNext()) {
                return pAssumeCode;
            }
            assert (rightHandSide.startsWith("{") && rightHandSide.endsWith("}"));
            rightHandSide = rightHandSide.substring(1, rightHandSide.length() - 1).trim();
            Iterable elements = Splitter.on((char)',').trimResults().split((CharSequence)rightHandSide);
            StringBuilder resultBuilder = new StringBuilder();
            int index = 0;
            for (String element : elements) {
                resultBuilder.append(String.format("%s[%d] = %s; ", leftHandSide, index, element));
                ++index;
            }
            return resultBuilder.toString();
        }
        return pAssumeCode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isGraphmlAutomaton(Path pPath, LogManager pLogger) throws InvalidConfigurationException {
        try (InputStream input = pPath.asByteSource().openStream();){
            SAXParserFactory.newInstance().newSAXParser().parse(input, new DefaultHandler());
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            throw new InvalidConfigurationException("Invalid automaton file provided! File not found: " + pPath.getPath());
        }
        catch (IOException e) {
            throw new InvalidConfigurationException("Error while accessing automaton file", (Throwable)e);
        }
        catch (SAXException e) {
            return false;
        }
        catch (ParserConfigurationException e) {
            pLogger.logException(Level.WARNING, (Throwable)e, "SAX parser configured incorrectly. Could not determine whether or not the path describes a graphml automaton.");
            return false;
        }
    }

    private static AutomatonBoolExpr not(AutomatonBoolExpr pA) {
        if (pA.equals(AutomatonBoolExpr.TRUE)) {
            return AutomatonBoolExpr.FALSE;
        }
        if (pA.equals(AutomatonBoolExpr.FALSE)) {
            return AutomatonBoolExpr.TRUE;
        }
        return new AutomatonBoolExpr.Negation(pA);
    }

    private static AutomatonBoolExpr and(AutomatonBoolExpr pA, AutomatonBoolExpr pB) {
        if (pA.equals(AutomatonBoolExpr.TRUE) || pA.equals(AutomatonBoolExpr.FALSE)) {
            return pB;
        }
        if (pB.equals(AutomatonBoolExpr.TRUE) || pA.equals(AutomatonBoolExpr.FALSE)) {
            return pA;
        }
        return new AutomatonBoolExpr.And(pA, pB);
    }

    private static AutomatonBoolExpr and(AutomatonBoolExpr ... pExpressions) {
        AutomatonBoolExpr result = AutomatonBoolExpr.TRUE;
        for (AutomatonBoolExpr e : pExpressions) {
            result = AutomatonGraphmlParser.and(result, e);
        }
        return result;
    }

    private static AutomatonBoolExpr or(AutomatonBoolExpr pA, AutomatonBoolExpr pB) {
        return AutomatonGraphmlParser.not(AutomatonGraphmlParser.and(AutomatonGraphmlParser.not(pA), AutomatonGraphmlParser.not(pB)));
    }

    private static class GraphMlDocumentData {
        private final HashMap<String, Optional<String>> defaultDataValues = Maps.newHashMap();
        private final Document doc;
        private Map<String, Element> idToNodeMap = null;

        public GraphMlDocumentData(Document doc) {
            this.doc = doc;
        }

        public EnumSet<AutomatonGraphmlCommon.NodeFlag> getNodeFlags(Element pStateNode) {
            EnumSet<AutomatonGraphmlCommon.NodeFlag> result = EnumSet.noneOf(AutomatonGraphmlCommon.NodeFlag.class);
            NodeList dataChilds = pStateNode.getElementsByTagName(AutomatonGraphmlCommon.GraphMlTag.DATA.toString());
            for (int i = 0; i < dataChilds.getLength(); ++i) {
                Node dataChild = dataChilds.item(i);
                Node attribute = dataChild.getAttributes().getNamedItem("key");
                Preconditions.checkNotNull((Object)attribute, (Object)"Every data element must have a key attribute!");
                String key = attribute.getTextContent();
                AutomatonGraphmlCommon.NodeFlag flag = AutomatonGraphmlCommon.NodeFlag.getNodeFlagByKey(key);
                if (flag == null) continue;
                result.add(flag);
            }
            return result;
        }

        public Map<String, Element> getIdToNodeMap() {
            if (this.idToNodeMap != null) {
                return this.idToNodeMap;
            }
            this.idToNodeMap = Maps.newHashMap();
            NodeList nodes = this.doc.getElementsByTagName(AutomatonGraphmlCommon.GraphMlTag.NODE.toString());
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element stateNode = (Element)nodes.item(i);
                String stateId = GraphMlDocumentData.getNodeId(stateNode);
                this.idToNodeMap.put(stateId, stateNode);
            }
            return this.idToNodeMap;
        }

        private static String getAttributeValue(Node of, String attributeName, String exceptionMessage) {
            Node attribute = of.getAttributes().getNamedItem(attributeName);
            Preconditions.checkNotNull((Object)attribute, (Object)exceptionMessage);
            return attribute.getTextContent();
        }

        private Optional<String> getDataDefault(AutomatonGraphmlCommon.KeyDef dataKey) {
            Optional result = this.defaultDataValues.get(dataKey.id);
            if (result != null) {
                return result;
            }
            NodeList keyDefs = this.doc.getElementsByTagName(AutomatonGraphmlCommon.GraphMlTag.KEY.toString());
            for (int i = 0; i < keyDefs.getLength(); ++i) {
                Element keyDef = (Element)keyDefs.item(i);
                Node id = keyDef.getAttributes().getNamedItem("id");
                if (!dataKey.id.equals(id.getTextContent())) continue;
                NodeList defaultTags = keyDef.getElementsByTagName(AutomatonGraphmlCommon.GraphMlTag.DEFAULT.toString());
                result = Optional.absent();
                if (defaultTags.getLength() > 0) {
                    Preconditions.checkArgument((defaultTags.getLength() == 1 ? 1 : 0) != 0);
                    result = Optional.of((Object)defaultTags.item(0).getTextContent());
                }
                this.defaultDataValues.put(dataKey.id, (Optional<String>)result);
                return result;
            }
            return Optional.absent();
        }

        private static String getNodeId(Node stateNode) {
            return GraphMlDocumentData.getAttributeValue(stateNode, "id", "Every state needs an ID!");
        }

        private Element getNodeWithId(String nodeId) {
            Element result = this.getIdToNodeMap().get(nodeId);
            Preconditions.checkNotNull((Object)result, (Object)("Node not found. Id: " + nodeId));
            return result;
        }

        private String getDataValueWithDefault(Node dataOnNode, AutomatonGraphmlCommon.KeyDef dataKey, String defaultValue) {
            Set<String> values = GraphMlDocumentData.getDataOnNode(dataOnNode, dataKey);
            if (values.size() == 0) {
                Optional<String> dataDefault = this.getDataDefault(dataKey);
                if (dataDefault.isPresent()) {
                    return (String)dataDefault.get();
                }
                return defaultValue;
            }
            return values.iterator().next();
        }

        private static Set<String> getDataOnNode(Node node, AutomatonGraphmlCommon.KeyDef dataKey) {
            Preconditions.checkNotNull((Object)node);
            Preconditions.checkArgument((node.getNodeType() == 1 ? 1 : 0) != 0);
            Element nodeElement = (Element)node;
            Set<Node> dataNodes = GraphMlDocumentData.findKeyedDataNode(nodeElement, dataKey);
            HashSet result = Sets.newHashSet();
            for (Node n : dataNodes) {
                result.add(n.getTextContent());
            }
            return result;
        }

        private static Set<Node> findKeyedDataNode(Element of, AutomatonGraphmlCommon.KeyDef dataKey) {
            HashSet result = Sets.newHashSet();
            NodeList dataChilds = of.getElementsByTagName(AutomatonGraphmlCommon.GraphMlTag.DATA.toString());
            for (int i = 0; i < dataChilds.getLength(); ++i) {
                Node dataChild = dataChilds.item(i);
                Node attribute = dataChild.getAttributes().getNamedItem("key");
                Preconditions.checkNotNull((Object)attribute, (Object)"Every data element must have a key attribute!");
                if (!attribute.getTextContent().equals(dataKey.id)) continue;
                result.add(dataChild);
            }
            return result;
        }
    }
}

